/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.SetUtil;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.qa.unittest.TestUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProvisioningUtil
extends TestCase {
    private static String NAME_ROOT_DOMAIN = "ldaptest";

    public static String genTestId() {
        Date date = new Date();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd-HHmmss");
        return fmt.format(date);
    }

    public static String baseDomainName(String testName) {
        return testName + "-" + TestProvisioningUtil.genTestId() + "." + NAME_ROOT_DOMAIN;
    }

    public static String baseDomainName(String testName, String testId) {
        if (testId == null) {
            return testName + "." + NAME_ROOT_DOMAIN;
        }
        return testName + "-" + testId + "." + NAME_ROOT_DOMAIN;
    }

    public static void verifySameId(NamedEntry entry1, NamedEntry entry2) throws Exception {
        TestProvisioningUtil.assertNotNull((Object)entry1);
        TestProvisioningUtil.assertNotNull((Object)entry2);
        TestProvisioningUtil.assertEquals((String)entry1.getId(), (String)entry2.getId());
    }

    public static void verifySameEntry(NamedEntry entry1, NamedEntry entry2) throws Exception {
        TestProvisioningUtil.verifySameId(entry1, entry2);
        TestProvisioningUtil.assertEquals((String)entry1.getName(), (String)entry2.getName());
    }

    public static void verifyEntries(List<NamedEntry> list, NamedEntry[] entries, boolean checkCount) throws Exception {
        try {
            if (checkCount) {
                TestProvisioningUtil.assertEquals((int)list.size(), (int)entries.length);
            }
            HashSet<String> ids = new HashSet<String>();
            for (NamedEntry entry : list) {
                ids.add(entry.getId());
            }
            for (NamedEntry entry : entries) {
                TestProvisioningUtil.assertTrue((boolean)ids.contains(entry.getId()));
                ids.remove(entry.getId());
            }
            if (checkCount) {
                TestProvisioningUtil.assertEquals((int)ids.size(), (int)0);
            }
        }
        catch (AssertionFailedError e) {
            System.out.println("\n===== verifyEntries failed =====");
            System.out.println("Message:" + e.getMessage());
            System.out.println("\nlist contains " + list.size() + " entries:");
            for (NamedEntry entry : list) {
                System.out.println("    " + entry.getName());
            }
            System.out.println("entries contains " + entries.length + " entries:");
            for (NamedEntry entry : entries) {
                System.out.println("    " + entry.getName());
            }
            System.out.println();
            throw e;
        }
    }

    public static void verifyEntriesById(List<NamedEntry> list, String[] names, boolean checkCount) throws Exception {
        HashSet<String> idsInList = new HashSet<String>();
        for (NamedEntry entry : list) {
            idsInList.add(entry.getId());
        }
        TestProvisioningUtil.verifyEntries(idsInList, names, checkCount);
    }

    public static void verifyEntriesByName(List<NamedEntry> list, String[] names, boolean checkCount) throws Exception {
        HashSet<String> namesInList = new HashSet<String>();
        for (NamedEntry entry : list) {
            namesInList.add(entry.getName());
        }
        TestProvisioningUtil.verifyEntries(namesInList, names, checkCount);
    }

    public static void verifyEntries(Set<String> list, String[] names, boolean checkCount) throws Exception {
        try {
            if (checkCount) {
                TestProvisioningUtil.assertEquals((int)names.length, (int)list.size());
            }
            for (String name : names) {
                TestProvisioningUtil.assertTrue((boolean)list.contains(name));
            }
        }
        catch (AssertionFailedError e) {
            System.out.println("\n===== verifyEntries failed =====");
            System.out.println("Message:" + e.getMessage());
            System.out.println("\nlist contains " + list.size() + " entries:");
            for (String name : list) {
                System.out.println("    " + name);
            }
            System.out.println("entries contains " + names.length + " entries:");
            for (String name : names) {
                System.out.println("    " + name);
            }
            System.out.println();
            throw e;
        }
    }

    public static void verifyEquals(Set<String> expected, Set<String> atual) throws Exception {
        TestProvisioningUtil.assertEquals((int)0, (int)SetUtil.subtract(expected, atual).size());
        TestProvisioningUtil.assertEquals((int)0, (int)SetUtil.subtract(atual, expected).size());
    }

    public static Provisioning getProvisioning(Class cls) throws ServiceException {
        if (cls == LdapProvisioning.class) {
            return TestProvisioningUtil.getLdapProvisioning();
        }
        if (cls == SoapProvisioning.class) {
            return TestProvisioningUtil.getSoapProvisioning();
        }
        throw ServiceException.FAILURE("unsupported Provisioning class", null);
    }

    public static LdapProvisioning getLdapProvisioning() throws ServiceException {
        LdapProvisioning lp = (LdapProvisioning)Provisioning.getInstance();
        return lp;
    }

    public static SoapProvisioning getSoapProvisioning() throws ServiceException {
        SoapProvisioning sp = new SoapProvisioning();
        sp.soapSetURI("https://localhost:7071/service/admin/soap/");
        sp.soapZimbraAdminAuthenticate();
        return sp;
    }

    public static SoapProvisioning getSoapProvisioning(String userName, String password) throws ServiceException {
        SoapProvisioning sp = new SoapProvisioning();
        sp.soapSetURI("https://localhost:7071/service/admin/soap/");
        sp.soapAdminAuthenticate(userName, password);
        return sp;
    }

    public static SoapProvisioningUser getSoapProvisioningUser(String userName, String password) throws ServiceException {
        SoapProvisioningUser spu = new SoapProvisioningUser(userName, password);
        spu.auth();
        return spu;
    }

    public static class SoapProvisioningUser
    extends SoapProvisioning {
        String mName;
        String mPassword;

        SoapProvisioningUser(String name, String password) {
            this.mName = name;
            this.mPassword = password;
            this.setURL();
        }

        private void setURL() {
            this.soapSetURI(TestUtil.getSoapUrl());
        }

        private void auth() throws ServiceException {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.AUTH_REQUEST);
            Element a = req.addElement("account");
            a.addAttribute("by", "name");
            a.setText(this.mName);
            req.addElement("password").setText(this.mPassword);
            Element response = this.invoke(req);
            String authToken = response.getElement("authToken").getText();
            this.setAuthToken(new ZAuthToken(authToken));
        }

        public Element invokeOnTargetAccount(Element request, String targetId) throws ServiceException {
            return super.invokeOnTargetAccount(request, targetId);
        }
    }

    public static class IDNName {
        String mUincodeName;
        String mAsciiName;

        IDNName(String uName) {
            this.mUincodeName = uName;
            String[] parts = uName.split("@");
            this.mAsciiName = parts.length == 2 ? parts[0] + "@" + IDNUtil.toAsciiDomainName(parts[1]) : IDNUtil.toAsciiDomainName(uName);
        }

        IDNName(String localPart, String uName) {
            this.mUincodeName = localPart + "@" + uName;
            this.mAsciiName = localPart + "@" + IDNUtil.toAsciiDomainName(uName);
        }

        String uName() {
            return this.mUincodeName;
        }

        String aName() {
            return this.mAsciiName;
        }
    }
}

