/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.SetUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Alias;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.MailTarget;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.PreAuthKey;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.ZAttrAccount;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.account.auth.ZimbraCustomAuth;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.custom.CustomLdapProvisioning;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.cs.mime.MimeTypeInfo;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProvisioning
extends TestCase {
    private static final boolean TEST_STARTTLS = false;
    private Provisioning mProv;
    LdapProvisioning mLdapProv;
    CustomProvTester mCustomProvTester;
    SoapProvisioning mSoapProv;
    private String TEST_ID;
    private String PRE_AUTH_KEY;
    private String PASSWORD;
    private String SPECIAL_CHARS_ALLOWED_IN_DOMAIN;
    private String SPECIAL_CHARS_ALLOWED_IN_USER_PART;
    private String COS_NAME;
    private String DOMAIN_NAME;
    private String DOMAIN_NAME_SPECIAL_CHARS;
    private String OTHER_DOMAIN_NAME;
    private String SERVER_NAME;
    private String ZIMLET_NAME;
    private String BASE_DN_PSEUDO_ATTR = "ldap.baseDN";
    private String NEW_NAME;
    private String NEW_EMAIL;
    private String NEW_EMAIL_IN_OTHER_DOMAIN;
    private String DEFAULT_LDAP_ADMIN_USER;
    private String ADMIN_USER;
    private String ADMIN_EMAIL;
    private String ACCT_USER;
    private String ACCT_EMAIL;
    private String ACCT_USER_SPECIAL_CHARS;
    private String ACCT_EMAIL_SPECIAL_CHARS;
    private String ACCT_ALIAS_USER;
    private String ACCT_ALIAS_EMAIL;
    private String ACCT_ALIAS_AFTER_ACCOUNT_RENAME_TO_OTHER_DMAIN_EMAIL;
    private String ACCT_ALIAS_IN_OTHER_DOMAIN_USER;
    private String ACCT_ALIAS_IN_OTHER_DOMAIN_EMAIL;
    private String ACCT_ALIAS_IN_OTHER_DOMAIN_AFTER_ACCOUNT_RENAME_TO_ORIG_DOMAIN_EMAIL;
    private String ACCT_FULL_NAME;
    private String ACCT_NAMING_ATTR;
    private String ACCT_NAMING_ATTR_VALUE;
    private String ACCT_BASE_DN;
    private String CR_USER;
    private String CR_EMAIL;
    private String CR_ALIAS_USER;
    private String CR_ALIAS_EMAIL;
    private String DL_USER;
    private String DL_EMAIL;
    private String DL_USER_SPECIAL_CHARS;
    private String DL_EMAIL_SPECIAL_CHARS;
    private String DL_ALIAS_USER;
    private String DL_ALIAS_EMAIL;
    private String DL_NESTED_USER;
    private String DL_NESTED_EMAIL;
    private String DL_NESTED_ALIAS_USER;
    private String DL_NESTED_ALIAS_EMAIL;
    private String DATA_SOURCE_NAME;
    private String IDENTITY_NAME;
    private String SIGNATURE_NAME;
    private String SIGNATURE_VALUE;
    private String SIGNATURE_VALUE_MODIFIED;

    public void setUp() throws Exception {
        this.mProv = Provisioning.getInstance();
        TestProvisioning.assertTrue((boolean)(this.mProv instanceof LdapProvisioning));
        this.mLdapProv = (LdapProvisioning)this.mProv;
        this.mCustomProvTester = new CustomProvTester(this.mProv);
        this.mSoapProv = new SoapProvisioning();
        this.mSoapProv.soapSetURI(TestUtil.getAdminSoapUrl());
        this.mSoapProv.soapZimbraAdminAuthenticate();
        this.TEST_ID = TestProvisioningUtil.genTestId();
        this.PRE_AUTH_KEY = PreAuthKey.generateRandomPreAuthKey();
        this.PASSWORD = "test123";
        this.SPECIAL_CHARS_ALLOWED_IN_DOMAIN = "/";
        this.SPECIAL_CHARS_ALLOWED_IN_USER_PART = "/";
        this.COS_NAME = "cos-" + this.TEST_ID;
        this.DOMAIN_NAME = TestProvisioningUtil.baseDomainName("domain", this.TEST_ID);
        this.DOMAIN_NAME_SPECIAL_CHARS = TestProvisioningUtil.baseDomainName("domain-" + this.SPECIAL_CHARS_ALLOWED_IN_DOMAIN, this.TEST_ID);
        this.OTHER_DOMAIN_NAME = "other-" + this.DOMAIN_NAME;
        this.SERVER_NAME = "server-" + this.TEST_ID;
        this.ZIMLET_NAME = "zimlet-" + this.TEST_ID;
        this.NEW_NAME = "newname";
        this.NEW_EMAIL = this.NEW_NAME + "-" + this.TEST_ID + "@" + this.DOMAIN_NAME;
        this.NEW_EMAIL_IN_OTHER_DOMAIN = this.NEW_NAME + "-" + this.TEST_ID + "@" + this.OTHER_DOMAIN_NAME;
        this.DEFAULT_LDAP_ADMIN_USER = LC.zimbra_ldap_user.value();
        this.ADMIN_USER = "admin";
        this.ADMIN_EMAIL = this.ADMIN_USER + "@" + this.DOMAIN_NAME;
        this.ACCT_USER = "acct-1";
        this.ACCT_EMAIL = this.ACCT_USER + "@" + this.DOMAIN_NAME;
        this.ACCT_USER_SPECIAL_CHARS = "acct-special-chars-" + this.SPECIAL_CHARS_ALLOWED_IN_USER_PART;
        this.ACCT_EMAIL_SPECIAL_CHARS = this.ACCT_USER_SPECIAL_CHARS + "@" + this.DOMAIN_NAME_SPECIAL_CHARS;
        this.ACCT_ALIAS_USER = "alias-of-" + this.ACCT_USER;
        this.ACCT_ALIAS_EMAIL = this.ACCT_ALIAS_USER + "@" + this.DOMAIN_NAME;
        this.ACCT_ALIAS_AFTER_ACCOUNT_RENAME_TO_OTHER_DMAIN_EMAIL = this.ACCT_ALIAS_USER + "@" + this.OTHER_DOMAIN_NAME;
        this.ACCT_ALIAS_IN_OTHER_DOMAIN_USER = this.ACCT_ALIAS_USER + "-in-other-domain";
        this.ACCT_ALIAS_IN_OTHER_DOMAIN_EMAIL = this.ACCT_ALIAS_IN_OTHER_DOMAIN_USER + "@" + this.OTHER_DOMAIN_NAME;
        this.ACCT_ALIAS_IN_OTHER_DOMAIN_AFTER_ACCOUNT_RENAME_TO_ORIG_DOMAIN_EMAIL = this.ACCT_ALIAS_IN_OTHER_DOMAIN_USER + "@" + this.DOMAIN_NAME;
        this.ACCT_FULL_NAME = "Phoebe Shao";
        this.ACCT_NAMING_ATTR = LC.get("ldap_dit_naming_rdn_attr_user");
        if (StringUtil.isNullOrEmpty(this.ACCT_NAMING_ATTR)) {
            this.ACCT_NAMING_ATTR = "uid";
        }
        this.ACCT_NAMING_ATTR_VALUE = this.namingAttrValue(this.ACCT_USER);
        this.ACCT_BASE_DN = "ou=grp1,ou=mail,o=Comcast";
        this.CR_USER = "cr-1";
        this.CR_EMAIL = this.CR_USER + "@" + this.DOMAIN_NAME;
        this.CR_ALIAS_USER = "alias-of-" + this.CR_USER;
        this.CR_ALIAS_EMAIL = this.CR_ALIAS_USER + "@" + this.DOMAIN_NAME;
        this.DL_USER = "dl-1";
        this.DL_EMAIL = this.DL_USER + "@" + this.DOMAIN_NAME;
        this.DL_USER_SPECIAL_CHARS = "dl-special-chars-" + this.SPECIAL_CHARS_ALLOWED_IN_USER_PART;
        this.DL_EMAIL_SPECIAL_CHARS = this.DL_USER_SPECIAL_CHARS + "@" + this.DOMAIN_NAME_SPECIAL_CHARS;
        this.DL_ALIAS_USER = "alias-of" + this.DL_USER;
        this.DL_ALIAS_EMAIL = this.DL_ALIAS_USER + "@" + this.DOMAIN_NAME;
        this.DL_NESTED_USER = "dl-nested";
        this.DL_NESTED_EMAIL = this.DL_NESTED_USER + "@" + this.DOMAIN_NAME;
        this.DL_NESTED_ALIAS_USER = "alias-of-" + this.DL_NESTED_USER;
        this.DL_NESTED_ALIAS_EMAIL = this.DL_NESTED_ALIAS_USER + "@" + this.DOMAIN_NAME;
        this.DATA_SOURCE_NAME = "datasource-1";
        this.IDENTITY_NAME = "identity-1";
        this.SIGNATURE_NAME = "signature-1";
        this.SIGNATURE_VALUE = "this is my signature";
        this.SIGNATURE_VALUE_MODIFIED = "this is my signature MODIFIED";
    }

    private List<NamedEntry> searchAccountsInDomain(Domain domain) throws ServiceException {
        Provisioning.SearchOptions options = new Provisioning.SearchOptions();
        int flags = 0;
        flags = 1;
        options.setFlags(flags);
        options.setDomain(domain);
        return this.mProv.searchDirectory(options);
    }

    private List<NamedEntry> searchAliasesInDomain(Domain domain) throws ServiceException {
        Provisioning.SearchOptions options = new Provisioning.SearchOptions();
        int flags = 0;
        flags = 2;
        options.setFlags(flags);
        options.setDomain(domain);
        return this.mProv.searchDirectory(options);
    }

    private void setDefaultDomain(String domain) throws Exception {
        HashMap<String, String> confAttrs = new HashMap<String, String>();
        confAttrs.put("zimbraDefaultDomainName", domain);
        this.mProv.modifyAttrs(this.mProv.getConfig(), confAttrs, true);
    }

    private String namingAttrValue(String name) {
        return name + ".mailuser";
    }

    private void healthTest() throws Exception {
        System.out.println("Testing health");
        this.mProv.healthCheck();
    }

    private Config configTest() throws Exception {
        System.out.println("Testing config");
        Config entry = this.mProv.getConfig();
        TestProvisioning.assertNotNull((Object)(entry != null ? 1 : 0));
        return entry;
    }

    private String cosTest() throws Exception {
        System.out.println("Testing cos");
        Cos entry = this.mProv.createCos(this.COS_NAME, new HashMap<String, Object>());
        Cos entryGot = this.mProv.get(Provisioning.CosBy.id, entry.getId());
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        entryGot = this.mProv.get(Provisioning.CosBy.name, this.COS_NAME);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        Cos defaultCos = this.mProv.get(Provisioning.CosBy.name, "default");
        TestProvisioning.assertNotNull((Object)defaultCos);
        String destCosName = "cos2-" + this.TEST_ID;
        Cos destCos = this.mProv.copyCos(defaultCos.getId(), destCosName);
        List<NamedEntry> list = this.mProv.getAllCos();
        TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{defaultCos, entry, destCos}, false);
        this.mProv.renameCos(entry.getId(), this.NEW_NAME);
        this.mProv.renameCos(entry.getId(), this.COS_NAME);
        return entry.getName();
    }

    private String[] domainTest() throws Exception {
        System.out.println("Testing domain");
        int numVirtualHosts = 500;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraPreAuthKey", this.PRE_AUTH_KEY);
        HashSet<String> virtualHosts = new HashSet<String>();
        for (int i = 0; i < numVirtualHosts; ++i) {
            String virtualHostName = "vhost-" + i + "-" + this.TEST_ID + ".com";
            virtualHosts.add(virtualHostName);
        }
        attrs.put("zimbraVirtualHostname", virtualHosts.toArray(new String[0]));
        Domain entry = this.mProv.createDomain(this.DOMAIN_NAME, attrs);
        Domain entryGot = this.mProv.get(Provisioning.DomainBy.id, entry.getId());
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        entryGot = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        for (int i = 0; i < numVirtualHosts; ++i) {
            String virtualHostName = "vhost-" + i + "-" + this.TEST_ID + ".com";
            entryGot = this.mProv.get(Provisioning.DomainBy.virtualHostname, virtualHostName);
            TestProvisioningUtil.verifySameEntry(entry, entryGot);
        }
        Domain otherEntry = this.mProv.createDomain(this.OTHER_DOMAIN_NAME, attrs);
        Domain specialCharEntry = this.mProv.createDomain(this.DOMAIN_NAME_SPECIAL_CHARS, attrs);
        List<NamedEntry> list = this.mProv.getAllDomains();
        TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{entry, otherEntry, specialCharEntry}, false);
        this.setDefaultDomain(this.DOMAIN_NAME);
        return new String[]{entry.getName(), otherEntry.getName(), specialCharEntry.getName()};
    }

    private void mimeTest() throws Exception {
        System.out.println("Testing mime");
        List<MimeTypeInfo> mime = this.mProv.getMimeTypes("all");
        TestProvisioning.assertEquals((int)1, (int)mime.size());
    }

    private Server serverTest() throws Exception {
        System.out.println("Testing server");
        HashMap<String, Object> serverAttrs = new HashMap<String, Object>();
        Server entry = this.mProv.createServer(this.SERVER_NAME, serverAttrs);
        Server entryGot = this.mProv.get(Provisioning.ServerBy.id, entry.getId());
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        entryGot = this.mProv.get(Provisioning.ServerBy.name, this.SERVER_NAME);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        Server localServer = this.mProv.getLocalServer();
        TestProvisioning.assertNotNull((Object)localServer);
        List<NamedEntry> list = this.mProv.getAllServers();
        TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{localServer, entry}, false);
        list = this.mProv.getAllServers("mailbox");
        TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{localServer}, false);
        return entry;
    }

    private Zimlet zimletTest() throws Exception {
        System.out.println("Testing zimlet");
        HashMap<String, Object> zimletAttrs = new HashMap<String, Object>();
        zimletAttrs.put("zimbraZimletVersion", "1.0");
        Zimlet entry = this.mProv.createZimlet(this.ZIMLET_NAME, zimletAttrs);
        Zimlet entryGot = this.mProv.getZimlet(this.ZIMLET_NAME);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        return entry;
    }

    private void externalAuthTest(Account account, boolean startTLS) throws Exception {
        Domain domain = this.mProv.getDomain(account);
        HashMap<String, String> attrsToMod = new HashMap<String, String>();
        attrsToMod.put("zimbraAuthMech", "ldap");
        attrsToMod.put("zimbraAuthLdapURL", "ldap://" + LC.zimbra_server_hostname.value() + ":389");
        attrsToMod.put("zimbraAuthLdapSearchFilter", "(zimbraMailDeliveryAddress=%n)");
        attrsToMod.put("zimbraAuthLdapSearchBindPassword", LC.zimbra_ldap_password.value());
        attrsToMod.put("zimbraAuthLdapSearchBindDn", LC.zimbra_ldap_userdn.value());
        if (startTLS) {
            attrsToMod.put("zimbraAuthLdapStartTlsEnabled", "TRUE");
        }
        this.mProv.modifyAttrs(domain, attrsToMod, true);
        this.mProv.authAccount(account, this.PASSWORD, AuthContext.Protocol.test);
    }

    private void authTest(Account account) throws Exception {
        System.out.println("Testing auth");
        this.mProv.authAccount(account, this.PASSWORD, AuthContext.Protocol.test);
        this.externalAuthTest(account, false);
        Domain domain = this.mProv.getDomain(account);
        HashMap<String, String> attrsToMod = new HashMap<String, String>();
        attrsToMod.clear();
        attrsToMod.put("zimbraAuthMech", "kerberos5");
        attrsToMod.put("zimbraAuthKerberos5Realm", "PHOEBE.LOCAL");
        this.mProv.modifyAttrs(domain, attrsToMod, true);
        attrsToMod.clear();
        attrsToMod.put("zimbraForeignPrincipal", "kerberos5:user1@PHOEBE.LOCAL");
        this.mProv.modifyAttrs(account, attrsToMod, true);
        attrsToMod.clear();
        String customAuthHandlerName = "test";
        String args = "http://blah.com:123    green \" ocean blue   \"  \"\" yelllow \"\"";
        attrsToMod.put("zimbraAuthMech", "custom:" + customAuthHandlerName + " " + args);
        this.mProv.modifyAttrs(domain, attrsToMod, true);
        ZimbraCustomAuth.register(customAuthHandlerName, new TestCustomAuth(account, this.PASSWORD));
        this.mProv.authAccount(account, this.PASSWORD, AuthContext.Protocol.test);
        try {
            this.mProv.authAccount(account, this.PASSWORD + "-not", AuthContext.Protocol.test);
            TestProvisioning.fail((String)"AccountServiceException.AUTH_FAILED not thrown");
        }
        catch (ServiceException e) {
            TestProvisioning.assertEquals((String)"account.AUTH_FAILED", (String)e.getCode());
        }
        attrsToMod.put("zimbraAuthMech", "zimbra");
        this.mProv.modifyAttrs(domain, attrsToMod, true);
        HashMap<String, String> params = new HashMap<String, String>();
        String authBy = "name";
        long timestamp = System.currentTimeMillis();
        long expires = 0L;
        params.put("account", this.ACCT_EMAIL);
        params.put("by", authBy);
        params.put("timestamp", timestamp + "");
        params.put("expires", expires + "");
        String preAuth = PreAuthKey.computePreAuth(params, this.PRE_AUTH_KEY);
        HashMap<String, Object> authCtxt = new HashMap<String, Object>();
        authCtxt.put("ocip", "127.0.0.1");
        authCtxt.put("anp", this.ACCT_EMAIL);
        this.mProv.preAuthAccount(account, this.ACCT_EMAIL, authBy, timestamp, 0L, preAuth, authCtxt);
    }

    private Account adminAccountTest() throws Exception {
        System.out.println("Testing admin account");
        Account entry = this.mProv.get(Provisioning.AccountBy.adminName, this.DEFAULT_LDAP_ADMIN_USER);
        TestProvisioning.assertNotNull((Object)entry);
        HashMap<String, Object> acctAttrs = new HashMap<String, Object>();
        this.mCustomProvTester.addAttr(acctAttrs, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
        this.mCustomProvTester.addAttr(acctAttrs, this.ACCT_NAMING_ATTR, this.namingAttrValue(this.ADMIN_USER));
        acctAttrs.put("zimbraIsAdminAccount", "TRUE");
        entry = this.mProv.createAccount(this.ADMIN_EMAIL, this.PASSWORD, acctAttrs);
        Account entryGot = this.mProv.get(Provisioning.AccountBy.name, this.ADMIN_EMAIL);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        Account entryGotByuser = this.mProv.get(Provisioning.AccountBy.name, this.ADMIN_USER);
        TestProvisioningUtil.verifySameEntry(entryGot, entryGotByuser);
        if (!Flag.needLdapPaging("getAllAdminAccounts")) {
            List<NamedEntry> list = this.mProv.getAllAdminAccounts();
            TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{entry}, false);
        }
        return entry;
    }

    private Account[] accountTest(Account adminAcct, Cos cos, Domain domain, Domain otherDomain) throws Exception {
        List<NamedEntry> list;
        Account acctY;
        Account acctX;
        boolean correct;
        Account entrySpecialChars;
        String entryId;
        Account entry;
        block21: {
            TestVisitor visitor;
            Account entryGot;
            String acctDn;
            HashMap<String, Object> acctAttrs;
            String krb5Principal2;
            String krb5Principal1;
            block20: {
                System.out.println("Testing account");
                krb5Principal1 = "fp1@FOO.COM";
                krb5Principal2 = "fp2@BAR.COM";
                acctAttrs = new HashMap<String, Object>();
                this.mCustomProvTester.addAttr(acctAttrs, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
                this.mCustomProvTester.addAttr(acctAttrs, this.ACCT_NAMING_ATTR, this.ACCT_NAMING_ATTR_VALUE);
                acctAttrs.put("zimbraCOSId", cos.getId());
                acctAttrs.put("zimbraForeignPrincipal", new String[]{"kerberos5:" + krb5Principal1, "kerberos5:" + krb5Principal2});
                entry = this.mProv.createAccount(this.ACCT_EMAIL, this.PASSWORD, acctAttrs);
                entryId = entry.getId();
                acctDn = this.ACCT_NAMING_ATTR + "=" + this.ACCT_NAMING_ATTR_VALUE + "," + this.ACCT_BASE_DN;
                this.mCustomProvTester.verifyDn(entry, acctDn);
                HashMap<String, Object> acctAttrsSpecialChars = new HashMap<String, Object>();
                this.mCustomProvTester.addAttr(acctAttrsSpecialChars, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
                this.mCustomProvTester.addAttr(acctAttrsSpecialChars, this.ACCT_NAMING_ATTR, this.namingAttrValue(this.ACCT_USER_SPECIAL_CHARS));
                acctAttrs.put("zimbraCOSId", cos.getId());
                entrySpecialChars = this.mProv.createAccount(this.ACCT_EMAIL_SPECIAL_CHARS, this.PASSWORD, acctAttrsSpecialChars);
                String acctSpecialCharsDn = this.ACCT_NAMING_ATTR + "=" + this.namingAttrValue(this.ACCT_USER_SPECIAL_CHARS) + "," + this.ACCT_BASE_DN;
                this.mCustomProvTester.verifyDn(entrySpecialChars, acctSpecialCharsDn);
                entryGot = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL_SPECIAL_CHARS);
                TestProvisioningUtil.verifySameEntry(entrySpecialChars, entryGot);
                this.mProv.addAlias(entry, this.ACCT_ALIAS_EMAIL);
                correct = false;
                try {
                    this.mProv.addAlias(entry, this.ACCT_ALIAS_IN_OTHER_DOMAIN_EMAIL);
                    correct = true;
                }
                catch (ServiceException e) {
                    if (!this.mCustomProvTester.isCustom()) break block20;
                    correct = true;
                }
            }
            TestProvisioning.assertTrue((boolean)correct);
            entryGot = this.mProv.get(Provisioning.AccountBy.id, entry.getId());
            TestProvisioningUtil.verifySameEntry(entry, entryGot);
            entryGot = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
            TestProvisioningUtil.verifySameEntry(entry, entryGot);
            entryGot = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_ALIAS_EMAIL);
            TestProvisioningUtil.verifySameEntry(entry, entryGot);
            entryGot = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_ALIAS_IN_OTHER_DOMAIN_EMAIL);
            if (this.mCustomProvTester.isCustom()) {
                TestProvisioning.assertEquals(null, (Object)entryGot);
            } else {
                TestProvisioningUtil.verifySameEntry(entry, entryGot);
            }
            entryGot = this.mProv.get(Provisioning.AccountBy.krb5Principal, krb5Principal1);
            TestProvisioningUtil.verifySameEntry(entry, entryGot);
            entryGot = this.mProv.get(Provisioning.AccountBy.krb5Principal, krb5Principal2);
            TestProvisioningUtil.verifySameEntry(entry, entryGot);
            String krb5PrincipalDup = "fp-dup@FOO.COM";
            acctAttrs.clear();
            acctAttrs.put("zimbraForeignPrincipal", new String[]{"kerberos5:" + krb5PrincipalDup});
            acctX = this.mProv.createAccount("acctx-dup-kerberos@" + this.DOMAIN_NAME, "test123", acctAttrs);
            acctY = this.mProv.createAccount("accty-dup-kerberos@" + this.DOMAIN_NAME, "test123", acctAttrs);
            try {
                this.mProv.get(Provisioning.AccountBy.krb5Principal, krb5PrincipalDup);
                TestProvisioning.fail();
            }
            catch (ServiceException e) {
                TestProvisioning.assertEquals((String)"account.MULTIPLE_ACCOUNTS_MATCHED", (String)e.getCode());
            }
            HashMap<String, Object> domainAttrs = new HashMap<String, Object>();
            domainAttrs.put("zimbraAuthMech", "kerberos5");
            domainAttrs.put("zimbraAuthKerberos5Realm", "JUNKREALM.COM");
            String krb5DomainName = "krb-test." + this.DOMAIN_NAME;
            Domain krb5TestDomain = this.mProv.createDomain(krb5DomainName, domainAttrs);
            Account krb5TestAcct = this.mProv.createAccount("user1@" + krb5DomainName, "test123", null);
            entryGot = this.mProv.get(Provisioning.AccountBy.krb5Principal, "user1@JUNKREALM.COM");
            TestProvisioningUtil.verifySameEntry(krb5TestAcct, entryGot);
            list = null;
            if (!Flag.needLdapPaging("getAllAccounts_domain")) {
                list = this.mProv.getAllAccounts(domain);
                TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{entry, adminAcct, acctX, acctY}, this.mCustomProvTester.verifyAccountCountForDomainBasedSearch());
            }
            if (!Flag.needLdapPaging("getAllAccounts_domain_visitor")) {
                visitor = new TestVisitor();
                this.mProv.getAllAccounts(domain, visitor);
                TestProvisioningUtil.verifyEntries(visitor.visited(), new NamedEntry[]{entry, adminAcct, acctX, acctY}, this.mCustomProvTester.verifyAccountCountForDomainBasedSearch());
            }
            if (!Flag.needLdapPaging("getAllAccounts_domain_server_visitor")) {
                visitor = new TestVisitor();
                Server server = this.mProv.getLocalServer();
                this.mProv.getAllAccounts(domain, server, visitor);
                TestProvisioningUtil.verifyEntries(visitor.visited(), new NamedEntry[]{entry, adminAcct, acctX, acctY}, this.mCustomProvTester.verifyAccountCountForDomainBasedSearch());
            }
            this.mProv.modifyAccountStatus(entry, "maintenance");
            this.mProv.modifyAccountStatus(entry, "active");
            this.mProv.renameAccount(entryId, this.NEW_EMAIL);
            if (!Flag.needLdapPaging("searchDirectory")) {
                list = this.searchAccountsInDomain(domain);
                TestProvisioningUtil.verifyEntriesById(list, new String[]{entryId}, false);
                TestProvisioningUtil.verifyEntriesByName(list, new String[]{this.NEW_EMAIL}, false);
                entry = this.mProv.get(Provisioning.AccountBy.id, entryId);
                if (this.mCustomProvTester.isCustom()) {
                    this.mCustomProvTester.verifyDn(entry, acctDn);
                    list = this.searchAliasesInDomain(domain);
                    TestProvisioningUtil.verifyEntriesByName(list, new String[]{this.ACCT_ALIAS_EMAIL}, this.mCustomProvTester.verifyAliasCountForDomainBasedSearch());
                } else {
                    list = this.searchAliasesInDomain(domain);
                    TestProvisioningUtil.verifyEntriesByName(list, new String[]{this.ACCT_ALIAS_EMAIL}, true);
                    list = this.searchAliasesInDomain(otherDomain);
                    TestProvisioningUtil.verifyEntriesByName(list, new String[]{this.ACCT_ALIAS_IN_OTHER_DOMAIN_EMAIL}, true);
                }
            }
            correct = false;
            try {
                this.mProv.renameAccount(entryId, this.NEW_EMAIL_IN_OTHER_DOMAIN);
                correct = true;
            }
            catch (ServiceException e) {
                if (!this.mCustomProvTester.isCustom()) break block21;
                correct = true;
            }
        }
        TestProvisioning.assertTrue((boolean)correct);
        entry = this.mProv.get(Provisioning.AccountBy.id, entryId);
        if (!this.mCustomProvTester.isCustom() && !Flag.needLdapPaging("searchDirectory")) {
            list = this.searchAccountsInDomain(otherDomain);
            TestProvisioningUtil.verifyEntriesById(list, new String[]{entryId}, true);
            TestProvisioningUtil.verifyEntriesByName(list, new String[]{this.NEW_EMAIL_IN_OTHER_DOMAIN}, true);
            list = this.searchAliasesInDomain(domain);
            TestProvisioning.assertEquals((int)0, (int)list.size());
            list = this.searchAliasesInDomain(otherDomain);
            TestProvisioningUtil.verifyEntriesByName(list, new String[]{this.ACCT_ALIAS_AFTER_ACCOUNT_RENAME_TO_OTHER_DMAIN_EMAIL, this.ACCT_ALIAS_IN_OTHER_DOMAIN_EMAIL}, true);
        }
        this.mProv.renameAccount(entryId, this.ACCT_EMAIL);
        if (!Flag.needLdapPaging("searchDirectory")) {
            list = this.searchAccountsInDomain(domain);
            TestProvisioningUtil.verifyEntriesById(list, new String[]{entryId}, false);
            TestProvisioningUtil.verifyEntriesByName(list, new String[]{this.ACCT_EMAIL}, false);
            entry = this.mProv.get(Provisioning.AccountBy.id, entryId);
            if (this.mCustomProvTester.isCustom()) {
                list = this.searchAliasesInDomain(domain);
                TestProvisioningUtil.verifyEntriesByName(list, new String[]{this.ACCT_ALIAS_EMAIL}, this.mCustomProvTester.verifyAliasCountForDomainBasedSearch());
            } else {
                list = this.searchAliasesInDomain(otherDomain);
                TestProvisioning.assertEquals((int)0, (int)list.size());
                list = this.searchAliasesInDomain(domain);
                TestProvisioningUtil.verifyEntriesByName(list, new String[]{this.ACCT_ALIAS_EMAIL, this.ACCT_ALIAS_IN_OTHER_DOMAIN_AFTER_ACCOUNT_RENAME_TO_ORIG_DOMAIN_EMAIL}, true);
            }
        }
        this.mProv.removeAlias(entry, this.ACCT_ALIAS_EMAIL);
        if (!this.mCustomProvTester.isCustom()) {
            this.mProv.removeAlias(entry, this.ACCT_ALIAS_IN_OTHER_DOMAIN_AFTER_ACCOUNT_RENAME_TO_ORIG_DOMAIN_EMAIL);
        }
        if (!Flag.needLdapPaging("searchDirectory")) {
            list = this.searchAliasesInDomain(domain);
            TestProvisioning.assertEquals((int)0, (int)list.size());
            list = this.searchAliasesInDomain(otherDomain);
            TestProvisioning.assertEquals((int)0, (int)list.size());
        }
        entry = this.mProv.get(Provisioning.AccountBy.id, entryId);
        this.mProv.setCOS(entry, cos);
        return new Account[]{entry, entrySpecialChars, acctX, acctY};
    }

    private void passwordTest(Account account) throws Exception {
        System.out.println("Testing password");
        this.mProv.changePassword(account, this.PASSWORD, this.PASSWORD);
        this.mProv.checkPasswordStrength(account, this.PASSWORD);
        this.mProv.setPassword(account, this.PASSWORD);
    }

    private void doLocaleTest(Account acct, String locale) throws Exception {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPrefLocale", locale);
        this.mSoapProv.modifyAttrs(acct, attrs, true);
        String provLocale = this.mSoapProv.getLocale(acct).toString();
        TestProvisioning.assertEquals((String)locale, (String)provLocale);
        String entryLocale = acct.getLocale().toString();
        TestProvisioning.assertEquals((String)locale, (String)entryLocale);
    }

    private void localeTest() throws Exception {
        System.out.println("Testing locale");
        Account acct = this.mSoapProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        TestProvisioning.assertNotNull((Object)acct);
        this.doLocaleTest(acct, "xxx");
        this.doLocaleTest(acct, "yyy");
        this.doLocaleTest(acct, "zzz");
    }

    private CalendarResource calendarResourceTest(Cos cos, Domain domain) throws Exception {
        System.out.println("Testing calendar resource");
        HashMap<String, Object> crAttrs = new HashMap<String, Object>();
        this.mCustomProvTester.addAttr(crAttrs, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
        this.mCustomProvTester.addAttr(crAttrs, this.ACCT_NAMING_ATTR, this.namingAttrValue(this.CR_USER));
        crAttrs.put("displayName", this.CR_USER);
        crAttrs.put("zimbraCalResType", "Equipment");
        crAttrs.put("zimbraCOSId", cos.getId());
        CalendarResource entry = this.mProv.createCalendarResource(this.CR_EMAIL, this.PASSWORD, crAttrs);
        this.mProv.addAlias(entry, this.CR_ALIAS_EMAIL);
        CalendarResource entryGot = this.mProv.get(Provisioning.CalendarResourceBy.id, entry.getId());
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        entryGot = this.mProv.get(Provisioning.CalendarResourceBy.name, this.CR_EMAIL);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        entryGot = this.mProv.get(Provisioning.CalendarResourceBy.name, this.CR_ALIAS_EMAIL);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        List list = null;
        if (!Flag.needLdapPaging("getAllCalendarResources_domain")) {
            list = this.mProv.getAllCalendarResources(domain);
            TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{entry}, this.mCustomProvTester.verifyAccountCountForDomainBasedSearch());
        }
        if (!Flag.needLdapPaging("getAllCalendarResources_domain_visitor")) {
            TestVisitor visitor = new TestVisitor();
            this.mProv.getAllCalendarResources(domain, visitor);
            TestProvisioningUtil.verifyEntries(visitor.visited(), new NamedEntry[]{entry}, this.mCustomProvTester.verifyAccountCountForDomainBasedSearch());
        }
        this.mProv.renameCalendarResource(entry.getId(), this.NEW_EMAIL);
        this.mProv.renameCalendarResource(entry.getId(), this.CR_EMAIL);
        return entry;
    }

    private DistributionList[] distributionListTest(Domain domain) throws Exception {
        System.out.println("Testing distribution list");
        HashMap<String, Object> dlAttrs = new HashMap<String, Object>();
        this.mCustomProvTester.addAttr(dlAttrs, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
        this.mCustomProvTester.addAttr(dlAttrs, this.ACCT_NAMING_ATTR, this.namingAttrValue(this.DL_USER));
        DistributionList entry = this.mProv.createDistributionList(this.DL_EMAIL, dlAttrs);
        this.mProv.addAlias(entry, this.DL_ALIAS_EMAIL);
        DistributionList entryGot = this.mProv.get(Provisioning.DistributionListBy.id, entry.getId());
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        entryGot = this.mProv.get(Provisioning.DistributionListBy.name, this.DL_EMAIL);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        entryGot = this.mProv.get(Provisioning.DistributionListBy.name, this.DL_ALIAS_EMAIL);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        HashMap<String, Object> dlNestedAttrs = new HashMap<String, Object>();
        this.mCustomProvTester.addAttr(dlNestedAttrs, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
        this.mCustomProvTester.addAttr(dlNestedAttrs, this.ACCT_NAMING_ATTR, this.namingAttrValue(this.DL_NESTED_USER));
        DistributionList dlNested = this.mProv.createDistributionList(this.DL_NESTED_EMAIL, dlNestedAttrs);
        this.mProv.addAlias(dlNested, this.DL_NESTED_ALIAS_EMAIL);
        String curDefaultDomain = this.mProv.getConfig().getAttr("zimbraDefaultDomainName");
        if (this.mCustomProvTester.isCustom()) {
            this.setDefaultDomain(this.DOMAIN_NAME_SPECIAL_CHARS);
        }
        HashMap<String, Object> dlAttrsSpecialChars = new HashMap<String, Object>();
        this.mCustomProvTester.addAttr(dlAttrsSpecialChars, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
        this.mCustomProvTester.addAttr(dlAttrsSpecialChars, this.ACCT_NAMING_ATTR, this.namingAttrValue(this.DL_USER_SPECIAL_CHARS));
        DistributionList dlSpecilaChars = this.mProv.createDistributionList(this.DL_EMAIL_SPECIAL_CHARS, dlAttrsSpecialChars);
        entryGot = this.mProv.get(Provisioning.DistributionListBy.name, this.DL_EMAIL_SPECIAL_CHARS);
        TestProvisioningUtil.verifySameEntry(dlSpecilaChars, entryGot);
        if (this.mCustomProvTester.isCustom()) {
            this.setDefaultDomain(curDefaultDomain);
        }
        this.mProv.addMembers(entry, new String[]{this.DL_NESTED_EMAIL});
        this.mProv.addMembers(dlNested, new String[]{this.ACCT_EMAIL});
        List list = null;
        if (!Flag.needLdapPaging("getAllDistributionLists")) {
            list = this.mProv.getAllDistributionLists(domain);
            TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{entry, dlNested}, this.mCustomProvTester.verifyDLCountForDomainBasedSearch());
        }
        Account account = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        Set<String> set = null;
        if (!Flag.needLdapPaging("getDistributionLists_account")) {
            set = this.mProv.getDistributionLists(account);
            TestProvisioning.assertEquals((int)2, (int)set.size());
            TestProvisioning.assertTrue((boolean)set.contains(entry.getId()));
            TestProvisioning.assertTrue((boolean)set.contains(dlNested.getId()));
        }
        if (!Flag.needLdapPaging("getDistributionLists_account_directonly_via")) {
            HashMap<String, String> via = new HashMap<String, String>();
            list = this.mProv.getDistributionLists(account, false, via);
            TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{entry, dlNested}, true);
            TestProvisioning.assertEquals((int)1, (int)via.size());
            TestProvisioning.assertEquals((String)dlNested.getName(), (String)((String)via.get(entry.getName())));
        }
        if (!Flag.needLdapPaging("getDistributionLists_account_directonly_via")) {
            list = this.mProv.getDistributionLists(account, true, null);
            TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{dlNested}, true);
        }
        if (!Flag.needLdapPaging("inDistributionList")) {
            boolean inList = this.mProv.inDistributionList(account, entry.getId());
            TestProvisioning.assertTrue((boolean)inList);
        }
        this.mProv.removeAlias(entry, this.DL_ALIAS_EMAIL);
        this.mProv.removeMembers(entry, new String[]{dlNested.getName()});
        this.mProv.renameDistributionList(entry.getId(), this.NEW_EMAIL);
        entryGot = this.mProv.get(Provisioning.DistributionListBy.name, this.NEW_EMAIL);
        TestProvisioningUtil.verifySameId(entry, entryGot);
        if (!Flag.needLdapPaging("getAllDistributionLists")) {
            list = this.mProv.getAllDistributionLists(domain);
            TestProvisioningUtil.verifyEntriesByName(list, new String[]{this.NEW_EMAIL, this.DL_NESTED_EMAIL}, this.mCustomProvTester.verifyDLCountForDomainBasedSearch());
        }
        entry = this.mProv.get(Provisioning.DistributionListBy.name, this.NEW_EMAIL);
        this.mProv.renameDistributionList(entry.getId(), this.DL_EMAIL);
        entryGot = this.mProv.get(Provisioning.DistributionListBy.name, this.DL_EMAIL);
        TestProvisioningUtil.verifySameId(entry, entryGot);
        if (!Flag.needLdapPaging("getAllDistributionLists")) {
            list = this.mProv.getAllDistributionLists(domain);
            TestProvisioningUtil.verifyEntriesByName(list, new String[]{this.DL_EMAIL, this.DL_NESTED_EMAIL}, this.mCustomProvTester.verifyDLCountForDomainBasedSearch());
        }
        return new DistributionList[]{entry, dlNested, dlSpecilaChars};
    }

    private DataSource dataSourceTest(Account account) throws Exception {
        System.out.println("Testing data source");
        HashMap<String, Object> dsAttrs = new HashMap<String, Object>();
        dsAttrs.put("zimbraDataSourceEnabled", "TRUE");
        dsAttrs.put("zimbraDataSourceConnectionType", "ssl");
        dsAttrs.put("zimbraDataSourceFolderId", "inbox");
        dsAttrs.put("zimbraDataSourceHost", "pop.google.com");
        dsAttrs.put("zimbraDataSourceLeaveOnServer", "TRUE");
        dsAttrs.put("zimbraDataSourcePassword", this.PASSWORD);
        dsAttrs.put("zimbraDataSourcePort", "9999");
        dsAttrs.put("zimbraDataSourceUsername", "mickymouse");
        dsAttrs.put("zimbraDataSourceEmailAddress", "micky@google.com");
        dsAttrs.put("zimbraPrefDefaultSignatureId", LdapUtil.generateUUID());
        dsAttrs.put("zimbraPrefFromDisplay", "Micky Mouse");
        dsAttrs.put("zimbraPrefReplyToAddress", "goofy@yahoo.com");
        dsAttrs.put("zimbraPrefReplyToDisplay", "Micky");
        DataSource entry = this.mProv.createDataSource(account, DataSource.Type.pop3, this.DATA_SOURCE_NAME, dsAttrs);
        DataSource entryGot = this.mProv.get(account, Provisioning.DataSourceBy.id, entry.getId());
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        entryGot = this.mProv.get(account, Provisioning.DataSourceBy.name, this.DATA_SOURCE_NAME);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        List<NamedEntry> list = this.mProv.getAllDataSources(account);
        TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{entry}, true);
        HashMap<String, Object> attrsToMod = new HashMap<String, Object>();
        attrsToMod.put("zimbraDataSourcePollingInterval", "100");
        this.mProv.modifyDataSource(account, entry.getId(), attrsToMod);
        return entry;
    }

    private Identity identityTest(Account account) throws Exception {
        System.out.println("Testing identity");
        HashMap<String, Object> identityAttrs = new HashMap<String, Object>();
        identityAttrs.put("zimbraPrefDefaultSignatureId", LdapUtil.generateUUID());
        identityAttrs.put("zimbraPrefFromAddress", "micky.mouse@zimbra,com");
        identityAttrs.put("zimbraPrefFromDisplay", "Micky Mouse");
        identityAttrs.put("zimbraPrefReplyToEnabled", "TRUE");
        identityAttrs.put("zimbraPrefReplyToAddress", "goofy@yahoo.com");
        identityAttrs.put("zimbraPrefReplyToDisplay", "Micky");
        Identity entry = this.mProv.createIdentity(account, this.IDENTITY_NAME, identityAttrs);
        Identity entryGot = this.mProv.get(account, Provisioning.IdentityBy.id, entry.getId());
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        entryGot = this.mProv.get(account, Provisioning.IdentityBy.name, this.IDENTITY_NAME);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        Identity defaultIdentity = this.mProv.get(account, Provisioning.IdentityBy.name, "DEFAULT");
        TestProvisioningUtil.verifySameId(account, defaultIdentity);
        TestProvisioning.assertEquals((String)"DEFAULT", (String)defaultIdentity.getName());
        List<NamedEntry> list = this.mProv.getAllIdentities(account);
        TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{defaultIdentity, entry}, true);
        HashMap<String, Object> attrsToMod = new HashMap<String, Object>();
        attrsToMod.put("zimbraPrefReplyToDisplay", "MM");
        this.mProv.modifyIdentity(account, this.IDENTITY_NAME, attrsToMod);
        String newName = "identity-new-name";
        attrsToMod.clear();
        attrsToMod.put("zimbraPrefIdentityName", newName);
        this.mProv.modifyIdentity(account, this.IDENTITY_NAME, attrsToMod);
        entryGot = this.mProv.get(account, Provisioning.IdentityBy.name, newName);
        entry = this.mProv.get(account, Provisioning.IdentityBy.id, entry.getId());
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        attrsToMod.clear();
        attrsToMod.put("zimbraPrefIdentityName", this.IDENTITY_NAME);
        this.mProv.modifyIdentity(account, newName, attrsToMod);
        entry = this.mProv.get(account, Provisioning.IdentityBy.id, entry.getId());
        return entry;
    }

    private void signatureTest(Account account) throws Exception {
        System.out.println("Testing signature");
        HashMap<String, Object> signatureAttrs = new HashMap<String, Object>();
        signatureAttrs.put("zimbraPrefMailSignature", this.SIGNATURE_VALUE);
        Signature entry = this.mProv.createSignature(account, this.SIGNATURE_NAME, signatureAttrs);
        Signature entryGot = this.mProv.get(account, Provisioning.SignatureBy.id, entry.getId());
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        entryGot = this.mProv.get(account, Provisioning.SignatureBy.name, this.SIGNATURE_NAME);
        TestProvisioningUtil.verifySameEntry(entry, entryGot);
        List<NamedEntry> list = this.mProv.getAllSignatures(account);
        TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{entry}, true);
        String defaultSigId = account.getAttr("zimbraPrefDefaultSignatureId");
        TestProvisioning.assertEquals((String)entry.getId(), (String)defaultSigId);
        HashMap<String, Object> attrsToMod = new HashMap<String, Object>();
        attrsToMod.put("zimbraPrefMailSignature", this.SIGNATURE_VALUE_MODIFIED);
        this.mProv.modifySignature(account, entry.getId(), attrsToMod);
        entryGot = this.mProv.get(account, Provisioning.SignatureBy.id, entry.getId());
        TestProvisioning.assertEquals((String)this.SIGNATURE_VALUE_MODIFIED, (String)entryGot.getAttr("zimbraPrefMailSignature"));
        String secondSigName = "second-sig";
        signatureAttrs.clear();
        Signature secondEntry = this.mProv.createSignature(account, secondSigName, signatureAttrs);
        HashMap<String, String> acctAttrs = new HashMap<String, String>();
        acctAttrs.put("zimbraPrefDefaultSignatureId", secondEntry.getId());
        this.mProv.modifyAttrs(account, acctAttrs);
        this.mProv.deleteSignature(account, entry.getId());
        String secondSigNameNew = "second-sig-new-name";
        signatureAttrs.clear();
        signatureAttrs.put("zimbraSignatureName", secondSigNameNew);
        this.mProv.modifySignature(account, secondEntry.getId(), signatureAttrs);
        defaultSigId = account.getAttr("zimbraPrefDefaultSignatureId");
        TestProvisioning.assertEquals((String)secondEntry.getId(), (String)defaultSigId);
        secondEntry = this.mProv.get(account, Provisioning.SignatureBy.name, secondSigNameNew);
        String thirdSigName = "third-sig";
        signatureAttrs.clear();
        Signature thirdEntry = this.mProv.createSignature(account, thirdSigName, signatureAttrs);
        String acctSigName = account.getAttr("zimbraSignatureName");
        TestProvisioning.assertEquals((String)thirdSigName, (String)acctSigName);
        list = this.mProv.getAllSignatures(account);
        TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{secondEntry, thirdEntry}, true);
        this.mProv.deleteSignature(account, thirdEntry.getId());
        String aSigValueOnAccount = "a signature value on account";
        String accountSigName = account.getName();
        acctAttrs.clear();
        acctAttrs.put("zimbraPrefMailSignature", aSigValueOnAccount);
        this.mProv.modifyAttrs(account, acctAttrs);
        Signature acctSig = this.mProv.get(account, Provisioning.SignatureBy.name, accountSigName);
        TestProvisioning.assertEquals((String)account.getName(), (String)acctSig.getName());
        TestProvisioning.assertNotSame((Object)account.getId(), (Object)acctSig.getId());
        TestProvisioning.assertEquals((String)acctSig.getAttr("zimbraPrefMailSignature"), (String)aSigValueOnAccount);
        acctSig = this.mProv.get(account, Provisioning.SignatureBy.id, acctSig.getId());
        TestProvisioning.assertNotSame((Object)account.getId(), (Object)acctSig.getId());
        TestProvisioning.assertEquals((String)acctSig.getAttr("zimbraPrefMailSignature"), (String)aSigValueOnAccount);
        list = this.mProv.getAllSignatures(account);
        TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{acctSig, secondEntry}, true);
        this.mProv.deleteSignature(account, acctSig.getId());
        acctAttrs.clear();
        acctAttrs.put("zimbraPrefMailSignature", aSigValueOnAccount);
        this.mProv.modifyAttrs(account, acctAttrs);
        acctSig = this.mProv.get(account, Provisioning.SignatureBy.name, accountSigName);
        acctAttrs.clear();
        acctAttrs.put("zimbraPrefDefaultSignatureId", acctSig.getId());
        this.mProv.modifyAttrs(account, acctAttrs);
        TestProvisioning.assertEquals((String)acctSig.getAttr("zimbraPrefMailSignature"), (String)aSigValueOnAccount);
        String accountSigNameNew = "account-sig-new-name";
        signatureAttrs.clear();
        signatureAttrs.put("zimbraSignatureName", accountSigNameNew);
        this.mProv.modifySignature(account, acctSig.getId(), signatureAttrs);
        Signature renamedAcctSig = this.mProv.get(account, Provisioning.SignatureBy.name, accountSigNameNew);
        TestProvisioning.assertEquals((String)renamedAcctSig.getId(), (String)acctSig.getId());
        defaultSigId = account.getAttr("zimbraPrefDefaultSignatureId");
        TestProvisioning.assertEquals((String)acctSig.getId(), (String)defaultSigId);
        acctAttrs.clear();
        acctAttrs.put("zimbraPrefDefaultSignatureId", secondEntry.getName());
        this.mProv.modifyAttrs(account, acctAttrs);
        this.mProv.deleteSignature(account, renamedAcctSig.getId());
    }

    private void entryTest(NamedEntry entry) throws Exception {
        String namingAttr;
        System.out.println("Testing entry");
        HashMap<String, String> attrsToMod = new HashMap<String, String>();
        attrsToMod.put("zimbraId", "junk");
        try {
            this.mProv.modifyAttrs(entry, attrsToMod, true);
            TestProvisioning.fail((String)"ServiceException.INVALID_REQUEST not thrown");
        }
        catch (ServiceException e) {
            TestProvisioning.assertEquals((String)"service.INVALID_REQUEST", (String)e.getCode());
        }
        attrsToMod.clear();
        attrsToMod.put("displayName", this.ACCT_FULL_NAME);
        this.mProv.modifyAttrs((Entry)entry, attrsToMod, true, true);
        if (this.mLdapProv != null && !(namingAttr = this.mLdapProv.getNamingRdnAttr(entry)).equals("cn")) {
            String cnValue = entry.getAttr("cn");
            TestProvisioning.assertEquals((String)this.ACCT_FULL_NAME, (String)cnValue);
        }
        this.mProv.reload(entry);
    }

    private void externalGalTest(Domain domain, boolean startTLS) throws Exception {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalMode", "ldap");
        attrs.put("zimbraGalLdapURL", "ldap://" + LC.zimbra_server_hostname.value() + ":389");
        attrs.put("zimbraGalLdapBindDn", LC.zimbra_ldap_userdn.value());
        attrs.put("zimbraGalLdapBindPassword", "zimbra");
        attrs.put("zimbraGalLdapFilter", "(mail=*%s*)");
        attrs.put("zimbraGalLdapKerberos5Principal", "ldap/phoebe.local@PHOEBE.LOCAL");
        attrs.put("zimbraGalLdapKerberos5Keytab", "/etc/krb5.keytab");
        if (startTLS) {
            attrs.put("zimbraGalLdapStartTlsEnabled", "TRUE");
            attrs.put("zimbraGalSyncLdapStartTlsEnabled", "TRUE");
        }
        this.mProv.modifyAttrs(domain, attrs, true);
        Provisioning.SearchGalResult galResult = this.mProv.searchGal(domain, this.ACCT_EMAIL, Provisioning.GAL_SEARCH_TYPE.ALL, null);
        List<GalContact> matches = galResult.getMatches();
        TestProvisioning.assertEquals((int)1, (int)galResult.getNumMatches());
        TestProvisioning.assertEquals((Object)this.ACCT_FULL_NAME, (Object)matches.get(0).getAttrs().get("fullName"));
    }

    private void galTest(Domain domain) throws Exception {
        System.out.println("Testing gal");
        String query = this.ACCT_USER;
        Account acct = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        Provisioning.SearchGalResult galResult = this.mProv.autoCompleteGal(domain, query, Provisioning.GAL_SEARCH_TYPE.ALL, 100);
        List<GalContact> matches = galResult.getMatches();
        TestProvisioning.assertEquals((int)1, (int)galResult.getNumMatches());
        TestProvisioning.assertEquals((Object)this.ACCT_FULL_NAME, (Object)matches.get(0).getAttrs().get("fullName"));
        galResult = this.mProv.searchGal(domain, query, Provisioning.GAL_SEARCH_TYPE.ALL, null);
        matches = galResult.getMatches();
        TestProvisioning.assertEquals((int)1, (int)galResult.getNumMatches());
        TestProvisioning.assertEquals((Object)this.ACCT_FULL_NAME, (Object)matches.get(0).getAttrs().get("fullName"));
        this.externalGalTest(domain, false);
    }

    private void searchTest(Domain domain) throws Exception {
        System.out.println("Testing search");
        Account acct = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        Account cr = this.mProv.get(Provisioning.AccountBy.name, this.CR_EMAIL);
        String query = "(zimbraMailDeliveryAddress=" + this.ACCT_EMAIL + ")";
        List<NamedEntry> list = null;
        if (!Flag.needLdapPaging("searchAccounts")) {
            list = this.mProv.searchAccounts(query, new String[]{"zimbraMailDeliveryAddress"}, "zimbraMailDeliveryAddress", true, 1);
            TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{acct}, true);
            String serverName = this.mProv.getLocalServer().getAttr("zimbraServiceHostname");
            list = this.mProv.searchAccounts("(zimbraMailHost=" + serverName + ")", new String[]{"zimbraId"}, null, false, 9);
        }
        if (!Flag.needLdapPaging("searchAccounts_domain")) {
            list = this.mProv.searchAccounts(domain, query, new String[]{"zimbraMailDeliveryAddress"}, "zimbraMailDeliveryAddress", true, 1);
            TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{acct}, true);
        }
        EntrySearchFilter.Single term = new EntrySearchFilter.Single(false, "zimbraMailDeliveryAddress", EntrySearchFilter.Operator.eq, this.CR_EMAIL);
        EntrySearchFilter filter = new EntrySearchFilter(term);
        if (!Flag.needLdapPaging("searchCalendarResources")) {
            list = this.mProv.searchCalendarResources(filter, new String[]{"zimbraMailDeliveryAddress"}, "zimbraMailDeliveryAddress", true);
            TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{cr}, true);
        }
        if (!Flag.needLdapPaging("searchCalendarResources_domain")) {
            list = this.mProv.searchCalendarResources(domain, filter, new String[]{"zimbraMailDeliveryAddress"}, "zimbraMailDeliveryAddress", true);
            TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{cr}, true);
        }
        if (!Flag.needLdapPaging("searchDirectory")) {
            Provisioning.SearchOptions options = new Provisioning.SearchOptions();
            options.setDomain(domain);
            options.setQuery(query);
            list = this.mProv.searchDirectory(options);
            TestProvisioningUtil.verifyEntries(list, new NamedEntry[]{acct}, true);
        }
    }

    private Domain aliasTest() throws Exception {
        System.out.println("Testing alias");
        String domainName = "alias-test." + this.DOMAIN_NAME;
        Domain domain = this.mProv.createDomain(domainName, new HashMap<String, Object>());
        return domain;
    }

    private void familyTest() throws Exception {
        Account parent;
        HashSet<String> idsNotChild;
        HashMap<String, Object> attrs;
        HashSet<String> cids;
        block8: {
            String parentName;
            String parentNameLocal;
            HashSet<String> visibleCids;
            block7: {
                String childName;
                String childNameLocal;
                System.out.println("Testing family");
                visibleCids = new HashSet<String>();
                HashSet<String> invisibleCids = new HashSet<String>();
                cids = new HashSet<String>();
                attrs = new HashMap<String, Object>();
                for (int i = 0; i < 5; ++i) {
                    attrs.clear();
                    childNameLocal = "v-child-" + i;
                    childName = childNameLocal + "@" + this.DOMAIN_NAME;
                    this.mCustomProvTester.addAttr(attrs, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
                    this.mCustomProvTester.addAttr(attrs, this.ACCT_NAMING_ATTR, this.namingAttrValue(childNameLocal));
                    Account acct = this.mProv.createAccount(childName, this.PASSWORD, attrs);
                    visibleCids.add(acct.getId());
                    cids.add(acct.getId());
                    attrs.clear();
                    childNameLocal = "iv-child-" + i;
                    childName = childNameLocal + "@" + this.DOMAIN_NAME;
                    this.mCustomProvTester.addAttr(attrs, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
                    this.mCustomProvTester.addAttr(attrs, this.ACCT_NAMING_ATTR, this.namingAttrValue(childNameLocal));
                    acct = this.mProv.createAccount(childName, this.PASSWORD, attrs);
                    invisibleCids.add(acct.getId());
                    cids.add(acct.getId());
                }
                attrs.clear();
                childNameLocal = "not-child";
                childName = childNameLocal + "@" + this.DOMAIN_NAME;
                this.mCustomProvTester.addAttr(attrs, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
                this.mCustomProvTester.addAttr(attrs, this.ACCT_NAMING_ATTR, this.namingAttrValue(childNameLocal));
                Account acctNotChild = this.mProv.createAccount(childName, this.PASSWORD, attrs);
                String idNotChild = acctNotChild.getId();
                idsNotChild = new HashSet<String>();
                idsNotChild.add(idNotChild);
                HashSet temp = new HashSet();
                parentNameLocal = "parent";
                parentName = parentNameLocal + "@" + this.DOMAIN_NAME;
                try {
                    attrs.clear();
                    this.mCustomProvTester.addAttr(attrs, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
                    this.mCustomProvTester.addAttr(attrs, this.ACCT_NAMING_ATTR, this.namingAttrValue(parentNameLocal));
                    attrs.put("zimbraChildAccount", cids);
                    attrs.put("zimbraPrefChildVisibleAccount", SetUtil.union(temp, visibleCids, idsNotChild));
                    parent = this.mProv.createAccount(parentName, this.PASSWORD, attrs);
                    TestProvisioning.fail();
                }
                catch (ServiceException e) {
                    if (e.getCode().equals("service.INVALID_REQUEST")) break block7;
                    TestProvisioning.fail();
                }
            }
            attrs.clear();
            this.mCustomProvTester.addAttr(attrs, this.BASE_DN_PSEUDO_ATTR, this.ACCT_BASE_DN);
            this.mCustomProvTester.addAttr(attrs, this.ACCT_NAMING_ATTR, this.namingAttrValue(parentNameLocal));
            attrs.put("zimbraChildAccount", cids);
            attrs.put("zimbraPrefChildVisibleAccount", visibleCids);
            parent = this.mProv.createAccount(parentName, this.PASSWORD, attrs);
            try {
                attrs.clear();
                attrs.put("+zimbraPrefChildVisibleAccount", idsNotChild);
                this.mProv.modifyAttrs(parent, attrs);
                TestProvisioning.fail();
            }
            catch (ServiceException e) {
                if (e.getCode().equals("service.INVALID_REQUEST")) break block8;
                TestProvisioning.fail();
            }
        }
        attrs.clear();
        attrs.put("+zimbraChildAccount", idsNotChild);
        attrs.put("+zimbraPrefChildVisibleAccount", idsNotChild);
        this.mProv.modifyAttrs(parent, attrs);
        attrs.clear();
        attrs.put("-zimbraChildAccount", idsNotChild);
        this.mProv.modifyAttrs(parent, attrs);
        Set<String> curAttrs = parent.getMultiAttrSet("zimbraPrefChildVisibleAccount");
        TestProvisioning.assertFalse((boolean)curAttrs.contains(idsNotChild));
        attrs.clear();
        attrs.put("zimbraChildAccount", "");
        this.mProv.modifyAttrs(parent, attrs);
        curAttrs = parent.getMultiAttrSet("zimbraPrefChildVisibleAccount");
        TestProvisioning.assertEquals((int)0, (int)curAttrs.size());
        for (String childId : cids) {
            this.mProv.deleteAccount(childId);
        }
        for (String childId : idsNotChild) {
            this.mProv.deleteAccount(childId);
        }
        this.mProv.deleteAccount(parent.getId());
    }

    private void flushCacheTest() throws Exception {
        System.out.println("Testing flush cache");
        String value = null;
        String newVal = "new value";
        String oldVal = "old value";
        HashMap<String, String> attrs = new HashMap<String, String>();
        String acctAttr = "description";
        Account acct = this.mSoapProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        TestProvisioning.assertNotNull((Object)acct);
        attrs.clear();
        attrs.put(acctAttr, oldVal);
        this.mSoapProv.modifyAttrs(acct, attrs);
        acct = this.mSoapProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        value = acct.getAttr(acctAttr);
        TestProvisioning.assertEquals((String)oldVal, (String)value);
        attrs.clear();
        attrs.put(acctAttr, newVal);
        acct = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        this.mProv.modifyAttrs(acct, attrs);
        acct = this.mSoapProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        value = acct.getAttr(acctAttr);
        TestProvisioning.assertEquals((String)oldVal, (String)value);
        this.mSoapProv.flushCache(Provisioning.CacheEntryType.account, new Provisioning.CacheEntry[]{new Provisioning.CacheEntry(Provisioning.CacheEntryBy.id, acct.getId())});
        acct = this.mSoapProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        value = acct.getAttr(acctAttr);
        TestProvisioning.assertEquals((String)newVal, (String)value);
        String cosAttr = "zimbraPrefSkin";
        Cos cos = this.mSoapProv.get(Provisioning.CosBy.name, this.COS_NAME);
        TestProvisioning.assertNotNull((Object)cos);
        attrs.clear();
        attrs.put(cosAttr, oldVal);
        this.mSoapProv.modifyAttrs(cos, attrs);
        cos = this.mSoapProv.get(Provisioning.CosBy.name, this.COS_NAME);
        value = cos.getAttr(cosAttr);
        TestProvisioning.assertEquals((String)oldVal, (String)value);
        attrs.clear();
        attrs.put(cosAttr, newVal);
        cos = this.mProv.get(Provisioning.CosBy.name, this.COS_NAME);
        this.mProv.modifyAttrs(cos, attrs);
        cos = this.mSoapProv.get(Provisioning.CosBy.name, this.COS_NAME);
        value = cos.getAttr(cosAttr);
        TestProvisioning.assertEquals((String)oldVal, (String)value);
        acct = this.mSoapProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        value = acct.getAttr(cosAttr);
        TestProvisioning.assertEquals((String)oldVal, (String)value);
        this.mSoapProv.flushCache(Provisioning.CacheEntryType.cos, new Provisioning.CacheEntry[]{new Provisioning.CacheEntry(Provisioning.CacheEntryBy.id, cos.getId())});
        cos = this.mSoapProv.get(Provisioning.CosBy.name, this.COS_NAME);
        value = cos.getAttr(cosAttr);
        TestProvisioning.assertEquals((String)newVal, (String)value);
        acct = this.mSoapProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        value = acct.getAttr(cosAttr);
        TestProvisioning.assertEquals((String)newVal, (String)value);
        String configAttr = "zimbraWebClientLoginUrl";
        Config config = this.mSoapProv.getConfig();
        TestProvisioning.assertNotNull((Object)config);
        attrs.clear();
        attrs.put(configAttr, oldVal);
        this.mSoapProv.modifyAttrs(config, attrs);
        config = this.mSoapProv.getConfig();
        value = config.getAttr(configAttr);
        TestProvisioning.assertEquals((String)oldVal, (String)value);
        attrs.clear();
        attrs.put(configAttr, newVal);
        config = this.mProv.getConfig();
        this.mProv.modifyAttrs(config, attrs);
        config = this.mSoapProv.getConfig();
        value = config.getAttr(configAttr);
        TestProvisioning.assertEquals((String)oldVal, (String)value);
        this.mSoapProv.flushCache(Provisioning.CacheEntryType.config, null);
        config = this.mSoapProv.getConfig();
        value = config.getAttr(configAttr);
        TestProvisioning.assertEquals((String)newVal, (String)value);
    }

    private void attributeInheritanceTest() throws Exception {
        System.out.println("Testing attribute inheritance");
        Account acct = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        TestProvisioning.assertNotNull((Object)acct);
        Cos cos = this.mProv.getCOS(acct);
        TestProvisioning.assertNotNull((Object)cos);
        Domain domain = this.mProv.getDomain(acct);
        TestProvisioning.assertNotNull((Object)domain);
        String attr = "zimbraPrefSkin";
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.clear();
        attrs.put(attr, "account-value");
        this.mProv.modifyAttrs(acct, attrs);
        attrs.clear();
        attrs.put(attr, "cos-value");
        this.mProv.modifyAttrs(cos, attrs);
        attrs.clear();
        attrs.put(attr, "domain-value");
        this.mProv.modifyAttrs(domain, attrs);
        String val = acct.getAttr(attr);
        TestProvisioning.assertEquals((String)"account-value", (String)val);
        attrs.clear();
        attrs.put(attr, "");
        this.mProv.modifyAttrs(acct, attrs);
        val = acct.getAttr(attr);
        TestProvisioning.assertEquals((String)"cos-value", (String)val);
        attrs.clear();
        attrs.put(attr, "");
        this.mProv.modifyAttrs(cos, attrs);
        val = acct.getAttr(attr);
        TestProvisioning.assertEquals((String)"domain-value", (String)val);
        attrs.clear();
        attrs.put(attr, "");
        this.mProv.modifyAttrs(domain, attrs);
        val = acct.getAttr(attr);
        TestProvisioning.assertEquals(null, (String)val);
    }

    private Set<String> getAvailableSkins_prior_bug31596(Account acct) throws ServiceException {
        Set<String> skins = acct.getMultiAttrSet("zimbraAvailableSkin");
        if (skins.size() > 0) {
            return skins;
        }
        Domain domain = Provisioning.getInstance().getDomain(acct);
        if (domain == null) {
            return skins;
        }
        return domain.getMultiAttrSet("zimbraAvailableSkin");
    }

    private void attributeInheritanceTestMultiValue_prior_bug31596() throws Exception {
        System.out.println("Testing attribute inheritance multi-value prior bug31596");
        Account acct = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        TestProvisioning.assertNotNull((Object)acct);
        Domain domain = this.mProv.getDomain(acct);
        TestProvisioning.assertNotNull((Object)domain);
        String attr = "zimbraAvailableSkin";
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.clear();
        attrs.put("+" + attr, new String[]{"domain-value-1", "domain-value-2"});
        this.mProv.modifyAttrs(domain, attrs);
        Set<String> val = this.getAvailableSkins_prior_bug31596(acct);
        TestProvisioningUtil.verifyEntries(val, new String[]{"domain-value-1", "domain-value-2"}, true);
    }

    private void attributeInheritanceTestMultiValue() throws Exception {
        System.out.println("Testing attribute inheritance multi-value");
        Account acct = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        TestProvisioning.assertNotNull((Object)acct);
        Domain domain = this.mProv.getDomain(acct);
        TestProvisioning.assertNotNull((Object)domain);
        String attr = "zimbraAvailableSkin";
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.clear();
        attrs.put("+" + attr, new String[]{"domain-value-1", "domain-value-2"});
        this.mProv.modifyAttrs(domain, attrs);
        Set<String> val = acct.getMultiAttrSet(attr);
        TestProvisioningUtil.verifyEntries(val, new String[]{"domain-value-1", "domain-value-2"}, true);
    }

    private void loadTest() throws Exception {
        System.out.println("Testing load");
        String domainName = "load-test." + this.DOMAIN_NAME;
        Domain domain = this.mProv.createDomain(domainName, new HashMap<String, Object>());
        int numAccts = 5000;
        for (int a = 0; a < numAccts; ++a) {
            String acctName = "acct-" + (a + 1) + "@" + domainName;
            System.out.println("creating account" + acctName);
            Account acct = this.mProv.createAccount(acctName, this.PASSWORD, new HashMap<String, Object>());
        }
    }

    private String execute() throws Exception {
        this.healthTest();
        Config config = this.configTest();
        String cosName = this.cosTest();
        String[] domainNames = this.domainTest();
        String domainName = domainNames[0];
        String otherDomainName = domainNames[1];
        String specialCharDomainName = domainNames[2];
        this.mimeTest();
        Server server = this.serverTest();
        Zimlet zimlet = this.zimletTest();
        Account adminAccount = this.adminAccountTest();
        Account[] accounts = this.accountTest(adminAccount, this.mProv.get(Provisioning.CosBy.name, cosName), this.mProv.get(Provisioning.DomainBy.name, domainName), this.mProv.get(Provisioning.DomainBy.name, otherDomainName));
        Account account = accounts[0];
        this.authTest(account);
        this.passwordTest(account);
        this.localeTest();
        CalendarResource calendarResource = this.calendarResourceTest(this.mProv.get(Provisioning.CosBy.name, cosName), this.mProv.get(Provisioning.DomainBy.name, domainName));
        DistributionList[] distributionLists = this.distributionListTest(this.mProv.get(Provisioning.DomainBy.name, domainName));
        DataSource dataSource = this.dataSourceTest(account);
        Identity identity = this.identityTest(account);
        this.signatureTest(account);
        this.entryTest(account);
        this.galTest(this.mProv.get(Provisioning.DomainBy.name, domainName));
        this.searchTest(this.mProv.get(Provisioning.DomainBy.name, domainName));
        Domain aliasTestDomain = this.aliasTest();
        this.familyTest();
        this.flushCacheTest();
        this.attributeInheritanceTest();
        this.attributeInheritanceTestMultiValue_prior_bug31596();
        this.attributeInheritanceTestMultiValue();
        System.out.println("\nPress enter to delete entries created by the test");
        String line = new BufferedReader(new InputStreamReader(System.in)).readLine();
        System.out.println("\nDeleting entries");
        this.mProv.deleteZimlet(this.ZIMLET_NAME);
        this.mProv.deleteServer(server.getId());
        this.mProv.deleteIdentity(account, this.IDENTITY_NAME);
        this.mProv.deleteDataSource(account, dataSource.getId());
        for (DistributionList distributionList : distributionLists) {
            String defaultDomain = this.mProv.getConfig().getAttr("zimbraDefaultDomainName");
            if (this.mCustomProvTester.isCustom() && distributionList.getDomainName().equals(this.DOMAIN_NAME_SPECIAL_CHARS)) {
                this.setDefaultDomain(this.DOMAIN_NAME_SPECIAL_CHARS);
            }
            this.mProv.deleteDistributionList(distributionList.getId());
            if (!this.mCustomProvTester.isCustom() || !distributionList.getDomainName().equals(this.DOMAIN_NAME_SPECIAL_CHARS)) continue;
            this.setDefaultDomain(defaultDomain);
        }
        this.mProv.deleteCalendarResource(calendarResource.getId());
        for (MailTarget mailTarget : accounts) {
            this.mProv.deleteAccount(((ZAttrAccount)mailTarget).getId());
        }
        this.mProv.deleteAccount(adminAccount.getId());
        this.mProv.deleteDomain(this.mProv.get(Provisioning.DomainBy.name, domainName).getId());
        this.mProv.deleteDomain(this.mProv.get(Provisioning.DomainBy.name, otherDomainName).getId());
        this.mProv.deleteDomain(this.mProv.get(Provisioning.DomainBy.name, specialCharDomainName).getId());
        this.mProv.deleteDomain(aliasTestDomain.getId());
        this.mProv.deleteCos(this.mProv.get(Provisioning.CosBy.name, cosName).getId());
        System.out.println("\nAll done");
        return this.TEST_ID;
    }

    public void testProvisioning() throws Exception {
        try {
            System.out.println("\nTest " + this.TEST_ID + " starting\n");
            this.execute();
            System.out.println("\nTest " + this.TEST_ID + " done!");
        }
        catch (ServiceException e) {
            Throwable cause = e.getCause();
            System.out.println("ERROR: " + e.getCode() + " (" + e.getMessage() + ")" + (cause == null ? "" : " (cause: " + cause.getClass().getName() + " " + cause.getMessage() + ")"));
            e.printStackTrace(System.out);
            System.out.println("\nTest " + this.TEST_ID + " failed!");
        }
        catch (AssertionFailedError e) {
            System.out.println("\n===== assertion failed =====");
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup("WARN");
        TestProvisioning t = new TestProvisioning();
        t.setUp();
        t.execute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestCustomAuth
    extends ZimbraCustomAuth {
        Account mTheOnlyAcctThatCanAuth;
        String mTheOnlyPasswordIKnowAbout;

        TestCustomAuth(Account account, String password) {
            this.mTheOnlyAcctThatCanAuth = account;
            this.mTheOnlyPasswordIKnowAbout = password;
        }

        private boolean verifyArgs(List<String> args) {
            return args.size() == 6 && args.get(0).equals("http://blah.com:123") && args.get(1).equals("green") && args.get(2).equals(" ocean blue   ") && args.get(3).equals("") && args.get(4).equals("yelllow") && args.get(5).equals("");
        }

        @Override
        public void authenticate(Account acct, String password, Map<String, Object> context, List<String> args) throws Exception {
            String acOrigClientIp = (String)context.get("ocip");
            String acNamePassedIn = (String)context.get("anp");
            AuthContext.Protocol acProto = (AuthContext.Protocol)((Object)context.get("proto"));
            if (acct.getName().equals(this.mTheOnlyAcctThatCanAuth.getName()) && password.equals(this.mTheOnlyPasswordIKnowAbout) && this.verifyArgs(args)) {
                return;
            }
            throw new Exception("auth failed by TestCustomAuth for " + acct.getName() + " password " + password);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestVisitor
    implements NamedEntry.Visitor {
        List<NamedEntry> mVisited = new ArrayList<NamedEntry>();

        private TestVisitor() {
        }

        @Override
        public void visit(NamedEntry entry) throws ServiceException {
            this.mVisited.add(entry);
        }

        public List<NamedEntry> visited() {
            return this.mVisited;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CustomProvTester {
        Provisioning mProv;
        boolean mIsCustomProv;

        CustomProvTester(Provisioning prov) {
            this.mProv = prov;
            this.mIsCustomProv = prov instanceof CustomLdapProvisioning;
        }

        public void cleanup() throws Exception {
            System.out.println("Cleanup...");
            Provisioning.SearchOptions options = new Provisioning.SearchOptions();
            int flags = 0;
            flags = 13;
            options.setFlags(flags);
            if (this.isCustom()) {
                options.setBase(TestProvisioning.this.ACCT_BASE_DN);
            }
            List<NamedEntry> list = this.mProv.searchDirectory(options);
            for (NamedEntry entry : list) {
                if (entry instanceof CalendarResource) {
                    this.mProv.deleteCalendarResource(entry.getId());
                    continue;
                }
                if (entry instanceof Alias) {
                    this.mProv.removeAlias((Account)null, entry.getName());
                    continue;
                }
                if (entry instanceof Account) {
                    this.mProv.deleteAccount(entry.getId());
                    continue;
                }
                if (entry instanceof DistributionList) {
                    this.mProv.deleteDistributionList(entry.getId());
                    continue;
                }
                throw new Exception("unexpected entry type: " + entry.getClass().getCanonicalName());
            }
            flags = 255;
            options.setFlags(flags);
            list = this.mProv.searchDirectory(options);
            Assert.assertEquals((int)0, (int)list.size());
        }

        public boolean isCustom() {
            return this.mIsCustomProv;
        }

        public void addAttr(Map<String, Object> attrs, String pseudoAttr, String value) {
            if (!this.mIsCustomProv) {
                return;
            }
            attrs.put(pseudoAttr, value);
        }

        private void verifyDn(Entry entry, String dn) throws Exception {
            if (!this.mIsCustomProv) {
                return;
            }
            Assert.assertEquals((String)dn, (String)TestProvisioning.this.mLdapProv.getDN(entry));
        }

        public boolean verifyAccountCountForDomainBasedSearch() {
            if (!this.mIsCustomProv) {
                return true;
            }
            return true;
        }

        public boolean verifyDLCountForDomainBasedSearch() {
            return !this.mIsCustomProv;
        }

        public boolean verifyAliasCountForDomainBasedSearch() {
            return !this.mIsCustomProv;
        }
    }

    static class Flag {
        private static Set<String> sNeedLdapPaging = new HashSet<String>();

        Flag() {
        }

        static boolean needLdapPaging(String methodName) {
            return false;
        }

        static {
            sNeedLdapPaging.add("getAllAdminAccounts");
            sNeedLdapPaging.add("getAllAccounts_domain");
            sNeedLdapPaging.add("getAllAccounts_domain_visitor");
            sNeedLdapPaging.add("getAllAccounts_domain_server_visitor");
            sNeedLdapPaging.add("getAllCalendarResources_domain");
            sNeedLdapPaging.add("getAllCalendarResources_domain_visitor");
            sNeedLdapPaging.add("getAllDistributionLists");
            sNeedLdapPaging.add("getDistributionLists_account");
            sNeedLdapPaging.add("getDistributionLists_account_directonly_via");
            sNeedLdapPaging.add("inDistributionList");
            sNeedLdapPaging.add("searchAccounts");
            sNeedLdapPaging.add("searchAccounts_domain");
            sNeedLdapPaging.add("searchCalendarResources");
            sNeedLdapPaging.add("searchCalendarResources_domain");
            sNeedLdapPaging.add("searchDirectory");
        }
    }
}

