/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.PreAuthKey;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.qa.unittest.TestUtil;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;

public class TestPreAuthServlet
extends TestCase {
    String setUpDomain() throws Exception {
        String domainName = TestUtil.getDomain();
        Domain domain = Provisioning.getInstance().get(Provisioning.DomainBy.name, domainName);
        String preAuthKey = PreAuthKey.generateRandomPreAuthKey();
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPreAuthKey", preAuthKey);
        Provisioning.getInstance().modifyAttrs(domain, attrs);
        return preAuthKey;
    }

    String genPreAuthUrl(String preAuthKey, String user, boolean admin, boolean shouldFail) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        String acctName = TestUtil.getAddress(user);
        String authBy = "name";
        long timestamp = System.currentTimeMillis();
        long expires = 0L;
        params.put("account", acctName);
        params.put("by", authBy);
        params.put("timestamp", timestamp + "");
        params.put("expires", expires + "");
        if (admin) {
            params.put("admin", "1");
        }
        String preAuth = PreAuthKey.computePreAuth(params, preAuthKey);
        StringBuffer url = new StringBuffer("/service/preauth?");
        url.append("account=" + acctName);
        url.append("&by=" + authBy);
        if (shouldFail) {
            long timestampBad = timestamp + 10L;
            url.append("&timestamp=" + timestampBad);
        } else {
            url.append("&timestamp=" + timestamp);
        }
        url.append("&expires=" + expires);
        url.append("&preauth=" + preAuth);
        if (admin) {
            url.append("&admin=1");
        }
        return url.toString();
    }

    void doPreAuthServletRequest(String preAuthUrl, boolean admin) throws Exception {
        Server localServer = Provisioning.getInstance().getLocalServer();
        String protoHostPort = admin ? "https://localhost:" + localServer.getIntAttr("zimbraAdminPort", 0) : "http://localhost:" + localServer.getIntAttr("zimbraMailPort", 0);
        String url = protoHostPort + preAuthUrl;
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        try {
            try {
                int respCode = client.executeMethod(method);
                int statusCode = method.getStatusCode();
                String statusLine = method.getStatusLine().toString();
                System.out.println("respCode=" + respCode);
                System.out.println("statusCode=" + statusCode);
                System.out.println("statusLine=" + statusLine);
            }
            catch (HttpException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            Object var12_13 = null;
            method.releaseConnection();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            method.releaseConnection();
            throw throwable;
        }
    }

    private void doPreAuth(String userLocalPart, boolean admin, boolean shouldFail) throws Exception {
        String preAuthKey = this.setUpDomain();
        String preAuthUrl = this.genPreAuthUrl(preAuthKey, userLocalPart, admin, shouldFail);
        System.out.println("preAuthKey=" + preAuthKey);
        System.out.println("preAuth=" + preAuthUrl);
        this.doPreAuthServletRequest(preAuthUrl, admin);
    }

    public void testPreAuthServlet() throws Exception {
        this.doPreAuth("user1", false, false);
        this.doPreAuth("da", true, false);
    }

    private Account dumpLockoutAttrs(String user) throws Exception {
        String[] failureTime;
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, user);
        System.out.println();
        System.out.println("zimbraAccountStatus: " + acct.getAttr("zimbraAccountStatus"));
        System.out.println("zimbraPasswordLockoutLockedTime: " + acct.getAttr("zimbraPasswordLockoutLockedTime"));
        System.out.println("zimbraPasswordLockoutFailureTime: ");
        for (String ft : failureTime = acct.getMultiAttr("zimbraPasswordLockoutFailureTime")) {
            System.out.println("    " + ft);
        }
        return acct;
    }

    public void disable_testPreAuthLockout() throws Exception {
        String user = "user4";
        Account acct = TestUtil.getAccount(user);
        Provisioning prov = Provisioning.getInstance();
        HashMap<String, String> attrs = new HashMap<String, String>();
        int lockoutAfterNumFailures = 3;
        attrs.put("zimbraPasswordLockoutEnabled", "TRUE");
        attrs.put("zimbraPasswordLockoutDuration", "1m");
        attrs.put("zimbraPasswordLockoutMaxFailures", lockoutAfterNumFailures + "");
        attrs.put("zimbraPasswordLockoutFailureLifetime", "30s");
        attrs.put("zimbraAccountStatus", "active");
        attrs.put("zimbraPasswordLockoutLockedTime", "");
        attrs.put("zimbraPasswordLockoutFailureTime", "");
        prov.modifyAttrs(acct, attrs);
        System.out.println("Before the test:");
        this.dumpLockoutAttrs(user);
        System.out.println();
        for (int i = 0; i <= lockoutAfterNumFailures; ++i) {
            System.out.println("======================");
            System.out.println("Iteration: " + i);
            this.doPreAuth(user, false, true);
            Account a = this.dumpLockoutAttrs(user);
            System.out.println("\n\n");
            if (i >= lockoutAfterNumFailures - 1) {
                TestPreAuthServlet.assertEquals((String)"lockout", (String)a.getAttr("zimbraAccountStatus"));
            } else {
                TestPreAuthServlet.assertEquals((String)"active", (String)a.getAttr("zimbraAccountStatus"));
            }
            Thread.sleep(2000L);
        }
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        try {
            TestUtil.runTest(TestPreAuthServlet.class);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

