/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.db.DbPop3Message;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.zclient.ZDataSource;
import com.zimbra.cs.zclient.ZFilterAction;
import com.zimbra.cs.zclient.ZFilterCondition;
import com.zimbra.cs.zclient.ZFilterRule;
import com.zimbra.cs.zclient.ZFilterRules;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.cs.zclient.ZPop3DataSource;
import com.zimbra.qa.unittest.TestUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.internet.MailDateFormat;
import junit.framework.TestCase;
import org.testng.TestNG;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestPop3Import
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String USER2_NAME = "user2";
    private static final String NAME_PREFIX;
    private static final String DATA_SOURCE_NAME;
    private static final String TEMP_USER_NAME;
    private ZFilterRules mOriginalRules;
    private boolean mIsServerSideTest;

    @BeforeMethod
    public void setUp() throws Exception {
        this.mIsServerSideTest = false;
        this.cleanUp();
        this.createDataSource();
        this.mOriginalRules = TestUtil.getZMailbox(USER_NAME).getFilterRules();
    }

    @Test(groups={"Server"})
    public void testUidPersistence() throws Exception {
        this.mIsServerSideTest = true;
        DataSource ds = this.getDataSource();
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        String uid1 = "myUID";
        String uid2 = "myUid";
        HashSet<String> uids = new HashSet<String>();
        uids.add(uid1);
        uids.add(uid2);
        Set<String> matchingUids = DbPop3Message.getMatchingUids(mbox, ds, uids);
        TestPop3Import.assertEquals((String)"Test 1: set size", (int)0, (int)matchingUids.size());
        DbPop3Message.storeUid(mbox, ds.getId(), uid1, 2);
        matchingUids = DbPop3Message.getMatchingUids(mbox, ds, uids);
        TestPop3Import.assertEquals((String)"Test 2: set size", (int)1, (int)matchingUids.size());
        TestPop3Import.assertTrue((String)"Test 2: did not find uid1", (boolean)matchingUids.contains(uid1));
        TestPop3Import.assertFalse((String)"Test 2: found uid2", (boolean)matchingUids.contains(uid2));
        DbPop3Message.storeUid(mbox, ds.getId(), uid2, 3);
        matchingUids = DbPop3Message.getMatchingUids(mbox, ds, uids);
        TestPop3Import.assertEquals((String)"Test 3: set size", (int)2, (int)matchingUids.size());
        TestPop3Import.assertTrue((String)"Test 3: did not find uid1", (boolean)matchingUids.contains(uid1));
        TestPop3Import.assertTrue((String)"Test 3: did not find uid2", (boolean)matchingUids.contains(uid2));
        DbPop3Message.deleteUids(mbox, ds.getId());
        matchingUids = DbPop3Message.getMatchingUids(mbox, ds, uids);
        TestPop3Import.assertEquals((String)"Test 3: set size", (int)0, (int)matchingUids.size());
    }

    @Test(groups={"Server"})
    public void testModifyDataSource() throws Exception {
        this.mIsServerSideTest = true;
        ZPop3DataSource zds = this.getZDataSource();
        zds.setHost(zds.getHost() + "2");
        this.modifyAndCheck(zds, false);
        zds = this.getZDataSource();
        zds.setUsername(zds.getUsername() + "2");
        this.modifyAndCheck(zds, false);
        zds = this.getZDataSource();
        zds.setLeaveOnServer(!zds.leaveOnServer());
        this.modifyAndCheck(zds, true);
    }

    @Test(groups={"Server"})
    public void testDeleteMailbox() throws Exception {
        this.mIsServerSideTest = true;
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.createAccount(TestUtil.getAddress(TEMP_USER_NAME), "test123", null);
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        DbPop3Message.storeUid(mbox, "TestPop3Import", "uid1", 2);
        IMPersona.deleteIMPersona(account.getName());
        mbox.deleteMailbox();
    }

    @Test
    public void testBogusDate() throws Exception {
        Provisioning.getInstance().createAccount(TestUtil.getAddress(TEMP_USER_NAME), "test123", null);
        MailDateFormat format = new MailDateFormat();
        Date date = format.parse("Thu, 31  Aug 2039 10:29:46 +0800");
        String message = TestUtil.getTestMessage(NAME_PREFIX + " testBogusDate", null, null, date);
        ZMailbox remoteMbox = TestUtil.getZMailbox(TEMP_USER_NAME);
        String folderId = Integer.toString(2);
        remoteMbox.addMessage(folderId, null, null, 0L, message, true);
        ZMailbox localMbox = TestUtil.getZMailbox(USER_NAME);
        ZPop3DataSource ds = this.getZDataSource();
        ds.setUsername(TEMP_USER_NAME);
        ds.setEnabled(true);
        localMbox.modifyDataSource(ds);
        List<ZMessage> messages = TestUtil.search(localMbox, "in:inbox " + NAME_PREFIX);
        TestPop3Import.assertEquals((String)"Found unexpected message in local inbox", (int)0, (int)messages.size());
        TestUtil.importDataSource(ds, localMbox, remoteMbox);
        messages = TestUtil.search(localMbox, "in:inbox " + NAME_PREFIX);
        TestPop3Import.assertEquals((String)"Imported message not found", (int)1, (int)messages.size());
    }

    @Test
    public void testTestDataSource() throws Exception {
        ZMailbox localMbox = TestUtil.getZMailbox(USER_NAME);
        ZPop3DataSource ds = this.getZDataSource();
        ds.setUsername(USER2_NAME);
        localMbox.modifyDataSource(ds);
        TestPop3Import.assertNull((Object)localMbox.testDataSource(ds));
    }

    @Test
    public void testFiltering() throws Exception {
        String folderPath = "/" + NAME_PREFIX + "-testFiltering";
        String filteredPath = "/" + NAME_PREFIX + "-testFiltering-filtered";
        Provisioning.getInstance().createAccount(TestUtil.getAddress(TEMP_USER_NAME), "test123", null);
        ZMailbox remoteMbox = TestUtil.getZMailbox(TEMP_USER_NAME);
        TestUtil.addMessage(remoteMbox, NAME_PREFIX + " testFiltering");
        ZMailbox localMbox = TestUtil.getZMailbox(USER_NAME);
        ZFolder dsFolder = TestUtil.createFolder(localMbox, folderPath);
        TestUtil.createFolder(localMbox, filteredPath);
        ArrayList<ZFilterRule> rules = new ArrayList<ZFilterRule>();
        ArrayList<ZFilterCondition> conditions = new ArrayList<ZFilterCondition>();
        ArrayList<ZFilterAction> actions = new ArrayList<ZFilterAction>();
        conditions.add(new ZFilterCondition.ZHeaderCondition("subject", ZFilterCondition.HeaderOp.CONTAINS, "testFiltering"));
        actions.add(new ZFilterAction.ZFileIntoAction(filteredPath));
        rules.add(new ZFilterRule("testFiltering", true, false, conditions, actions));
        localMbox.saveFilterRules(new ZFilterRules(rules));
        ZPop3DataSource ds = this.getZDataSource();
        ds.setUsername(TEMP_USER_NAME);
        ds.setFolderId(dsFolder.getId());
        ds.setEnabled(true);
        localMbox.modifyDataSource(ds);
        TestUtil.importDataSource(ds, localMbox, remoteMbox);
        List<ZMessage> messages = TestUtil.search(localMbox, "in:" + folderPath);
        TestPop3Import.assertEquals((String)("Found unexpected messages in " + folderPath), (int)0, (int)messages.size());
        messages = TestUtil.search(localMbox, "in:" + filteredPath);
        TestPop3Import.assertEquals((String)("Message not found in " + filteredPath), (int)1, (int)messages.size());
    }

    private void modifyAndCheck(ZPop3DataSource zds, boolean shouldDeleteData) throws Exception {
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        DataSource ds = this.getDataSource();
        ZMailbox zmbox = TestUtil.getZMailbox(USER_NAME);
        DbPop3Message.deleteUids(mbox, ds.getId());
        DbPop3Message.storeUid(mbox, ds.getId(), "1", 2);
        zmbox.modifyDataSource(zds);
        HashSet<String> uids = new HashSet<String>();
        uids.add("1");
        Set<String> matchingUids = DbPop3Message.getMatchingUids(mbox, ds, uids);
        int expected = shouldDeleteData ? 0 : 1;
        TestPop3Import.assertEquals((String)("matching UID's: " + StringUtil.join(",", matchingUids)), (int)expected, (int)matchingUids.size());
    }

    private ZPop3DataSource getZDataSource() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        List<ZDataSource> dataSources = mbox.getAllDataSources();
        for (ZDataSource ds : dataSources) {
            if (!ds.getName().equals(DATA_SOURCE_NAME)) continue;
            return (ZPop3DataSource)ds;
        }
        TestPop3Import.fail((String)("Could not find data source " + DATA_SOURCE_NAME));
        return null;
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.cleanUp();
        TestUtil.getZMailbox(USER_NAME).saveFilterRules(this.mOriginalRules);
    }

    private void createDataSource() throws Exception {
        Provisioning prov = Provisioning.getInstance();
        Account account = TestUtil.getAccount(USER_NAME);
        int port = Integer.parseInt(TestUtil.getServerAttr("zimbraPop3BindPort"));
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDataSourceEnabled", "FALSE");
        attrs.put("zimbraDataSourceHost", "localhost");
        attrs.put("zimbraDataSourcePort", Integer.toString(port));
        attrs.put("zimbraDataSourceUsername", USER_NAME);
        attrs.put("zimbraDataSourcePassword", "test123");
        attrs.put("zimbraDataSourceFolderId", Integer.toString(2));
        attrs.put("zimbraDataSourceConnectionType", "cleartext");
        attrs.put("zimbraDataSourceLeaveOnServer", "FALSE");
        prov.createDataSource(account, DataSource.Type.pop3, DATA_SOURCE_NAME, attrs);
    }

    private DataSource getDataSource() throws Exception {
        Provisioning prov = Provisioning.getInstance();
        Account account = TestUtil.getAccount(USER_NAME);
        return prov.get(account, Provisioning.DataSourceBy.name, DATA_SOURCE_NAME);
    }

    private void cleanUp() throws Exception {
        Provisioning prov = Provisioning.getInstance();
        DataSource ds = this.getDataSource();
        if (ds != null) {
            Account account = TestUtil.getAccount(USER_NAME);
            if (this.mIsServerSideTest) {
                Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
                DbPop3Message.deleteUids(mbox, ds.getId());
            }
            prov.deleteDataSource(account, ds.getId());
        }
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
        TestUtil.deleteAccount(TEMP_USER_NAME);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestNG testng = TestUtil.newTestNG();
        testng.setExcludedGroups("Server");
        testng.setTestClasses(new Class[]{TestPop3Import.class});
        testng.run();
    }

    static {
        DATA_SOURCE_NAME = NAME_PREFIX = TestPop3Import.class.getSimpleName();
        TEMP_USER_NAME = NAME_PREFIX + "Temp";
    }
}

