/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.DummySSLSocketFactory;
import com.zimbra.common.util.EasySSLProtocolSocketFactory;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.qa.unittest.TestUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import junit.framework.TestCase;

public class TestPop3ImapAuth
extends TestCase {
    private static final String CRLF = "\r\n";
    private static final String HOSTNAME = "localhost";
    private static final String POP3_CONNECT_RESPONSE = "\\+OK .* POP3 server ready";
    private static final String POP3_USER = "USER user1\r\n";
    private static final String POP3_USER_RESPONSE = "\\+OK hello user1, please enter your password";
    private static final String POP3_PASS = "PASS test123\r\n";
    private static final String POP3_PASS_RESPONSE = "\\+OK server ready";
    private static final String POP3_STLS = "STLS\r\n";
    private static final String POP3_STLS_RESPONSE = "\\+OK Begin TLS negotiation";
    private static final String POP3_CLEARTEXT_FAILED_RESPONSE = "-ERR only valid after entering TLS mode";
    private static final String POP3_QUIT = "QUIT\r\n";
    private static final String POP3_QUIT_RESPONSE = "\\+OK .* closing connection";
    private static final String POP3_XOIP = "XOIP 100.99.98.97\r\n";
    private static final String POP3_XOIP_RESPONSE = "\\+OK";
    private static final String IMAP_CONNECT_RESPONSE = "\\* OK .* Zimbra IMAP4rev1 service ready";
    private static final String IMAP_LOGIN = "1 LOGIN user1 test123\r\n";
    private static final String IMAP_LOGIN_RESPONSE = "1 OK.*LOGIN completed";
    private static final String IMAP_CLEARTEXT_FAILED_RESPONSE = "1 NO cleartext logins disabled";
    private static final String IMAP_STARTTLS = "2 STARTTLS\r\n";
    private static final String IMAP_STARTTLS_RESPONSE = "2 OK Begin TLS negotiation now";
    private static final String IMAP_LOGOUT = "3 LOGOUT\r\n";
    private static final String IMAP_LOGOUT_RESPONSE1 = "\\* BYE.*IMAP4rev1 server terminating connection";
    private static final String IMAP_LOGOUT_RESPONSE2 = "3 OK LOGOUT completed";
    private static final String IMAP_ID = "4 ID (\"X-ORIGINATING-IP\" \"100.99.98.97\" \"name\" \"foobar\" \"version\" \"1.0\")\r\n";
    private static final String IMAP_ID_RESPONSE1 = "\\* ID.*";
    private static final String IMAP_ID_RESPONSE2 = "4 OK ID completed";
    private Provisioning mProv;
    private boolean mOrigPop3CleartextLoginEnabled;
    private boolean mOrigImapCleartextLoginEnabled;
    private int mPop3CleartextPort;
    private int mPop3SslPort;
    private int mImapCleartextPort;
    private int mImapSslPort;
    private Map<Socket, BufferedReader> mReaders = new HashMap<Socket, BufferedReader>();

    public void setUp() throws Exception {
        EasySSLProtocolSocketFactory.init();
        this.mProv = Provisioning.getInstance();
        Server server = this.mProv.getLocalServer();
        this.mOrigPop3CleartextLoginEnabled = server.getBooleanAttr("zimbraPop3CleartextLoginEnabled", false);
        this.mOrigImapCleartextLoginEnabled = server.getBooleanAttr("zimbraImapCleartextLoginEnabled", false);
        this.mPop3CleartextPort = server.getIntAttr("zimbraPop3BindPort", 7110);
        this.mPop3SslPort = server.getIntAttr("zimbraPop3SSLBindPort", 7995);
        this.mImapCleartextPort = server.getIntAttr("zimbraImapBindPort", 7143);
        this.mImapSslPort = server.getIntAttr("zimbraImapSSLBindPort", 7995);
    }

    public void testPop3CleartextTrue() throws Exception {
        this.setPop3Cleartext(true);
        Socket socket = new Socket(HOSTNAME, this.mPop3CleartextPort);
        this.send(socket, "", POP3_CONNECT_RESPONSE);
        this.send(socket, POP3_USER, POP3_USER_RESPONSE);
        this.send(socket, POP3_PASS, POP3_PASS_RESPONSE);
        this.send(socket, POP3_QUIT, POP3_QUIT_RESPONSE);
        socket.close();
        socket = DummySSLSocketFactory.getDefault().createSocket(HOSTNAME, this.mPop3SslPort);
        this.send(socket, "", POP3_CONNECT_RESPONSE);
        this.send(socket, POP3_USER, POP3_USER_RESPONSE);
        this.send(socket, POP3_PASS, POP3_PASS_RESPONSE);
        this.send(socket, POP3_QUIT, POP3_QUIT_RESPONSE);
        socket.close();
        socket = new Socket(HOSTNAME, this.mPop3CleartextPort);
        this.send(socket, "", POP3_CONNECT_RESPONSE);
        this.send(socket, POP3_STLS, POP3_STLS_RESPONSE);
        SSLSocketFactory factory = (SSLSocketFactory)DummySSLSocketFactory.getDefault();
        socket = factory.createSocket(socket, HOSTNAME, this.mPop3CleartextPort, true);
        this.send(socket, POP3_USER, POP3_USER_RESPONSE);
        this.send(socket, POP3_PASS, POP3_PASS_RESPONSE);
        this.send(socket, POP3_QUIT, POP3_QUIT_RESPONSE);
    }

    public void testPop3CleartextFalse() throws Exception {
        this.setPop3Cleartext(false);
        Socket socket = new Socket(HOSTNAME, this.mPop3CleartextPort);
        this.send(socket, null, POP3_CONNECT_RESPONSE);
        this.send(socket, POP3_USER, POP3_CLEARTEXT_FAILED_RESPONSE);
        this.send(socket, POP3_QUIT, POP3_QUIT_RESPONSE);
        socket.close();
        socket = DummySSLSocketFactory.getDefault().createSocket(HOSTNAME, this.mPop3SslPort);
        this.send(socket, null, POP3_CONNECT_RESPONSE);
        this.send(socket, POP3_USER, POP3_USER_RESPONSE);
        this.send(socket, POP3_PASS, POP3_PASS_RESPONSE);
        this.send(socket, POP3_QUIT, POP3_QUIT_RESPONSE);
        socket.close();
        socket = new Socket(HOSTNAME, this.mPop3CleartextPort);
        this.send(socket, null, POP3_CONNECT_RESPONSE);
        this.send(socket, POP3_STLS, POP3_STLS_RESPONSE);
        SSLSocketFactory factory = (SSLSocketFactory)DummySSLSocketFactory.getDefault();
        socket = factory.createSocket(socket, HOSTNAME, this.mPop3CleartextPort, true);
        this.send(socket, POP3_USER, POP3_USER_RESPONSE);
        this.send(socket, POP3_PASS, POP3_PASS_RESPONSE);
        this.send(socket, POP3_QUIT, POP3_QUIT_RESPONSE);
    }

    public void testImapCleartextTrue() throws Exception {
        this.setImapCleartext(true);
        Socket socket = new Socket(HOSTNAME, this.mImapCleartextPort);
        this.send(socket, null, IMAP_CONNECT_RESPONSE);
        this.send(socket, IMAP_LOGIN, IMAP_LOGIN_RESPONSE);
        this.send(socket, IMAP_LOGOUT, IMAP_LOGOUT_RESPONSE1);
        this.send(socket, null, IMAP_LOGOUT_RESPONSE2);
        socket = DummySSLSocketFactory.getDefault().createSocket(HOSTNAME, this.mImapSslPort);
        this.send(socket, null, IMAP_CONNECT_RESPONSE);
        this.send(socket, IMAP_LOGIN, IMAP_LOGIN_RESPONSE);
        this.send(socket, IMAP_LOGOUT, IMAP_LOGOUT_RESPONSE1);
        this.send(socket, null, IMAP_LOGOUT_RESPONSE2);
        socket = new Socket(HOSTNAME, this.mImapCleartextPort);
        this.send(socket, null, IMAP_CONNECT_RESPONSE);
        this.send(socket, IMAP_STARTTLS, IMAP_STARTTLS_RESPONSE);
        SSLSocketFactory factory = (SSLSocketFactory)DummySSLSocketFactory.getDefault();
        socket = factory.createSocket(socket, HOSTNAME, this.mImapCleartextPort, true);
        this.send(socket, IMAP_LOGIN, IMAP_LOGIN_RESPONSE);
        this.send(socket, IMAP_LOGOUT, IMAP_LOGOUT_RESPONSE1);
        this.send(socket, null, IMAP_LOGOUT_RESPONSE2);
    }

    public void testImapCleartextFalse() throws Exception {
        this.setImapCleartext(false);
        Socket socket = new Socket(HOSTNAME, this.mImapCleartextPort);
        this.send(socket, null, IMAP_CONNECT_RESPONSE);
        this.send(socket, IMAP_LOGIN, IMAP_CLEARTEXT_FAILED_RESPONSE);
        this.send(socket, IMAP_LOGOUT, IMAP_LOGOUT_RESPONSE1);
        this.send(socket, null, IMAP_LOGOUT_RESPONSE2);
        socket = DummySSLSocketFactory.getDefault().createSocket(HOSTNAME, this.mImapSslPort);
        this.send(socket, null, IMAP_CONNECT_RESPONSE);
        this.send(socket, IMAP_LOGIN, IMAP_LOGIN_RESPONSE);
        this.send(socket, IMAP_LOGOUT, IMAP_LOGOUT_RESPONSE1);
        this.send(socket, null, IMAP_LOGOUT_RESPONSE2);
        socket = new Socket(HOSTNAME, this.mImapCleartextPort);
        this.send(socket, null, IMAP_CONNECT_RESPONSE);
        this.send(socket, IMAP_STARTTLS, IMAP_STARTTLS_RESPONSE);
        SSLSocketFactory factory = (SSLSocketFactory)DummySSLSocketFactory.getDefault();
        socket = factory.createSocket(socket, HOSTNAME, this.mImapCleartextPort, true);
        this.send(socket, IMAP_LOGIN, IMAP_LOGIN_RESPONSE);
        this.send(socket, IMAP_LOGOUT, IMAP_LOGOUT_RESPONSE1);
        this.send(socket, null, IMAP_LOGOUT_RESPONSE2);
    }

    public void testPop3XOIP() throws Exception {
        this.setPop3Cleartext(true);
        Socket socket = new Socket(HOSTNAME, this.mPop3CleartextPort);
        this.send(socket, "", POP3_CONNECT_RESPONSE);
        this.send(socket, POP3_XOIP, POP3_XOIP_RESPONSE);
        this.send(socket, POP3_USER, POP3_USER_RESPONSE);
        this.send(socket, POP3_PASS, POP3_PASS_RESPONSE);
        this.send(socket, POP3_QUIT, POP3_QUIT_RESPONSE);
        socket.close();
    }

    public void testImapID() throws Exception {
        this.setImapCleartext(true);
        Socket socket = new Socket(HOSTNAME, this.mImapCleartextPort);
        this.send(socket, null, IMAP_CONNECT_RESPONSE);
        this.send(socket, IMAP_ID, IMAP_ID_RESPONSE1);
        this.send(socket, null, IMAP_ID_RESPONSE2);
        this.send(socket, IMAP_LOGIN, IMAP_LOGIN_RESPONSE);
        this.send(socket, IMAP_LOGOUT, IMAP_LOGOUT_RESPONSE1);
        this.send(socket, null, IMAP_LOGOUT_RESPONSE2);
    }

    public void tearDown() throws Exception {
        this.setPop3Cleartext(this.mOrigPop3CleartextLoginEnabled);
        this.setImapCleartext(this.mOrigImapCleartextLoginEnabled);
    }

    private void send(Socket socket, String msg, String responsePattern) throws Exception {
        BufferedReader reader;
        if (msg != null) {
            OutputStream out = socket.getOutputStream();
            out.write(msg.getBytes());
            out.flush();
        }
        if ((reader = this.mReaders.get(socket)) == null) {
            reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.mReaders.put(socket, reader);
        }
        String response = reader.readLine();
        String errorMsg = "Unexpected response: '" + response + "'";
        TestPop3ImapAuth.assertTrue((String)errorMsg, (boolean)response.matches(responsePattern));
    }

    private void setPop3Cleartext(boolean value) throws Exception {
        this.setServerAttr("zimbraPop3CleartextLoginEnabled", value);
    }

    private void setImapCleartext(boolean value) throws Exception {
        this.setServerAttr("zimbraImapCleartextLoginEnabled", value);
    }

    private void setServerAttr(String attrName, boolean value) throws Exception {
        String val = value ? "TRUE" : "FALSE";
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(attrName, val);
        this.mProv.modifyAttrs(this.mProv.getLocalServer(), attrs);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestPop3ImapAuth.class);
    }
}

