/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.mailclient.MailConfig;
import com.zimbra.cs.mailclient.pop3.ContentInputStream;
import com.zimbra.cs.mailclient.pop3.Pop3Capabilities;
import com.zimbra.cs.mailclient.pop3.Pop3Config;
import com.zimbra.cs.mailclient.pop3.Pop3Connection;
import com.zimbra.cs.mailclient.util.SSLUtil;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.log4j.BasicConfigurator;

public class TestPop3Client
extends TestCase {
    private Pop3Config config;
    private Pop3Connection connection;
    private static final String HOST = "localhost";
    private static final int PORT = 7110;
    private static final int SSL_PORT = 7995;
    private static final String USER = "user1";
    private static final String PASS = "test123";
    private static final boolean DEBUG = true;

    public void testDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.config = null;
        this.connection = null;
    }

    public void testLogin() throws Exception {
        this.login();
    }

    public void testPlainAuth() throws Exception {
        this.connect();
        this.connection.authenticate(PASS);
    }

    public void testTls() throws Exception {
        this.config = TestPop3Client.getConfig(false);
        this.config.setSecurity(MailConfig.Security.TLS);
        this.connect();
        this.login();
    }

    public void testCapabilities() throws Exception {
        this.connect();
        Pop3Capabilities caps = this.connection.getCapabilities();
        TestPop3Client.assertNotNull((Object)caps);
        TestPop3Client.assertTrue((boolean)caps.hasCapability("STLS"));
        TestPop3Client.assertTrue((boolean)caps.hasCapability("StLs"));
        TestPop3Client.assertTrue((boolean)caps.hasCapability("IMPLEMENTATION", "ZimbraInc"));
        TestPop3Client.assertFalse((boolean)caps.hasCapability("EXPIRE", "NEVER"));
        this.login();
        caps = this.connection.getCapabilities();
        TestPop3Client.assertTrue((boolean)caps.hasCapability("EXPIRE", "NEVER"));
    }

    public void testGetMessageSizes() throws Exception {
        this.login();
        Integer[] sizes = this.connection.getMessageSizes();
        TestPop3Client.assertNotNull((Object)sizes);
        TestPop3Client.assertEquals((int)this.connection.getMessageCount(), (int)sizes.length);
        for (int i = 0; i < sizes.length; ++i) {
            TestPop3Client.assertEquals((Object)sizes[i], (Object)this.connection.getMessageSize(i + 1));
        }
    }

    public void testGetMessageUids() throws Exception {
        this.login();
        String[] uids = this.connection.getMessageUids();
        TestPop3Client.assertNotNull((Object)uids);
        TestPop3Client.assertEquals((int)this.connection.getMessageCount(), (int)uids.length);
        for (int i = 0; i < uids.length; ++i) {
            TestPop3Client.assertEquals((String)uids[i], (String)this.connection.getMessageUid(i + 1));
        }
    }

    public void testGetMessage() throws Exception {
        this.login();
        for (int msgno = 5; msgno < 20; ++msgno) {
            int size = this.connection.getMessageSize(msgno);
            TestPop3Client.assertTrue((size > 0 ? 1 : 0) != 0);
            ContentInputStream is = this.connection.getMessage(msgno);
            TestPop3Client.assertNotNull((Object)is);
            int count = TestPop3Client.countBytes(is);
            TestPop3Client.assertEquals((int)size, (int)count);
            ((InputStream)is).close();
        }
    }

    public void testDeleteMessage() throws Exception {
        this.login();
        boolean deleted = this.connection.deleteMessage(1);
        TestPop3Client.assertTrue((boolean)deleted);
        int count = this.connection.getMessageCount() - 1;
        this.connection.quit();
        this.login();
        int newCount = this.connection.getMessageCount();
        TestPop3Client.assertEquals((int)count, (int)newCount);
    }

    private static int countBytes(InputStream is) throws IOException {
        int count = 0;
        while (is.read() != -1) {
            ++count;
        }
        return count;
    }

    private void login() throws IOException {
        this.connect();
        this.connection.login(PASS);
    }

    private void connect() throws IOException {
        this.connect(false);
    }

    private void connect(boolean ssl) throws IOException {
        if (this.config == null) {
            this.config = TestPop3Client.getConfig(ssl);
        }
        System.out.println("---------");
        this.connection = new Pop3Connection(this.config);
        this.connection.connect();
    }

    private static Pop3Config getConfig(boolean ssl) throws IOException {
        Pop3Config config = new Pop3Config(HOST);
        if (ssl) {
            config.setSecurity(MailConfig.Security.SSL);
        }
        config.setPort(ssl ? 7995 : 7110);
        config.setSSLSocketFactory(SSLUtil.getDummySSLContext().getSocketFactory());
        config.setDebug(true);
        config.setTrace(true);
        config.setMechanism("PLAIN");
        config.setAuthenticationId(USER);
        return config;
    }

    static {
        BasicConfigurator.configure();
    }
}

