/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mime.MimeVisitor;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.util.JMSession;
import com.zimbra.qa.unittest.TestMimeVisitor;
import com.zimbra.qa.unittest.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.internet.MimeMessage;
import junit.framework.TestCase;

public class TestParsedMessage
extends TestCase {
    private static final String SENDER_NAME = "user1";
    private static final String RECIPIENT_NAME = "user1";
    private static final String NAME_PREFIX = TestParsedMessage.class.getSimpleName();
    private File mFile;

    public void setUp() throws Exception {
        this.cleanUp();
    }

    public void testParsedMessage() throws Exception {
        String subject;
        ExpectedResults expected = new ExpectedResults();
        expected.convertedSubject = subject = NAME_PREFIX + " testParsedMessage";
        expected.rawContent = TestUtil.getTestMessage(subject, "user1", "user1", null);
        expected.rawDigest = ByteUtil.getDigest(expected.rawContent.getBytes());
        expected.wasMutated = false;
        ParsedMessage pm = new ParsedMessage(expected.rawContent.getBytes(), false);
        this.verifyParsedMessage(pm, expected);
        pm = new ParsedMessage(expected.rawContent.getBytes(), true);
        this.verifyParsedMessage(pm, expected);
        this.mFile = File.createTempFile("TestParsedMessage", ".msg");
        FileOutputStream out = new FileOutputStream(this.mFile);
        out.write(expected.rawContent.getBytes());
        pm = new ParsedMessage(this.mFile, null, false);
        this.verifyParsedMessage(pm, expected);
        pm = new ParsedMessage(this.mFile, null, true);
        this.verifyParsedMessage(pm, expected);
        MimeMessage mimeMsg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(expected.rawContent.getBytes()));
        pm = new ParsedMessage(mimeMsg, false);
        this.verifyParsedMessage(pm, expected);
        pm = new ParsedMessage(mimeMsg, true);
        this.verifyParsedMessage(pm, expected);
    }

    public void testMimeConverter() throws Exception {
        MimeVisitor.registerConverter(TestMimeVisitor.class);
        ExpectedResults expected = new ExpectedResults();
        String subject = NAME_PREFIX + " testMimeConverter oldsubject";
        expected.convertedSubject = NAME_PREFIX + " testMimeConverter newsubject";
        expected.rawContent = TestUtil.getTestMessage(subject, "user1", "user1", null);
        expected.rawDigest = ByteUtil.getDigest(expected.rawContent.getBytes());
        expected.wasMutated = false;
        ParsedMessage pm = new ParsedMessage(expected.rawContent.getBytes(), false);
        this.verifyParsedMessage(pm, expected);
        pm = new ParsedMessage(expected.rawContent.getBytes(), true);
        this.verifyParsedMessage(pm, expected);
        this.mFile = File.createTempFile("TestParsedMessage", ".msg");
        FileOutputStream out = new FileOutputStream(this.mFile);
        out.write(expected.rawContent.getBytes());
        out.close();
        pm = new ParsedMessage(this.mFile, null, false);
        this.verifyParsedMessage(pm, expected);
        pm = new ParsedMessage(this.mFile, null, true);
        this.verifyParsedMessage(pm, expected);
        MimeMessage mimeMsg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(expected.rawContent.getBytes()));
        pm = new ParsedMessage(mimeMsg, false);
        TestParsedMessage.assertTrue((boolean)new String(pm.getRawData()).contains("oldsubject"));
        TestParsedMessage.assertTrue((boolean)this.getContent(pm.getMimeMessage()).contains("newsubject"));
        TestParsedMessage.assertTrue((boolean)pm.getSubject().contains("newsubject"));
        pm = new ParsedMessage(mimeMsg, true);
        TestParsedMessage.assertTrue((boolean)new String(pm.getRawData()).contains("oldsubject"));
        TestParsedMessage.assertTrue((boolean)this.getContent(pm.getMimeMessage()).contains("newsubject"));
        TestParsedMessage.assertTrue((boolean)pm.getSubject().contains("newsubject"));
    }

    private void verifyParsedMessage(ParsedMessage pm, ExpectedResults expected) throws Exception {
        for (int i = 1; i < 3; ++i) {
            TestParsedMessage.assertEquals((String)expected.rawContent, (String)new String(pm.getRawData()));
            TestParsedMessage.assertEquals((String)expected.rawDigest, (String)pm.getRawDigest());
            TestParsedMessage.assertEquals((int)expected.rawContent.length(), (int)pm.getRawSize());
            TestParsedMessage.assertEquals((String)expected.convertedSubject, (String)pm.getSubject());
            String sender = TestUtil.getAddress("user1");
            String recipient = TestUtil.getAddress("user1");
            TestParsedMessage.assertTrue((boolean)pm.getSender().contains(sender));
            TestParsedMessage.assertEquals((String)sender, (String)pm.getSenderEmail());
            TestParsedMessage.assertTrue((boolean)pm.getRecipients().contains(recipient));
            String contentFromStream = new String(ByteUtil.getContent(pm.getRawInputStream(), expected.rawContent.length()));
            TestParsedMessage.assertEquals((String)expected.rawContent, (String)contentFromStream);
            TestParsedMessage.assertTrue((boolean)this.getContent(pm.getMimeMessage()).contains(expected.convertedSubject));
            TestParsedMessage.assertEquals((boolean)expected.wasMutated, (boolean)pm.wasMutated());
            pm.analyzeFully();
        }
    }

    public void testMimeMutator() throws Exception {
        MimeVisitor.registerMutator(TestMimeVisitor.class);
        String subject = NAME_PREFIX + " testMimeConverter oldsubject";
        String content = TestUtil.getTestMessage(subject, "user1", "user1", null);
        ParsedMessage pm = new ParsedMessage(content.getBytes(), false);
        pm = new ParsedMessage(content.getBytes(), true);
        String substring = "newsubject";
        this.verifyMutatedMessage(pm, substring, true);
        this.mFile = this.createTempFile(content);
        pm = new ParsedMessage(this.mFile, null, false);
        this.verifyMutatedMessage(pm, substring, true);
        this.mFile = this.createTempFile(content);
        pm = new ParsedMessage(this.mFile, null, true);
        this.verifyMutatedMessage(pm, substring, true);
        MimeMessage mimeMsg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(content.getBytes()));
        pm = new ParsedMessage(mimeMsg, false);
        this.verifyMutatedMessage(pm, substring, true);
        mimeMsg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(content.getBytes()));
        pm = new ParsedMessage(mimeMsg, true);
        this.verifyMutatedMessage(pm, substring, true);
    }

    private File createTempFile(String content) throws IOException {
        File file = File.createTempFile("TestParsedMessage", ".msg");
        FileOutputStream out = new FileOutputStream(file);
        out.write(content.getBytes());
        out.close();
        return file;
    }

    private void verifyMutatedMessage(ParsedMessage pm, String substring, boolean wasMutated) throws Exception {
        TestParsedMessage.assertEquals((boolean)wasMutated, (boolean)pm.wasMutated());
        TestParsedMessage.assertTrue((boolean)pm.getSubject().contains(substring));
        TestParsedMessage.assertTrue((boolean)new String(pm.getRawData()).contains(substring));
        byte[] data = ByteUtil.getContent(pm.getRawInputStream(), 0);
        TestParsedMessage.assertTrue((boolean)new String(data).contains(substring));
        data = pm.getRawData();
        TestParsedMessage.assertTrue((boolean)new String(data).contains(substring));
    }

    public void testGetData() throws Exception {
        String msg = TestUtil.getTestMessage(NAME_PREFIX + " testGetData", "user1", "user1", null);
        ParsedMessage pm = new ParsedMessage(msg.getBytes(), true);
        this.runContentTests(msg, pm);
        this.mFile = File.createTempFile("TestParsedMessage", null);
        FileOutputStream out = new FileOutputStream(this.mFile);
        out.write(msg.getBytes());
        pm = new ParsedMessage(this.mFile, null, true);
        this.runContentTests(msg, pm);
        MimeMessage mimeMsg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(msg.getBytes()));
        pm = new ParsedMessage(mimeMsg, true);
        this.runContentTests(msg, pm);
    }

    private void runContentTests(String originalMsg, ParsedMessage pm) throws Exception {
        int size = originalMsg.length();
        String msg = new String(ByteUtil.getContent(pm.getRawInputStream(), size));
        TestParsedMessage.assertEquals((String)("expected: " + originalMsg + "\ngot: " + msg), (String)originalMsg, (String)msg);
        msg = new String(pm.getRawData());
        TestParsedMessage.assertEquals((String)("expected: " + originalMsg + "\ngot: " + msg), (String)originalMsg, (String)msg);
        String originalDigest = ByteUtil.getSHA1Digest(originalMsg.getBytes(), true);
        String digest = pm.getRawDigest();
        TestParsedMessage.assertEquals((String)("expected: " + digest + ", got: " + digest), (String)originalDigest, (String)digest);
        TestParsedMessage.assertEquals((int)size, (int)pm.getRawSize());
    }

    public void testAddMessage() throws Exception {
        String msg = TestUtil.getTestMessage(NAME_PREFIX + " testAddMessage", "user1", "user1", null);
        ParsedMessage pm = new ParsedMessage(msg.getBytes(), true);
        this.runAddMessageTest(msg, pm);
        this.mFile = File.createTempFile("TestParsedMessage", null);
        FileOutputStream out = new FileOutputStream(this.mFile);
        out.write(msg.getBytes());
        pm = new ParsedMessage(this.mFile, null, true);
        this.runAddMessageTest(msg, pm);
        MimeMessage mimeMsg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(msg.getBytes()));
        pm = new ParsedMessage(mimeMsg, true);
        this.runAddMessageTest(msg, pm);
    }

    private void runAddMessageTest(String originalMsg, ParsedMessage pm) throws Exception {
        Mailbox mbox = TestUtil.getMailbox("user1");
        Message msg = mbox.addMessage(null, pm, 2, false, 0, null);
        TestParsedMessage.assertEquals((String)originalMsg, (String)new String(ByteUtil.getContent(msg.getContentStream(), 0)));
    }

    private String getContent(MimeMessage msg) throws Exception {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)buf);
        return new String(buf.toByteArray());
    }

    public void tearDown() throws Exception {
        if (this.mFile != null) {
            this.mFile.delete();
        }
        MimeVisitor.unregisterConverter(TestMimeVisitor.class);
        MimeVisitor.unregisterMutator(TestMimeVisitor.class);
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData("user1", NAME_PREFIX);
    }

    private class ExpectedResults {
        String convertedSubject;
        String rawContent;
        String rawDigest;
        boolean wasMutated;

        private ExpectedResults() {
        }
    }
}

