/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.util.ParseMailboxID;
import junit.framework.TestCase;

public class TestParseMailboxID
extends TestCase {
    public void testParseMailboxID() throws ServiceException {
        String user1AcctID = null;
        ParseMailboxID id = ParseMailboxID.parse("1");
        TestParseMailboxID.assertTrue((boolean)id.isLocal());
        TestParseMailboxID.assertEquals((String)id.getServer(), null);
        TestParseMailboxID.assertEquals((long)id.getMailboxId(), (long)1L);
        TestParseMailboxID.assertEquals((Object)id.getMailbox(), (Object)MailboxManager.getInstance().getMailboxById(1L));
        TestParseMailboxID.assertFalse((boolean)id.isAllMailboxIds());
        TestParseMailboxID.assertFalse((boolean)id.isAllServers());
        user1AcctID = id.getMailbox().getAccountId();
        id = ParseMailboxID.parse("user1@example.zimbra.com");
        TestParseMailboxID.assertTrue((boolean)id.isLocal());
        TestParseMailboxID.assertEquals((String)id.getServer(), null);
        TestParseMailboxID.assertEquals((long)id.getMailboxId(), (long)1L);
        TestParseMailboxID.assertEquals((Object)id.getMailbox(), (Object)MailboxManager.getInstance().getMailboxById(1L));
        TestParseMailboxID.assertFalse((boolean)id.isAllMailboxIds());
        TestParseMailboxID.assertFalse((boolean)id.isAllServers());
        id = ParseMailboxID.parse(user1AcctID);
        TestParseMailboxID.assertTrue((boolean)id.isLocal());
        TestParseMailboxID.assertEquals((String)id.getServer(), null);
        TestParseMailboxID.assertEquals((long)id.getMailboxId(), (long)1L);
        TestParseMailboxID.assertEquals((Object)id.getMailbox(), (Object)MailboxManager.getInstance().getMailboxById(1L));
        TestParseMailboxID.assertFalse((boolean)id.isAllMailboxIds());
        TestParseMailboxID.assertFalse((boolean)id.isAllServers());
        String localhost = Provisioning.getInstance().getLocalServer().getAttr("zimbraServiceHostname");
        ParseMailboxID id2 = ParseMailboxID.parse("/" + localhost + "/1");
        TestParseMailboxID.assertTrue((boolean)id2.isLocal());
        TestParseMailboxID.assertEquals((String)id2.getServer(), null);
        TestParseMailboxID.assertEquals((long)id2.getMailboxId(), (long)1L);
        TestParseMailboxID.assertEquals((Object)id2.getMailbox(), (Object)MailboxManager.getInstance().getMailboxById(1L));
        TestParseMailboxID.assertFalse((boolean)id2.isAllMailboxIds());
        TestParseMailboxID.assertFalse((boolean)id2.isAllServers());
        id2 = ParseMailboxID.parse("*");
        TestParseMailboxID.assertFalse((boolean)id2.isLocal());
        TestParseMailboxID.assertEquals((String)id2.getServer(), (String)"*");
        TestParseMailboxID.assertEquals((long)id2.getMailboxId(), (long)0L);
        TestParseMailboxID.assertEquals((Object)id2.getMailbox(), null);
        TestParseMailboxID.assertTrue((boolean)id2.isAllMailboxIds());
        TestParseMailboxID.assertTrue((boolean)id2.isAllServers());
        String idStr = "/" + localhost + "/*";
        ParseMailboxID id3 = ParseMailboxID.parse(idStr);
        TestParseMailboxID.assertTrue((boolean)id3.isLocal());
        TestParseMailboxID.assertEquals((String)id3.getServer(), null);
        TestParseMailboxID.assertEquals((long)id3.getMailboxId(), (long)0L);
        TestParseMailboxID.assertEquals((Object)id3.getMailbox(), null);
        TestParseMailboxID.assertTrue((boolean)id3.isAllMailboxIds());
        TestParseMailboxID.assertFalse((boolean)id3.isAllServers());
        try {
            id2 = ParseMailboxID.parse(localhost + "*/3");
            TestParseMailboxID.assertFalse((boolean)true);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }
}

