/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.account.Account;
import com.zimbra.cs.db.DbOutOfOffice;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.qa.unittest.TestUtil;
import java.util.Date;
import junit.framework.TestCase;

public class TestOutOfOffice
extends TestCase {
    private DbPool.Connection mConn;
    private Mailbox mMbox;
    private String mOriginalFromAddress;
    private String mOriginalFromDisplay;
    private String mOriginalReplyEnabled;
    private String mOriginalFromDate;
    private String mOriginalUntilDate;
    private String mOriginalAllowAnyFrom;
    private static String NAME_PREFIX = TestOutOfOffice.class.getSimpleName();
    private static String RECIPIENT_NAME = "user1";
    private static String SENDER_NAME = "user2";
    private static String RECIPIENT1_ADDRESS = "TestOutOfOffice1@example.zimbra.com";
    private static String RECIPIENT2_ADDRESS = "TestOutOfOffice2@example.zimbra.com";

    protected void setUp() throws Exception {
        super.setUp();
        this.mMbox = TestUtil.getMailbox(RECIPIENT_NAME);
        this.mConn = DbPool.getConnection();
        Account recipient = TestUtil.getAccount(RECIPIENT_NAME);
        this.mOriginalFromAddress = recipient.getPrefFromAddress();
        this.mOriginalFromDisplay = recipient.getPrefFromDisplay();
        this.mOriginalAllowAnyFrom = TestUtil.getAccountAttr(RECIPIENT_NAME, "zimbraAllowAnyFromAddress");
        this.mOriginalReplyEnabled = TestUtil.getAccountAttr(RECIPIENT_NAME, "zimbraPrefOutOfOfficeReplyEnabled");
        this.mOriginalFromDate = recipient.getPrefOutOfOfficeFromDateAsString();
        this.mOriginalUntilDate = recipient.getPrefOutOfOfficeUntilDateAsString();
        this.cleanUp();
    }

    public void testRowExists() throws Exception {
        long fiveDaysAgo = System.currentTimeMillis() - 432000000L;
        DbOutOfOffice.setSentTime(this.mConn, this.mMbox, RECIPIENT1_ADDRESS, fiveDaysAgo);
        this.mConn.commit();
        TestOutOfOffice.assertFalse((String)"1 day", (boolean)DbOutOfOffice.alreadySent(this.mConn, this.mMbox, RECIPIENT1_ADDRESS, 86400000L));
        TestOutOfOffice.assertFalse((String)"4 days", (boolean)DbOutOfOffice.alreadySent(this.mConn, this.mMbox, RECIPIENT1_ADDRESS, 345600000L));
        TestOutOfOffice.assertFalse((String)"5 days", (boolean)DbOutOfOffice.alreadySent(this.mConn, this.mMbox, RECIPIENT1_ADDRESS, 432000000L));
        TestOutOfOffice.assertTrue((String)"6 days", (boolean)DbOutOfOffice.alreadySent(this.mConn, this.mMbox, RECIPIENT1_ADDRESS, 518400000L));
        TestOutOfOffice.assertTrue((String)"100 days", (boolean)DbOutOfOffice.alreadySent(this.mConn, this.mMbox, RECIPIENT1_ADDRESS, 8640000000L));
    }

    public void testRowDoesntExist() throws Exception {
        TestOutOfOffice.assertFalse((String)"1 day", (boolean)DbOutOfOffice.alreadySent(this.mConn, this.mMbox, RECIPIENT1_ADDRESS, 86400000L));
        TestOutOfOffice.assertFalse((String)"5 days", (boolean)DbOutOfOffice.alreadySent(this.mConn, this.mMbox, RECIPIENT1_ADDRESS, 432000000L));
        TestOutOfOffice.assertFalse((String)"100 days", (boolean)DbOutOfOffice.alreadySent(this.mConn, this.mMbox, RECIPIENT1_ADDRESS, 8640000000L));
    }

    public void testPrune() throws Exception {
        long fiveDaysAgo = System.currentTimeMillis() - 432000000L;
        long sixDaysAgo = System.currentTimeMillis() - 518400000L;
        DbOutOfOffice.setSentTime(this.mConn, this.mMbox, RECIPIENT1_ADDRESS, fiveDaysAgo);
        DbOutOfOffice.setSentTime(this.mConn, this.mMbox, RECIPIENT2_ADDRESS, sixDaysAgo);
        this.mConn.commit();
        DbOutOfOffice.prune(this.mConn, 518400000L);
        this.mConn.commit();
        TestOutOfOffice.assertTrue((String)"recipient1", (boolean)DbOutOfOffice.alreadySent(this.mConn, this.mMbox, RECIPIENT1_ADDRESS, 518400000L));
        TestOutOfOffice.assertFalse((String)"recipient2", (boolean)DbOutOfOffice.alreadySent(this.mConn, this.mMbox, RECIPIENT2_ADDRESS, 604800000L));
    }

    public void testPrefFromAddress() throws Exception {
        String newFromAddress = TestUtil.getAddress("testPrefFromAddress");
        String newDisplayName = NAME_PREFIX + " testPrefFromAddress";
        Account recipient = TestUtil.getAccount(RECIPIENT_NAME);
        recipient.setPrefFromAddress(newFromAddress);
        recipient.setPrefFromDisplay(newDisplayName);
        long now = System.currentTimeMillis();
        recipient.setPrefOutOfOfficeFromDate(new Date(now));
        recipient.setPrefOutOfOfficeUntilDate(new Date(now + 86400000L));
        recipient.setPrefOutOfOfficeReplyEnabled(true);
        recipient.setAllowAnyFromAddress(false);
        String subject = NAME_PREFIX + " testPrefFromAddress 1";
        ZMailbox senderMbox = TestUtil.getZMailbox(SENDER_NAME);
        TestUtil.sendMessage(senderMbox, RECIPIENT_NAME, subject);
        ZMessage reply = TestUtil.waitForMessage(senderMbox, "in:inbox subject:\"" + subject + "\"");
        ZEmailAddress fromAddress = this.getFromAddress(reply);
        TestOutOfOffice.assertEquals((String)recipient.getName(), (String)fromAddress.getAddress());
        DbOutOfOffice.clear(this.mConn, this.mMbox);
        this.mConn.commit();
        recipient.setAllowAnyFromAddress(true);
        subject = NAME_PREFIX + " testPrefFromAddress 2";
        TestUtil.sendMessage(senderMbox, RECIPIENT_NAME, subject);
        reply = TestUtil.waitForMessage(senderMbox, "in:inbox subject:\"" + subject + "\"");
        fromAddress = this.getFromAddress(reply);
        TestOutOfOffice.assertEquals((String)newFromAddress, (String)fromAddress.getAddress());
    }

    private ZEmailAddress getFromAddress(ZMessage msg) {
        for (ZEmailAddress address : msg.getEmailAddresses()) {
            if (!address.getType().equals("f")) continue;
            return address;
        }
        TestOutOfOffice.fail((String)("Could not find From address in message: " + msg.getSubject()));
        return null;
    }

    public void tearDown() throws Exception {
        this.cleanUp();
        DbPool.quietClose(this.mConn);
        Account sender = TestUtil.getAccount(SENDER_NAME);
        sender.setPrefFromAddress(this.mOriginalFromAddress);
        sender.setPrefFromDisplay(this.mOriginalFromDisplay);
        TestUtil.setAccountAttr(SENDER_NAME, "zimbraAllowAnyFromAddress", this.mOriginalAllowAnyFrom);
        TestUtil.setAccountAttr(RECIPIENT_NAME, "zimbraPrefOutOfOfficeReplyEnabled", this.mOriginalReplyEnabled);
        TestUtil.setAccountAttr(RECIPIENT_NAME, "zimbraPrefOutOfOfficeFromDate", this.mOriginalFromDate);
        TestUtil.setAccountAttr(RECIPIENT_NAME, "zimbraPrefOutOfOfficeUntilDate", this.mOriginalUntilDate);
        super.tearDown();
    }

    private void cleanUp() throws Exception {
        DbOutOfOffice.clear(this.mConn, this.mMbox);
        this.mConn.commit();
        TestUtil.deleteTestData(SENDER_NAME, NAME_PREFIX);
        TestUtil.deleteTestData(RECIPIENT_NAME, NAME_PREFIX);
    }
}

