/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.db.DbOutOfOffice;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.util.JMSession;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.qa.unittest.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import junit.framework.TestCase;
import org.testng.TestNG;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNotification
extends TestCase {
    private static String RECIPIENT_NAME = "user1";
    private static String SENDER_NAME = "user2";
    private static String TAPPED_NAME = "user1";
    private static String INTERCEPTOR_NAME = "user2";
    private static String INTERCEPTOR2_NAME = "user3";
    private static String[] ALL_TEST_USERS = new String[]{"user1", "user2", "user3"};
    private static String NAME_PREFIX = TestNotification.class.getSimpleName();
    private static String NEW_MAIL_SUBJECT = NAME_PREFIX + " \u041a\u0440\u043e\u043a\u043e\u0434\u0438\u043b";
    private static String NEW_MAIL_BODY = NAME_PREFIX + " \u0427\u0435\u0440\u0435\u043f\u0430\u0445\u0430";
    private static String OUT_OF_OFFICE_SUBJECT = NAME_PREFIX + " \u041e\u0431\u0435\u0437\u044c\u044f\u043d\u0430";
    private static String OUT_OF_OFFICE_BODY = NAME_PREFIX + " \u0416\u0438\u0440\u0430\u0444";
    private boolean mOriginalReplyEnabled;
    private String mOriginalReply;
    private boolean mOriginalNotificationEnabled;
    private String mOriginalNotificationAddress;
    private String mOriginalNotificationSubject;
    private String mOriginalNotificationBody;
    private String[] mOriginalInterceptAddresses;
    private String mOriginalInterceptSendHeadersOnly;
    private String mOriginalSaveToSent;
    private boolean mIsServerTest = false;

    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
        this.cleanUp();
        Account account = TestUtil.getAccount(RECIPIENT_NAME);
        this.mOriginalReplyEnabled = account.getBooleanAttr("zimbraPrefOutOfOfficeReplyEnabled", false);
        this.mOriginalReply = account.getAttr("zimbraPrefOutOfOfficeReply", "");
        this.mOriginalNotificationEnabled = account.getBooleanAttr("zimbraPrefNewMailNotificationEnabled", false);
        this.mOriginalNotificationAddress = account.getAttr("zimbraPrefNewMailNotificationAddress", "");
        this.mOriginalNotificationSubject = account.getAttr("zimbraNewMailNotificationSubject", "");
        this.mOriginalNotificationBody = account.getAttr("zimbraNewMailNotificationBody", "");
        this.mOriginalInterceptAddresses = account.getMultiAttr("zimbraInterceptAddress");
        this.mOriginalInterceptSendHeadersOnly = account.getAttr("zimbraInterceptSendHeadersOnly", "");
        this.mOriginalSaveToSent = account.getAttr("zimbraPrefSaveToSent", "");
    }

    @Test(groups={"Server"})
    public void testUtf8() throws Exception {
        this.mIsServerTest = true;
        Account account = TestUtil.getAccount(RECIPIENT_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPrefOutOfOfficeReplyEnabled", "TRUE");
        attrs.put("zimbraPrefOutOfOfficeReply", OUT_OF_OFFICE_BODY);
        attrs.put("zimbraPrefNewMailNotificationEnabled", "TRUE");
        attrs.put("zimbraPrefNewMailNotificationAddress", TestUtil.getAddress(SENDER_NAME));
        attrs.put("zimbraNewMailNotificationSubject", NEW_MAIL_SUBJECT);
        attrs.put("zimbraNewMailNotificationBody", NEW_MAIL_BODY);
        Provisioning.getInstance().modifyAttrs(account, attrs);
        ZMailbox senderMbox = TestUtil.getZMailbox(SENDER_NAME);
        ZMailbox recipMbox = TestUtil.getZMailbox(RECIPIENT_NAME);
        List<ZMessage> messages = TestUtil.search(recipMbox, "in:inbox subject:" + OUT_OF_OFFICE_SUBJECT);
        TestNotification.assertEquals((String)"Messages in recipient mailbox", (int)0, (int)messages.size());
        messages = TestUtil.search(senderMbox, "in:inbox subject:" + OUT_OF_OFFICE_SUBJECT);
        TestNotification.assertEquals((String)"Messages in sender mailbox", (int)0, (int)messages.size());
        messages = TestUtil.search(senderMbox, NEW_MAIL_SUBJECT);
        TestNotification.assertEquals((String)"New mail reply", (int)0, (int)messages.size());
        TestUtil.sendMessage(senderMbox, RECIPIENT_NAME, OUT_OF_OFFICE_SUBJECT, "testing");
        TestUtil.waitForMessage(recipMbox, "in:inbox subject:" + OUT_OF_OFFICE_SUBJECT);
        TestUtil.waitForMessage(senderMbox, "in:inbox subject:" + OUT_OF_OFFICE_SUBJECT);
        messages = TestUtil.search(senderMbox, "in:inbox content:" + OUT_OF_OFFICE_BODY);
        TestNotification.assertEquals((String)"Out-of-office body not found", (int)1, (int)messages.size());
        TestUtil.waitForMessage(senderMbox, "in:inbox subject:" + NEW_MAIL_SUBJECT);
        messages = TestUtil.search(senderMbox, "in:inbox content:" + NEW_MAIL_BODY);
        TestNotification.assertEquals((String)"New mail notification body not found", (int)1, (int)messages.size());
    }

    @Test
    public void testIntercept() throws Exception {
        String interceptorAddress = TestUtil.getAddress(INTERCEPTOR_NAME);
        TestUtil.setAccountAttr(TAPPED_NAME, "zimbraInterceptAddress", interceptorAddress);
        TestUtil.setAccountAttr(TAPPED_NAME, "zimbraInterceptSendHeadersOnly", "FALSE");
        ZMailbox interceptorMbox = TestUtil.getZMailbox(INTERCEPTOR_NAME);
        ZMailbox tappedMbox = TestUtil.getZMailbox(TAPPED_NAME);
        String tappedAddress = TestUtil.getAddress(TAPPED_NAME);
        String subject = NAME_PREFIX + " testIntercept-receive";
        TestUtil.addMessageLmtp(subject, tappedAddress, interceptorAddress);
        ZMessage tappedMsg = TestUtil.getMessage(tappedMbox, "subject:\"" + subject + "\"");
        ZMessage interceptMsg = TestUtil.waitForMessage(interceptorMbox, "subject:\"" + subject + "\"");
        this.verifyInterceptMessage(interceptMsg, "add message", "Inbox", Integer.toString(2));
        this.compareContent(tappedMbox, tappedMsg, interceptorMbox, interceptMsg);
        ZMailbox.ZOutgoingMessage outgoing = new ZMailbox.ZOutgoingMessage();
        ArrayList<ZEmailAddress> addresses = new ArrayList<ZEmailAddress>();
        addresses.add(new ZEmailAddress(TestUtil.getAddress(INTERCEPTOR_NAME), null, null, "t"));
        outgoing.setAddresses(addresses);
        subject = NAME_PREFIX + " testIntercept-draft-1";
        outgoing.setSubject(subject);
        outgoing.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart("text/plain", "I always feel like somebody's watching me."));
        tappedMbox.saveDraft(outgoing, null, Integer.toString(6));
        tappedMsg = TestUtil.getMessage(tappedMbox, "in:drafts subject:\"" + subject + "\"");
        interceptMsg = TestUtil.waitForMessage(interceptorMbox, "subject:\"" + subject + "\"");
        this.verifyInterceptMessage(interceptMsg, "add message", "Drafts", Integer.toString(6));
        this.compareContent(tappedMbox, tappedMsg, interceptorMbox, interceptMsg);
        ZMessage draft = TestUtil.getMessage(tappedMbox, "in:drafts subject:\"" + subject + "\"");
        subject = NAME_PREFIX + " testIntercept-draft-2";
        outgoing.setSubject(subject);
        tappedMbox.saveDraft(outgoing, draft.getId(), null);
        tappedMsg = TestUtil.getMessage(tappedMbox, "in:drafts subject:\"" + subject + "\"");
        interceptMsg = TestUtil.waitForMessage(interceptorMbox, "subject:\"" + subject + "\"");
        this.verifyInterceptMessage(interceptMsg, "save draft", "Drafts", Integer.toString(6));
        this.compareContent(tappedMbox, tappedMsg, interceptorMbox, interceptMsg);
        TestUtil.setAccountAttr(TAPPED_NAME, "zimbraPrefSaveToSent", "TRUE");
        subject = NAME_PREFIX + " testIntercept-send-1";
        TestUtil.sendMessage(tappedMbox, INTERCEPTOR_NAME, subject);
        tappedMsg = TestUtil.waitForMessage(tappedMbox, "in:sent subject:\"" + subject + "\"");
        interceptMsg = TestUtil.waitForMessage(interceptorMbox, "subject:intercepted subject:\"" + subject + "\"");
        this.verifyInterceptMessage(interceptMsg, "add message", "Sent", Integer.toString(5));
        this.compareContent(tappedMbox, tappedMsg, interceptorMbox, interceptMsg);
        TestUtil.setAccountAttr(TAPPED_NAME, "zimbraPrefSaveToSent", "FALSE");
        subject = NAME_PREFIX + " testIntercept-send-2";
        TestUtil.sendMessage(tappedMbox, INTERCEPTOR_NAME, subject);
        interceptMsg = TestUtil.waitForMessage(interceptorMbox, "subject:intercepted subject:\"" + subject + "\"");
        this.verifyInterceptMessage(interceptMsg, "send message", "none", "none");
        TestUtil.setAccountAttr(TAPPED_NAME, "zimbraInterceptSendHeadersOnly", "TRUE");
        subject = NAME_PREFIX + " testIntercept-headers-only";
        TestUtil.sendMessage(interceptorMbox, TAPPED_NAME, subject);
        tappedMsg = TestUtil.waitForMessage(tappedMbox, "in:inbox subject:\"" + subject + "\"");
        interceptMsg = TestUtil.waitForMessage(interceptorMbox, "subject:intercepted subject:\"" + subject + "\"");
        this.verifyInterceptMessage(interceptMsg, "add message", "Inbox", Integer.toString(2));
        this.compareContent(tappedMbox, tappedMsg, interceptorMbox, interceptMsg);
    }

    @Test
    public void testInterceptMultiValue() throws Exception {
        String interceptor1Address = TestUtil.getAddress(INTERCEPTOR_NAME);
        String interceptor2Address = TestUtil.getAddress(INTERCEPTOR2_NAME);
        String[] interceptorAddresses = new String[]{interceptor1Address, interceptor2Address};
        TestUtil.setAccountAttr(TAPPED_NAME, "zimbraInterceptAddress", interceptorAddresses);
        TestUtil.setAccountAttr(TAPPED_NAME, "zimbraInterceptSendHeadersOnly", "FALSE");
        ZMailbox tappedMbox = TestUtil.getZMailbox(TAPPED_NAME);
        String tappedAddress = TestUtil.getAddress(TAPPED_NAME);
        String subject = NAME_PREFIX + " testIntercept-receive";
        TestUtil.addMessageLmtp(subject, tappedAddress, interceptor1Address);
        ZMailbox interceptor1Mbox = TestUtil.getZMailbox(INTERCEPTOR_NAME);
        ZMailbox interceptor2Mbox = TestUtil.getZMailbox(INTERCEPTOR2_NAME);
        ZMessage tappedMsg = TestUtil.getMessage(tappedMbox, "subject:\"" + subject + "\"");
        ZMessage interceptMsg1 = TestUtil.waitForMessage(interceptor1Mbox, "subject:\"" + subject + "\"");
        ZMessage interceptMsg2 = TestUtil.waitForMessage(interceptor2Mbox, "subject:\"" + subject + "\"");
        this.verifyInterceptMessage(interceptMsg1, "add message", "Inbox", Integer.toString(2));
        this.verifyInterceptMessage(interceptMsg2, "add message", "Inbox", Integer.toString(2));
        this.compareContent(tappedMbox, tappedMsg, interceptor1Mbox, interceptMsg1);
        this.compareContent(tappedMbox, tappedMsg, interceptor2Mbox, interceptMsg2);
    }

    private void verifyInterceptMessage(ZMessage interceptMsg, String operation, String folderName, String folderId) throws Exception {
        ZMessage.ZMimePart part = interceptMsg.getMimeStructure();
        TestNotification.assertEquals((String)"multipart/mixed", (String)part.getContentType());
        List<ZMessage.ZMimePart> children = part.getChildren();
        TestNotification.assertEquals((int)2, (int)children.size());
        ZMessage.ZMimePart bodyPart = children.get(0);
        TestNotification.assertEquals((String)"text/plain", (String)bodyPart.getContentType());
        String body = bodyPart.getContent();
        String context = "Unexpected body: \n" + body;
        TestNotification.assertTrue((String)context, (boolean)body.contains("Intercepted message for " + RECIPIENT_NAME));
        TestNotification.assertTrue((String)context, (boolean)body.contains("Operation=" + operation));
        TestNotification.assertTrue((String)context, (boolean)body.contains("folder=" + folderName));
        TestNotification.assertTrue((String)context, (boolean)body.contains("folder ID=" + folderId));
        ZMessage.ZMimePart interceptedPart = children.get(1);
        TestNotification.assertEquals((String)"message/rfc822", (String)interceptedPart.getContentType());
    }

    private void compareContent(ZMailbox tappedMbox, ZMessage tappedMsg, ZMailbox interceptorMbox, ZMessage interceptMsg) throws Exception {
        String relativeUrl = String.format("?id=%s&part=2", interceptMsg.getId());
        InputStream in = interceptorMbox.getRESTResource(relativeUrl);
        String interceptedMsgContent = new String(ByteUtil.getContent(in, -1)).trim();
        String tappedMsgContent = TestUtil.getContent(tappedMbox, tappedMsg.getId()).trim();
        Account account = TestUtil.getAccount(TAPPED_NAME);
        MimeMessage tappedMimeMsg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(tappedMsgContent.getBytes()));
        MimeMessage interceptedMimeMsg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(interceptedMsgContent.getBytes()));
        boolean headersOnly = account.getBooleanAttr("zimbraInterceptSendHeadersOnly", false);
        Set<String> tappedHeaderLines = this.getHeaderLines(tappedMimeMsg);
        Set<String> interceptedHeaderLines = this.getHeaderLines(interceptedMimeMsg);
        tappedHeaderLines.removeAll(this.getHeaderLines(interceptedMimeMsg));
        interceptedHeaderLines.removeAll(this.getHeaderLines(tappedMimeMsg));
        String context = "Unexpected headers found.  tapped: " + StringUtil.join(",", tappedHeaderLines) + ".  intercepted: " + StringUtil.join(",", interceptedHeaderLines) + ".";
        TestNotification.assertTrue((String)context, (tappedHeaderLines.size() == 0 && interceptedHeaderLines.size() == 0 ? 1 : 0) != 0);
        if (headersOnly) {
            String interceptedBody = new String(ByteUtil.getContent(interceptedMimeMsg.getInputStream(), 0));
            if (interceptedBody != null) {
                interceptedBody = interceptedBody.trim();
            }
            TestNotification.assertTrue((String)("Unexpected body: '" + interceptedBody + "'"), (interceptedBody == null || interceptedBody.length() == 0 ? 1 : 0) != 0);
        } else {
            TestNotification.assertEquals((String)("Expected:\n'" + tappedMsgContent + "'\nGot:\n'" + interceptedMsgContent + "'"), (String)tappedMsgContent, (String)interceptedMsgContent);
        }
    }

    private Set<String> getHeaderLines(MimeMessage msg) throws MessagingException {
        HashSet<String> headerLines = new HashSet<String>();
        Enumeration e = msg.getAllHeaderLines();
        while (e.hasMoreElements()) {
            headerLines.add((String)e.nextElement());
        }
        return headerLines;
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.cleanUp();
        Account account = TestUtil.getAccount(RECIPIENT_NAME);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraPrefOutOfOfficeReplyEnabled", LdapUtil.getBooleanString(this.mOriginalReplyEnabled));
        attrs.put("zimbraPrefOutOfOfficeReply", this.mOriginalReply);
        attrs.put("zimbraPrefNewMailNotificationEnabled", LdapUtil.getBooleanString(this.mOriginalNotificationEnabled));
        attrs.put("zimbraPrefNewMailNotificationAddress", this.mOriginalNotificationAddress);
        attrs.put("zimbraNewMailNotificationSubject", this.mOriginalNotificationSubject);
        attrs.put("zimbraNewMailNotificationBody", this.mOriginalNotificationBody);
        if (this.mOriginalInterceptAddresses != null && this.mOriginalInterceptAddresses.length == 0) {
            attrs.put("zimbraInterceptAddress", "");
        } else {
            attrs.put("zimbraInterceptAddress", this.mOriginalInterceptAddresses);
        }
        attrs.put("zimbraInterceptSendHeadersOnly", this.mOriginalInterceptSendHeadersOnly);
        attrs.put("zimbraPrefSaveToSent", this.mOriginalSaveToSent);
        Provisioning.getInstance().modifyAttrs(account, attrs);
        super.tearDown();
    }

    private void cleanUp() throws Exception {
        if (this.mIsServerTest) {
            DbPool.Connection conn = DbPool.getConnection();
            Mailbox mbox = TestUtil.getMailbox(RECIPIENT_NAME);
            DbOutOfOffice.clear(conn, mbox);
            conn.commit();
            DbPool.quietClose(conn);
        }
        for (String userName : ALL_TEST_USERS) {
            TestUtil.deleteTestData(userName, NAME_PREFIX);
        }
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestNG testng = TestUtil.newTestNG();
        testng.setExcludedGroups("Server");
        testng.setTestClasses(new Class[]{TestNotification.class});
        testng.run();
    }
}

