/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.TaskUtil;
import com.zimbra.cs.imap.LiteralInfo;
import com.zimbra.cs.mina.LineBuffer;
import com.zimbra.cs.mina.MinaOutputStream;
import com.zimbra.cs.mina.MinaUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public class TestMina
extends TestCase {
    private static final String LINE = "This is a line";
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";
    private static final String EOM = "\r\n.\r\n";
    private static final int BIG_DATA_SIZE = 65536;
    private static final String MSG_1 = "01234\r\n0123456789\r\n.\r\n";
    private static final String MSG_2 = "01234\r\n..foo.0123456789\r\n.\r\n";
    private static final String MSG_3 = ".\r\n";
    private static final String MSG_4 = "\r\n.\r\n";

    public void testExpand() {
        ByteBuffer bb = ByteBuffer.allocate(100);
        bb.position(99);
        bb = MinaUtil.expand(bb, 1001);
        TestMina.assertTrue((bb.remaining() >= 1001 ? 1 : 0) != 0);
    }

    public void testExpandBigData() {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(10);
        for (i = 0; i < 65536; ++i) {
            bb = MinaUtil.expand(bb, 1);
            TestMina.assertTrue((boolean)bb.hasRemaining());
            bb.put((byte)i);
        }
        TestMina.assertEquals((int)65536, (int)bb.position());
        bb.flip();
        for (i = 0; i < 65536; ++i) {
            TestMina.assertEquals((byte)((byte)i), (byte)bb.get());
        }
    }

    public void testToString() {
        ByteBuffer bb = ByteBuffer.wrap(LINE.getBytes());
        TestMina.assertEquals((String)LINE, (String)MinaUtil.toAsciiString(bb));
    }

    public void testGetBytes() {
        byte[] b = new byte[100];
        ByteBuffer bb = ByteBuffer.wrap(b);
        TestMina.assertEquals(b, MinaUtil.getBytes(bb));
        TestMina.assertNotSame((Object)b, (Object)MinaUtil.getBytes(bb.put((byte)1)));
        bb = ByteBuffer.wrap(b, 1, b.length - 1);
        TestMina.assertNotSame((Object)b, (Object)MinaUtil.getBytes(bb));
    }

    public void testLineBuffer() {
        LineBuffer lb = new LineBuffer();
        TestMina.assertFalse((boolean)lb.isComplete());
        lb.parse(MinaUtil.toAsciiBytes(LINE));
        TestMina.assertFalse((boolean)lb.isComplete());
        ByteBuffer bb = MinaUtil.toAsciiBytes("\r\nThis is a line");
        lb.parse(bb);
        TestMina.assertTrue((boolean)lb.isComplete());
        TestMina.assertEquals((String)"This is a line\r\n", (String)lb.toString());
        TestMina.assertEquals((int)LINE.length(), (int)bb.remaining());
        lb = new LineBuffer();
        for (int i = 0; i < LINE.length(); ++i) {
            lb.parse(ByteBuffer.wrap(new byte[]{(byte)LINE.charAt(i)}));
            TestMina.assertFalse((boolean)lb.isComplete());
        }
        lb.parse(MinaUtil.toAsciiBytes(CRLF));
        TestMina.assertTrue((boolean)lb.isComplete());
        TestMina.assertEquals((String)"This is a line\r\n", (String)lb.toString());
    }

    public void testLineBuffer2() {
        LineBuffer lb = new LineBuffer();
        lb.parse(MinaUtil.toAsciiBytes(LINE));
        lb.parse(MinaUtil.toAsciiBytes(CR));
        lb.parse(MinaUtil.toAsciiBytes(LF));
        TestMina.assertTrue((boolean)lb.isComplete());
        TestMina.assertEquals((String)"This is a line\r\n", (String)lb.toString());
    }

    public void testLiteralInfo() throws Exception {
        LiteralInfo li = LiteralInfo.parse(". append {10+}");
        TestMina.assertNotNull((Object)li);
        TestMina.assertEquals((int)10, (int)li.getCount());
        TestMina.assertFalse((boolean)li.isBlocking());
        TestMina.assertNull((Object)LiteralInfo.parse(". login foo bar}"));
        try {
            LiteralInfo.parse(". append {-10}");
            TestMina.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMinaOutputStream() throws IOException {
        TestMinaOutputStream tos = new TestMinaOutputStream();
        ByteBuffer data = TestMina.testData(65536);
        byte[] b = new byte[65536];
        int len = 1;
        while (data.hasRemaining()) {
            data.get(b, 0, len);
            tos.write(b, 0, len);
            len = Math.min(len * 2, data.remaining());
        }
        tos.close();
        TestMina.assertEquals((int)data.position(), (int)tos.buf.position());
        for (int i = 0; i < 65536; ++i) {
            TestMina.assertEquals((String)("pos=" + i), (byte)data.get(i), (byte)tos.buf.get(i));
        }
    }

    private static ByteBuffer testData(int size) {
        ByteBuffer bb = ByteBuffer.allocate(size);
        for (int i = 0; i < size; ++i) {
            bb.put((byte)i);
        }
        bb.flip();
        return bb;
    }

    public void testTaskUtil1() throws Exception {
        long timeout = 100L;
        try {
            TaskUtil.call(new Callable<Object>(){

                @Override
                public Object call() throws InterruptedException {
                    Thread.sleep(400L);
                    return null;
                }
            }, 100L);
        }
        catch (TimeoutException e) {
            return;
        }
        throw new AssertionError((Object)"Task should have timed out");
    }

    public void testTaskUtil2() throws Exception {
        long timeout = 500L;
        try {
            TaskUtil.call(new Callable<Object>(){

                @Override
                public Object call() throws InterruptedException {
                    return null;
                }
            }, 500L);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)"Task should not have timed out");
        }
    }

    private static void assertEquals(byte[] b1, byte[] b2) {
        TestMina.assertEquals((int)b1.length, (int)b2.length);
        for (int i = 0; i < b1.length; ++i) {
            TestMina.assertEquals((String)("at index " + i), (byte)b1[i], (byte)b2[i]);
        }
    }

    private static class TestMinaOutputStream
    extends MinaOutputStream {
        ByteBuffer buf;

        TestMinaOutputStream() {
            super(23);
        }

        public void flushBytes(ByteBuffer bb) {
            this.buf = MinaUtil.expand(this.buf, bb.remaining()).put(bb);
        }

        public boolean join(long ms) {
            return true;
        }
    }
}

