/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.mime.MimeHandler;
import com.zimbra.cs.mime.MimeHandlerManager;
import com.zimbra.cs.mime.handler.TextEnrichedHandler;
import com.zimbra.cs.mime.handler.TextHtmlHandler;
import com.zimbra.cs.mime.handler.UnknownTypeHandler;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMimeHandler
extends TestCase {
    public void testMimeHandlerLookup() throws Exception {
        TestMimeHandler.checkHandler("text/html", "html", TextHtmlHandler.class);
        TestMimeHandler.checkHandler("text/html", "htm", TextHtmlHandler.class);
        TestMimeHandler.checkHandler("text/enriched", "txe", TextEnrichedHandler.class);
        TestMimeHandler.checkHandler("application/octet-stream", "exe", UnknownTypeHandler.class);
        TestMimeHandler.checkHandler(null, null, UnknownTypeHandler.class);
        TestMimeHandler.checkHandler("", "", UnknownTypeHandler.class);
    }

    public static void checkHandler(String mimeType, String extension, Class<?> handlerClass) throws Exception {
        String context = "mimeType=" + mimeType + ", ext=" + extension;
        MimeHandler handler = MimeHandlerManager.getMimeHandler(mimeType, "filename." + extension);
        TestMimeHandler.assertEquals((String)context, (String)handlerClass.getName(), (String)handler.getClass().getName());
        if (mimeType != null) {
            handler = MimeHandlerManager.getMimeHandler(mimeType, null);
            TestMimeHandler.assertEquals((String)context, (String)handlerClass.getName(), (String)handler.getClass().getName());
            handler = MimeHandlerManager.getMimeHandler(mimeType, "filename.foobar");
            TestMimeHandler.assertEquals((String)context, (String)handlerClass.getName(), (String)handler.getClass().getName());
        }
        if (extension != null) {
            handler = MimeHandlerManager.getMimeHandler(null, extension);
            TestMimeHandler.assertEquals((String)context, (String)handlerClass.getName(), (String)handler.getClass().getName());
            handler = MimeHandlerManager.getMimeHandler("bogus/type", extension);
            TestMimeHandler.assertEquals((String)context, (String)handlerClass.getName(), (String)handler.getClass().getName());
        }
    }
}

