/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.qa.unittest.TestUtil;
import junit.framework.TestCase;

public class TestMetadata
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String METADATA_SECTION = TestMetadata.class.getSimpleName();

    public void setUp() throws Exception {
        this.cleanUp();
    }

    public void testMetadata() throws Exception {
        ZimbraLog.test.info("Starting testMetadata");
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        TestMetadata.assertNull((Object)mbox.getConfig(null, METADATA_SECTION));
        Metadata config = new Metadata();
        config.put("string", "mystring");
        mbox.setConfig(null, METADATA_SECTION, config);
        config = mbox.getConfig(null, METADATA_SECTION);
        TestMetadata.assertEquals((String)"mystring", (String)config.get("string"));
        config.put("long", 87L);
        mbox.setConfig(null, METADATA_SECTION, config);
        config = mbox.getConfig(null, METADATA_SECTION);
        TestMetadata.assertEquals((long)87L, (long)config.getLong("long"));
        TestMetadata.assertEquals((String)"mystring", (String)config.get("string"));
        mbox.setConfig(null, METADATA_SECTION, null);
        TestMetadata.assertNull((Object)mbox.getConfig(null, METADATA_SECTION));
    }

    public void tearDown() throws Exception {
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        mbox.setConfig(null, METADATA_SECTION, null);
    }
}

