/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.qa.unittest.TestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;

public class TestMaxMessageSize
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String NAME_PREFIX = TestMaxMessageSize.class.getSimpleName();
    private static final int TEST_MAX_MESSAGE_SIZE = 2000;
    private String mOrigMaxMessageSize;
    private String mOrigFileUploadMaxSize;

    public void setUp() throws Exception {
        this.cleanUp();
        Provisioning prov = Provisioning.getInstance();
        this.mOrigMaxMessageSize = prov.getConfig().getAttr("zimbraMtaMaxMessageSize", null);
        this.mOrigFileUploadMaxSize = prov.getLocalServer().getAttr("zimbraFileUploadMaxSize", null);
    }

    public void testMaxMessageSizeBelowThreshold() throws Exception {
        this.setMaxMessageSize(2000);
        HashMap<String, byte[]> attachments = new HashMap<String, byte[]>();
        attachments.put("file1.exe", new byte[500]);
        attachments.put("file2.exe", new byte[600]);
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        String aid = mbox.uploadAttachments(attachments, 5000);
        TestUtil.sendMessage(mbox, USER_NAME, NAME_PREFIX, "Message size below threshold", aid);
    }

    public void testMaxMessageSizeAboveThreshold() throws Exception {
        this.setMaxMessageSize(2000);
        HashMap<String, byte[]> attachments = new HashMap<String, byte[]>();
        attachments.put("file1.exe", new byte[800]);
        attachments.put("file2.exe", new byte[700]);
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        String aid = mbox.uploadAttachments(attachments, 5000);
        try {
            TestUtil.sendMessage(mbox, USER_NAME, NAME_PREFIX, "Message size above threshold", aid);
            TestMaxMessageSize.fail((String)"sendMessage() should not have succeeded");
        }
        catch (SoapFaultException e) {
            this.validateMessageTooBigFault(e);
        }
    }

    public void testMaxMessageSizeSaveDraft() throws Exception {
        this.setMaxMessageSize(2000);
        HashMap<String, byte[]> attachments = new HashMap<String, byte[]>();
        attachments.put("file1.exe", new byte[1400]);
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        String aid = mbox.uploadAttachments(attachments, 5000);
        ZMailbox.ZOutgoingMessage outgoing = new ZMailbox.ZOutgoingMessage();
        ArrayList<ZEmailAddress> addresses = new ArrayList<ZEmailAddress>();
        addresses.add(new ZEmailAddress(TestUtil.getAddress(USER_NAME), null, null, "t"));
        outgoing.setAddresses(addresses);
        outgoing.setAttachmentUploadId(aid);
        String subject = NAME_PREFIX + " testMaxMessageSizeSaveDraft";
        outgoing.setSubject(subject);
        ZMessage draft = mbox.saveDraft(outgoing, null, null);
        outgoing.setAttachmentUploadId(null);
        ArrayList<ZMailbox.ZOutgoingMessage.AttachedMessagePart> attachedParts = new ArrayList<ZMailbox.ZOutgoingMessage.AttachedMessagePart>();
        attachedParts.add(new ZMailbox.ZOutgoingMessage.AttachedMessagePart(draft.getId(), "1", null));
        outgoing.setMessagePartsToAttach(attachedParts);
        mbox.sendMessage(outgoing, null, false);
        TestUtil.waitForMessage(mbox, "in:inbox subject:\"" + subject + "\"");
        this.setMaxMessageSize(1200);
        try {
            mbox.sendMessage(outgoing, null, false);
            TestMaxMessageSize.fail((String)"Message send should not have succeeded.");
        }
        catch (SoapFaultException e) {
            this.validateMessageTooBigFault(e);
        }
    }

    public void testUploadMaxSize() throws Exception {
        this.setMaxMessageSize(900);
        HashMap<String, byte[]> attachments = new HashMap<String, byte[]>();
        attachments.put("file1.exe", new byte[1000]);
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        try {
            mbox.uploadAttachments(attachments, 5000);
            TestMaxMessageSize.fail((String)"Attachment upload should have failed");
        }
        catch (ZClientException e) {
            TestMaxMessageSize.assertEquals((String)"zclient.UPLOAD_SIZE_LIMIT_EXCEEDED", (String)e.getCode());
        }
    }

    private void validateMessageTooBigFault(SoapFaultException e) throws Exception {
        Provisioning prov = Provisioning.getInstance();
        int maxSize = prov.getConfig().getIntAttr("zimbraMtaMaxMessageSize", -1);
        TestMaxMessageSize.assertTrue((String)("Unexpected error: " + e.getReason()), (boolean)e.getReason().matches("Message of size \\d+ exceeded allowed size"));
        TestMaxMessageSize.assertEquals((String)"mail.MESSAGE_TOO_BIG", (String)e.getCode());
        TestMaxMessageSize.assertEquals((String)Integer.toString(maxSize), (String)e.getArgumentValue("maxSize"));
    }

    public void tearDown() throws Exception {
        this.cleanUp();
        TestUtil.setServerAttr("zimbraFileUploadMaxSize", this.mOrigFileUploadMaxSize);
        TestUtil.setConfigAttr("zimbraMtaMaxMessageSize", this.mOrigMaxMessageSize);
    }

    private void setMaxMessageSize(int numBytes) throws Exception {
        Provisioning prov = Provisioning.getInstance();
        Config config = prov.getConfig();
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMaxMessageSize", Integer.toString(numBytes));
        prov.modifyAttrs(config, attrs);
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestMaxMessageSize.class);
    }
}

