/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.util.JMSession;
import com.zimbra.qa.unittest.TestUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import javax.mail.internet.MimeMessage;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestMailSender
extends TestCase {
    private static final int TEST_SMTP_PORT = 6025;
    private static final String NAME_PREFIX = TestMailSender.class.getSimpleName();
    private static final String SENDER_NAME = "user1";
    private static final String RECIPIENT_NAME = "user2";
    private String mOriginalSmtpPort = null;

    public void setUp() throws Exception {
        this.mOriginalSmtpPort = Provisioning.getInstance().getLocalServer().getSmtpPortAsString();
    }

    public void testRejectSender() throws Exception {
        Thread smtpServerThread = new Thread(new SmtpRejectSender());
        smtpServerThread.start();
        Provisioning.getInstance().getLocalServer().setSmtpPort(6025);
        String content = TestUtil.getTestMessage(NAME_PREFIX + " testRejectSender", RECIPIENT_NAME, SENDER_NAME, null);
        MimeMessage msg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(content.getBytes()));
        Mailbox mbox = TestUtil.getMailbox(SENDER_NAME);
        boolean sendFailed = false;
        try {
            mbox.getMailSender().sendMimeMessage(null, mbox, msg, null, null, null, null, null, false, false);
        }
        catch (MailServiceException e) {
            TestMailSender.assertEquals((String)e.getCode(), (String)"mail.SEND_ABORTED_ADDRESS_FAILURE");
            String errorMsg = e.getMessage();
            TestMailSender.assertTrue((String)"Unexpected error message", (boolean)errorMsg.contains("Sender address rejected"));
            sendFailed = true;
        }
        TestMailSender.assertTrue((boolean)sendFailed);
    }

    public void tearDown() throws Exception {
        Provisioning.getInstance().getLocalServer().setSmtpPortAsString(this.mOriginalSmtpPort);
    }

    public static void main(String[] args) throws Exception {
        Thread thread = new Thread(new SmtpRejectSender());
        thread.start();
    }

    private static class SmtpRejectSender
    implements Runnable {
        private PrintWriter mOut;

        private SmtpRejectSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block26: {
                ServerSocket server = null;
                Socket socket = null;
                InputStream in = null;
                server = new ServerSocket(6025);
                socket = server.accept();
                in = socket.getInputStream();
                this.mOut = new PrintWriter(socket.getOutputStream());
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = null;
                this.send("220 " + SmtpRejectSender.class.getSimpleName());
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("EHLO")) {
                        this.send("500 Use HELO instead");
                        continue;
                    }
                    if (line.startsWith("HELO")) {
                        this.send("250 OK");
                        continue;
                    }
                    if (line.startsWith("MAIL FROM")) {
                        this.send("250 OK");
                        continue;
                    }
                    if (line.startsWith("RSET")) {
                        this.send("250 OK");
                        continue;
                    }
                    if (line.startsWith("QUIT")) {
                        this.send("221 Buh-bye.");
                        break;
                    }
                    Assert.assertTrue((String)("Unexpected line: " + line), (boolean)line.startsWith("RCPT TO"));
                    this.send("550 Sender address rejected: User unknown in relay recipient table");
                }
                Object var7_7 = null;
                try {
                    if (this.mOut != null) {
                        this.mOut.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    if (server != null) {
                        server.close();
                    }
                    break block26;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                break block26;
                {
                    catch (Exception e) {
                        ZimbraLog.test.error("Error in %s.", (Object)SmtpRejectSender.class.getSimpleName(), e);
                        Object var7_8 = null;
                        try {
                            if (this.mOut != null) {
                                this.mOut.close();
                            }
                            if (in != null) {
                                in.close();
                            }
                            if (socket != null) {
                                socket.close();
                            }
                            if (server != null) {
                                server.close();
                            }
                            break block26;
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (this.mOut != null) {
                            this.mOut.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        if (socket != null) {
                            socket.close();
                        }
                        if (server != null) {
                            server.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }

        private void send(String response) {
            this.mOut.print(response + "\r\n");
            this.mOut.flush();
        }
    }
}

