/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbResults;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.formatter.HeadersOnlyInputStream;
import com.zimbra.qa.unittest.TestUtil;
import java.io.ByteArrayInputStream;
import java.util.List;
import junit.framework.TestCase;

public class TestMailItem
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final int TEST_CONTACT_ID = 9999;

    public void setUp() throws Exception {
        this.cleanUp();
    }

    public void testListItemIds() throws Exception {
        Account account = TestUtil.getAccount(USER_NAME);
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        String sql = "SELECT folder_id, type, count(*) AS item_count FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE mailbox_id = " + mbox.getId() + " GROUP BY folder_id, type";
        DbResults results = DbUtil.executeQuery(sql);
        TestMailItem.assertTrue((String)"No results returned", (results.size() > 0 ? 1 : 0) != 0);
        while (results.next()) {
            int folderId = results.getInt("folder_id");
            byte type = (byte)results.getInt("type");
            int count = results.getInt(3);
            ZimbraLog.test.debug("Confirming that folder " + folderId + " has " + count + " items of type " + type);
            Folder folder = mbox.getFolderById(null, folderId);
            TestMailItem.assertNotNull((String)"Folder not found", (Object)folder);
            List<Integer> ids = mbox.listItemIds(null, type, folderId);
            TestMailItem.assertEquals((String)"Item count does not match", (int)count, (int)ids.size());
        }
    }

    public void testHeadersOnlyInputStream() throws Exception {
        String s = "test";
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes());
        HeadersOnlyInputStream headerStream = new HeadersOnlyInputStream(in);
        String read = new String(ByteUtil.getContent(headerStream, s.length()));
        TestMailItem.assertEquals((String)s, (String)read);
        s = "\r\n\r\ntest";
        in = new ByteArrayInputStream(s.getBytes());
        headerStream = new HeadersOnlyInputStream(in);
        read = new String(ByteUtil.getContent(headerStream, s.length()));
        TestMailItem.assertEquals((int)0, (int)read.length());
        s = "te\r\n\r\nst";
        in = new ByteArrayInputStream(s.getBytes());
        headerStream = new HeadersOnlyInputStream(in);
        read = new String(ByteUtil.getContent(headerStream, s.length()));
        TestMailItem.assertEquals((String)"te", (String)read);
        s = "test\r\n\r\n";
        in = new ByteArrayInputStream(s.getBytes());
        headerStream = new HeadersOnlyInputStream(in);
        read = new String(ByteUtil.getContent(headerStream, s.length()));
        TestMailItem.assertEquals((String)"test", (String)read);
        s = "te\r\n\rst";
        in = new ByteArrayInputStream(s.getBytes());
        headerStream = new HeadersOnlyInputStream(in);
        read = new String(ByteUtil.getContent(headerStream, s.length()));
        TestMailItem.assertEquals((String)s, (String)read);
    }

    public void tearDown() throws Exception {
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        mbox.delete(null, 9999, (byte)6);
    }
}

