/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.lmtpserver.LmtpMessageInputStream;
import com.zimbra.cs.lmtpserver.utils.LmtpClient;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZGetMessageParams;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.qa.unittest.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;

public class TestLmtp
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String USER2_NAME = "user2";
    private static final String NAME_PREFIX = TestLmtp.class.getSimpleName();
    private ZMailbox mMbox;
    private Account mAccount;
    private String mOriginalWarnInterval;
    private int mOriginalWarnPercent;
    private String mOriginalServerDiskThreshold;
    private String mOriginalConfigDiskThreshold;
    private String mOriginalQuota;

    public void setUp() throws Exception {
        this.mMbox = TestUtil.getZMailbox(USER_NAME);
        this.mAccount = TestUtil.getAccount(USER_NAME);
        this.mOriginalWarnInterval = this.mAccount.getAttr("zimbraQuotaWarnInterval");
        this.mOriginalWarnPercent = this.mAccount.getIntAttr("zimbraQuotaWarnPercent", 0);
        this.mOriginalServerDiskThreshold = TestUtil.getServerAttr("zimbraMailDiskStreamingThreshold");
        this.mOriginalConfigDiskThreshold = TestUtil.getConfigAttr("zimbraMailDiskStreamingThreshold");
        this.mOriginalQuota = TestUtil.getAccountAttr(USER_NAME, "zimbraMailQuota");
        this.cleanUp();
    }

    public void testReadLmtpData() throws Exception {
        TestLmtp.assertEquals((String)"123", (String)this.read("123", 3, 3));
        TestLmtp.assertEquals((String)"123", (String)this.read("123", -1, 3));
        TestLmtp.assertEquals((String)"123", (String)this.read("123", 0, 3));
        TestLmtp.assertEquals((String)"123", (String)this.read("123", 10, 3));
        TestLmtp.assertEquals((String)"123", (String)this.read("123", 3, 10));
        TestLmtp.assertEquals((String)"12", (String)this.read("123", -1, 2));
        TestLmtp.assertEquals((String)"12", (String)this.read("123", 0, 2));
        TestLmtp.assertEquals((String)"12", (String)this.read("123", 1, 2));
        TestLmtp.assertEquals((String)"12", (String)this.read("123", 2, 2));
        TestLmtp.assertEquals((String)"12", (String)this.read("123", 10, 2));
    }

    private String read(String dataString, int sizeHint, int limit) throws Exception {
        byte[] data = dataString.getBytes();
        int numToRead = Math.min(data.length, limit);
        int numRemaining = data.length - numToRead;
        byte[] expected = new byte[numToRead];
        System.arraycopy(data, 0, expected, 0, numToRead);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        byte[] bytesRead = ByteUtil.readInput(in, sizeHint, limit);
        TestLmtp.assertEquals((int)numToRead, (int)bytesRead.length);
        TestLmtp.assertEquals((int)numRemaining, (int)((InputStream)in).available());
        TestLmtp.assertEquals((String)new String(expected), (String)new String(bytesRead));
        if (numRemaining == 0) {
            TestLmtp.assertEquals((int)-1, (int)((InputStream)in).read());
        } else {
            TestLmtp.assertTrue((((InputStream)in).read() >= 0 ? 1 : 0) != 0);
        }
        return new String(bytesRead);
    }

    public void testQuotaWarning() throws Exception {
        String address = TestUtil.getAddress(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraQuotaLastWarnTime", "");
        Provisioning.getInstance().modifyAttrs(this.mAccount, attrs);
        this.validateNumWarnings(0);
        TestUtil.addMessageLmtp(NAME_PREFIX + " 1", address, address);
        this.validateNumWarnings(0);
        this.setQuotaWarnPercent(0);
        TestUtil.addMessageLmtp(NAME_PREFIX + " 2", address, address);
        this.validateNumWarnings(0);
        this.setQuotaWarnPercent(0);
        TestUtil.addMessageLmtp(NAME_PREFIX + " 3", address, address);
        this.validateNumWarnings(0);
        this.setQuotaWarnPercent(1);
        TestUtil.addMessageLmtp(NAME_PREFIX + " 4", address, address);
        this.validateNumWarnings(1);
        TestUtil.addMessageLmtp(NAME_PREFIX + " 5", address, address);
        this.validateNumWarnings(1);
        this.setQuotaWarnInterval("1s");
        Thread.sleep(1000L);
        TestUtil.addMessageLmtp(NAME_PREFIX + " 6", address, address);
        this.validateNumWarnings(2);
        this.setQuotaWarnInterval("");
        TestUtil.addMessageLmtp(NAME_PREFIX + " 7", address, address);
        this.validateNumWarnings(2);
    }

    private void validateNumWarnings(int numWarnings) throws Exception {
        List<ZMessage> messages = TestUtil.search(this.mMbox, "Quota warning");
        TestLmtp.assertEquals((String)"Number of quota warnings", (int)numWarnings, (int)messages.size());
    }

    private void setQuotaWarnPercent(int percent) throws Exception {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraQuotaWarnPercent", Integer.toString(percent));
        Provisioning.getInstance().modifyAttrs(this.mAccount, attrs);
    }

    private void setQuotaWarnInterval(String interval) throws Exception {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraQuotaWarnInterval", interval);
        Provisioning.getInstance().modifyAttrs(this.mAccount, attrs);
    }

    public void testLmtpMessageInputStream() throws Exception {
        String prefix = "12345678\r\n";
        this.runLmtpMessageTest("abcd\r\n", null, null);
        this.runLmtpMessageTest("abcd\r\n.\r", null, null);
        this.runLmtpMessageTest("\n\r.\r\n", null, null);
        this.runLmtpMessageTest("\n\r\r\r\r\n\r.\r\n", null, null);
        this.runLmtpMessageTest("\r\n.\n\r\n", null, null);
        this.runLmtpMessageTest("..\r\n", null, null);
        this.runLmtpMessageTest(".", null, null);
        this.runLmtpMessageTest(".\r", null, null);
        this.runLmtpMessageTest("ab\r\ncd\r\n.\r\n", "ab\r\ncd\r\n", null);
        this.runLmtpMessageTest("ab\r\ncd\r\n.\r\n", "ab\r\ncd\r\n", prefix);
        this.runLmtpMessageTest("ab\r\ncd\r\n\r\n.\r\n", "ab\r\ncd\r\n\r\n", null);
        this.runLmtpMessageTest("ab\r\ncd\r\n\r\n.\r\n", "ab\r\ncd\r\n\r\n", prefix);
        this.runLmtpMessageTest("ab\r\n..\n\r\n\r\n.\r\n", "ab\r\n.\n\r\n\r\n", null);
        this.runLmtpMessageTest("ab\r\n..\n\r\n\r\n.\r\n", "ab\r\n.\n\r\n\r\n", prefix);
        this.runLmtpMessageTest("ab\r\n.\rcd\r\n.\r\n", "ab\r\n\rcd\r\n", null);
        this.runLmtpMessageTest("ab\r\n.\rcd\r\n.\r\n", "ab\r\n\rcd\r\n", prefix);
        this.runLmtpMessageTest(".\r\n", "", null);
        this.runLmtpMessageTest(".\r\n", "", prefix);
        this.runLmtpMessageTest("..\r\n.\r\n", ".\r\n", null);
        this.runLmtpMessageTest("..\r\n.\r\n", ".\r\n", prefix);
        this.runLmtpMessageTest("..\rabcd\r\n.\r\n", ".\rabcd\r\n", null);
        this.runLmtpMessageTest("..\rabcd\r\n.\r\n", ".\rabcd\r\n", prefix);
        this.runLmtpMessageTest("..a\r\n.\r\n", ".a\r\n", null);
        this.runLmtpMessageTest("..a\r\n.\r\n", ".a\r\n", prefix);
        this.runLmtpMessageTest("a\r\n..a\r\n.\r\n", "a\r\n.a\r\n", null);
        this.runLmtpMessageTest("a\r\n..a\r\n.\r\n", "a\r\n.a\r\n", prefix);
    }

    private void runLmtpMessageTest(String input, String expectedOutput, String prefix) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes());
        LmtpMessageInputStream lin = new LmtpMessageInputStream(in, prefix);
        StringBuilder readContent = new StringBuilder();
        try {
            int c;
            while ((c = lin.read()) >= 0) {
                readContent.append((char)c);
            }
        }
        catch (IOException ioe) {
            if (expectedOutput == null) {
                return;
            }
            throw ioe;
        }
        if (prefix == null) {
            prefix = "";
        }
        TestLmtp.assertEquals((String)(prefix + expectedOutput), (String)readContent.toString());
        TestLmtp.assertEquals((int)(expectedOutput.length() + prefix.length()), (int)lin.getMessageSize());
    }

    public void testDiskStreamingOneRecipient() throws Exception {
        TestUtil.setServerAttr("zimbraMailDiskStreamingThreshold", "0");
        String recipient = TestUtil.getAddress(USER_NAME);
        TestUtil.addMessageLmtp(NAME_PREFIX + " testDiskStreamingOneRecipient", recipient, TestUtil.getAddress(USER_NAME));
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        TestUtil.waitForMessage(mbox, NAME_PREFIX);
    }

    public void testDiskStreamingMultipleRecipients() throws Exception {
        TestUtil.setServerAttr("zimbraMailDiskStreamingThreshold", "0");
        String[] recipients = new String[]{TestUtil.getAddress(USER_NAME), TestUtil.getAddress(USER2_NAME)};
        String subject = NAME_PREFIX + " testDiskStreamingMultipleRecipients";
        ZMailbox mbox1 = TestUtil.getZMailbox(USER_NAME);
        ZMailbox mbox2 = TestUtil.getZMailbox(USER2_NAME);
        TestUtil.addMessageLmtp(subject, recipients, TestUtil.getAddress(USER_NAME));
        TestUtil.waitForMessage(mbox1, "in:inbox subject:\"" + subject + "\"");
        ZMessage msg2 = TestUtil.waitForMessage(mbox2, "in:inbox subject:\"" + subject + "\"");
        mbox2.deleteMessage(msg2.getId());
        mbox1 = TestUtil.getZMailbox(USER_NAME);
        TestUtil.waitForMessage(mbox1, "in:inbox subject:\"" + subject + "\"");
    }

    public void testDiskStreamingEmptyFolder() throws Exception {
        TestUtil.setServerAttr("zimbraMailDiskStreamingThreshold", "0");
        String[] recipients = new String[]{TestUtil.getAddress(USER_NAME), TestUtil.getAddress(USER2_NAME)};
        String subject = NAME_PREFIX + " testDiskStreamingMultipleRecipients";
        ZMailbox mbox1 = TestUtil.getZMailbox(USER_NAME);
        ZMailbox mbox2 = TestUtil.getZMailbox(USER2_NAME);
        TestUtil.addMessageLmtp(subject, recipients, TestUtil.getAddress(USER_NAME));
        TestUtil.waitForMessage(mbox1, "in:inbox subject:\"" + subject + "\"");
        ZMessage msg2 = TestUtil.waitForMessage(mbox2, "in:inbox subject:\"" + subject + "\"");
        ZFolder folder2 = TestUtil.createFolder(mbox2, "/" + NAME_PREFIX + " testDiskStreamingEmptyFolder");
        mbox2.moveMessage(msg2.getId(), folder2.getId());
        mbox2.markItemRead(msg2.getId(), true, null);
        mbox2.emptyFolder(folder2.getId());
        mbox1 = TestUtil.getZMailbox(USER_NAME);
        TestUtil.waitForMessage(mbox1, "in:inbox subject:\"" + subject + "\"");
    }

    public void testSizeHint() throws Exception {
        String address = TestUtil.getAddress(USER_NAME);
        String subject = NAME_PREFIX + " testIncorrectSizeHint";
        String messageString = TestUtil.getTestMessage(subject, address, address, null);
        String[] recipients = new String[]{address};
        LmtpClient lmtp = new LmtpClient("localhost", 7025);
        byte[] data = messageString.getBytes();
        lmtp.sendMessage((InputStream)new ByteArrayInputStream(data), recipients, address, "TestLmtp", null);
        lmtp.sendMessage((InputStream)new ByteArrayInputStream(data), recipients, address, "TestLmtp", (Long)0L);
        lmtp.sendMessage((InputStream)new ByteArrayInputStream(data), recipients, address, "TestLmtp", (Long)10L);
        lmtp.sendMessage((InputStream)new ByteArrayInputStream(data), recipients, address, "TestLmtp", Long.valueOf(data.length));
        lmtp.sendMessage((InputStream)new ByteArrayInputStream(data), recipients, address, "TestLmtp", (Long)Integer.MAX_VALUE);
        lmtp.close();
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        List<ZMessage> messages = null;
        for (int i = 1; i < 20 && (messages = TestUtil.search(mbox, subject)).size() != 5; ++i) {
            Thread.sleep(500L);
        }
        TestLmtp.assertEquals((int)5, (int)messages.size());
        ZGetMessageParams params = new ZGetMessageParams();
        params.setRawContent(true);
        for (ZMessage msg : messages) {
            params.setId(msg.getId());
            msg = mbox.getMessage(params);
            TestUtil.assertMessageContains(msg.getContent(), messageString);
        }
    }

    public void testAttachedMessage() throws Exception {
        String outerSubject = NAME_PREFIX + " testAttachedMessage outer";
        String innerSubject = NAME_PREFIX + " testAttachedMessage inner";
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        ZMailbox.ZOutgoingMessage msg = new ZMailbox.ZOutgoingMessage();
        ArrayList<ZEmailAddress> addresses = new ArrayList<ZEmailAddress>();
        addresses.add(new ZEmailAddress(TestUtil.getAddress(USER_NAME), null, null, "t"));
        msg.setAddresses(addresses);
        msg.setSubject(outerSubject);
        String attachedMessageString = TestUtil.getTestMessage(innerSubject, USER_NAME, USER_NAME, null);
        ZMailbox.ZOutgoingMessage.MessagePart attachedMessage = new ZMailbox.ZOutgoingMessage.MessagePart("message/rfc822", attachedMessageString);
        ZMailbox.ZOutgoingMessage.MessagePart body = new ZMailbox.ZOutgoingMessage.MessagePart("text/plain", "This is the outer message");
        msg.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart("multipart/mixed", body, attachedMessage));
        mbox.sendMessage(msg, null, false);
        TestUtil.waitForMessage(mbox, "in:inbox " + outerSubject);
        List<ZMessage> msgs = TestUtil.search(mbox, "in:inbox " + innerSubject);
        TestLmtp.assertEquals((int)1, (int)msgs.size());
        msgs = TestUtil.search(mbox, "in:sent " + innerSubject);
        TestLmtp.assertEquals((int)1, (int)msgs.size());
        msgs = TestUtil.search(mbox, "in:inbox " + NAME_PREFIX + " waves");
        TestLmtp.assertEquals((int)1, (int)msgs.size());
        msgs = TestUtil.search(mbox, "in:sent " + NAME_PREFIX + " waves");
        TestLmtp.assertEquals((int)1, (int)msgs.size());
    }

    public void testMissingDiskThreshold() throws Exception {
        TestUtil.setServerAttr("zimbraMailDiskStreamingThreshold", "");
        TestUtil.setConfigAttr("zimbraMailDiskStreamingThreshold", "");
        String subject = NAME_PREFIX + " testMissingDiskThreshold";
        TestUtil.addMessageLmtp(subject, USER_NAME, USER_NAME);
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        TestUtil.waitForMessage(mbox, "in:inbox subject:\"" + subject + "\"");
    }

    public void testConcurrentDedupe() throws Exception {
        int i;
        String subject = NAME_PREFIX + " testConcurrentDedupe";
        String content = TestUtil.getTestMessage(subject, USER_NAME, USER_NAME, null);
        content = "Message-ID: " + System.currentTimeMillis() + "\r\n" + content;
        Thread[] threads = new Thread[5];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new LmtpClientThread(USER_NAME, content));
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        List<ZMessage> messages = TestUtil.search(mbox, "in:inbox subject:\"" + subject + "\"");
        TestLmtp.assertEquals((int)1, (int)messages.size());
    }

    public void testDeliveryAfterFailure() throws Exception {
        String subject = NAME_PREFIX + " testDeliveryAfterFailure";
        String content = TestUtil.getTestMessage(subject, USER_NAME, USER_NAME, null);
        content = "Message-ID: " + System.currentTimeMillis() + "\r\n" + content;
        String[] recipients = new String[]{USER_NAME};
        TestUtil.setAccountAttr(USER_NAME, "zimbraMailQuota", "1");
        TestLmtp.assertFalse((String)"LMTP should not have succeeded", (boolean)TestUtil.addMessageLmtp(recipients, USER_NAME, content));
        TestUtil.setAccountAttr(USER_NAME, "zimbraMailQuota", this.mOriginalQuota);
        TestUtil.addMessageLmtp(recipients, USER_NAME, content);
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        TestUtil.getMessage(mbox, "in:inbox subject:\"" + subject + "\"");
    }

    public void tearDown() throws Exception {
        this.setQuotaWarnPercent(this.mOriginalWarnPercent);
        this.setQuotaWarnInterval(this.mOriginalWarnInterval);
        TestUtil.setServerAttr("zimbraMailDiskStreamingThreshold", this.mOriginalServerDiskThreshold);
        TestUtil.setConfigAttr("zimbraMailDiskStreamingThreshold", this.mOriginalConfigDiskThreshold);
        TestUtil.setAccountAttr(USER_NAME, "zimbraMailQuota", this.mOriginalQuota);
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
        TestUtil.deleteTestData(USER_NAME, "Quota warning");
        TestUtil.deleteTestData(USER2_NAME, NAME_PREFIX);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestLmtp.class);
    }

    private class LmtpClientThread
    implements Runnable {
        private String mRecipient;
        private String mContent;

        private LmtpClientThread(String recipient, String content) {
            this.mRecipient = recipient;
            this.mContent = content;
        }

        public void run() {
            try {
                TestUtil.addMessageLmtp(new String[]{this.mRecipient}, this.mRecipient, this.mContent);
            }
            catch (Exception e) {
                ZimbraLog.test.error("Unable to send message to %s.", (Object)this.mRecipient, e);
            }
        }
    }
}

