/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.qa.unittest.TestUtil;
import java.util.List;
import junit.framework.TestCase;

public class TestItemCache
extends TestCase {
    private Mailbox mMbox;
    private Account mAccount;

    protected void setUp() throws Exception {
        ZimbraLog.test.debug("TestTags.setUp()");
        super.setUp();
        this.mAccount = TestUtil.getAccount("user1");
        this.mMbox = MailboxManager.getInstance().getMailboxByAccount(this.mAccount);
    }

    public void testCacheHit() throws Exception {
        ZimbraLog.test.debug("testCacheHit");
        List messages = this.mMbox.getItemList(null, (byte)5);
        TestItemCache.assertTrue((String)"No messages found", (messages.size() > 0 ? 1 : 0) != 0);
        Message msg = (Message)messages.get(0);
        this.mMbox.getItemById(null, msg.getId(), msg.getType());
        int prepareCount = ZimbraPerf.getPrepareCount();
        for (int i = 1; i <= 10; ++i) {
            this.mMbox.getItemById(null, msg.getId(), msg.getType());
        }
        prepareCount = ZimbraPerf.getPrepareCount() - prepareCount;
        TestItemCache.assertEquals((String)"Detected unexpected SQL statements.", (int)0, (int)prepareCount);
    }
}

