/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.qa.unittest.TestUtil;
import java.util.List;
import junit.framework.TestCase;

public class TestIndex
extends TestCase {
    private static final String NAME_PREFIX = TestIndex.class.getSimpleName();
    private static final String USER_NAME = "user1";
    private int mOriginalTextLimit;

    public void setUp() throws Exception {
        this.mOriginalTextLimit = Integer.parseInt(TestUtil.getServerAttr("zimbraAttachmentsIndexedTextLimit"));
        this.cleanUp();
    }

    public void testIndexedTextLimit() throws Exception {
        StringBuilder body = new StringBuilder();
        for (int i = 1; i < 100; ++i) {
            body.append("Walrus walrus walrus walrus walrus walrus walrus.\n");
        }
        body.append("Goo goo goo joob.\n");
        this.setTextLimit(50);
        String subject = NAME_PREFIX + " text attachment 1";
        String msgId = this.sendMessage(subject, body.toString().getBytes(), "attachment.txt", "text/plain").getId();
        this.checkQuery("in:inbox subject:\"" + subject + "\" walrus", msgId);
        this.checkQuery("in:inbox subject:\"" + subject + "\" joob", null);
        subject = NAME_PREFIX + " HTML attachment 1";
        String htmlBody = "<html>\n" + body + "</html>";
        msgId = this.sendMessage(subject, htmlBody.getBytes(), "attachment.html", "text/html").getId();
        this.checkQuery("in:inbox subject:\"" + subject + "\" walrus", msgId);
        this.checkQuery("in:inbox subject:\"" + subject + "\" joob", null);
        this.setTextLimit(100000);
        subject = NAME_PREFIX + " text attachment 2";
        msgId = this.sendMessage(subject, body.toString().getBytes(), "attachment.txt", "text/plain").getId();
        this.checkQuery("in:inbox subject:\"" + subject + "\" walrus", msgId);
        this.checkQuery("in:inbox subject:\"" + subject + "\" joob", msgId);
        subject = NAME_PREFIX + " HTML attachment 2";
        msgId = this.sendMessage(subject, htmlBody.getBytes(), "attachment.html", "text/html").getId();
        this.checkQuery("in:inbox subject:\"" + subject + "\" walrus", msgId);
        this.checkQuery("in:inbox subject:\"" + subject + "\" joob", msgId);
        subject = NAME_PREFIX + " subject";
        String attachedMsg = TestUtil.getTestMessage("Pigs from a gun", "recipient", "sender", null);
        this.setTextLimit(4);
        msgId = this.sendMessage(subject, attachedMsg.getBytes(), "attachment.msg", "message/rfc822").getId();
        this.checkQuery("in:inbox subject:\"" + subject + "\" pigs", msgId);
        this.checkQuery("in:inbox subject:\"" + subject + "\" gun", null);
    }

    private ZMessage sendMessage(String subject, byte[] attData, String attName, String attContentType) throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        String attachmentId = mbox.uploadAttachment(attName, attData, attContentType, 5000);
        TestUtil.sendMessage(mbox, USER_NAME, subject, "Cranberry sauce", attachmentId);
        String query = "in:inbox subject:\"" + subject + "\"";
        return TestUtil.waitForMessage(mbox, query);
    }

    private void checkQuery(String query, String msgId) throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        List<ZMessage> messages = TestUtil.search(mbox, query);
        if (msgId == null) {
            TestIndex.assertEquals((int)0, (int)messages.size());
        } else {
            TestIndex.assertEquals((int)1, (int)messages.size());
            TestIndex.assertEquals((String)msgId, (String)messages.get(0).getId());
        }
    }

    private void setTextLimit(int numBytes) throws Exception {
        TestUtil.setServerAttr("zimbraAttachmentsIndexedTextLimit", Integer.toString(numBytes));
    }

    public void tearDown() throws Exception {
        this.setTextLimit(this.mOriginalTextLimit);
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestIndex.class);
    }
}

