/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.datasource.ImapUtil;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import com.zimbra.cs.mailclient.imap.ListData;
import com.zimbra.cs.mailclient.util.Ascii;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestImapUtil
extends TestCase {
    private static final String[] FOLDERS = new String[]{"BOOBOO/BEAR", "INBOX", "Inbox", "Inbox/Foo", "Foobar", "INBOX/bar", "Foobar/Blah Blah/XXX", "foobar", "Foobar/Blah Blah"};
    private static final String[] FOLDERS_2 = new String[]{"Bulk Mail", "INBOX/Page-PSI-Wallet", "INBOX/ReviewBoard", "Trash", "INBOX/Page-PSI-Bill", "INBOX/QA", "INBOX/PSI-Wallet-OnCall", "INBOX/Devel-CPP", "INBOX/Manoj", "Drafts", "INBOX/PSI-Wallet", "INBOX/IT Support", "Sent", "INBOX/FitnessCenter", "INBOX/Hack", "INBOX/Bugzilla", "Junk E-mail", "Deleted Items", "Contacts", "Calendar", "INBOX/Devel-Random", "INBOX/PSI-Payments", "INBOX/D_PSI-Devel", "Sent Items", "INBOX/Page-PSI-Payments", "INBOX/BTN", "INBOX/PSI-Billing", "INBOX", "Outbox", "Journal", "Notes", "Tasks", "Sync Issues", "Sync Issues/Conflicts", "Sync Issues/Local Failures", "Sync Issues/Server Failures"};
    private static final String[] SORTED_FOLDERS = new String[]{"INBOX", "Inbox/Foo", "INBOX/bar", "Foobar/Blah Blah/XXX", "Foobar/Blah Blah", "Foobar", "BOOBOO/BEAR"};

    public void testSortFolders() throws Exception {
        List<String> folders = this.getNames(ImapUtil.sortFolders(this.parseFolders(FOLDERS)));
        TestImapUtil.assertEquals(Arrays.asList(SORTED_FOLDERS), folders);
    }

    public void testSortFolders2() throws Exception {
        List<String> folders = this.getNames(ImapUtil.sortFolders(this.parseFolders(FOLDERS_2)));
        TestImapUtil.assertEquals((String)"INBOX", (String)folders.get(0));
    }

    private void compareLists(List<?> expected, List<?> actual) {
        TestImapUtil.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestImapUtil.assertEquals(expected.get(i), actual.get(i));
        }
    }

    private List<ListData> parseFolders(String[] folders) throws IOException {
        ArrayList<ListData> lds = new ArrayList<ListData>();
        ImapInputStream is = TestImapUtil.getImapInputStream(folders);
        while (!is.isEOF()) {
            is.skipChar('*');
            is.skipChar(' ');
            is.readAtom();
            is.skipChar(' ');
            lds.add(ListData.read(is));
            is.skipCRLF();
        }
        return lds;
    }

    private List<String> getNames(List<ListData> lds) {
        ArrayList<String> names = new ArrayList<String>(lds.size());
        for (ListData ld : lds) {
            names.add(ld.getMailbox());
        }
        return names;
    }

    private static ImapInputStream getImapInputStream(String[] folders) {
        StringBuilder sb = new StringBuilder();
        for (String folder : folders) {
            sb.append("* LIST () \"/\" \"").append(folder).append("\"\r\n");
        }
        ImapConfig config = new ImapConfig();
        return new ImapInputStream((InputStream)new ByteArrayInputStream(Ascii.getBytes(sb.toString())), config);
    }
}

