/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.mailclient.MailConfig;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.ListData;
import com.zimbra.cs.mailclient.imap.Mailbox;
import com.zimbra.cs.zclient.ZDataSource;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZImapDataSource;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.qa.unittest.TestUtil;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestImapSync {
    private static final String LOCAL_USER = "TestImapSync";
    private static final String TEST_FOLDER_1 = "TestOne";
    private static final String TEST_FOLDER_2 = "TestTwo";
    private static final Log LOG = ZimbraLog.test;
    private final ImapConfig config;
    private final String pass;
    private final ImapFolder imapFolder1 = new ImapFolder("TestOne");
    private final ImapFolder imapFolder2 = new ImapFolder("TestTwo");
    private ZMailbox localMailbox;
    private ImapConnection imapConnection;
    private ZDataSource dataSource;

    public TestImapSync(ImapConfig config, String pass) {
        this.config = config;
        this.pass = pass;
        config.setTrace(true);
        config.setDebug(true);
    }

    public TestImapSync() {
        this.config = new ImapConfig();
        this.config.setHost("localhost");
        this.config.setPort(7143);
        this.config.setAuthenticationId("user1");
        this.pass = "test123";
    }

    @Test
    public void testSync() throws Exception {
        LOG.info("Testing adding message to local mailbox");
        ZFolder folder = TestUtil.createFolder(this.localMailbox, TEST_FOLDER_1);
        TestUtil.addMessage(this.localMailbox, "msg1", folder.getId(), "u");
        Assert.assertFalse((boolean)this.imapFolder1.exists());
        this.syncFolders();
        Assert.assertTrue((boolean)this.imapFolder1.exists());
        Mailbox mb = this.imapFolder1.select();
        Assert.assertEquals((long)1L, (long)mb.getExists());
        Assert.assertEquals((long)1L, (long)mb.getUnseen());
    }

    @Before
    public void setUp() throws Exception {
        if (TestUtil.accountExists(LOCAL_USER)) {
            TestUtil.deleteAccount(LOCAL_USER);
        }
        TestUtil.createAccount(LOCAL_USER);
        this.localMailbox = TestUtil.getZMailbox(LOCAL_USER);
        this.dataSource = this.createDataSource();
        this.connect();
        this.deleteImapFolders();
    }

    @After
    public void tearDown() throws Exception {
        if (TestUtil.accountExists(LOCAL_USER)) {
            TestUtil.deleteAccount(LOCAL_USER);
        }
        if (this.imapConnection != null) {
            this.deleteImapFolders();
            this.imapConnection.logout();
            this.imapConnection = null;
        }
        this.localMailbox = null;
        this.dataSource = null;
    }

    private void syncFolders() throws Exception {
        TestUtil.importDataSource(this.dataSource, this.localMailbox, null);
    }

    private ZDataSource createDataSource() throws Exception {
        DataSource.ConnectionType ctype = this.config.getSecurity() == MailConfig.Security.SSL ? DataSource.ConnectionType.ssl : DataSource.ConnectionType.cleartext;
        String id = this.localMailbox.createDataSource(new ZImapDataSource(LOCAL_USER, true, this.config.getHost(), this.config.getPort(), this.config.getAuthenticationId(), this.pass, "1", ctype));
        for (ZDataSource ds : this.localMailbox.getAllDataSources()) {
            if (!ds.getId().equals(id)) continue;
            return ds;
        }
        Assert.fail((String)"Could not find data source");
        return null;
    }

    private void connect() throws IOException {
        this.imapConnection = new ImapConnection(this.config);
        this.imapConnection.connect();
        this.imapConnection.login(this.pass);
    }

    private void deleteImapFolders() throws IOException {
        if (this.imapConnection.isAuthenticated()) {
            if (this.imapFolder1.exists()) {
                this.imapFolder1.delete();
            }
            if (this.imapFolder1.exists()) {
                this.imapFolder1.delete();
            }
        }
    }

    private class ImapFolder {
        private String name;

        ImapFolder(String name) {
            this.name = name;
        }

        String name() {
            return this.name;
        }

        boolean exists() throws IOException {
            return this.getListData() != null;
        }

        ListData getListData() throws IOException {
            List<ListData> lds = TestImapSync.this.imapConnection.list("", this.name);
            return lds.isEmpty() ? null : lds.get(0);
        }

        Mailbox select() throws IOException {
            return TestImapSync.this.imapConnection.select(this.name());
        }

        void create() throws IOException {
            TestImapSync.this.imapConnection.create(this.name());
        }

        void delete() throws IOException {
            TestImapSync.this.imapConnection.delete(this.name());
        }

        void renameTo(String newName) throws IOException {
            TestImapSync.this.imapConnection.rename(this.name(), newName);
        }
    }
}

