/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.zclient.ZDataSource;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZImapDataSource;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.qa.unittest.TestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestImapImport
extends TestCase {
    private static final String REMOTE_USER_NAME = "testimapimportremote";
    private static final String LOCAL_USER_NAME = "testimapimportlocal";
    private static final String NAME_PREFIX = "TestImapImport";
    private static final String DS_FOLDER_ROOT = "/TestImapImport";
    private static final String REMOTE_PATH_F1 = "/TestImapImport-f1";
    private static final String REMOTE_PATH_F2 = "/TestImapImport-f1/TestImapImport-f2";
    private static final String REMOTE_PATH_F3 = "/TestImapImport-f3";
    private static final String REMOTE_PATH_F4 = "/TestImapImport-f3/TestImapImport-f4";
    private static final String LOCAL_PATH_F1 = "/TestImapImport/TestImapImport-f1";
    private static final String LOCAL_PATH_F2 = "/TestImapImport/TestImapImport-f1/TestImapImport-f2";
    private static final String LOCAL_PATH_F3 = "/TestImapImport/TestImapImport-f3";
    private static final String LOCAL_PATH_F4 = "/TestImapImport/TestImapImport-f3/TestImapImport-f4";
    private static final String LOCAL_PATH_INBOX = "/TestImapImport/INBOX";
    private static final String LOCAL_PATH_TRASH = "/TestImapImport/Trash";
    private ZMailbox mRemoteMbox;
    private ZMailbox mLocalMbox;
    private String mOriginalCleartextValue;
    private ZDataSource mDataSource;
    private boolean mOriginalEnableStarttls;

    public void setUp() throws Exception {
        this.cleanUp();
        if (!TestUtil.accountExists(LOCAL_USER_NAME)) {
            TestUtil.createAccount(LOCAL_USER_NAME);
        }
        if (!TestUtil.accountExists(REMOTE_USER_NAME)) {
            TestUtil.createAccount(REMOTE_USER_NAME);
        }
        this.mRemoteMbox = TestUtil.getZMailbox(REMOTE_USER_NAME);
        this.mLocalMbox = TestUtil.getZMailbox(LOCAL_USER_NAME);
        ZFolder folder = this.mLocalMbox.getFolderByPath(DS_FOLDER_ROOT);
        if (folder == null) {
            folder = TestUtil.createFolder(this.mLocalMbox, NAME_PREFIX);
        }
        int port = Integer.parseInt(TestUtil.getServerAttr("zimbraImapBindPort"));
        this.mDataSource = new ZImapDataSource(NAME_PREFIX, true, "localhost", port, REMOTE_USER_NAME, "test123", folder.getId(), DataSource.ConnectionType.cleartext);
        String id = this.mLocalMbox.createDataSource(this.mDataSource);
        this.mDataSource = null;
        for (ZDataSource ds : this.mLocalMbox.getAllDataSources()) {
            if (!ds.getId().equals(id)) continue;
            this.mDataSource = ds;
        }
        TestImapImport.assertNotNull((Object)this.mDataSource);
        this.mOriginalCleartextValue = TestUtil.getServerAttr("zimbraImapCleartextLoginEnabled");
        TestUtil.setServerAttr("zimbraImapCleartextLoginEnabled", "TRUE");
        this.mOriginalEnableStarttls = LC.javamail_imap_enable_starttls.booleanValue();
        LC.javamail_imap_enable_starttls.setDefault(Boolean.toString(false));
    }

    public void testImapImport() throws Exception {
        ZimbraLog.test.info("Testing adding message to remote inbox.");
        String remoteQuery = "in:inbox msg1";
        TestUtil.addMessage(this.mRemoteMbox, "TestImapImport msg1", Integer.toString(2), "u");
        this.checkMsgCount(this.mRemoteMbox, remoteQuery, 1);
        TestImapImport.assertNull((Object)this.mLocalMbox.getFolderByPath(LOCAL_PATH_INBOX));
        List<ZMessage> msgs = TestUtil.search(this.mRemoteMbox, remoteQuery);
        TestImapImport.assertEquals((String)"Message count in remote inbox", (int)1, (int)msgs.size());
        ZMessage msg = msgs.get(0);
        TestImapImport.assertTrue((String)"Remote message is read", (boolean)msg.isUnread());
        this.importImap();
        String localInboxQuery = "in:/TestImapImport/INBOX";
        this.checkMsgCount(this.mLocalMbox, localInboxQuery, 1);
        msgs = TestUtil.search(this.mRemoteMbox, remoteQuery);
        msg = msgs.get(0);
        TestImapImport.assertTrue((String)"Remote message is read", (boolean)msg.isUnread());
        this.compare();
        ZimbraLog.test.info("Testing flag.");
        msgs = TestUtil.search(this.mRemoteMbox, remoteQuery);
        TestImapImport.assertEquals((String)"Message count in remote inbox", (int)1, (int)msgs.size());
        msg = msgs.get(0);
        TestImapImport.assertTrue((String)"Remote message is read", (boolean)msg.isUnread());
        String remoteId = msg.getId();
        this.mRemoteMbox.flagMessage(remoteId, true);
        msgs = TestUtil.search(this.mLocalMbox, localInboxQuery);
        TestImapImport.assertEquals((String)"Message count in local inbox", (int)1, (int)msgs.size());
        msg = msgs.get(0);
        TestImapImport.assertFalse((String)"Local message is flagged", (boolean)msg.isFlagged());
        TestImapImport.assertTrue((String)"Local message is read", (boolean)msg.isUnread());
        this.importImap();
        msgs = TestUtil.search(this.mLocalMbox, localInboxQuery);
        TestImapImport.assertEquals((String)"Message count in local inbox", (int)1, (int)msgs.size());
        msg = msgs.get(0);
        TestImapImport.assertTrue((String)"Local message is flagged", (boolean)msg.isFlagged());
        TestImapImport.assertTrue((String)"Local message is read", (boolean)msg.isUnread());
        this.compare();
        ZimbraLog.test.info("Testing remote move to trash.");
        this.mRemoteMbox.trashMessage(remoteId);
        this.checkMsgCount(this.mRemoteMbox, "in:trash", 1);
        this.checkMsgCount(this.mLocalMbox, "in:trash", 0);
        this.importImap();
        this.checkMsgCount(this.mLocalMbox, "in:/TestImapImport/Trash", 1);
        this.compare();
        ZimbraLog.test.info("Testing folder creation.");
        TestUtil.createFolder(this.mRemoteMbox, REMOTE_PATH_F1);
        TestUtil.createFolder(this.mRemoteMbox, REMOTE_PATH_F2);
        TestUtil.createFolder(this.mLocalMbox, LOCAL_PATH_F3);
        TestUtil.createFolder(this.mLocalMbox, LOCAL_PATH_F4);
        this.importImap();
        TestImapImport.assertNotNull((String)"Local folder /TestImapImport/TestImapImport-f1", (Object)this.mLocalMbox.getFolderByPath(LOCAL_PATH_F1));
        TestImapImport.assertNotNull((String)"Local folder /TestImapImport/TestImapImport-f1/TestImapImport-f2", (Object)this.mLocalMbox.getFolderByPath(LOCAL_PATH_F2));
        TestImapImport.assertNotNull((String)"Remote folder /TestImapImport-f3", (Object)this.mRemoteMbox.getFolderByPath(REMOTE_PATH_F3));
        TestImapImport.assertNotNull((String)"Remote folder /TestImapImport-f3/TestImapImport-f4", (Object)this.mRemoteMbox.getFolderByPath(REMOTE_PATH_F4));
        this.compare();
        ZimbraLog.test.info("Testing UIDVALIDITY change.");
        ZFolder localFolder1 = this.mLocalMbox.getFolderByPath(LOCAL_PATH_F1);
        ZFolder remoteFolder1 = this.mRemoteMbox.getFolderByPath(REMOTE_PATH_F1);
        String subject = "TestImapImport msg2";
        String originalId = TestUtil.addMessage(this.mLocalMbox, subject, localFolder1.getId());
        msgs = TestUtil.search(this.mLocalMbox, subject);
        TestImapImport.assertEquals((int)1, (int)msgs.size());
        TestImapImport.assertEquals((String)originalId, (String)msgs.get(0).getId());
        this.mRemoteMbox.renameFolder(remoteFolder1.getId(), "TestImapImport-renamed");
        this.mRemoteMbox.renameFolder(remoteFolder1.getId(), "TestImapImport-f1");
        this.importImap();
        msgs = TestUtil.search(this.mLocalMbox, subject);
        TestImapImport.assertEquals((int)1, (int)msgs.size());
        TestImapImport.assertFalse((String)("Message id did not change: " + originalId), (boolean)originalId.equals(msgs.get(0).getId()));
        ZimbraLog.test.info("Testing simultaneous message add and folder delete 1.");
        ZFolder remoteFolder2 = this.mRemoteMbox.getFolderByPath(REMOTE_PATH_F2);
        TestUtil.addMessage(this.mRemoteMbox, "TestImapImport msg3", remoteFolder2.getId());
        ZFolder localFolder3 = this.mLocalMbox.getFolderByPath(LOCAL_PATH_F3);
        this.mLocalMbox.deleteFolder(localFolder3.getId());
        this.checkMsgCount(this.mLocalMbox, "in:/TestImapImport/TestImapImport-f1/TestImapImport-f2", 0);
        this.importImap();
        TestImapImport.assertNull((String)"Remote folder 3", (Object)this.mRemoteMbox.getFolderByPath(REMOTE_PATH_F3));
        TestImapImport.assertNull((String)"Remote folder 4", (Object)this.mRemoteMbox.getFolderByPath(REMOTE_PATH_F4));
        this.checkMsgCount(this.mLocalMbox, "in:/TestImapImport/TestImapImport-f1/TestImapImport-f2", 1);
        this.compare();
        ZimbraLog.test.info("Testing simultaneous message add and folder delete 2.");
        ZFolder localFolder = this.mLocalMbox.getFolderByPath(LOCAL_PATH_F2);
        TestUtil.addMessage(this.mLocalMbox, "TestImapImport msg4", localFolder.getId());
        remoteFolder1 = this.mRemoteMbox.getFolderByPath(REMOTE_PATH_F1);
        this.mRemoteMbox.deleteFolder(remoteFolder1.getId());
        this.importImap();
        TestImapImport.assertNull((String)"Local folder 1", (Object)this.mLocalMbox.getFolderByPath(LOCAL_PATH_F1));
        TestImapImport.assertNull((String)"Local folder 2", (Object)this.mLocalMbox.getFolderByPath(LOCAL_PATH_F2));
        TestImapImport.assertNull((String)"Remote folder 1", (Object)this.mRemoteMbox.getFolderByPath(REMOTE_PATH_F1));
        TestImapImport.assertNull((String)"Remote folder 2", (Object)this.mRemoteMbox.getFolderByPath(REMOTE_PATH_F2));
        this.compare();
        ZimbraLog.test.info("Testing sync from local to remote.");
        this.checkMsgCount(this.mLocalMbox, "in:/TestImapImport/INBOX", 0);
        ZFolder localInbox = this.mLocalMbox.getFolderByPath(LOCAL_PATH_INBOX);
        TestUtil.addMessage(this.mLocalMbox, "TestImapImport msg5", localInbox.getId());
        this.checkMsgCount(this.mLocalMbox, "in:/TestImapImport/INBOX", 1);
        this.checkMsgCount(this.mRemoteMbox, "in:inbox", 0);
        this.checkMsgCount(this.mLocalMbox, "in:/TestImapImport/Trash", 1);
        ZFolder localTrash = this.mLocalMbox.getFolderByPath(LOCAL_PATH_TRASH);
        this.mLocalMbox.emptyFolder(localTrash.getId());
        this.checkMsgCount(this.mLocalMbox, "in:/TestImapImport/Trash", 0);
        this.checkMsgCount(this.mRemoteMbox, "in:trash", 1);
        this.importImap();
        this.checkMsgCount(this.mRemoteMbox, "in:inbox msg5", 1);
        this.checkMsgCount(this.mRemoteMbox, "in:trash", 0);
        this.compare();
    }

    private void checkMsgCount(ZMailbox mbox, String query, int expectedCount) throws Exception {
        List<ZMessage> msgs = TestUtil.search(mbox, query);
        TestImapImport.assertEquals((String)("Result size for query '" + query + "'"), (int)expectedCount, (int)msgs.size());
    }

    private void importImap() throws Exception {
        TestUtil.importDataSource(this.mDataSource, this.mLocalMbox, this.mRemoteMbox);
    }

    private void compare() throws Exception {
        ZFolder folder1 = this.mRemoteMbox.getUserRoot();
        ZFolder folder2 = this.mLocalMbox.getFolderByPath(DS_FOLDER_ROOT);
        this.compare(this.mRemoteMbox, folder1, this.mLocalMbox, folder2);
    }

    private void compare(ZMailbox mbox1, ZFolder folder1, ZMailbox mbox2, ZFolder folder2) throws Exception {
        TestImapImport.assertNotNull((Object)mbox1);
        TestImapImport.assertNotNull((Object)folder1);
        TestImapImport.assertNotNull((Object)mbox2);
        TestImapImport.assertNotNull((Object)folder2);
        for (ZFolder child1 : folder1.getSubFolders()) {
            if (!this.isMailFolder(child1)) continue;
            ZFolder child2 = folder2.getSubFolderByPath(child1.getName());
            String msg = String.format("Could not find folder %s/%s for %s", folder2.getPath(), child1.getName(), mbox2.getName());
            TestImapImport.assertNotNull((String)msg, (Object)child2);
            this.compare(mbox1, child1, mbox2, child2);
        }
        TestImapImport.assertEquals((String)("Message count doesn't match (folder1 = " + folder1 + ", folder2 = " + folder2 + ")"), (int)folder1.getMessageCount(), (int)folder2.getMessageCount());
        if (!folder1.getPath().equals("/") && !folder2.getPath().equals("/")) {
            List<ZMessage> msgs1 = TestUtil.search(mbox1, "in:" + folder1.getPath());
            List<ZMessage> msgs2 = TestUtil.search(mbox2, "in:" + folder2.getPath());
            this.compareMessages(msgs1, msgs2);
        }
    }

    private boolean isMailFolder(ZFolder folder) {
        ZFolder.View view = folder.getDefaultView();
        return view == null || view == ZFolder.View.message || view == ZFolder.View.conversation;
    }

    private void compareMessages(List<ZMessage> msgs1, List<ZMessage> msgs2) throws Exception {
        HashMap<String, ZMessage> msgMap = new HashMap<String, ZMessage>();
        for (ZMessage msg : msgs1) {
            msgMap.put(msg.getMessageIdHeader(), msg);
        }
        for (ZMessage msg2 : msgs2) {
            String id = msg2.getMessageIdHeader();
            ZMessage msg1 = (ZMessage)msgMap.remove(id);
            TestImapImport.assertNotNull((String)("Found message '" + msg2.getSubject() + "' in mbox2 but not in mbox1"), (Object)msg1);
            TestImapImport.assertEquals((String)"Message content", (String)msg1.getContent(), (String)msg2.getContent());
            String f1 = msg1.getFlags() != null ? msg1.getFlags() : "";
            String f2 = msg2.getFlags() != null ? msg2.getFlags() : "";
            TestImapImport.assertEquals((String)("Flags for message '" + msg1.getSubject() + "' don't match"), (String)f1, (String)f2);
        }
        if (msgMap.size() != 0) {
            ArrayList<String> subjects = new ArrayList<String>();
            for (ZMessage msg : msgMap.values()) {
                subjects.add(msg.getSubject());
            }
            TestImapImport.fail((String)("Found messages in mbox1 but not in mbox2: " + StringUtil.join(",", subjects)));
        }
    }

    public void tearDown() throws Exception {
        this.cleanUp();
        TestUtil.setServerAttr("zimbraImapCleartextLoginEnabled", this.mOriginalCleartextValue);
        LC.javamail_imap_enable_starttls.setDefault(Boolean.toString(this.mOriginalEnableStarttls));
    }

    public void cleanUp() throws Exception {
        if (TestUtil.accountExists(REMOTE_USER_NAME)) {
            TestUtil.deleteAccount(REMOTE_USER_NAME);
        }
        if (TestUtil.accountExists(LOCAL_USER_NAME)) {
            TestUtil.deleteAccount(LOCAL_USER_NAME);
        }
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestImapImport.class);
    }
}

