/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.datasource.ImapAppender;
import com.zimbra.cs.mailclient.CommandFailedException;
import com.zimbra.cs.mailclient.MailConfig;
import com.zimbra.cs.mailclient.MailException;
import com.zimbra.cs.mailclient.imap.AppendResult;
import com.zimbra.cs.mailclient.imap.Body;
import com.zimbra.cs.mailclient.imap.BodyStructure;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.Envelope;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.IDInfo;
import com.zimbra.cs.mailclient.imap.ImapCapabilities;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.ImapResponse;
import com.zimbra.cs.mailclient.imap.ImapUtil;
import com.zimbra.cs.mailclient.imap.ListData;
import com.zimbra.cs.mailclient.imap.Literal;
import com.zimbra.cs.mailclient.imap.Mailbox;
import com.zimbra.cs.mailclient.imap.MessageData;
import com.zimbra.cs.mailclient.imap.ResponseHandler;
import com.zimbra.cs.mailclient.util.Ascii;
import com.zimbra.cs.mailclient.util.SSLUtil;
import com.zimbra.cs.util.JMSession;
import com.zimbra.qa.unittest.TestImap;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;

public class TestImapClient {
    private ImapConfig config;
    private ImapConnection connection;
    private static final Logger LOG = Logger.getLogger(TestImapClient.class);
    private static final String HOST = "localhost";
    private static final int PORT = 7143;
    private static final int SSL_PORT = 7993;
    private static final String USER = "user1";
    private static final String PASS = "test123";
    private static final String MESSAGE = "Return-Path: dac@zimbra.com\r\nDate: Fri, 27 Feb 2004 15:24:43 -0800 (PST)\r\nFrom: dac <dac@zimbra.com>\r\nTo: bozo <bozo@foo.com>\r\n\r\nThis is a test message.\r\n";
    private static final boolean DEBUG = true;

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.config = null;
        this.connection = null;
    }

    @Test
    public void testLogin() throws Exception {
        this.connect();
        this.connection.login(PASS);
    }

    @Test
    public void testSSLLogin() throws Exception {
        this.connect(MailConfig.Security.SSL);
        this.connection.login(PASS);
    }

    @Test
    public void testStartTls() throws Exception {
        this.connect(MailConfig.Security.TLS);
        this.connection.login(PASS);
    }

    @Test
    public void testPlainAuth() throws Exception {
        try {
            this.connect();
            this.connection.authenticate(PASS);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testBadAuth() throws Exception {
        this.connect();
        try {
            this.connection.authenticate("foobaz");
        }
        catch (CommandFailedException e) {
            return;
        }
        throw new Exception("Expected auth failure");
    }

    @Test
    public void testSelect() throws Exception {
        this.login();
        Mailbox mb = this.connection.getMailbox();
        Assert.assertNotNull((Object)mb);
        Assert.assertTrue((boolean)mb.isReadWrite());
        Assert.assertTrue((mb.getUidValidity() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((mb.getUidNext() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testList() throws Exception {
        this.login();
        List<ListData> lds = this.connection.list("", "*");
        for (ListData ld : lds) {
            Assert.assertEquals((long)47L, (long)ld.getDelimiter());
            Assert.assertNotNull((Object)ld.getMailbox());
            Assert.assertTrue((ld.getFlags().size() > 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIdle() throws Exception {
        this.login();
        Assert.assertFalse((boolean)this.connection.isIdling());
        final AtomicLong exists = new AtomicLong(-1L);
        this.connection.idle(new ResponseHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResponse(ImapResponse res) {
                System.out.println("XXX res = " + res);
                if (res.getCCode() == CAtom.EXISTS) {
                    AtomicLong atomicLong = exists;
                    synchronized (atomicLong) {
                        exists.set(res.getNumber());
                    }
                }
            }
        });
        Assert.assertTrue((boolean)this.connection.isIdling());
        this.sendTestMessage();
        AtomicLong atomicLong = exists;
        synchronized (atomicLong) {
            while (exists.get() <= 0L) {
                exists.wait();
            }
        }
        this.connection.stopIdle();
        Mailbox mb = this.connection.getMailbox();
        Assert.assertEquals((long)mb.getExists(), (long)exists.get());
    }

    private void sendTestMessage() throws IOException {
        Socket sock = new Socket(HOST, 7025);
        OutputStreamWriter out = new OutputStreamWriter(sock.getOutputStream());
        BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
        TestImapClient.smtpSend(in, out, "LHLO localhost");
        TestImapClient.smtpSend(in, out, "MAIL FROM: <user1@localhost>");
        TestImapClient.smtpSend(in, out, "RCPT TO: <user1>");
        TestImapClient.smtpSend(in, out, "DATA");
        TestImapClient.smtpSend(in, out, "Hello, world\r\n.\r\n");
        TestImapClient.smtpSend(in, out, "QUIT");
    }

    private static void smtpSend(BufferedReader in, Writer out, String cmd) throws IOException {
        String line;
        System.out.println("SMTP C: " + cmd);
        out.write(cmd);
        out.write("\r\n");
        out.flush();
        while ((line = in.readLine()) != null) {
            System.out.println("SMTP S: " + line);
            if (line.matches("5.. .*")) {
                throw new IOException("SMTP command failed: " + line);
            }
            if (line.matches("2..-.*")) continue;
            return;
        }
    }

    @Test
    public void testAppend() throws Exception {
        this.login();
        Mailbox mb = this.connection.select("INBOX");
        long exists = mb.getExists();
        Date date = new Date(System.currentTimeMillis() / 1000L * 1000L);
        Flags flags = Flags.fromSpec("fs");
        AppendResult res = this.connection.append("INBOX", Flags.fromSpec("fs"), date, new Literal(Ascii.getBytes(MESSAGE)));
        Assert.assertNotNull((Object)res);
        mb = this.connection.select("INBOX");
        Assert.assertEquals((long)1L, (long)(mb.getExists() - exists));
        MessageData md = this.connection.uidFetch(res.getUid(), (Object)"(FLAGS BODY.PEEK[] INTERNALDATE)");
        Assert.assertNotNull((Object)md);
        Assert.assertEquals((Object)date, (Object)md.getInternalDate());
        Assert.assertEquals((long)res.getUid(), (long)md.getUid());
        Assert.assertEquals((Object)flags, (Object)md.getFlags());
        Body[] parts = md.getBodySections();
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)1L, (long)parts.length);
    }

    @Test
    public void testDelete() throws Exception {
        this.login();
        Mailbox mb = this.connection.select("INBOX");
        long exists = mb.getExists();
        AppendResult res = this.connection.append("INBOX", Flags.fromSpec("fs"), new Date(System.currentTimeMillis()), new Literal(Ascii.getBytes(MESSAGE)));
        Assert.assertNotNull((Object)res);
        mb = this.connection.select("INBOX");
        Assert.assertEquals((long)exists, (long)(mb.getExists() - 1L));
        this.connection.uidStore(String.valueOf(res.getUid()), "+FLAGS.SILENT", Flags.fromSpec("d"));
        mb = this.connection.select("INBOX");
        Assert.assertEquals((long)exists, (long)(mb.getExists() - 1L));
        this.connection.expunge();
        mb = this.connection.select("INBOX");
        Assert.assertEquals((long)exists, (long)mb.getExists());
    }

    @Test
    public void testFetch() throws Exception {
        this.connect();
        this.login();
        Mailbox mb = this.connection.select("INBOX");
        final AtomicLong count = new AtomicLong(mb.getExists());
        this.connection.uidFetch("1:*", "(FLAGS INTERNALDATE RFC822.SIZE ENVELOPE BODY BODY.PEEK[])", new ResponseHandler(){

            public void handleResponse(ImapResponse res) throws Exception {
                if (res.getCCode() != CAtom.FETCH) {
                    return;
                }
                MessageData md = (MessageData)res.getData();
                Assert.assertNotNull((Object)md);
                Envelope env = md.getEnvelope();
                Assert.assertNotNull((Object)env);
                Assert.assertNotNull((Object)env.getSubject());
                Assert.assertNotNull((Object)md.getUid());
                Assert.assertTrue((md.getRfc822Size() != -1L ? 1 : 0) != 0);
                Assert.assertNotNull((Object)md.getInternalDate());
                BodyStructure bs = md.getBodyStructure();
                Assert.assertNotNull((Object)bs);
                if (bs.isMultipart()) {
                    BodyStructure[] parts;
                    for (BodyStructure part : parts = bs.getParts()) {
                        Assert.assertNotNull((Object)part.getType());
                        Assert.assertNotNull((Object)part.getSubtype());
                    }
                } else {
                    Assert.assertNotNull((Object)bs.getType());
                    Assert.assertNotNull((Object)bs.getSubtype());
                }
                Body[] body = md.getBodySections();
                Assert.assertNotNull((Object)body);
                Assert.assertEquals((long)1L, (long)body.length);
                count.decrementAndGet();
                System.out.printf("Fetched uid = %s\n", md.getUid());
            }
        });
        Assert.assertEquals((long)0L, (long)count.longValue());
    }

    @Test
    public void testID() throws Exception {
        IDInfo id = new IDInfo();
        id.setName("foo");
        Assert.assertEquals((Object)"foo", (Object)id.getName());
        Assert.assertEquals((Object)"foo", id.get("Name"));
        this.connect();
        IDInfo id1 = this.connection.id(id);
        Assert.assertNotNull((Object)id1);
        Assert.assertEquals((Object)"Zimbra", (Object)id1.getName());
        IDInfo id2 = this.connection.id();
        Assert.assertEquals((Object)id1, (Object)id2);
    }

    @Test
    public void testYahoo() throws Exception {
        ImapConfig config = new ImapConfig();
        config.setDebug(true);
        config.setTrace(true);
        config.setHost("imap.mail.yahoo.com");
        config.setAuthenticationId("dacztest");
        this.connection = new ImapConnection(config);
        this.connection.connect();
        IDInfo id = new IDInfo();
        id.put("guid", "unknown");
        this.connection.id(id);
        this.connection.login("test1234");
        char delim = this.connection.getDelimiter();
        Assert.assertEquals((long)0L, (long)delim);
        this.createTestMailbox("Large", 10000);
    }

    @Test
    public void testGMailAppend() throws Exception {
        ImapConfig config = new ImapConfig();
        config.setDebug(true);
        config.setTrace(true);
        config.setHost("imap.gmail.com");
        config.setSecurity(MailConfig.Security.SSL);
        config.setSSLSocketFactory(SSLUtil.getDummySSLContext().getSocketFactory());
        config.setAuthenticationId("dacztest");
        config.setMaxLiteralTraceSize(999999);
        this.connection = new ImapConnection(config);
        this.connection.connect();
        this.connection.login("test1234");
        MimeMessage mm = TestImapClient.newTestMessage(new Random().nextInt());
        ImapAppender appender = new ImapAppender(this.connection, "INBOX");
        long uid1 = appender.appendMessage(this.getBytes(mm), null);
        System.out.println("XXX uid1 = " + uid1);
        Assert.assertTrue((String)"uid1 not found", (uid1 > 0L ? 1 : 0) != 0);
        long uid2 = appender.appendMessage(this.getBytes(mm), null);
        Assert.assertTrue((String)"uid2 not found", (uid2 > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)uid1, (long)uid2);
        this.connection.close();
    }

    @Test
    public void testParseUidSet() {
        long[] seq = new long[]{1L, 2L, 3L, 4L, 5L};
        Assert.assertArrayEquals((long[])seq, (long[])ImapUtil.parseUidSet("1,2,3,4,5"));
        Assert.assertArrayEquals((long[])seq, (long[])ImapUtil.parseUidSet("1,2:4,5"));
        Assert.assertArrayEquals((long[])seq, (long[])ImapUtil.parseUidSet("4:1,5"));
        try {
            ImapUtil.parseUidSet("4::1,4");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ImapUtil.parseUidSet("");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ImapUtil.parseUidSet("1,,2");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private byte[] getBytes(MimeMessage mm) throws MessagingException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        mm.writeTo((OutputStream)baos);
        return baos.toByteArray();
    }

    private void createTestMailbox(String name, int count) throws IOException, MessagingException {
        if (!this.connection.exists(name)) {
            this.connection.create(name);
        }
        Mailbox mb = this.connection.select(name);
        for (int i = (int)mb.getExists(); i < count; ++i) {
            MimeMessage mm = TestImapClient.newTestMessage(i);
            long uid = this.uidAppend(mm, null, null);
            LOG.debug((Object)("Appended test message " + i + ", uid = " + uid));
        }
    }

    private static MimeMessage newTestMessage(int num) throws MessagingException {
        MimeMessage mm = new MimeMessage(JMSession.getSession());
        mm.setHeader("Message-Id", "<test-" + num + "@foo.com>");
        mm.setHeader("To", "nobody@foo.com");
        mm.setHeader("From", "nobody@bar.com");
        mm.setSubject("Test message " + num);
        mm.setSentDate(new Date(System.currentTimeMillis()));
        mm.setContent((Object)("This is test message " + num), "text/plain");
        return mm;
    }

    private long uidAppend(MimeMessage msg, Flags flags, Date date) throws IOException {
        long l;
        File tmp;
        block6: {
            String name = this.connection.getMailbox().getName();
            tmp = null;
            OutputStream os = null;
            try {
                File dir = this.connection.getImapConfig().getLiteralDataDir();
                tmp = File.createTempFile("lit", null, dir);
                os = new FileOutputStream(tmp);
                msg.writeTo(os);
                os.close();
                AppendResult res = this.connection.append(name, flags, date, new Literal(tmp));
                l = res != null ? res.getUid() : -1L;
                Object var12_11 = null;
                if (os == null) break block6;
            }
            catch (MessagingException e) {
                try {
                    throw new MailException("Error appending message", e);
                }
                catch (Throwable throwable) {
                    block7: {
                        Object var12_12 = null;
                        if (os != null) {
                            os.close();
                        }
                        if (tmp == null) break block7;
                        tmp.delete();
                    }
                    throw throwable;
                }
            }
            os.close();
        }
        if (tmp != null) {
            tmp.delete();
        }
        return l;
    }

    private void login() throws IOException {
        this.connect();
        this.connection.login(PASS);
        this.connection.select("INBOX");
        Assert.assertTrue((boolean)this.connection.getMailbox().getName().equals("INBOX"));
        ImapCapabilities cap = this.connection.getCapabilities();
        Assert.assertNotNull((Object)cap);
        Assert.assertTrue((boolean)cap.hasCapability("UIDPLUS"));
        Assert.assertTrue((boolean)cap.hasCapability("UNSELECT"));
    }

    private void connect() throws IOException {
        this.connect(null);
    }

    private void connect(MailConfig.Security security) throws IOException {
        if (this.config == null) {
            this.config = TestImapClient.getConfig(security);
        }
        System.out.println("---------");
        this.connection = new ImapConnection(this.config);
        this.connection.connect();
    }

    private static ImapConfig getConfig(MailConfig.Security security) throws IOException {
        ImapConfig config = new ImapConfig(HOST);
        config.setPort(7143);
        if (security != null) {
            config.setSecurity(security);
            if (security == MailConfig.Security.SSL) {
                config.setPort(7993);
                config.setSSLSocketFactory(SSLUtil.getDummySSLContext().getSocketFactory());
            }
        }
        config.setDebug(true);
        config.setTrace(true);
        config.setMechanism("PLAIN");
        config.setAuthenticationId(USER);
        return config;
    }

    public static void main(String ... args) throws Exception {
        JUnitCore junit = new JUnitCore();
        if (args.length > 0) {
            for (String test : args) {
                String method = String.format("test%C%s", Character.valueOf(test.charAt(0)), test.substring(1));
                junit.run(Request.method(TestImap.class, (String)method));
            }
        } else {
            junit.run(new Class[]{TestImap.class});
        }
    }

    static {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        LOG.setLevel(Level.DEBUG);
    }
}

