/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.mailclient.imap.AppendMessage;
import com.zimbra.cs.mailclient.imap.AppendResult;
import com.zimbra.cs.mailclient.imap.Body;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.Literal;
import com.zimbra.cs.mailclient.imap.MessageData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;

public class TestImap {
    private static final String HOST = "localhost";
    private static final int PORT = 7143;
    private static final String USER = "user1";
    private static final String PASS = "test123";
    private static ImapConnection connection;

    @BeforeClass
    public static void setUp() throws Exception {
        connection = TestImap.connect();
    }

    @AfterClass
    public static void tearDown() {
        if (connection != null) {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend() throws Exception {
        Assert.assertTrue((boolean)connection.hasCapability("UIDPLUS"));
        Flags flags = Flags.fromSpec("afs");
        Date date = new Date(System.currentTimeMillis());
        Literal msg = TestImap.message(100000);
        try {
            AppendResult res = connection.append("INBOX", flags, date, msg);
            Assert.assertNotNull((Object)res);
            byte[] b = this.fetchBody(res.getUid());
            Assert.assertArrayEquals((String)"content mismatch", (byte[])msg.getBytes(), (byte[])b);
            Object var7_6 = null;
            msg.dispose();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            msg.dispose();
            throw throwable;
        }
    }

    @Test
    public void testAppendNoLiteralPlus() throws Exception {
        this.withLiteralPlus(false, new RunnableTest(){

            public void run() throws Exception {
                TestImap.this.testAppend();
            }
        });
    }

    @Test
    public void testCatenateSimple() throws Exception {
        Assert.assertTrue((boolean)connection.hasCapability("CATENATE"));
        Assert.assertTrue((boolean)connection.hasCapability("UIDPLUS"));
        String part1 = TestImap.simpleMessage("test message");
        String part2 = "more text\r\n";
        AppendMessage am = new AppendMessage(null, null, TestImap.literal(part1), TestImap.literal(part2));
        AppendResult res = connection.append("INBOX", am);
        connection.select("INBOX");
        byte[] body = this.fetchBody(res.getUid());
        Assert.assertArrayEquals((String)"content mismatch", (byte[])TestImap.bytes(part1 + part2), (byte[])body);
    }

    @Test
    public void testCatenateSimpleNoLiteralPlus() throws Exception {
        this.withLiteralPlus(false, new RunnableTest(){

            public void run() throws Exception {
                TestImap.this.testCatenateSimple();
            }
        });
    }

    @Test
    public void testCatenateUrl() throws Exception {
        Assert.assertTrue((boolean)connection.hasCapability("CATENATE"));
        Assert.assertTrue((boolean)connection.hasCapability("UIDPLUS"));
        String msg1 = TestImap.simpleMessage("test message");
        AppendResult res1 = connection.append("INBOX", null, null, TestImap.literal(msg1));
        String s1 = "first part\r\n";
        String s2 = "second part\r\n";
        String msg2 = msg1 + s1 + s2;
        AppendMessage am = new AppendMessage(null, null, this.url("INBOX", res1), TestImap.literal(s1), TestImap.literal(s2));
        AppendResult res2 = connection.append("INBOX", am);
        connection.select("INBOX");
        byte[] b2 = this.fetchBody(res2.getUid());
        Assert.assertArrayEquals((String)"content mismatch", (byte[])TestImap.bytes(msg2), (byte[])b2);
    }

    @Test
    public void testMultiappend() throws Exception {
        Assert.assertTrue((boolean)connection.hasCapability("MULTIAPPEND"));
        Assert.assertTrue((boolean)connection.hasCapability("UIDPLUS"));
        AppendMessage msg1 = new AppendMessage(null, null, TestImap.literal("test 1"));
        AppendMessage msg2 = new AppendMessage(null, null, TestImap.literal("test 2"));
        AppendResult res = connection.append("INBOX", msg1, msg2);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((String)"expecting 2 uids", (long)2L, (long)res.getUids().length);
    }

    @Test
    public void testMultiappendNoLiteralPlus() throws Exception {
        this.withLiteralPlus(false, new RunnableTest(){

            public void run() throws Exception {
                TestImap.this.testMultiappend();
            }
        });
    }

    private String url(String mbox, AppendResult res) {
        return String.format("/%s;UIDVALIDITY=%d/;UID=%d", mbox, res.getUidValidity(), res.getUid());
    }

    private static Literal literal(String s) {
        return new Literal(TestImap.bytes(s));
    }

    private static byte[] bytes(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)"UTF8 encoding not supported");
            return null;
        }
    }

    private byte[] fetchBody(long uid) throws IOException {
        MessageData md = connection.uidFetch(uid, (Object)"(BODY.PEEK[])");
        Assert.assertNotNull((String)"message not found", (Object)md);
        Assert.assertEquals((long)uid, (long)md.getUid());
        Body[] bs = md.getBodySections();
        Assert.assertNotNull((Object)bs);
        Assert.assertEquals((long)1L, (long)bs.length);
        return bs[0].getImapData().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Literal message(int size) throws IOException {
        File file = File.createTempFile("msg", null);
        file.deleteOnExit();
        FileWriter out = new FileWriter(file);
        try {
            out.write(TestImap.simpleMessage("test message"));
            for (int i = 0; i < size; ++i) {
                out.write(88);
                if (i % 72 != 0) continue;
                out.write("\r\n");
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            out.close();
            throw throwable;
        }
        out.close();
        return new Literal(file, true);
    }

    private static String simpleMessage(String text) {
        return "Return-Path: dac@zimbra.com\r\nDate: Fri, 27 Feb 2004 15:24:43 -0800 (PST)\r\nFrom: dac <dac@zimbra.com>\r\nTo: bozo <bozo@foo.com>\r\nSubject: Foo foo\r\n\r\n" + text + "\r\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withLiteralPlus(boolean lp, RunnableTest test) throws Exception {
        ImapConfig config = connection.getImapConfig();
        boolean oldLp = config.isUseLiteralPlus();
        config.setUseLiteralPlus(lp);
        try {
            test.run();
            Object var6_5 = null;
            config.setUseLiteralPlus(oldLp);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            config.setUseLiteralPlus(oldLp);
            throw throwable;
        }
    }

    private static ImapConnection connect() throws IOException {
        ImapConfig config = new ImapConfig(HOST);
        config.setPort(7143);
        config.setAuthenticationId(USER);
        config.setTrace(true);
        ImapConnection connection = new ImapConnection(config);
        connection.connect();
        connection.login(PASS);
        connection.select("INBOX");
        return connection;
    }

    public static void main(String ... args) throws Exception {
        JUnitCore junit = new JUnitCore();
        if (args.length > 0) {
            for (String test : args) {
                String method = String.format("test%c%s", Character.valueOf(Character.toUpperCase(test.charAt(0))), test.substring(1));
                System.out.printf("** Running test '%s'\n", method);
                junit.run(Request.method(TestImap.class, (String)method));
            }
        } else {
            System.out.println("** Running all tests");
            junit.run(new Class[]{TestImap.class});
        }
    }

    private static interface RunnableTest {
        public void run() throws Exception;
    }
}

