/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;

public class TestIDN
extends TestCase {
    private static String TEST_ID;
    private static String TEST_NAME;
    private static String UNICODESTR;
    private static String PASSWORD;
    private static Provisioning mProv;
    private static String BASE_DOMAIN_NAME;

    public void setUp() throws Exception {
        if (TEST_ID != null) {
            return;
        }
        TEST_ID = TestProvisioningUtil.genTestId();
        System.out.println("\nTest " + TEST_ID + " setting up...\n");
        mProv = Provisioning.getInstance();
        BASE_DOMAIN_NAME = "." + TestProvisioningUtil.baseDomainName(TEST_NAME, TEST_ID);
    }

    private String makeDomainName(String prefix) {
        return prefix + UNICODESTR + BASE_DOMAIN_NAME;
    }

    private Domain createDomain(String domainName, String description) throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("description", "=====" + description + "=====");
        Domain domain = mProv.createDomain(domainName, attrs);
        TestIDN.assertNotNull((Object)domain);
        return domain;
    }

    private Account createAccount(String email, String description) throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("description", "=====" + description + "=====");
        Account acct = mProv.createAccount(email, PASSWORD, attrs);
        TestIDN.assertNotNull((Object)acct);
        return acct;
    }

    private CalendarResource createCalendarResource(String email, String description) throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("description", "=====" + description + "=====");
        attrs.put("displayName", email);
        attrs.put("zimbraCalResType", "Equipment");
        CalendarResource cr = mProv.createCalendarResource(email, PASSWORD, attrs);
        TestIDN.assertNotNull((Object)cr);
        return cr;
    }

    private DistributionList createDistributionList(String email, String description) throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("description", "=====" + description + "=====");
        DistributionList dl = mProv.createDistributionList(email, attrs);
        TestIDN.assertNotNull((Object)dl);
        return dl;
    }

    private NamedEntry createTest(EntryType entryType, NameType by, TestProvisioningUtil.IDNName name) throws Exception {
        NamedEntry created;
        block22: {
            created = null;
            NamedEntry notCreated = null;
            String firstCreateBy = null;
            String thenCreateBy = null;
            if (by == NameType.UNAME) {
                firstCreateBy = name.uName();
                thenCreateBy = name.aName();
            } else {
                firstCreateBy = name.aName();
                thenCreateBy = name.uName();
            }
            String desc = name.uName();
            switch (entryType) {
                case DOMAIN: {
                    created = this.createDomain(firstCreateBy, desc);
                    break;
                }
                case ACCOUNT: {
                    created = this.createAccount(firstCreateBy, desc);
                    break;
                }
                case CR: {
                    created = this.createCalendarResource(firstCreateBy, desc);
                    break;
                }
                case DL: {
                    created = this.createDistributionList(firstCreateBy, desc);
                }
            }
            TestIDN.assertNotNull(created);
            try {
                switch (entryType) {
                    case DOMAIN: {
                        notCreated = this.createDomain(thenCreateBy, desc);
                        break;
                    }
                    case ACCOUNT: {
                        notCreated = this.createAccount(thenCreateBy, desc);
                        break;
                    }
                    case CR: {
                        notCreated = this.createCalendarResource(thenCreateBy, desc);
                        break;
                    }
                    case DL: {
                        notCreated = this.createDistributionList(thenCreateBy, desc);
                    }
                }
                TestIDN.fail();
            }
            catch (ServiceException e) {
                String expectedExceptionCode = null;
                switch (entryType) {
                    case DOMAIN: {
                        expectedExceptionCode = "account.DOMAIN_EXISTS";
                        break;
                    }
                    case ACCOUNT: {
                        expectedExceptionCode = "account.ACCOUNT_EXISTS";
                        break;
                    }
                    case CR: {
                        expectedExceptionCode = "account.ACCOUNT_EXISTS";
                        break;
                    }
                    case DL: {
                        expectedExceptionCode = "account.DISTRIBUTION_LIST_EXISTS";
                    }
                }
                if (e.getCode().equals(expectedExceptionCode)) break block22;
                TestIDN.fail();
            }
        }
        return created;
    }

    private void getTest(EntryType entryType, NamedEntry expectedEntry, TestProvisioningUtil.IDNName name) throws Exception {
        NamedEntry gotByUName = null;
        NamedEntry gotByAName = null;
        switch (entryType) {
            case DOMAIN: {
                gotByUName = mProv.get(Provisioning.DomainBy.name, name.uName());
                gotByAName = mProv.get(Provisioning.DomainBy.name, name.aName());
                break;
            }
            case ACCOUNT: {
                gotByUName = mProv.get(Provisioning.AccountBy.name, name.uName());
                gotByAName = mProv.get(Provisioning.AccountBy.name, name.aName());
                break;
            }
            case CR: {
                gotByUName = mProv.get(Provisioning.CalendarResourceBy.name, name.uName());
                gotByAName = mProv.get(Provisioning.CalendarResourceBy.name, name.aName());
                break;
            }
            case DL: {
                gotByUName = mProv.get(Provisioning.DistributionListBy.name, name.uName());
                gotByAName = mProv.get(Provisioning.DistributionListBy.name, name.aName());
            }
        }
        if (expectedEntry == null) {
            TestIDN.assertNull(gotByUName);
            TestIDN.assertNull(gotByAName);
        } else {
            TestIDN.assertNotNull(gotByUName);
            TestIDN.assertNotNull(gotByAName);
            TestIDN.assertEquals((String)expectedEntry.getId(), (String)gotByUName.getId());
            TestIDN.assertEquals((String)expectedEntry.getId(), (String)gotByAName.getId());
        }
    }

    private void renameTest(EntryType entryType, NamedEntry entry, TestProvisioningUtil.IDNName name) throws Exception {
        switch (entryType) {
            case DOMAIN: {
                TestIDN.assertTrue((boolean)(mProv instanceof LdapProvisioning));
                ((LdapProvisioning)mProv).renameDomain(entry.getId(), name.uName());
                break;
            }
            case ACCOUNT: {
                mProv.renameAccount(entry.getId(), name.uName());
                break;
            }
            case CR: {
                mProv.renameCalendarResource(entry.getId(), name.uName());
                break;
            }
            case DL: {
                mProv.renameDistributionList(entry.getId(), name.uName());
            }
        }
    }

    private void setAddressAttrsTest(EntryType entryType, NamedEntry entry, TestProvisioningUtil.IDNName name) throws Exception {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailCanonicalAddress", "canonical-" + name.uName());
        attrs.put("+zimbraMailForwardingAddress", "extra-1-forwarding-" + name.uName());
        attrs.put("+zimbraMailForwardingAddress", "extra-2-forwarding-" + name.uName());
        attrs.put("+zimbraMailDeliveryAddress", "extra-1-delivery-" + name.uName());
        attrs.put("+zimbraMailDeliveryAddress", "extra-2-delivery-" + name.uName());
        attrs.put("+zimbraMailCatchAllAddress", "@" + name.uName());
        attrs.put("+zimbraMailCatchAllCanonicalAddress", "@" + name.uName());
        attrs.put("+zimbraMailCatchAllForwardingAddress", "@" + name.uName());
        mProv.modifyAttrs(entry, attrs);
    }

    public void testDomain() throws Exception {
        TestProvisioningUtil.IDNName d1Name = new TestProvisioningUtil.IDNName(this.makeDomainName("domain-1."));
        TestProvisioningUtil.IDNName d2Name = new TestProvisioningUtil.IDNName(this.makeDomainName("domain-2."));
        TestProvisioningUtil.IDNName d2RenamedName = new TestProvisioningUtil.IDNName(this.makeDomainName("domain-2-renamed."));
        Domain domain1 = (Domain)this.createTest(EntryType.DOMAIN, NameType.UNAME, d1Name);
        Domain domain2 = (Domain)this.createTest(EntryType.DOMAIN, NameType.ANAME, d2Name);
        this.getTest(EntryType.DOMAIN, domain1, d1Name);
        this.getTest(EntryType.DOMAIN, domain2, d2Name);
        this.renameTest(EntryType.DOMAIN, domain2, d2RenamedName);
    }

    private void doTestInvalidNames(String domainName, boolean expectedValid) throws Exception {
        boolean actualValid;
        try {
            Domain domain = mProv.createDomain(domainName, new HashMap<String, Object>());
            actualValid = domain != null;
        }
        catch (ServiceException e) {
            actualValid = false;
        }
        TestIDN.assertEquals((boolean)expectedValid, (boolean)actualValid);
    }

    public void testDomainInvalidNames() throws Exception {
        Config config = mProv.getConfig();
        String curAllowNonLDH = config.getAttr("zimbraAllowNonLDHCharsInDomain");
        String goodEnglish = "good" + BASE_DOMAIN_NAME;
        String goodIDN = this.makeDomainName("good");
        String LDHEnglish_comma = "ldh'ldh" + BASE_DOMAIN_NAME;
        String LDHIDN_comma = this.makeDomainName("ldh'ldh");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAllowNonLDHCharsInDomain", "TRUE");
        mProv.modifyAttrs(config, attrs);
        String prefix = "allowtest.";
        this.doTestInvalidNames(prefix + goodEnglish, true);
        this.doTestInvalidNames(prefix + goodIDN, true);
        this.doTestInvalidNames(prefix + LDHEnglish_comma, true);
        this.doTestInvalidNames(prefix + LDHIDN_comma, true);
        attrs.clear();
        attrs.put("zimbraAllowNonLDHCharsInDomain", "FALSE");
        mProv.modifyAttrs(config, attrs);
        prefix = "notallowtest.";
        this.doTestInvalidNames(prefix + goodEnglish, true);
        this.doTestInvalidNames(prefix + goodIDN, true);
        this.doTestInvalidNames(prefix + LDHEnglish_comma, false);
        this.doTestInvalidNames(prefix + LDHIDN_comma, false);
        attrs.clear();
        attrs.put("zimbraAllowNonLDHCharsInDomain", curAllowNonLDH);
        mProv.modifyAttrs(config, attrs);
    }

    public void testAccount() throws Exception {
        TestProvisioningUtil.IDNName domainName = new TestProvisioningUtil.IDNName(this.makeDomainName("domain-acct-test."));
        Domain domain = this.createDomain(domainName.uName(), domainName.uName());
        TestProvisioningUtil.IDNName acct1Name = new TestProvisioningUtil.IDNName("acct-1", domainName.uName());
        TestProvisioningUtil.IDNName acct2Name = new TestProvisioningUtil.IDNName("acct-2", domainName.uName());
        TestProvisioningUtil.IDNName acct2RenamedName = new TestProvisioningUtil.IDNName("acct-2-renamed", domainName.uName());
        TestProvisioningUtil.IDNName alias1Name = new TestProvisioningUtil.IDNName("alias-1-of-acct-1", domainName.uName());
        TestProvisioningUtil.IDNName alias2Name = new TestProvisioningUtil.IDNName("alias-2-of-acct-1", domainName.uName());
        TestProvisioningUtil.IDNName cr1Name = new TestProvisioningUtil.IDNName("cr-1", domainName.uName());
        TestProvisioningUtil.IDNName cr2Name = new TestProvisioningUtil.IDNName("cr-2", domainName.uName());
        TestProvisioningUtil.IDNName cr2RenamedName = new TestProvisioningUtil.IDNName("cr-2-renamed", domainName.uName());
        Account acct1 = (Account)this.createTest(EntryType.ACCOUNT, NameType.UNAME, acct1Name);
        Account acct2 = (Account)this.createTest(EntryType.ACCOUNT, NameType.ANAME, acct2Name);
        this.getTest(EntryType.ACCOUNT, acct1, acct1Name);
        this.getTest(EntryType.ACCOUNT, acct2, acct2Name);
        this.setAddressAttrsTest(EntryType.ACCOUNT, acct1, acct1Name);
        mProv.addAlias(acct1, alias1Name.uName());
        mProv.addAlias(acct1, alias2Name.aName());
        this.getTest(EntryType.ACCOUNT, acct1, alias1Name);
        this.getTest(EntryType.ACCOUNT, acct1, alias2Name);
        mProv.removeAlias(acct1, alias1Name.aName());
        mProv.removeAlias(acct1, alias2Name.uName());
        this.getTest(EntryType.ACCOUNT, null, alias1Name);
        this.getTest(EntryType.ACCOUNT, null, alias2Name);
        mProv.addAlias(acct1, alias1Name.uName());
        mProv.addAlias(acct1, alias2Name.aName());
        this.renameTest(EntryType.ACCOUNT, acct2, acct2RenamedName);
        this.getTest(EntryType.ACCOUNT, acct2, acct2RenamedName);
        CalendarResource cr1 = (CalendarResource)this.createTest(EntryType.CR, NameType.UNAME, cr1Name);
        CalendarResource cr2 = (CalendarResource)this.createTest(EntryType.CR, NameType.ANAME, cr2Name);
        this.getTest(EntryType.CR, cr1, cr1Name);
        this.getTest(EntryType.CR, cr2, cr2Name);
        this.renameTest(EntryType.CR, cr2, cr2RenamedName);
        this.getTest(EntryType.CR, cr2, cr2RenamedName);
    }

    public void testDistributionList() throws Exception {
        TestProvisioningUtil.IDNName domainName = new TestProvisioningUtil.IDNName(this.makeDomainName("domain-dl-test."));
        Domain domain = this.createDomain(domainName.uName(), domainName.uName());
        TestProvisioningUtil.IDNName acct1Name = new TestProvisioningUtil.IDNName("acct-1", domainName.uName());
        TestProvisioningUtil.IDNName acct2Name = new TestProvisioningUtil.IDNName("acct-2", domainName.uName());
        TestProvisioningUtil.IDNName dl1Name = new TestProvisioningUtil.IDNName("dl-1", domainName.uName());
        TestProvisioningUtil.IDNName dl2Name = new TestProvisioningUtil.IDNName("dl-2", domainName.uName());
        TestProvisioningUtil.IDNName dl2RenamedName = new TestProvisioningUtil.IDNName("dl-2-renamed", domainName.uName());
        TestProvisioningUtil.IDNName nestedDl1Name = new TestProvisioningUtil.IDNName("nested-dl-1", domainName.uName());
        TestProvisioningUtil.IDNName nestedDl2Name = new TestProvisioningUtil.IDNName("nested-dl-2", domainName.uName());
        DistributionList dl1 = (DistributionList)this.createTest(EntryType.DL, NameType.UNAME, dl1Name);
        DistributionList dl2 = (DistributionList)this.createTest(EntryType.DL, NameType.ANAME, dl2Name);
        this.getTest(EntryType.DL, dl1, dl1Name);
        this.getTest(EntryType.DL, dl2, dl2Name);
        this.renameTest(EntryType.DL, dl2, dl2RenamedName);
        this.getTest(EntryType.DL, dl2, dl2RenamedName);
        Account a1 = this.createAccount(acct1Name.uName(), acct1Name.uName());
        Account a2 = this.createAccount(acct2Name.uName(), acct2Name.uName());
        DistributionList nestedDl1 = this.createDistributionList(nestedDl1Name.aName(), nestedDl1Name.uName());
        DistributionList nestedDl2 = this.createDistributionList(nestedDl2Name.aName(), nestedDl2Name.uName());
        mProv.addMembers(dl1, new String[]{acct1Name.uName(), acct2Name.aName(), nestedDl1Name.uName(), nestedDl2Name.aName()});
        boolean inList = mProv.inDistributionList(a1, dl1.getId());
        TestIDN.assertTrue((boolean)inList);
        inList = mProv.inDistributionList(a2, dl1.getId());
        TestIDN.assertTrue((boolean)inList);
        HashMap via = new HashMap();
        String[] members = dl1.getAllMembers();
        List<String> memberIds = Arrays.asList(members);
        TestIDN.assertTrue((boolean)memberIds.contains(acct1Name.aName()));
        TestIDN.assertTrue((boolean)memberIds.contains(acct2Name.aName()));
        TestIDN.assertTrue((boolean)memberIds.contains(nestedDl1Name.aName()));
        TestIDN.assertTrue((boolean)memberIds.contains(nestedDl2Name.aName()));
        mProv.removeMembers(dl1, new String[]{acct1Name.uName(), acct2Name.aName(), nestedDl1Name.uName(), nestedDl2Name.aName()});
        members = dl1.getAllMembers();
        TestIDN.assertEquals((int)0, (int)members.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicAuth() throws Exception {
        TestProvisioningUtil.IDNName domainName = new TestProvisioningUtil.IDNName(this.makeDomainName("basicAuthTest."));
        Domain domain = this.createDomain(domainName.uName(), domainName.uName());
        TestProvisioningUtil.IDNName acctName = new TestProvisioningUtil.IDNName("acct", domainName.uName());
        Account acct = (Account)this.createTest(EntryType.ACCOUNT, NameType.UNAME, acctName);
        HttpState initialState = new HttpState();
        String guestName = acct.getUnicodeName();
        String guestPassword = "test123";
        UsernamePasswordCredentials loginCredentials = new UsernamePasswordCredentials(guestName, guestPassword);
        initialState.setCredentials(AuthScope.ANY, loginCredentials);
        HttpClient client = new HttpClient();
        client.setState(initialState);
        String url = UserServlet.getRestUrl(acct) + "/Calendar";
        System.out.println("REST URL: " + url);
        GetMethod method = new GetMethod(url);
        HttpMethodParams methodParams = method.getParams();
        methodParams.setCredentialCharset("UTF-8");
        try {
            int respCode = client.executeMethod(method);
            if (respCode != 200) {
                System.out.println("failed, respCode=" + respCode);
            } else {
                boolean chunked = false;
                boolean textContent = false;
                System.out.println("Headers:");
                System.out.println("--------");
                for (Header header : method.getRequestHeaders()) {
                    System.out.print("    " + header.toString());
                }
                System.out.println();
                System.out.println("Body:");
                System.out.println("-----");
                String respBody = method.getResponseBodyAsString();
                System.out.println(respBody);
            }
            Object var21_20 = null;
            method.releaseConnection();
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            method.releaseConnection();
            throw throwable;
        }
    }

    private void IDNUtilTest(String u1, String expectedAscii) {
        boolean verbose = true;
        String a1 = IDNUtil.toAsciiDomainName(u1);
        TestIDN.assertTrue((boolean)expectedAscii.equals(a1));
        this.printOutput(verbose, "u1: " + u1);
        this.printOutput(verbose, "a1: " + a1);
        String u2 = IDNUtil.toUnicodeDomainName(u1);
        String a2 = IDNUtil.toAsciiDomainName(u2);
        this.printOutput(verbose, "u2: " + u2);
        this.printOutput(verbose, "a2: " + a2);
        TestIDN.assertTrue((a1.equals(a2) && u1.equals(u2) ? 1 : 0) != 0);
        this.printOutput(verbose, "");
    }

    public void testIDNUtil() throws Exception {
        this.IDNUtilTest("foobar.com", "foobar.com");
        this.IDNUtilTest("\u4e2d\u6587.xyz\u4e2d\u6587abc.com", "xn--fiq228c.xn--xyzabc-dw7i870n.com");
        this.IDNUtilTest("foo'bar.com", "foo'bar.com");
        this.IDNUtilTest("\u4e2d'\u6587.xyz\u4e2d\u6587abc.com", "xn--'-kq6a506e.xn--xyzabc-dw7i870n.com");
    }

    private void emailpTest(String unicode, AttributeManager.IDNType idnType) {
        boolean verbose = false;
        this.printOutput(verbose, "\nTesting email with personal part, idn type = " + (Object)((Object)idnType) + "\n");
        String emailp_u1 = unicode;
        String emailp_a1 = IDNUtil.toAscii(emailp_u1, idnType);
        this.printOutput(verbose, "emailp_u1: " + emailp_u1);
        this.printOutput(verbose, "emailp_a1: " + emailp_a1);
        String emailp_u2 = IDNUtil.toUnicode(emailp_a1, idnType);
        String emailp_a2 = IDNUtil.toAscii(emailp_u2, idnType);
        this.printOutput(verbose, "emailp_u2: " + emailp_u2);
        this.printOutput(verbose, "emailp_a2: " + emailp_a2);
        TestIDN.assertTrue((boolean)emailp_u1.equals(emailp_u2));
        TestIDN.assertTrue((boolean)emailp_a1.equals(emailp_a2));
    }

    public void testEmailp() throws Exception {
        this.emailpTest("foo bar <test@\u4e2d\u6587.xyz\u4e2d\u6587abc.com>", AttributeManager.IDNType.emailp);
        this.emailpTest("\"\u4e2d\u6587\" <test@\u4e2d\u6587.xyz\u4e2d\u6587abc.com>", AttributeManager.IDNType.emailp);
        this.emailpTest("foo bar <test@\u4e2d\u6587.xyz\u4e2d\u6587abc.com>", AttributeManager.IDNType.cs_emailp);
        this.emailpTest("foo bar <test@\u4e2d\u6587.xyz\u4e2d\u6587abc.com>, cat dog <test@xyz\u4e2d\u6587abc.com>", AttributeManager.IDNType.cs_emailp);
    }

    private void printOutput(boolean verbose, String text) {
        if (!verbose) {
            return;
        }
        PrintStream ps = System.out;
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)ps, "UTF-8"));
            writer.write(text + "\n");
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            ps.println(text);
        }
        catch (IOException e) {
            ps.println(text);
        }
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup();
        TestUtil.runTest(TestIDN.class);
    }

    static {
        TEST_NAME = "test-IDN";
        UNICODESTR = "\u4e2d\u6587";
        PASSWORD = "test123";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NameType {
        UNAME,
        ANAME;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EntryType {
        DOMAIN,
        ACCOUNT,
        CR,
        DL;

    }
}

