/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.mime.handler.TextEnrichedHandler;
import com.zimbra.cs.zclient.ZGetMessageParams;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.qa.unittest.MessageBuilder;
import com.zimbra.qa.unittest.TestUtil;
import junit.framework.TestCase;

public class TestGetMsg
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String NAME_PREFIX = TestGetMsg.class.getSimpleName();
    private String mOriginalContentMaxSize;

    public void setUp() throws Exception {
        this.cleanUp();
        this.mOriginalContentMaxSize = TestUtil.getServerAttr("zimbraMailContentMaxSize");
    }

    public void testPlainMessageContent() throws Exception {
        this.doTestMessageContent("text/plain", "This is the body of a plain message.");
    }

    public void testHtmlMessageContent() throws Exception {
        this.doTestMessageContent("text/html", "<html><head></head><body>HTML message</body></html>");
    }

    public void testEnrichedMessageContent() throws Exception {
        this.doTestMessageContent("text/enriched", "<color><param>red</param>Blood</color> is <bold>thicker</bold> than<color><param>blue</param>water</color>.");
    }

    private void doTestMessageContent(String contentType, String body) throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        MessageBuilder mb = new MessageBuilder();
        String subject = NAME_PREFIX + " testMessageContent " + contentType;
        String raw = mb.withSubject(subject).withBody(body).withContentType(contentType).create();
        String msgId = TestUtil.addRawMessage(mbox, raw);
        if (contentType.equals("text/enriched")) {
            body = TextEnrichedHandler.convertToHTML(body);
        }
        this.verifyMessageContent(mbox, msgId, false, null, null, false, body, contentType);
        this.verifyMessageContent(mbox, msgId, true, null, null, false, body, contentType);
        this.verifyMessageContent(mbox, msgId, false, 24, 24, true, body, contentType);
        this.verifyMessageContent(mbox, msgId, true, 24, 24, true, body, contentType);
        TestUtil.setServerAttr("zimbraMailContentMaxSize", "24");
        this.verifyMessageContent(mbox, msgId, false, null, 24, true, body, contentType);
        this.verifyMessageContent(mbox, msgId, true, null, 24, true, body, contentType);
    }

    private void verifyMessageContent(ZMailbox mbox, String msgId, boolean wantHtml, Integer requestMaxLength, Integer expectedLength, boolean expectedTruncated, String body, String contentType) throws Exception {
        ZGetMessageParams params = new ZGetMessageParams();
        params.setId(msgId);
        params.setWantHtml(wantHtml);
        params.setMax(requestMaxLength);
        ZMessage msg = mbox.getMessage(params);
        ZMessage.ZMimePart mp = msg.getMimeStructure();
        TestGetMsg.assertEquals((boolean)expectedTruncated, (boolean)mp.wasTruncated());
        String expected = body;
        if (expectedLength != null) {
            expected = body.substring(0, expectedLength);
        }
        if (contentType.equals("text/enriched")) {
            TestGetMsg.assertTrue((mp.getContent().length() > 0 ? 1 : 0) != 0);
            TestGetMsg.assertTrue((boolean)expected.startsWith(mp.getContent()));
        } else {
            TestGetMsg.assertEquals((String)expected, (String)mp.getContent());
        }
    }

    public void tearDown() throws Exception {
        this.cleanUp();
        TestUtil.setServerAttr("zimbraMailContentMaxSize", this.mOriginalContentMaxSize);
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestGetMsg.class);
    }
}

