/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.gal.GalConstants;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;

public class TestGal
extends TestCase {
    private String TEST_ID = TestProvisioningUtil.genTestId();
    private static String TEST_NAME = "test-gal";
    private static String PASSWORD = "test123";
    private static String ACCT_NAME_PREFIX;
    private static String QUERY;
    private static int NUM_ACCOUNTS;
    private static int MAX_PAGE_SIZE;
    private static int UNLIMITED;
    private static int LIMITED;
    private static int LDAP_SERVER_SIZE_LIMIT;
    private String DOMAIN_NAME = TestProvisioningUtil.baseDomainName(TEST_NAME, null);
    private String TOKENIZE_TEST_DOMAIN_NAME = TestProvisioningUtil.baseDomainName(TEST_NAME + "-tokenize", null);
    private Provisioning mProv = Provisioning.getInstance();
    private boolean DEBUG = true;
    private boolean SKIP_ACCT_CHECKING = false;
    private static final boolean SOAP_PROV = false;

    private String acctName(int index) {
        return ACCT_NAME_PREFIX + "-" + index + "@" + this.DOMAIN_NAME;
    }

    private void setupDomain(String domainName, String domainBaseDn) throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, domainName);
        if (domain == null) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("zimbraGalLdapURL", "ldap://localhost:389");
            attrs.put("zimbraGalLdapBindDn", LC.zimbra_ldap_userdn.value());
            attrs.put("zimbraGalLdapBindPassword", LC.zimbra_ldap_password.value());
            attrs.put("zimbraGalLdapSearchBase", domainBaseDn);
            attrs.put("zimbraGalLdapFilter", "zimbraAccounts");
            attrs.put("zimbraGalSyncLdapURL", "ldap://localhost:389");
            attrs.put("zimbraGalSyncLdapBindDn", LC.zimbra_ldap_userdn.value());
            attrs.put("zimbraGalSyncLdapBindPassword", LC.zimbra_ldap_password.value());
            attrs.put("zimbraGalSyncLdapSearchBase", domainBaseDn);
            attrs.put("zimbraGalSyncLdapFilter", "zimbraAccounts");
            domain = this.mProv.createDomain(domainName, attrs);
        }
        TestGal.assertNotNull((Object)domain);
        TestGal.assertEquals((String)domain.getAttr("zimbraGalLdapURL"), (String)"ldap://localhost:389");
        TestGal.assertEquals((String)domain.getAttr("zimbraGalLdapBindDn"), (String)LC.zimbra_ldap_userdn.value());
        TestGal.assertEquals((String)domain.getAttr("zimbraGalLdapBindPassword"), (String)LC.zimbra_ldap_password.value());
        TestGal.assertEquals((String)domain.getAttr("zimbraGalLdapSearchBase"), (String)domainBaseDn);
        TestGal.assertEquals((String)domain.getAttr("zimbraGalLdapFilter"), (String)"zimbraAccounts");
        TestGal.assertEquals((String)domain.getAttr("zimbraGalSyncLdapURL"), (String)"ldap://localhost:389");
        TestGal.assertEquals((String)domain.getAttr("zimbraGalSyncLdapBindDn"), (String)LC.zimbra_ldap_userdn.value());
        TestGal.assertEquals((String)domain.getAttr("zimbraGalSyncLdapBindPassword"), (String)LC.zimbra_ldap_password.value());
        TestGal.assertEquals((String)domain.getAttr("zimbraGalSyncLdapSearchBase"), (String)domainBaseDn);
        TestGal.assertEquals((String)domain.getAttr("zimbraGalSyncLdapFilter"), (String)"zimbraAccounts");
        this.setupTokenize(domainName, null, null);
        domain = this.mProv.get(Provisioning.DomainBy.name, domainName);
        TestGal.assertNotNull((Object)domain);
        TestGal.assertEquals((String)domain.getAttr("zimbraGalTokenizeAutoCompleteKey"), null);
        TestGal.assertEquals((String)domain.getAttr("zimbraGalTokenizeSearchKey"), null);
    }

    private void createAccount(String userName, String firstName, String lastName) throws Exception {
        Account acct;
        String acctName = userName + "@" + this.TOKENIZE_TEST_DOMAIN_NAME;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (firstName != null) {
            attrs.put("givenName", firstName);
        }
        if (lastName != null) {
            attrs.put("sn", lastName);
        }
        if ((acct = this.mProv.get(Provisioning.AccountBy.name, acctName)) == null) {
            acct = this.mProv.createAccount(acctName, PASSWORD, attrs);
        }
        TestGal.assertEquals((String)acct.getName(), (String)acctName);
        if (firstName != null) {
            TestGal.assertEquals((String)acct.getAttr("givenName"), (String)firstName);
        }
        if (lastName != null) {
            TestGal.assertEquals((String)acct.getAttr("sn"), (String)lastName);
        }
    }

    public TestGal() throws Exception {
        this.setupDomain(this.DOMAIN_NAME, "dc=test-gal,dc=ldaptest");
        if (this.SKIP_ACCT_CHECKING) {
            return;
        }
        for (int i = 0; i < NUM_ACCOUNTS; ++i) {
            String acctName = this.acctName(i);
            Account acct = this.mProv.get(Provisioning.AccountBy.name, acctName);
            if (acct == null) {
                acct = this.mProv.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
            }
            TestGal.assertNotNull((Object)acct);
            if ((i + 1) % 100 != 0) continue;
            System.out.println("Created/checked " + (i + 1) + " accounts");
        }
        this.setupDomain(this.TOKENIZE_TEST_DOMAIN_NAME, "dc=test-gal-tokenize,dc=ldaptest");
        this.createAccount("user1", "phoebe", "shao");
        this.createAccount("user2", "phoebe shao", null);
        this.createAccount("user3", null, "phoebe shao");
    }

    private void setupAutoComplete(Provisioning.GalMode galMode, int pageSize) throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME);
        TestGal.assertNotNull((Object)domain);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalMode", galMode.toString());
        attrs.put("zimbraGalLdapPageSize", "" + pageSize);
        attrs.put("zimbraGalMaxResults", "" + TestGal.more(NUM_ACCOUNTS));
        this.mProv.modifyAttrs(domain, attrs);
    }

    private void setupSearch(Provisioning.GalMode galMode, int pageSize, int domainLimit) throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME);
        TestGal.assertNotNull((Object)domain);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalMode", galMode.toString());
        attrs.put("zimbraGalLdapPageSize", "" + pageSize);
        attrs.put("zimbraGalMaxResults", "" + domainLimit);
        this.mProv.modifyAttrs(domain, attrs);
    }

    private void setupSync(Provisioning.GalMode galMode, int pageSize, int domainLimit) throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME);
        TestGal.assertNotNull((Object)domain);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalMode", galMode.toString());
        attrs.put("zimbraGalSyncLdapPageSize", "" + pageSize);
        attrs.put("zimbraGalMaxResults", "" + domainLimit);
        this.mProv.modifyAttrs(domain, attrs);
    }

    private static int less(int number) {
        TestGal.assertFalse((UNLIMITED == number ? 1 : 0) != 0);
        return number / 2;
    }

    private static int more(int number) {
        TestGal.assertFalse((UNLIMITED == number ? 1 : 0) != 0);
        return number * 2;
    }

    private void dumpResult(Provisioning.SearchGalResult galResult) throws Exception {
        for (GalContact contact : galResult.getMatches()) {
            System.out.println(contact.getId());
        }
    }

    private void autoCompleteGal(int numResultsExpected, int maxWanted) throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME);
        Provisioning.SearchGalResult galResult = this.mProv.autoCompleteGal(domain, QUERY, Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT, maxWanted);
        if (numResultsExpected != galResult.getNumMatches()) {
            this.dumpResult(galResult);
        }
        TestGal.assertEquals((int)numResultsExpected, (int)galResult.getNumMatches());
        boolean expectedHasMore = numResultsExpected < NUM_ACCOUNTS;
        TestGal.assertEquals((boolean)expectedHasMore, (boolean)galResult.getHadMore());
    }

    private void searchGal(int numResultsExpected) throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME);
        Provisioning.SearchGalResult galResult = this.mProv.searchGal(domain, QUERY, Provisioning.GAL_SEARCH_TYPE.ALL, null);
        TestGal.assertEquals((int)numResultsExpected, (int)galResult.getNumMatches());
        boolean expectedHasMore = numResultsExpected < NUM_ACCOUNTS;
        TestGal.assertEquals((boolean)expectedHasMore, (boolean)galResult.getHadMore());
    }

    private String syncGal(int numResultsExpected, int numTotal, String token) throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME);
        Provisioning.SearchGalResult galResult = this.mProv.searchGal(domain, QUERY, Provisioning.GAL_SEARCH_TYPE.ALL, token);
        TestGal.assertEquals((int)numResultsExpected, (int)galResult.getNumMatches());
        boolean expectedHasMore = numResultsExpected < numTotal;
        TestGal.assertEquals((boolean)expectedHasMore, (boolean)galResult.getHadMore());
        return galResult.getToken();
    }

    private void syncGal(int numResultsExpected) throws Exception {
        String token = this.syncGal(numResultsExpected, NUM_ACCOUNTS, null);
        TestGal.assertNotNull((Object)token);
        Thread.sleep(1000L);
        int numDelta = NUM_ACCOUNTS / 10;
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotes", "blah");
        for (int i = 0; i < numDelta; ++i) {
            String acctName = this.acctName(i);
            Account acct = this.mProv.get(Provisioning.AccountBy.name, acctName);
            TestGal.assertNotNull((Object)acct);
            this.mProv.modifyAttrs(acct, attrs);
        }
        this.syncGal(numDelta, numDelta, token);
    }

    private void autoCompleteGal(Provisioning.GalMode galMode, int pageSize) throws Exception {
        if (this.DEBUG) {
            System.out.format("autoCompleteGal: %s, page size = %d\n", new Object[]{galMode, pageSize});
        }
        this.setupAutoComplete(galMode, pageSize);
        if (LDAP_SERVER_SIZE_LIMIT == UNLIMITED) {
            this.autoCompleteGal(NUM_ACCOUNTS, UNLIMITED);
            this.autoCompleteGal(NUM_ACCOUNTS, TestGal.more(NUM_ACCOUNTS));
            this.autoCompleteGal(TestGal.less(NUM_ACCOUNTS), TestGal.less(NUM_ACCOUNTS));
        } else {
            this.autoCompleteGal(LDAP_SERVER_SIZE_LIMIT, UNLIMITED);
            this.autoCompleteGal(LDAP_SERVER_SIZE_LIMIT, TestGal.more(LDAP_SERVER_SIZE_LIMIT));
            this.autoCompleteGal(TestGal.less(LDAP_SERVER_SIZE_LIMIT), TestGal.less(LDAP_SERVER_SIZE_LIMIT));
        }
    }

    private void searchGal(Provisioning.GalMode galMode, int pageSize) throws Exception {
        if (this.DEBUG) {
            System.out.format("searchGal: %s, page size = %d\n", new Object[]{galMode, pageSize});
        }
        if (LDAP_SERVER_SIZE_LIMIT == UNLIMITED) {
            this.setupSearch(galMode, pageSize, UNLIMITED);
            this.searchGal(NUM_ACCOUNTS);
            this.setupSearch(galMode, pageSize, TestGal.more(NUM_ACCOUNTS));
            this.searchGal(NUM_ACCOUNTS);
            this.setupSearch(galMode, pageSize, TestGal.less(NUM_ACCOUNTS));
            this.searchGal(TestGal.less(NUM_ACCOUNTS));
        } else {
            this.setupSearch(galMode, pageSize, LDAP_SERVER_SIZE_LIMIT);
            this.searchGal(LDAP_SERVER_SIZE_LIMIT);
            this.setupSearch(galMode, pageSize, TestGal.more(LDAP_SERVER_SIZE_LIMIT));
            this.searchGal(LDAP_SERVER_SIZE_LIMIT);
            this.setupSearch(galMode, pageSize, TestGal.less(LDAP_SERVER_SIZE_LIMIT));
            this.searchGal(TestGal.less(LDAP_SERVER_SIZE_LIMIT));
        }
    }

    private void syncGal(Provisioning.GalMode galMode, int pageSize) throws Exception {
        if (this.DEBUG) {
            System.out.format("syncGal: %s, page size = %d\n", new Object[]{galMode, pageSize});
        }
        if (LDAP_SERVER_SIZE_LIMIT == UNLIMITED) {
            this.setupSync(galMode, pageSize, UNLIMITED);
            this.syncGal(NUM_ACCOUNTS);
            this.setupSync(galMode, pageSize, TestGal.more(NUM_ACCOUNTS));
            this.syncGal(NUM_ACCOUNTS);
            this.setupSync(galMode, pageSize, TestGal.less(NUM_ACCOUNTS));
            this.syncGal(TestGal.less(NUM_ACCOUNTS));
        } else {
            this.setupSync(galMode, pageSize, LDAP_SERVER_SIZE_LIMIT);
            this.syncGal(LDAP_SERVER_SIZE_LIMIT);
            this.setupSync(galMode, pageSize, TestGal.more(LDAP_SERVER_SIZE_LIMIT));
            this.syncGal(LDAP_SERVER_SIZE_LIMIT);
            this.setupSync(galMode, pageSize, TestGal.less(LDAP_SERVER_SIZE_LIMIT));
            this.syncGal(TestGal.less(LDAP_SERVER_SIZE_LIMIT));
        }
    }

    public void autoCompleteGal(Provisioning.GalMode galMode) throws Exception {
        PageSizeEnum pse = new PageSizeEnum();
        while (pse.hasNext()) {
            this.autoCompleteGal(galMode, pse.next());
        }
    }

    public void searchGal(Provisioning.GalMode galMode) throws Exception {
        PageSizeEnum pse = new PageSizeEnum();
        while (pse.hasNext()) {
            this.searchGal(galMode, pse.next());
        }
    }

    public void syncGal(Provisioning.GalMode galMode) throws Exception {
        PageSizeEnum pse = new PageSizeEnum();
        while (pse.hasNext()) {
            this.syncGal(galMode, pse.next());
        }
    }

    public void testAutoCompleteGal() throws Exception {
        this.autoCompleteGal(Provisioning.GalMode.zimbra);
        this.autoCompleteGal(Provisioning.GalMode.ldap);
    }

    public void testSearchGal() throws Exception {
        this.searchGal(Provisioning.GalMode.zimbra);
        this.searchGal(Provisioning.GalMode.ldap);
    }

    public void testSyncGal() throws Exception {
        this.syncGal(Provisioning.GalMode.zimbra);
        this.syncGal(Provisioning.GalMode.ldap);
    }

    private void setupTokenize(String domainName, Provisioning.GalMode galMode, String andOr) throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, domainName);
        TestGal.assertNotNull((Object)domain);
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (galMode != null) {
            attrs.put("zimbraGalMode", galMode.toString());
        }
        if (andOr == null) {
            attrs.put("zimbraGalTokenizeAutoCompleteKey", "");
            attrs.put("zimbraGalTokenizeSearchKey", "");
        } else {
            attrs.put("zimbraGalTokenizeAutoCompleteKey", andOr);
            attrs.put("zimbraGalTokenizeSearchKey", andOr);
        }
        this.mProv.modifyAttrs(domain, attrs);
    }

    private void tokenizeTest(GalOp galOp, String tokenizeKey, String key, String[] expectedUsers) throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, this.TOKENIZE_TEST_DOMAIN_NAME);
        Provisioning.SearchGalResult galResult = null;
        if (galOp == GalOp.GOP_AUTOCOMPLETE) {
            galResult = this.mProv.autoCompleteGal(domain, key, Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT, 10);
        } else if (galOp == GalOp.GOP_SEARCH) {
            galResult = this.mProv.searchGal(domain, key, Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT, null);
        } else {
            TestGal.fail();
        }
        System.out.println("tokenizeTest: key=" + key);
        TestGal.assertEquals((String)galResult.getTokenizeKey(), (String)tokenizeKey);
        HashSet<String> results = new HashSet<String>();
        for (GalContact gc : galResult.getMatches()) {
            String r = (String)gc.getAttrs().get("email");
            System.out.println("    " + r);
            results.add(r);
        }
        for (String mail : expectedUsers) {
            TestGal.assertTrue((boolean)results.contains(mail + "@" + this.TOKENIZE_TEST_DOMAIN_NAME));
        }
        List<String> expectedUsersList = Arrays.asList(expectedUsers);
        for (String mail : results) {
            TestGal.assertTrue((boolean)expectedUsersList.contains(mail.split("@")[0]));
        }
        TestGal.assertEquals((int)expectedUsers.length, (int)galResult.getNumMatches());
    }

    public void autoCompleteWithTokenizeAND(Provisioning.GalMode galMode) throws Exception {
        this.setupTokenize(this.TOKENIZE_TEST_DOMAIN_NAME, galMode, GalConstants.TOKENIZE_KEY_AND);
        this.tokenizeTest(GalOp.GOP_AUTOCOMPLETE, GalConstants.TOKENIZE_KEY_AND, "phoebe", new String[]{"user1", "user2", "user3"});
        this.tokenizeTest(GalOp.GOP_AUTOCOMPLETE, GalConstants.TOKENIZE_KEY_AND, "shao", new String[]{"user1"});
        this.tokenizeTest(GalOp.GOP_AUTOCOMPLETE, GalConstants.TOKENIZE_KEY_AND, "phoebe shao", new String[]{"user1"});
        this.tokenizeTest(GalOp.GOP_AUTOCOMPLETE, GalConstants.TOKENIZE_KEY_AND, "phoebe blah", new String[0]);
        this.tokenizeTest(GalOp.GOP_AUTOCOMPLETE, GalConstants.TOKENIZE_KEY_AND, "blah shao", new String[0]);
    }

    public void autoCompleteWithTokenizeOR(Provisioning.GalMode galMode) throws Exception {
        this.setupTokenize(this.TOKENIZE_TEST_DOMAIN_NAME, galMode, GalConstants.TOKENIZE_KEY_OR);
        this.tokenizeTest(GalOp.GOP_AUTOCOMPLETE, GalConstants.TOKENIZE_KEY_OR, "phoebe", new String[]{"user1", "user2", "user3"});
        this.tokenizeTest(GalOp.GOP_AUTOCOMPLETE, GalConstants.TOKENIZE_KEY_OR, "shao", new String[]{"user1"});
        this.tokenizeTest(GalOp.GOP_AUTOCOMPLETE, GalConstants.TOKENIZE_KEY_OR, "phoebe shao", new String[]{"user1", "user2", "user3"});
        this.tokenizeTest(GalOp.GOP_AUTOCOMPLETE, GalConstants.TOKENIZE_KEY_OR, "phoebe blah", new String[]{"user1", "user2", "user3"});
        this.tokenizeTest(GalOp.GOP_AUTOCOMPLETE, GalConstants.TOKENIZE_KEY_OR, "blah shao", new String[]{"user1"});
    }

    public void searchWithTokenizeAND(Provisioning.GalMode galMode) throws Exception {
        this.setupTokenize(this.TOKENIZE_TEST_DOMAIN_NAME, galMode, GalConstants.TOKENIZE_KEY_AND);
        this.tokenizeTest(GalOp.GOP_SEARCH, GalConstants.TOKENIZE_KEY_AND, "phoebe", new String[]{"user1", "user2", "user3"});
        this.tokenizeTest(GalOp.GOP_SEARCH, GalConstants.TOKENIZE_KEY_AND, "shao", new String[]{"user1", "user2", "user3"});
        this.tokenizeTest(GalOp.GOP_SEARCH, GalConstants.TOKENIZE_KEY_AND, "phoebe shao", new String[]{"user1", "user2", "user3"});
        this.tokenizeTest(GalOp.GOP_SEARCH, GalConstants.TOKENIZE_KEY_AND, "phoebe blah", new String[0]);
        this.tokenizeTest(GalOp.GOP_SEARCH, GalConstants.TOKENIZE_KEY_AND, "blah shao", new String[0]);
    }

    public void searchWithTokenizeOR(Provisioning.GalMode galMode) throws Exception {
        this.setupTokenize(this.TOKENIZE_TEST_DOMAIN_NAME, galMode, GalConstants.TOKENIZE_KEY_OR);
        this.tokenizeTest(GalOp.GOP_SEARCH, GalConstants.TOKENIZE_KEY_OR, "phoebe", new String[]{"user1", "user2", "user3"});
        this.tokenizeTest(GalOp.GOP_SEARCH, GalConstants.TOKENIZE_KEY_OR, "shao", new String[]{"user1", "user2", "user3"});
        this.tokenizeTest(GalOp.GOP_SEARCH, GalConstants.TOKENIZE_KEY_OR, "phoebe shao", new String[]{"user1", "user2", "user3"});
        this.tokenizeTest(GalOp.GOP_SEARCH, GalConstants.TOKENIZE_KEY_OR, "phoebe blah", new String[]{"user1", "user2", "user3"});
        this.tokenizeTest(GalOp.GOP_SEARCH, GalConstants.TOKENIZE_KEY_OR, "blah shao", new String[]{"user1", "user2", "user3"});
    }

    public void testTokenizeKey() throws Exception {
        this.autoCompleteWithTokenizeAND(Provisioning.GalMode.zimbra);
        this.autoCompleteWithTokenizeAND(Provisioning.GalMode.ldap);
        this.autoCompleteWithTokenizeOR(Provisioning.GalMode.zimbra);
        this.autoCompleteWithTokenizeOR(Provisioning.GalMode.ldap);
        this.searchWithTokenizeAND(Provisioning.GalMode.zimbra);
        this.searchWithTokenizeAND(Provisioning.GalMode.ldap);
        this.searchWithTokenizeOR(Provisioning.GalMode.zimbra);
        this.searchWithTokenizeOR(Provisioning.GalMode.ldap);
    }

    public void disable_testPageSizeEnum() throws Exception {
        PageSizeEnum pse = null;
        LDAP_SERVER_SIZE_LIMIT = LIMITED;
        System.out.println("limited");
        pse = new PageSizeEnum();
        while (pse.hasNext()) {
            System.out.println(pse.next());
        }
        LDAP_SERVER_SIZE_LIMIT = UNLIMITED;
        System.out.println("unlimited");
        pse = new PageSizeEnum();
        while (pse.hasNext()) {
            System.out.println(pse.next());
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            TestUtil.runTest(TestGal.class);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    static /* synthetic */ int access$000() {
        return NUM_ACCOUNTS;
    }

    static /* synthetic */ int access$100(int x0) {
        return TestGal.more(x0);
    }

    static /* synthetic */ int access$200(int x0) {
        return TestGal.less(x0);
    }

    static /* synthetic */ int access$400() {
        return LDAP_SERVER_SIZE_LIMIT;
    }

    static /* synthetic */ int access$500() {
        return UNLIMITED;
    }

    static {
        QUERY = ACCT_NAME_PREFIX = "user";
        NUM_ACCOUNTS = 1000;
        MAX_PAGE_SIZE = 1000;
        UNLIMITED = 0;
        LIMITED = 100;
        LDAP_SERVER_SIZE_LIMIT = UNLIMITED;
        CliUtil.toolSetup();
    }

    class PageSizeEnum {
        int mIdx = 0;
        PageSize[] mEnum = TestGal.access$400() == TestGal.access$500() ? PageSizeLdapServerUnlimited.values() : PageSizeLdapServerLimited.values();

        PageSizeEnum() {
        }

        public boolean hasNext() {
            return this.mIdx < this.mEnum.length;
        }

        public int next() {
            assert (this.mIdx < this.mEnum.length);
            return this.mEnum[this.mIdx++].pageSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PageSizeLdapServerLimited implements PageSize
    {
        PS_UNLIMITED(0),
        PS_MORE_LDAP_SERVER_LIMIT(TestGal.access$100(TestGal.access$400())),
        PS_LESS_LDAP_SERVER_LIMIT(TestGal.access$200(TestGal.access$400()));

        int mPs;

        private PageSizeLdapServerLimited(int ps) {
            if (ps > MAX_PAGE_SIZE) {
                ps = MAX_PAGE_SIZE;
            }
            this.mPs = ps;
        }

        @Override
        public int pageSize() {
            return this.mPs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PageSizeLdapServerUnlimited implements PageSize
    {
        PS_UNLIMITED(0),
        PS_MORE_ACCOUNTS(TestGal.access$100(TestGal.access$000())),
        PS_LESS_ACOUNTS(TestGal.access$200(TestGal.access$000()));

        int mPs;

        private PageSizeLdapServerUnlimited(int ps) {
            if (ps > MAX_PAGE_SIZE) {
                ps = MAX_PAGE_SIZE;
            }
            this.mPs = ps;
        }

        @Override
        public int pageSize() {
            return this.mPs;
        }
    }

    static interface PageSize {
        public int pageSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum GalOp {
        GOP_AUTOCOMPLETE,
        GOP_SEARCH,
        GOP_SYNC;

    }
}

