/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbResults;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.qa.unittest.TestUtil;
import java.util.List;
import junit.framework.TestCase;

public class TestFolders
extends TestCase {
    private Mailbox mMbox;
    private Account mAccount;
    private static String USER_NAME = "user1";
    private static String NAME_PREFIX = "TestFolders";

    protected void setUp() throws Exception {
        super.setUp();
        this.mAccount = TestUtil.getAccount(USER_NAME);
        this.mMbox = MailboxManager.getInstance().getMailboxByAccount(this.mAccount);
        this.cleanUp();
    }

    public void testDeleteParent() throws Exception {
        Folder parent = this.mMbox.createFolder(null, "/" + NAME_PREFIX + " - parent", (byte)0, (byte)-1);
        int parentId = parent.getId();
        Folder child = this.mMbox.createFolder(null, "NAME_PREFIX - child", parent.getId(), (byte)-1, 0, (byte)0, null);
        int childId = child.getId();
        this.mMbox.delete(null, parent.getId(), parent.getType());
        try {
            this.mMbox.getFolderById(null, parentId);
            TestFolders.fail((String)"Parent folder lookup by id should have not succeeded");
        }
        catch (MailServiceException.NoSuchItemException e) {
            // empty catch block
        }
        String sql = "SELECT id FROM " + DbMailItem.getMailItemTableName(this.mMbox) + " WHERE mailbox_id = " + this.mMbox.getId() + " AND id = " + parentId;
        DbResults results = DbUtil.executeQuery(sql);
        TestFolders.assertEquals((String)("Parent folder query returned data.  id=" + parentId), (int)0, (int)results.size());
        try {
            this.mMbox.getFolderById(null, childId);
            TestFolders.fail((String)"Child folder lookup by id should have not succeeded");
        }
        catch (MailServiceException.NoSuchItemException e) {
            // empty catch block
        }
        sql = "SELECT id FROM " + DbMailItem.getMailItemTableName(this.mMbox) + " WHERE mailbox_id = " + this.mMbox.getId() + " AND id = " + childId;
        results = DbUtil.executeQuery(sql);
        TestFolders.assertEquals((String)("Child folder query returned data.  id=" + childId), (int)0, (int)results.size());
    }

    public void testEmptyFolderNonrecursive() throws Exception {
        Folder parent = this.mMbox.createFolder(null, "/" + NAME_PREFIX + " - parent", (byte)0, (byte)-1);
        int parentId = parent.getId();
        Folder child = this.mMbox.createFolder(null, "NAME_PREFIX - child", parent.getId(), (byte)-1, 0, (byte)0, null);
        int childId = child.getId();
        this.mMbox.emptyFolder(null, parent.getId(), false);
        this.mMbox.getFolderById(null, parentId);
        String sql = "SELECT id FROM " + DbMailItem.getMailItemTableName(this.mMbox) + " WHERE mailbox_id = " + this.mMbox.getId() + " AND id = " + parentId;
        DbResults results = DbUtil.executeQuery(sql);
        TestFolders.assertEquals((String)("Parent folder query returned no data.  id=" + parentId), (int)1, (int)results.size());
        this.mMbox.getFolderById(null, childId);
        sql = "SELECT id FROM " + DbMailItem.getMailItemTableName(this.mMbox) + " WHERE mailbox_id = " + this.mMbox.getId() + " AND id = " + childId;
        results = DbUtil.executeQuery(sql);
        TestFolders.assertEquals((String)("Child folder query returned no data.  id=" + childId), (int)1, (int)results.size());
    }

    public void testEmptyFolderRecursive() throws Exception {
        Folder parent = this.mMbox.createFolder(null, "/" + NAME_PREFIX + " - parent", (byte)0, (byte)-1);
        int parentId = parent.getId();
        Folder child = this.mMbox.createFolder(null, "NAME_PREFIX - child", parent.getId(), (byte)-1, 0, (byte)0, null);
        int childId = child.getId();
        this.mMbox.emptyFolder(null, parent.getId(), true);
        this.mMbox.getFolderById(null, parentId);
        String sql = "SELECT id FROM " + DbMailItem.getMailItemTableName(this.mMbox) + " WHERE mailbox_id = " + this.mMbox.getId() + " AND id = " + parentId;
        DbResults results = DbUtil.executeQuery(sql);
        TestFolders.assertEquals((String)("Parent folder query returned no data.  id=" + parentId), (int)1, (int)results.size());
        try {
            this.mMbox.getFolderById(null, childId);
            TestFolders.fail((String)"Child folder lookup by id should have not succeeded");
        }
        catch (MailServiceException.NoSuchItemException e) {
            // empty catch block
        }
        sql = "SELECT id FROM " + DbMailItem.getMailItemTableName(this.mMbox) + " WHERE mailbox_id = " + this.mMbox.getId() + " AND id = " + childId;
        results = DbUtil.executeQuery(sql);
        TestFolders.assertEquals((String)("Child folder query returned data.  id=" + childId), (int)0, (int)results.size());
    }

    public void testManySubfolders() throws Exception {
        int NUM_LEVELS = 20;
        int parentId = 2;
        MailItem top = null;
        for (int i = 1; i <= 20; ++i) {
            Folder folder = this.mMbox.createFolder(null, NAME_PREFIX + i, parentId, (byte)-1, 0, (byte)0, null);
            if (i == 1) {
                top = folder;
            }
            parentId = folder.getId();
        }
        this.mMbox.delete(null, top.getId(), top.getType());
    }

    public void testMarkDeletionTargets() throws Exception {
        String name = NAME_PREFIX + " MDT";
        Message m1 = TestUtil.addMessage(this.mMbox, name);
        ZimbraLog.test.debug("Created message 1, id=" + m1.getId());
        Message m2 = TestUtil.addMessage(this.mMbox, "RE: " + name);
        ZimbraLog.test.debug("Created message 2, id=" + m2.getId());
        Message m3 = TestUtil.addMessage(this.mMbox, "RE: " + name);
        ZimbraLog.test.debug("Created message 3, id=" + m3.getId());
        Folder f = this.mMbox.createFolder(null, name, 2, (byte)-1, 0, (byte)0, null);
        this.mMbox.move(null, m1.getId(), m1.getType(), f.getId());
        this.mMbox.move(null, m2.getId(), m2.getType(), f.getId());
        Conversation conv = this.mMbox.getConversationById(null, m1.getConversationId());
        int convId = conv.getId();
        TestFolders.assertEquals((String)"Conversation size before folder delete", (long)3L, (long)conv.getSize());
        this.mMbox.delete(null, f.getId(), f.getType());
        conv = this.mMbox.getConversationById(null, convId);
        TestFolders.assertEquals((String)"Conversation size after folder delete", (long)1L, (long)conv.getSize());
    }

    public void testHierarchy() throws Exception {
        Folder f1 = this.mMbox.createFolder(null, "/f1", (byte)0, (byte)-1);
        Folder f2 = this.mMbox.createFolder(null, "/f1/f2", (byte)0, (byte)-1);
        this.mMbox.createFolder(null, "/f1/f2/f3", (byte)0, (byte)-1);
        TestFolders.assertEquals((String)"Hierarchy size before delete", (int)3, (int)f1.getSubfolderHierarchy().size());
        this.mMbox.delete(null, f2.getId(), f2.getType());
        List<Folder> hierarchy = f1.getSubfolderHierarchy();
        TestFolders.assertEquals((String)"Hierarchy size after delete", (int)1, (int)hierarchy.size());
        TestFolders.assertEquals((String)"Folder id", (int)f1.getId(), (int)hierarchy.get(0).getId());
    }

    private void cleanUp() throws Exception {
        Folder f;
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
        this.mAccount = TestUtil.getAccount(USER_NAME);
        this.mMbox = MailboxManager.getInstance().getMailboxByAccount(this.mAccount);
        try {
            f = this.mMbox.getFolderByPath(null, "/f1/f2/f3");
            this.mMbox.delete(null, f.getId(), f.getType());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            f = this.mMbox.getFolderByPath(null, "/f1/f2");
            this.mMbox.delete(null, f.getId(), f.getType());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            f = this.mMbox.getFolderByPath(null, "/f1");
            this.mMbox.delete(null, f.getId(), f.getType());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void tearDown() throws Exception {
        this.cleanUp();
        super.tearDown();
    }
}

