/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.zclient.ZFilterRules;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.qa.unittest.TestUtil;
import java.util.List;
import junit.framework.TestCase;

public class TestFolderFilterRules
extends TestCase {
    private static String USER_NAME = "user1";
    private static String NAME_PREFIX = "TestFolderFilterRules";
    private static String FOLDER1_NAME = NAME_PREFIX + "1";
    private static String FOLDER2_NAME = NAME_PREFIX + "2";
    private static String FOLDER3_NAME = NAME_PREFIX + "3";
    private static String FOLDER4_NAME = NAME_PREFIX + "4";
    private static String SUBJECT1 = NAME_PREFIX + " 1";
    private static String SUBJECT2 = NAME_PREFIX + " 2";
    private static String SUBJECT3 = NAME_PREFIX + " 3";
    private static String SUBJECT4 = NAME_PREFIX + " 4";
    private ZFolder mFolder1;
    private ZFolder mFolder2;
    private ZFolder mFolder3;
    private ZFolder mFolder4;
    private ZFilterRules mOriginalRules;
    private static final String FILTER_RULES = StringUtil.join("\n", new String[]{"require [\"fileinto\", \"reject\", \"tag\", \"flag\"];", "", "# Folder 1", "if anyof (header :is \"subject\" \"" + SUBJECT1 + "\" )", "{", "    fileinto \"" + FOLDER1_NAME + "\";", "    stop;", "}", "", "# Folder 2", "if anyof (header :is \"subject\" \"" + SUBJECT2 + "\" )", "{", "    fileinto \"/" + FOLDER1_NAME + "/" + FOLDER2_NAME + "\";", "    stop;", "}", "", "# Folder 3", "if anyof (header :is \"subject\" \"" + SUBJECT3 + "\" )", "{", "    fileinto \"" + FOLDER1_NAME + "/" + FOLDER2_NAME + "/" + FOLDER3_NAME + "\";", "    stop;", "}", "", "# Folder 4", "if anyof (header :is \"subject\" \"" + SUBJECT4 + "\" )", "{", "    fileinto \"/" + FOLDER4_NAME + "\";", "    stop;", "}"});

    public void setUp() throws Exception {
        super.setUp();
        this.cleanUp();
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        this.mFolder1 = TestUtil.createFolder(mbox, FOLDER1_NAME);
        this.mFolder2 = TestUtil.createFolder(mbox, this.mFolder1.getId(), FOLDER2_NAME);
        this.mFolder3 = TestUtil.createFolder(mbox, this.mFolder2.getId(), FOLDER3_NAME);
        this.mFolder4 = TestUtil.createFolder(mbox, FOLDER4_NAME);
        this.mOriginalRules = mbox.getFilterRules();
        TestUtil.setAccountAttr(USER_NAME, "zimbraMailSieveScript", FILTER_RULES);
    }

    public void testDefault() throws Exception {
        this.sendMessages();
    }

    public void testRenameLeaf() throws Exception {
        this.renameFolder(this.mFolder3.getId(), NAME_PREFIX + "New3", null);
        this.sendMessages();
    }

    public void testRenameRoot() throws Exception {
        this.renameFolder(this.mFolder1.getId(), NAME_PREFIX + "New1", null);
        this.sendMessages();
    }

    public void testMoveLeaf() throws Exception {
        this.moveFolder(this.mFolder3.getId(), this.mFolder4.getId());
        this.sendMessages();
    }

    public void testMoveParent() throws Exception {
        this.moveFolder(this.mFolder2.getId(), this.mFolder4.getId());
        this.sendMessages();
    }

    public void testMoveAndRename() throws Exception {
        this.renameFolder(this.mFolder2.getId(), NAME_PREFIX + "New2", this.mFolder4.getId());
        this.sendMessages();
    }

    public void testMoveAndChangeCase() throws Exception {
        String newName = this.mFolder2.getName().toUpperCase();
        this.renameFolder(this.mFolder2.getId(), newName, this.mFolder4.getId());
        this.sendMessages();
    }

    private void sendMessages() throws Exception {
        this.verifyFolderSize(this.mFolder1.getId(), 0);
        TestUtil.addMessageLmtp(SUBJECT1, USER_NAME, USER_NAME);
        this.verifyFolderSize(this.mFolder1.getId(), 1);
        this.verifyFolderSize(this.mFolder2.getId(), 0);
        TestUtil.addMessageLmtp(SUBJECT2, USER_NAME, USER_NAME);
        this.verifyFolderSize(this.mFolder2.getId(), 1);
        this.verifyFolderSize(this.mFolder3.getId(), 0);
        TestUtil.addMessageLmtp(SUBJECT3, USER_NAME, USER_NAME);
        this.verifyFolderSize(this.mFolder3.getId(), 1);
        this.verifyFolderSize(this.mFolder4.getId(), 0);
        TestUtil.addMessageLmtp(SUBJECT4, USER_NAME, USER_NAME);
        this.verifyFolderSize(this.mFolder4.getId(), 1);
    }

    private void verifyFolderSize(String folderId, int size) throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        ZFolder f = mbox.getFolderById(folderId);
        List<ZMessage> messages = TestUtil.search(mbox, "in:" + f.getPath());
        TestFolderFilterRules.assertEquals((String)("Incorrect message count for folder " + f.getPath()), (int)size, (int)messages.size());
    }

    private void renameFolder(String folderId, String newName, String newParentId) throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        ZFolder folder = mbox.getFolderById(folderId);
        String oldPath = folder.getPath();
        if (oldPath.charAt(0) == '/') {
            oldPath = oldPath.substring(1, oldPath.length());
        }
        Account account = TestUtil.getAccount(USER_NAME);
        String script = account.getAttr("zimbraMailSieveScript");
        TestFolderFilterRules.assertTrue((String)("Could not find path " + oldPath + " in script: " + script), (boolean)script.contains(oldPath));
        mbox.renameFolder(folderId, newName, newParentId);
        folder = mbox.getFolderById(folder.getId());
        String newPath = folder.getPath();
        if (newPath.charAt(0) == '/') {
            newPath = newPath.substring(1, newPath.length());
        }
        TestFolderFilterRules.assertEquals((String)newName, (String)folder.getName());
        TestFolderFilterRules.assertTrue((String)("Folder path '" + newPath + "' does not end with " + newName), (boolean)folder.getPath().endsWith(newName));
        account = TestUtil.getAccount(USER_NAME);
        script = account.getAttr("zimbraMailSieveScript");
        TestFolderFilterRules.assertFalse((String)("Found old path '" + oldPath + " in script: " + script), (script.indexOf(oldPath) >= 0 ? 1 : 0) != 0);
        TestFolderFilterRules.assertTrue((String)("Could not find new path '" + newPath + " in script: " + script), (script.indexOf(newPath) >= 0 ? 1 : 0) != 0);
    }

    private void moveFolder(String folderId, String newParentFolderId) throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        ZFolder folder = mbox.getFolderById(folderId);
        ZFolder newParent = mbox.getFolderById(newParentFolderId);
        String newParentPath = newParent.getPath();
        String oldPath = folder.getPath();
        if (oldPath.charAt(0) == '/') {
            oldPath = oldPath.substring(1, oldPath.length());
        }
        Account account = TestUtil.getAccount(USER_NAME);
        String script = account.getAttr("zimbraMailSieveScript");
        TestFolderFilterRules.assertTrue((String)("Could not find path " + oldPath + " in script: " + script), (boolean)script.contains(oldPath));
        mbox.moveFolder(folderId, newParentFolderId);
        folder = mbox.getFolderById(folder.getId());
        String newPath = folder.getPath();
        TestFolderFilterRules.assertFalse((String)("Path '" + oldPath + "' did not change"), (boolean)newPath.equals(oldPath));
        TestFolderFilterRules.assertTrue((String)("Folder path '" + newPath + "' does not start with " + newParentPath), (boolean)folder.getPath().startsWith(newParentPath));
        account = TestUtil.getAccount(USER_NAME);
        script = account.getAttr("zimbraMailSieveScript");
        TestFolderFilterRules.assertFalse((String)("Found old path '" + oldPath + " in script: " + script), (script.indexOf(oldPath) >= 0 ? 1 : 0) != 0);
        TestFolderFilterRules.assertTrue((String)("Could not find new path '" + newPath + " in script: " + script), (script.indexOf(newPath) >= 0 ? 1 : 0) != 0);
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX.toUpperCase());
    }

    protected void tearDown() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        mbox.saveFilterRules(this.mOriginalRules);
        this.cleanUp();
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestFolderFilterRules.class);
    }
}

