/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.acl.FolderACL;
import com.zimbra.cs.memcached.MemcachedConnector;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZGrant;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.qa.unittest.TestUtil;
import junit.framework.TestCase;

public class TestFolderACLCache
extends TestCase {
    String OWNER_ACCT_ID;
    Account USER1;
    Account USER2;
    Account USER3;
    int INBOX_FID;
    int SUB1_FID;
    int SUB2_FID;
    int SUB3_FID;

    public void setUp() throws Exception {
        String sub3Path;
        ZFolder sub3;
        String sub2Path;
        ZFolder sub2;
        Provisioning prov = Provisioning.getInstance();
        Account ownerAcct = prov.get(Provisioning.AccountBy.name, "user1");
        ZMailbox ownerMbx = TestUtil.getZMailbox(ownerAcct.getName());
        ZFolder inbox = ownerMbx.getFolderByPath("inbox");
        String sub1Path = "/inbox/sub1";
        ZFolder sub1 = ownerMbx.getFolderByPath(sub1Path);
        if (sub1 == null) {
            sub1 = TestUtil.createFolder(ownerMbx, sub1Path);
            ownerMbx.modifyFolderGrant(sub1.getId(), ZGrant.GranteeType.usr, "user2", "w", null);
            ownerMbx.modifyFolderGrant(sub1.getId(), ZGrant.GranteeType.usr, "user3", "rw", null);
        }
        if ((sub2 = ownerMbx.getFolderByPath(sub2Path = "/inbox/sub1/sub2")) == null) {
            sub2 = TestUtil.createFolder(ownerMbx, sub2Path);
        }
        if ((sub3 = ownerMbx.getFolderByPath(sub3Path = "/inbox/sub3")) == null) {
            sub3 = TestUtil.createFolder(ownerMbx, sub3Path);
            ownerMbx.modifyFolderGrant(sub3.getId(), ZGrant.GranteeType.pub, null, "r", null);
        }
        this.OWNER_ACCT_ID = ownerAcct.getId();
        this.USER1 = prov.get(Provisioning.AccountBy.name, "user1");
        this.USER2 = prov.get(Provisioning.AccountBy.name, "user2");
        this.USER3 = prov.get(Provisioning.AccountBy.name, "user3");
        this.INBOX_FID = Integer.valueOf(inbox.getId());
        this.SUB1_FID = Integer.valueOf(sub1.getId());
        this.SUB2_FID = Integer.valueOf(sub2.getId());
        this.SUB3_FID = Integer.valueOf(sub3.getId());
    }

    private String formatRights(short rights) {
        return ACL.rightsToString(rights) + "(" + rights + ")";
    }

    private void doTest(Account authedAcct, String ownerAcctId, int targetFolderId, short expectedEffectivePermissions, short needRightsForCanAccessTest, boolean expectedCanAccess) throws ServiceException {
        OperationContext octxt = authedAcct == null ? null : new OperationContext(authedAcct);
        FolderACL folderAcl = new FolderACL(octxt, ownerAcctId, targetFolderId);
        short effectivePermissions = folderAcl.getEffectivePermissions();
        boolean canAccess = folderAcl.canAccess(needRightsForCanAccessTest);
        boolean good = false;
        short actual = effectivePermissions;
        short expected = expectedEffectivePermissions;
        if (actual == -1) {
            actual = ACL.stringToRights(ACL.rightsToString(actual));
        }
        if (expected == -1) {
            expected = ACL.stringToRights(ACL.rightsToString(expected));
        }
        TestFolderACLCache.assertEquals((short)expected, (short)actual);
        TestFolderACLCache.assertEquals((boolean)expectedCanAccess, (boolean)canAccess);
        good = true;
    }

    public void testPublicUser() throws Exception {
        this.doTest(ACL.ANONYMOUS_ACCT, this.OWNER_ACCT_ID, this.INBOX_FID, (short)0, (short)1, false);
        this.doTest(ACL.ANONYMOUS_ACCT, this.OWNER_ACCT_ID, this.SUB1_FID, (short)0, (short)1, false);
        this.doTest(ACL.ANONYMOUS_ACCT, this.OWNER_ACCT_ID, this.SUB2_FID, (short)0, (short)1, false);
        this.doTest(ACL.ANONYMOUS_ACCT, this.OWNER_ACCT_ID, this.SUB3_FID, (short)1, (short)1, true);
        this.doTest(ACL.ANONYMOUS_ACCT, this.OWNER_ACCT_ID, this.SUB3_FID, (short)1, (short)2, false);
    }

    public void testOwner() throws Exception {
        this.doTest(null, this.OWNER_ACCT_ID, this.INBOX_FID, (short)-1, (short)-1, true);
        this.doTest(null, this.OWNER_ACCT_ID, this.SUB1_FID, (short)-1, (short)-1, true);
        this.doTest(null, this.OWNER_ACCT_ID, this.SUB2_FID, (short)-1, (short)-1, true);
        this.doTest(null, this.OWNER_ACCT_ID, this.SUB3_FID, (short)-1, (short)-1, true);
    }

    public void testUser1() throws Exception {
        this.doTest(this.USER1, this.OWNER_ACCT_ID, this.INBOX_FID, (short)-1, (short)-1, true);
        this.doTest(this.USER1, this.OWNER_ACCT_ID, this.SUB1_FID, (short)-1, (short)-1, true);
        this.doTest(this.USER1, this.OWNER_ACCT_ID, this.SUB2_FID, (short)-1, (short)-1, true);
        this.doTest(this.USER1, this.OWNER_ACCT_ID, this.SUB3_FID, (short)-1, (short)-1, true);
    }

    public void testUser2() throws Exception {
        this.doTest(this.USER2, this.OWNER_ACCT_ID, this.INBOX_FID, (short)0, (short)2, false);
        this.doTest(this.USER2, this.OWNER_ACCT_ID, this.SUB1_FID, (short)2, (short)2, true);
        this.doTest(this.USER2, this.OWNER_ACCT_ID, this.SUB2_FID, (short)2, (short)2, true);
        this.doTest(this.USER2, this.OWNER_ACCT_ID, this.SUB3_FID, (short)1, (short)1, true);
        this.doTest(this.USER2, this.OWNER_ACCT_ID, this.SUB3_FID, (short)1, (short)2, false);
    }

    public void testUser3() throws Exception {
        this.doTest(this.USER3, this.OWNER_ACCT_ID, this.INBOX_FID, (short)0, (short)2, false);
        this.doTest(this.USER3, this.OWNER_ACCT_ID, this.SUB1_FID, (short)3, (short)2, true);
        this.doTest(this.USER3, this.OWNER_ACCT_ID, this.SUB2_FID, (short)3, (short)2, true);
        this.doTest(this.USER3, this.OWNER_ACCT_ID, this.SUB3_FID, (short)1, (short)1, true);
        this.doTest(this.USER3, this.OWNER_ACCT_ID, this.SUB3_FID, (short)1, (short)2, false);
    }

    public static void main(String[] args) throws ServiceException {
        DbPool.startup();
        MemcachedConnector.startup();
        CliUtil.toolSetup();
        TestUtil.runTest(TestFolderACLCache.class);
    }
}

