/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.filter.RuleManager;
import com.zimbra.cs.zclient.ZFilterAction;
import com.zimbra.cs.zclient.ZFilterCondition;
import com.zimbra.cs.zclient.ZFilterRule;
import com.zimbra.cs.zclient.ZFilterRules;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.cs.zclient.ZTag;
import com.zimbra.qa.unittest.TestUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFilterExisting
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String NAME_PREFIX = "TestFilterExisting";
    private static final String FOLDER1_NAME = "TestFilterExisting-folder1";
    private static final String FOLDER2_NAME = "TestFilterExisting-folder2";
    private static final String FOLDER3_NAME = "TestFilterExisting-folder3";
    private static final String FOLDER1_PATH = "/TestFilterExisting-folder1";
    private static final String FOLDER2_PATH = "/TestFilterExisting-folder2";
    private static final String FOLDER3_PATH = "/TestFilterExisting-folder3";
    private static final String TAG_NAME = "TestFilterExisting-tag";
    private static final String KEEP_RULE_NAME = "TestFilterExisting keep";
    private static final String TAG_RULE_NAME = "TestFilterExisting tag";
    private static final String FLAG_RULE_NAME = "TestFilterExisting flag";
    private static final String FOLDER1_RULE_NAME = "TestFilterExisting folder1";
    private static final String FOLDER2_RULE_NAME = "TestFilterExisting folder2";
    private static final String FOLDER3_RULE_NAME = "TestFilterExisting folder3";
    private static final String DISCARD_RULE_NAME = "TestFilterExisting discard";
    private static final String REDIRECT_RULE_NAME = "TestFilterExisting redirect";
    private ZFilterRules mOriginalRules;

    public void setUp() throws Exception {
        this.cleanUp();
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        this.mOriginalRules = mbox.getFilterRules();
        this.saveNewRules();
    }

    public void testGetRule() throws Exception {
        String rule1 = "# Rule 1\nabc\n";
        String rule2 = "# Rule 2\ndef\n";
        String script = rule1 + rule2;
        TestFilterExisting.assertEquals((String)rule1, (String)RuleManager.getRuleByName(script, "Rule 1"));
        TestFilterExisting.assertEquals((String)rule2, (String)RuleManager.getRuleByName(script, "Rule 2"));
    }

    public void testKeep() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        String subject = "TestFilterExisting test keep";
        String id = TestUtil.addMessage(mbox, subject);
        String query = "in:inbox subject:\"" + subject + "\"";
        String[] ruleNames = new String[]{KEEP_RULE_NAME};
        Set<String> affectedIds = this.runRules(ruleNames, id, null);
        TestFilterExisting.assertEquals((int)0, (int)affectedIds.size());
        TestUtil.getMessage(mbox, query);
        affectedIds = this.runRules(ruleNames, null, "in:inbox");
        TestFilterExisting.assertEquals((int)0, (int)affectedIds.size());
        TestUtil.getMessage(mbox, query);
        ZFolder folder1 = TestUtil.createFolder(mbox, FOLDER1_PATH);
        mbox.moveMessage(id, folder1.getId());
        affectedIds = this.runRules(ruleNames, id, null);
        TestFilterExisting.assertEquals((int)0, (int)affectedIds.size());
        query = "in:TestFilterExisting-folder1 subject:\"" + subject + "\"";
        TestUtil.getMessage(mbox, query);
        affectedIds = this.runRules(ruleNames, null, "in:TestFilterExisting-folder1");
        TestFilterExisting.assertEquals((int)0, (int)affectedIds.size());
        TestUtil.getMessage(mbox, query);
    }

    public void testFileInto() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        TestUtil.createFolder(mbox, FOLDER1_PATH);
        TestUtil.createFolder(mbox, FOLDER2_PATH);
        String subject = "TestFilterExisting test keep, fileinto folder1 and folder2";
        String id = TestUtil.addMessage(mbox, subject);
        String[] ruleNames = new String[]{FOLDER1_RULE_NAME};
        Set<String> affectedIds = this.runRules(ruleNames, id, null);
        TestFilterExisting.assertEquals((int)1, (int)affectedIds.size());
        TestFilterExisting.assertTrue((boolean)affectedIds.contains(id));
        this.assertMoved("inbox", FOLDER1_NAME, subject);
        ZMessage msg = TestUtil.getMessage(mbox, "in:TestFilterExisting-folder1 subject:\"" + subject + "\"");
        id = msg.getId();
        ruleNames = new String[]{FOLDER2_RULE_NAME};
        affectedIds = this.runRules(ruleNames, null, "in:TestFilterExisting-folder1");
        TestFilterExisting.assertEquals((int)1, (int)affectedIds.size());
        TestFilterExisting.assertTrue((boolean)affectedIds.contains(id));
        this.assertMoved(FOLDER1_NAME, FOLDER2_NAME, subject);
        msg = TestUtil.getMessage(mbox, "in:TestFilterExisting-folder2 subject:\"" + subject + "\"");
        id = msg.getId();
        mbox.moveMessage(id, Integer.toString(2));
        ruleNames = new String[]{KEEP_RULE_NAME, FOLDER1_RULE_NAME, FOLDER2_RULE_NAME};
        affectedIds = this.runRules(ruleNames, id, null);
        TestFilterExisting.assertEquals((int)1, (int)affectedIds.size());
        TestFilterExisting.assertTrue((boolean)affectedIds.contains(id));
        TestUtil.getMessage(mbox, "in:inbox subject:\"" + subject + "\"");
        TestUtil.getMessage(mbox, "in:TestFilterExisting-folder1 subject:\"" + subject + "\"");
        TestUtil.getMessage(mbox, "in:TestFilterExisting-folder2 subject:\"" + subject + "\"");
    }

    public void testTag() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        ZTag tag = mbox.createTag(TAG_NAME, null);
        String subject = "TestFilterExisting test tag";
        String id = TestUtil.addMessage(mbox, subject);
        ZMessage msg = mbox.getMessageById(id);
        Set<String> affectedIds = this.runRules(new String[]{FLAG_RULE_NAME}, id, null);
        TestFilterExisting.assertEquals((int)0, (int)affectedIds.size());
        TestFilterExisting.assertFalse((boolean)msg.hasTags());
        affectedIds = this.runRules(new String[]{TAG_RULE_NAME}, id, null);
        TestFilterExisting.assertEquals((int)1, (int)affectedIds.size());
        TestFilterExisting.assertTrue((boolean)affectedIds.contains(id));
        mbox.noOp();
        msg = mbox.getMessageById(id);
        TestFilterExisting.assertEquals((String)tag.getId(), (String)msg.getTagIds());
    }

    public void testFlag() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        String subject = "TestFilterExisting test flag";
        String id = TestUtil.addMessage(mbox, subject);
        ZMessage msg = mbox.getMessageById(id);
        Set<String> affectedIds = this.runRules(new String[]{TAG_RULE_NAME}, id, null);
        TestFilterExisting.assertEquals((int)0, (int)affectedIds.size());
        TestFilterExisting.assertFalse((boolean)msg.isFlagged());
        affectedIds = this.runRules(new String[]{FLAG_RULE_NAME}, id, null);
        mbox.noOp();
        msg = mbox.getMessageById(id);
        TestFilterExisting.assertTrue((boolean)msg.isFlagged());
    }

    public void testDiscard() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        String subject = "TestFilterExisting test keep, fileinto folder1, and discard";
        String id = TestUtil.addMessage(mbox, subject);
        Set<String> affectedIds = this.runRules(new String[]{KEEP_RULE_NAME, DISCARD_RULE_NAME}, id, null);
        TestFilterExisting.assertEquals((int)0, (int)affectedIds.size());
        TestUtil.getMessage(mbox, "in:inbox subject:\"" + subject + "\"");
        affectedIds = this.runRules(new String[]{DISCARD_RULE_NAME, FOLDER1_RULE_NAME}, id, null);
        this.assertMoved("inbox", FOLDER1_NAME, subject);
        String query = "in:TestFilterExisting-folder1 subject:\"" + subject + "\"";
        ZMessage msg = TestUtil.getMessage(mbox, query);
        affectedIds = this.runRules(new String[]{DISCARD_RULE_NAME}, null, query);
        TestFilterExisting.assertEquals((int)1, (int)affectedIds.size());
        TestFilterExisting.assertTrue((boolean)affectedIds.contains(msg.getId()));
        List<ZMessage> messages = TestUtil.search(mbox, query);
        TestFilterExisting.assertEquals((int)0, (int)messages.size());
    }

    public void testRedirect() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        String subject = "TestFilterExisting test redirect";
        String id = TestUtil.addMessage(mbox, subject);
        String query = "in:inbox subject:\"" + subject + "\"";
        Set<String> affectedIds = this.runRules(new String[]{REDIRECT_RULE_NAME}, id, null);
        TestFilterExisting.assertEquals((int)0, (int)affectedIds.size());
        TestUtil.getMessage(mbox, query);
        ZMailbox mbox2 = TestUtil.getZMailbox("user2");
        TestFilterExisting.assertEquals((int)0, (int)TestUtil.search(mbox2, "in: inbox subject:\"" + subject + "\"").size());
    }

    public void testSimultaneous() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        ArrayList<String> msgIds = new ArrayList<String>();
        for (int i = 1; i <= 10; ++i) {
            msgIds.add(TestUtil.addMessage(mbox, "TestFilterExisting discard flag " + i));
        }
        String idList = StringUtil.join(",", msgIds);
        RunRule runDiscard = new RunRule(DISCARD_RULE_NAME, idList);
        RunRule runFlag = new RunRule(FLAG_RULE_NAME, idList);
        Thread discardThread = new Thread(runDiscard);
        Thread flagThread = new Thread(runFlag);
        discardThread.start();
        flagThread.start();
        discardThread.join();
        flagThread.join();
        Exception e = runDiscard.getError();
        if (e != null) {
            TestFilterExisting.fail((String)e.toString());
        }
        if ((e = runFlag.getError()) != null) {
            TestFilterExisting.fail((String)e.toString());
        }
    }

    public void testFileIntoSameFolder() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        ZFolder folder3 = TestUtil.createFolder(mbox, FOLDER3_PATH);
        String subject = "TestFilterExisting test folder3";
        String id = TestUtil.addMessage(mbox, subject, folder3.getId(), null);
        Set<String> affectedIds = this.runRules(new String[]{FOLDER3_RULE_NAME}, id, null);
        TestFilterExisting.assertEquals((int)0, (int)affectedIds.size());
        TestUtil.getMessage(mbox, "subject:\"" + subject + "\"");
    }

    private void assertMoved(String sourceFolderName, String destFolderName, String subject) throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        List<ZMessage> messages = TestUtil.search(mbox, "in:" + sourceFolderName + " subject:\"" + subject + "\"");
        TestFilterExisting.assertEquals((int)0, (int)messages.size());
        messages = TestUtil.search(mbox, "in:" + destFolderName + " subject:\"" + subject + "\"");
        TestFilterExisting.assertEquals((int)1, (int)messages.size());
    }

    private Set<String> runRules(String[] ruleNames, String idList, String query) throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        Element.XMLElement request = new Element.XMLElement(MailConstants.APPLY_FILTER_RULES_REQUEST);
        Element rulesEl = ((Element)request).addElement("filterRules");
        for (String ruleName : ruleNames) {
            rulesEl.addElement("filterRule").addAttribute("name", ruleName);
        }
        if (idList != null) {
            ((Element)request).addElement("m").addAttribute("ids", idList);
        }
        if (query != null) {
            ((Element)request).addElement("query").setText(query);
        }
        Element response = mbox.invoke(request);
        TreeSet<String> affectedIds = new TreeSet<String>();
        Element msgEl = response.getOptionalElement("m");
        if (msgEl != null) {
            for (String id : msgEl.getAttribute("ids").split(",")) {
                affectedIds.add(id);
            }
        }
        return affectedIds;
    }

    private void saveNewRules() throws Exception {
        ArrayList<ZFilterRule> rules = new ArrayList<ZFilterRule>();
        ArrayList<ZFilterCondition> conditions = new ArrayList<ZFilterCondition>();
        ArrayList<ZFilterAction> actions = new ArrayList<ZFilterAction>();
        conditions.add(new ZFilterCondition.ZHeaderCondition("subject", ZFilterCondition.HeaderOp.CONTAINS, "tag"));
        actions.add(new ZFilterAction.ZTagAction(TAG_NAME));
        rules.add(new ZFilterRule(TAG_RULE_NAME, true, false, conditions, actions));
        conditions = new ArrayList();
        actions = new ArrayList();
        conditions.add(new ZFilterCondition.ZHeaderCondition("subject", ZFilterCondition.HeaderOp.CONTAINS, "flag"));
        actions.add(new ZFilterAction.ZMarkAction(ZFilterAction.MarkOp.FLAGGED));
        rules.add(new ZFilterRule(FLAG_RULE_NAME, true, false, conditions, actions));
        conditions = new ArrayList();
        actions = new ArrayList();
        conditions.add(new ZFilterCondition.ZHeaderCondition("subject", ZFilterCondition.HeaderOp.CONTAINS, "keep"));
        actions.add(new ZFilterAction.ZKeepAction());
        rules.add(new ZFilterRule(KEEP_RULE_NAME, true, false, conditions, actions));
        conditions = new ArrayList();
        actions = new ArrayList();
        conditions.add(new ZFilterCondition.ZHeaderCondition("subject", ZFilterCondition.HeaderOp.CONTAINS, "folder1"));
        actions.add(new ZFilterAction.ZFileIntoAction(FOLDER1_PATH));
        rules.add(new ZFilterRule(FOLDER1_RULE_NAME, true, false, conditions, actions));
        conditions = new ArrayList();
        actions = new ArrayList();
        conditions.add(new ZFilterCondition.ZHeaderCondition("subject", ZFilterCondition.HeaderOp.CONTAINS, "folder2"));
        actions.add(new ZFilterAction.ZFileIntoAction(FOLDER2_PATH));
        rules.add(new ZFilterRule(FOLDER2_RULE_NAME, true, false, conditions, actions));
        conditions = new ArrayList();
        actions = new ArrayList();
        conditions.add(new ZFilterCondition.ZHeaderCondition("subject", ZFilterCondition.HeaderOp.CONTAINS, "folder3"));
        actions.add(new ZFilterAction.ZFileIntoAction(FOLDER3_NAME));
        rules.add(new ZFilterRule(FOLDER3_RULE_NAME, true, false, conditions, actions));
        conditions = new ArrayList();
        actions = new ArrayList();
        conditions.add(new ZFilterCondition.ZHeaderCondition("subject", ZFilterCondition.HeaderOp.CONTAINS, "discard"));
        actions.add(new ZFilterAction.ZDiscardAction());
        rules.add(new ZFilterRule(DISCARD_RULE_NAME, true, false, conditions, actions));
        conditions = new ArrayList();
        actions = new ArrayList();
        conditions.add(new ZFilterCondition.ZHeaderCondition("subject", ZFilterCondition.HeaderOp.CONTAINS, "redirect"));
        actions.add(new ZFilterAction.ZRedirectAction(TestUtil.getAddress("user2")));
        rules.add(new ZFilterRule(REDIRECT_RULE_NAME, true, false, conditions, actions));
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        mbox.saveFilterRules(new ZFilterRules(rules));
    }

    protected void tearDown() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        mbox.saveFilterRules(this.mOriginalRules);
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestFilterExisting.class);
    }

    private class RunRule
    implements Runnable {
        private String mRuleName;
        private String mIdList;
        private Exception mError;

        private RunRule(String ruleName, String idList) {
            this.mRuleName = ruleName;
            this.mIdList = idList;
        }

        public void run() {
            try {
                TestFilterExisting.this.runRules(new String[]{this.mRuleName}, this.mIdList, null);
            }
            catch (Exception e) {
                this.mError = e;
            }
        }

        private Exception getError() {
            return this.mError;
        }
    }
}

