/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.FileUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import junit.framework.TestCase;

public class TestFileUtil
extends TestCase {
    private File TEST_DIR;

    private File genFile(String path, int numBytes) throws Exception {
        File file = new File(path);
        FileOutputStream fos = new FileOutputStream(file);
        byte[] bytes = new byte[numBytes];
        int offset = 0;
        for (int i = 0; i < numBytes; ++i) {
            byte[] src = (String.valueOf(i) + "\n").getBytes();
            if (offset + src.length < numBytes) {
                System.arraycopy(src, 0, bytes, offset, src.length);
                offset += src.length;
                continue;
            }
            while (offset < numBytes) {
                bytes[offset++] = 42;
            }
            break;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteUtil.copy(bais, true, fos, true);
        return file;
    }

    private void printFile(File file) throws Exception {
        String line;
        InputStreamReader isr = new InputStreamReader(new FileInputStream(file));
        BufferedReader reader = new BufferedReader(isr);
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
    }

    private boolean isGzip(File file) throws Exception {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        int header = ((InputStream)is).read() | ((InputStream)is).read() << 8;
        ((InputStream)is).close();
        return header == 35615;
    }

    protected void setUp() throws Exception {
        String tempdir = System.getProperty("java.io.tmpdir");
        this.TEST_DIR = new File(tempdir + "/" + "testFileUtil");
        FileUtil.ensureDirExists(this.TEST_DIR);
    }

    protected void tearDown() throws Exception {
        FileUtil.deleteDir(this.TEST_DIR);
    }

    private File newFile(String fileName) {
        return new File(this.newFileName(fileName));
    }

    private String newFileName(String fileName) {
        return this.TEST_DIR.getAbsolutePath() + "/" + fileName;
    }

    public void testCompress() throws Exception {
        File orig = this.genFile(this.newFileName("junk.txt"), 1024);
        File compressed = this.newFile("junk.compressed");
        FileUtil.compress(orig, compressed, true);
        TestFileUtil.assertTrue((boolean)this.isGzip(compressed));
        File uncompressed = this.newFile("junk.uncompressed");
        FileUtil.uncompress(compressed, uncompressed, true);
        byte[] origBytes = ByteUtil.getContent(orig);
        byte[] uncompressedBytes = ByteUtil.getContent(uncompressed);
        TestFileUtil.assertTrue((boolean)Arrays.equals(origBytes, uncompressedBytes));
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestFileUtil.class);
    }
}

