/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.qa.unittest.TestUtil;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class TestFileUpload
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String NAME_PREFIX = TestFileUpload.class.getSimpleName();

    public void setUp() throws Exception {
        this.cleanUp();
    }

    public void testRequestId() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        URI uri = mbox.getUploadURI();
        HttpClient client = mbox.getHttpClient(uri);
        FilePart attachmentPart = mbox.createAttachmentPart("test.txt", new byte[10]);
        StringPart requestIdPart = new StringPart("requestId", "<script></script>");
        Part[] parts = new Part[]{attachmentPart, requestIdPart};
        PostMethod post = new PostMethod(uri.toString());
        post.setRequestEntity(new MultipartRequestEntity(parts, post.getParams()));
        int statusCode = client.executeMethod(post);
        TestFileUpload.assertEquals((int)200, (int)statusCode);
        String response = post.getResponseBodyAsString();
        TestFileUpload.assertTrue((String)("Response does not contain 'script': " + response), (boolean)response.contains("script"));
        TestFileUpload.assertFalse((String)("Response contains '<script>': " + response), (boolean)response.contains("<script>"));
        post.releaseConnection();
    }

    public void tearDown() throws Exception {
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestFileUpload.class);
    }
}

