/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.EmailUtil;
import com.zimbra.cs.mime.Mime;
import com.zimbra.qa.unittest.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import junit.framework.TestCase;

public class TestEmailUtil
extends TestCase {
    public void testSplit() {
        TestEmailUtil.assertNull((Object)EmailUtil.getLocalPartAndDomain("foo"));
        TestEmailUtil.assertNull((Object)EmailUtil.getLocalPartAndDomain("foo@"));
        TestEmailUtil.assertNull((Object)EmailUtil.getLocalPartAndDomain("@foo"));
        String[] parts = EmailUtil.getLocalPartAndDomain("jspiccoli@example.zimbra.com");
        TestEmailUtil.assertNotNull((Object)parts);
        TestEmailUtil.assertEquals((String)"jspiccoli", (String)parts[0]);
        TestEmailUtil.assertEquals((String)"example.zimbra.com", (String)parts[1]);
    }

    public void testRfc822() throws Exception {
        TestEmailUtil.assertTrue((boolean)this.isRfc822Message("Content-Type: text/plain"));
        TestEmailUtil.assertFalse((boolean)this.isRfc822Message("Content-Type text/plain"));
        TestEmailUtil.assertFalse((boolean)this.isRfc822Message("Content-Type\r\n  :text/plain"));
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i <= 998; ++i) {
            buf.append("X");
        }
        buf.append(": Y");
        TestEmailUtil.assertFalse((boolean)this.isRfc822Message(buf.toString()));
    }

    public void testParseAddressHeader() throws Exception {
        Mime.parseAddressHeader("(Test) <djoe@zimbra.com>,djoe@zimbra.com (Test)");
    }

    private boolean isRfc822Message(String content) throws IOException {
        return EmailUtil.isRfc822Message(new ByteArrayInputStream(content.getBytes()));
    }

    public static void main(String[] args) throws Exception {
        TestUtil.runTest(TestEmailUtil.class);
    }
}

