/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.DateUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.cs.lmtpserver.LmtpProtocolException;
import com.zimbra.qa.unittest.TestLmtp;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class TestDomainStatus
extends TestCase {
    private Provisioning mProv;
    private SoapProvisioning mSoapProv;
    private SoapProvisioning mSoapProvAdmin;
    private String TEST_ID;
    private static String TEST_NAME = "test-domainstatus";
    private static String PASSWORD = "test123";
    private static String NAMEPREFIX_ACCOUNT = "acct-";
    private String DOMAIN_NAME;
    private static final String NAME_PREFIX = TestLmtp.class.getSimpleName();
    private Account[] mAccts;
    private static HashMap<String, Map<String, String>> sStatusMap = new HashMap();

    public void setUp() throws Exception {
        this.TEST_ID = TestProvisioningUtil.genTestId();
        System.out.println("\nTest " + this.TEST_ID + " setting up...\n");
        this.mSoapProv = new SoapProvisioning();
        this.mSoapProv.soapSetURI(TestUtil.getSoapUrl());
        this.mSoapProvAdmin = new SoapProvisioning();
        this.mSoapProvAdmin.soapSetURI(TestUtil.getAdminSoapUrl());
        this.mSoapProvAdmin.soapZimbraAdminAuthenticate();
        this.mProv = this.mSoapProvAdmin;
        this.DOMAIN_NAME = TestProvisioningUtil.baseDomainName(TEST_NAME, this.TEST_ID);
        this.createDomain(this.DOMAIN_NAME);
        this.mAccts = new Account[AccountStatus.values().length];
        for (AccountStatus as : AccountStatus.values()) {
            Account acct;
            this.mAccts[as.ordinal()] = acct = this.createAccount(this.ACCOUNT_NAME(as), AccountType.ACCT_USER);
            this.mProv.modifyAccountStatus(acct, as.name());
            if (as != AccountStatus.lockout) continue;
            this.lockoutAccount(acct, true);
        }
    }

    private String ACCOUNT_NAME(AccountStatus as) {
        String localPart = NAMEPREFIX_ACCOUNT + as.name();
        return this.ACCOUNT_NAME(localPart);
    }

    private String ACCOUNT_NAME(String localPart) {
        return localPart + "@" + this.DOMAIN_NAME;
    }

    private void createDomain(String domainName) throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Domain domain = this.mProv.createDomain(domainName, attrs);
        TestDomainStatus.assertNotNull((Object)domain);
    }

    private Account createAccount(String accountEmail, AccountType at) throws Exception {
        HashMap<String, Object> acctAttrs = new HashMap<String, Object>();
        if (at == AccountType.ACCT_DOMAIN_ADMIN) {
            acctAttrs.put("zimbraIsDomainAdminAccount", "TRUE");
        } else if (at == AccountType.ACCT_GLOBAL_ADMIN) {
            acctAttrs.put("zimbraIsAdminAccount", "TRUE");
        }
        Account acct = this.mProv.createAccount(accountEmail, PASSWORD, acctAttrs);
        TestDomainStatus.assertNotNull((Object)acct);
        return acct;
    }

    private Domain getDomain() throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME);
        TestDomainStatus.assertNotNull((Object)domain);
        return domain;
    }

    private Account getAccount(AccountStatus as) throws Exception {
        return this.mAccts[as.ordinal()];
    }

    private String expectedAccountStatus(String domainStatus, String acctStatus) throws Exception {
        return sStatusMap.get(domainStatus).get(acctStatus);
    }

    private void lockoutAccount(Account acct, boolean set) throws Exception {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (set) {
            attrs.put("zimbraPasswordLockoutMaxFailures", "1");
            attrs.put("zimbraPasswordLockoutEnabled", "TRUE");
            attrs.put("zimbraPasswordLockoutLockedTime", DateUtil.toGeneralizedTime(new Date()));
            this.mProv.modifyAttrs(acct, attrs);
        } else {
            attrs.put("zimbraPasswordLockoutMaxFailures", "");
            attrs.put("-zimbraPasswordLockoutEnabled", "TRUE");
            attrs.put("zimbraPasswordLockoutLockedTime", "");
            this.mProv.modifyAttrs(acct, attrs);
        }
    }

    private void authTest(Account acct, String status) {
        boolean ok;
        block10: {
            ok = false;
            try {
                this.mProv.authAccount(acct, PASSWORD, AuthContext.Protocol.test);
                if (status.equals("active")) {
                    ok = true;
                }
            }
            catch (ServiceException e) {
                if (status.equals("active")) {
                    TestDomainStatus.fail();
                }
                if (status.equals("locked")) {
                    if (e.getCode().equals("account.AUTH_FAILED")) {
                        ok = true;
                    }
                }
                if (status.equals("lockout")) {
                    if (e.getCode().equals("account.AUTH_FAILED")) {
                        ok = true;
                    }
                }
                if (status.equals("maintenance")) {
                    if (e.getCode().equals("account.MAINTENANCE_MODE")) {
                        ok = true;
                    }
                }
                if (!status.equals("closed") || !e.getCode().equals("account.AUTH_FAILED")) break block10;
                ok = true;
            }
        }
        TestDomainStatus.assertTrue((boolean)ok);
    }

    private void mailTest(Account acct, String status) throws Exception {
        boolean ok;
        block4: {
            ok = false;
            try {
                TestUtil.addMessageLmtp(NAME_PREFIX + " 1", acct.getName(), "phoebeshao");
                if (status.equals("active") || status.equals("lockout") || status.equals("locked")) {
                    ok = true;
                }
            }
            catch (LmtpProtocolException e) {
                if (status.equals("active") || status.equals("lockout") || status.equals("locked")) {
                    TestDomainStatus.fail();
                }
                if (!status.equals("maintenance") && !status.equals("closed") || !e.getMessage().equals("503 5.5.1 No recipients")) break block4;
                ok = true;
            }
        }
        TestDomainStatus.assertTrue((boolean)ok);
    }

    private void statusTest(Account acct, String domainStatus, String acctStatus) throws Exception {
        String status = this.expectedAccountStatus(domainStatus, acctStatus);
        System.out.println(domainStatus + " " + acctStatus + " => " + status);
        this.authTest(acct, status);
        this.mailTest(acct, status);
    }

    private void statusTest(String domainStatus) throws Exception {
        for (AccountStatus as : AccountStatus.values()) {
            Account acct = this.getAccount(as);
            this.statusTest(acct, domainStatus, as.name());
        }
    }

    private void assertCodeEquals(ServiceException e, String expectedCode) {
        TestDomainStatus.assertEquals((String)e.getCode(), (String)expectedCode);
    }

    private void statusTest() throws Exception {
        Domain domain = this.getDomain();
        for (DomainStatus ds : DomainStatus.values()) {
            HashMap<String, String> attrs;
            String domainStatus = ds.name();
            if (ds == DomainStatus.EMPTY) {
                attrs = new HashMap<String, String>();
                attrs.put("zimbraDomainStatus", "");
                this.mProv.modifyAttrs(domain, attrs);
                domainStatus = DomainStatus.active.name();
            } else {
                attrs = new HashMap();
                attrs.put("zimbraDomainStatus", domainStatus);
                this.mProv.modifyAttrs(domain, attrs);
            }
            this.statusTest(domainStatus);
        }
    }

    String[] createTesters(DomainStatus ds, AccountType at) throws Exception {
        String[] testers = new String[SoapCommands.TesterObjs.values().length];
        String objSuffix = "tester-" + ds.name() + "-" + at.name();
        String name = this.ACCOUNT_NAME("acct-" + objSuffix);
        testers[SoapCommands.TesterObjs.TESTER_ID_ACCOUNT_FOR_DELETE_ACCOUNT_REQUEST.ordinal()] = this.createAccount(name, AccountType.ACCT_USER).getId();
        return testers;
    }

    private void suspendedDomainTest() throws Exception {
        Domain domain = this.getDomain();
        String domainId = domain.getId();
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainStatus", DomainStatus.active.name());
        this.mProv.modifyAttrs(domain, attrs);
        Account user = this.createAccount(this.ACCOUNT_NAME("user"), AccountType.ACCT_USER);
        String[] testersActiveUser = this.createTesters(DomainStatus.active, AccountType.ACCT_USER);
        String[] testersSuspendedUser = this.createTesters(DomainStatus.suspended, AccountType.ACCT_USER);
        SoapClient clientUser = SoapClient.newInstance(user, AccountType.ACCT_USER);
        Account domainAdmin = this.createAccount(this.ACCOUNT_NAME("domain-admin"), AccountType.ACCT_DOMAIN_ADMIN);
        String[] testersActiveDomainAdmin = this.createTesters(DomainStatus.active, AccountType.ACCT_DOMAIN_ADMIN);
        String[] testersSuspendedDomainAdmin = this.createTesters(DomainStatus.suspended, AccountType.ACCT_DOMAIN_ADMIN);
        SoapClient clientDomainAdmin = SoapClient.newInstance(domainAdmin, AccountType.ACCT_DOMAIN_ADMIN);
        Account globalAdmin = this.createAccount(this.ACCOUNT_NAME("global-admin"), AccountType.ACCT_GLOBAL_ADMIN);
        String[] testersActiveGlobalAdmin = this.createTesters(DomainStatus.active, AccountType.ACCT_GLOBAL_ADMIN);
        String[] testersSuspendedGlobalAdmin = this.createTesters(DomainStatus.suspended, AccountType.ACCT_GLOBAL_ADMIN);
        SoapClient clientGlobalAdmin = SoapClient.newInstance(globalAdmin, AccountType.ACCT_GLOBAL_ADMIN);
        attrs.clear();
        attrs.put("zimbraDomainStatus", DomainStatus.suspended.name());
        this.mProv.modifyAttrs(domain, attrs);
        SoapCommands.run(new SoapTestContext(clientUser, AccountType.ACCT_USER, user, true, this.DOMAIN_NAME, domainId, testersSuspendedUser, this.TEST_ID));
        SoapCommands.run(new SoapTestContext(clientDomainAdmin, AccountType.ACCT_DOMAIN_ADMIN, user, true, this.DOMAIN_NAME, domainId, testersSuspendedDomainAdmin, this.TEST_ID));
        SoapCommands.run(new SoapTestContext(clientGlobalAdmin, AccountType.ACCT_GLOBAL_ADMIN, user, true, this.DOMAIN_NAME, domainId, testersSuspendedGlobalAdmin, this.TEST_ID));
        attrs.clear();
        attrs.put("zimbraDomainStatus", DomainStatus.active.name());
        this.mProv.modifyAttrs(domain, attrs);
        SoapCommands.run(new SoapTestContext(clientUser, AccountType.ACCT_USER, user, false, this.DOMAIN_NAME, domainId, testersActiveUser, this.TEST_ID));
        SoapCommands.run(new SoapTestContext(clientDomainAdmin, AccountType.ACCT_DOMAIN_ADMIN, user, false, this.DOMAIN_NAME, domainId, testersActiveDomainAdmin, this.TEST_ID));
        SoapCommands.run(new SoapTestContext(clientGlobalAdmin, AccountType.ACCT_GLOBAL_ADMIN, user, false, this.DOMAIN_NAME, domainId, testersActiveGlobalAdmin, this.TEST_ID));
    }

    private void execute() throws Exception {
        this.suspendedDomainTest();
    }

    public void testDomainStatus() throws Exception {
        try {
            System.out.println("\nTest " + this.TEST_ID + " starting\n");
            this.execute();
            System.out.println("\nTest " + this.TEST_ID + " done!");
        }
        catch (ServiceException e) {
            Throwable cause = e.getCause();
            System.out.println("ERROR: " + e.getCode() + " (" + e.getMessage() + ")" + (cause == null ? "" : " (cause: " + cause.getClass().getName() + " " + cause.getMessage() + ")"));
            e.printStackTrace(System.out);
            System.out.println("\nTest " + this.TEST_ID + " failed!");
        }
        catch (AssertionFailedError e) {
            System.out.println("\n===== assertion failed =====");
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup();
        TestUtil.runTest(TestDomainStatus.class);
    }

    static {
        HashMap<String, String> domainActive = new HashMap<String, String>();
        domainActive.put("active", "active");
        domainActive.put("lockout", "lockout");
        domainActive.put("locked", "locked");
        domainActive.put("maintenance", "maintenance");
        domainActive.put("closed", "closed");
        HashMap<String, String> domainLocked = new HashMap<String, String>();
        domainLocked.put("active", "locked");
        domainLocked.put("lockout", "locked");
        domainLocked.put("locked", "locked");
        domainLocked.put("maintenance", "maintenance");
        domainLocked.put("closed", "closed");
        HashMap<String, String> domainMaintenance = new HashMap<String, String>();
        domainMaintenance.put("active", "maintenance");
        domainMaintenance.put("lockout", "maintenance");
        domainMaintenance.put("locked", "maintenance");
        domainMaintenance.put("maintenance", "maintenance");
        domainMaintenance.put("closed", "closed");
        HashMap<String, String> domainSuspended = new HashMap<String, String>();
        domainSuspended.put("active", "maintenance");
        domainSuspended.put("lockout", "maintenance");
        domainSuspended.put("locked", "maintenance");
        domainSuspended.put("maintenance", "maintenance");
        domainSuspended.put("closed", "closed");
        HashMap<String, String> domainClosed = new HashMap<String, String>();
        domainClosed.put("active", "closed");
        domainClosed.put("lockout", "closed");
        domainClosed.put("locked", "closed");
        domainClosed.put("maintenance", "closed");
        domainClosed.put("closed", "closed");
        sStatusMap.put("active", domainActive);
        sStatusMap.put("locked", domainLocked);
        sStatusMap.put("maintenance", domainMaintenance);
        sStatusMap.put("suspended", domainSuspended);
        sStatusMap.put("closed", domainClosed);
    }

    private static class SoapClient
    extends SoapProvisioning {
        private SoapClient() {
        }

        private void soapAuthenticate(String name, String password) throws ServiceException {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.AUTH_REQUEST);
            Element a = req.addElement("account");
            a.addAttribute("by", "name");
            a.setText(name);
            req.addElement("password").setText(password);
            Element response = this.invoke(req);
            String authToken = response.getElement("authToken").getText();
            this.setAuthToken(new ZAuthToken(authToken));
        }

        static SoapClient newInstance(Account acct, AccountType at) throws Exception {
            SoapClient soapClient = new SoapClient();
            if (at == AccountType.ACCT_USER) {
                soapClient.soapSetURI(TestUtil.getAdminSoapUrl());
                soapClient.soapAuthenticate(acct.getName(), PASSWORD);
            } else {
                soapClient.soapSetURI(TestUtil.getAdminSoapUrl());
                soapClient.soapAdminAuthenticate(acct.getName(), PASSWORD);
            }
            return soapClient;
        }

        protected synchronized Element invokeOnTargetAccount(Element request, String targetId) throws ServiceException {
            return super.invokeOnTargetAccount(request, targetId);
        }
    }

    static class SoapCommands {
        private SoapTestContext mCtx;
        private Map<String, String> mSignatureNameIdMap;

        SoapCommands(SoapTestContext ctx) {
            this.mCtx = ctx;
            this.mSignatureNameIdMap = new HashMap<String, String>();
        }

        private String testCtxId() {
            return this.mCtx.mAuthedAcctType.name() + "-" + (this.mCtx.mSuspended ? "suspended" : "active");
        }

        private String identityName() {
            return "identity-of-" + this.testCtxId();
        }

        private String signatureName() {
            return "signature-of-" + this.testCtxId();
        }

        private String accountName() {
            return "acct-created-by-" + this.testCtxId() + "@" + this.mCtx.mDomainName;
        }

        private String aliasName() {
            return "alias-created-by-" + this.testCtxId() + "@" + this.mCtx.mDomainName;
        }

        private String domainName() {
            return "domain-created-by-" + this.testCtxId() + "." + this.mCtx.mDomainName;
        }

        private String cosName() {
            String cosName = "cos-created-by-" + this.testCtxId() + "-" + this.mCtx.mTestId;
            return cosName.replace("_", "-");
        }

        public void AUTH_REQUEST() throws Exception {
            this.mCtx.mSoapClient.authAccount(this.mCtx.mTargetAcct, PASSWORD, AuthContext.Protocol.test);
        }

        public void CHANGE_PASSWORD_REQUEST() throws Exception {
            this.mCtx.mSoapClient.changePassword(this.mCtx.mTargetAcct, PASSWORD, PASSWORD);
        }

        public void GET_PREFS_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_PREFS_REQUEST);
            this.mCtx.mSoapClient.invoke(req);
        }

        public void MODIFY_PREFS_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.MODIFY_PREFS_REQUEST);
            Element p = req.addElement("pref");
            p.addAttribute("name", "zimbraPrefSkin");
            p.setText("sand");
            this.mCtx.mSoapClient.invoke(req);
        }

        public void GET_INFO_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_INFO_REQUEST);
            this.mCtx.mSoapClient.invoke(req);
        }

        public void GET_ACCOUNT_INFO_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_ACCOUNT_INFO_REQUEST);
            Element a = req.addElement("account");
            a.addAttribute("by", "name");
            a.setText(this.mCtx.mTargetAcct.getName());
            this.mCtx.mSoapClient.invokeOnTargetAccount(req, this.mCtx.mTargetAcct.getId());
        }

        public void SEARCH_GAL_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.SEARCH_GAL_REQUEST);
            Element n = req.addElement("name");
            n.setText("foo");
            this.mCtx.mSoapClient.invoke(req);
        }

        public void AUTO_COMPLETE_GAL_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.AUTO_COMPLETE_GAL_REQUEST);
            req.addAttribute("limit", "20");
            Element n = req.addElement("name");
            n.setText("foo");
            this.mCtx.mSoapClient.invoke(req);
        }

        public void SYNC_GAL_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.SYNC_GAL_REQUEST);
            this.mCtx.mSoapClient.invoke(req);
        }

        public void SEARCH_CALENDAR_RESOURCES_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.SEARCH_CALENDAR_RESOURCES_REQUEST);
            Element sf = req.addElement("searchFilter");
            Element cond = sf.addElement("cond");
            cond.addAttribute("attr", "zimbraCalResType");
            cond.addAttribute("op", "eq");
            cond.addAttribute("value", "Equipment");
            this.mCtx.mSoapClient.invoke(req);
        }

        public void MODIFY_PROPERTIES_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.MODIFY_PROPERTIES_REQUEST);
            this.mCtx.mSoapClient.invoke(req);
        }

        public void GET_ALL_LOCALES_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_ALL_LOCALES_REQUEST);
            this.mCtx.mSoapClient.invoke(req);
        }

        public void GET_AVAILABLE_LOCALES_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_AVAILABLE_LOCALES_REQUEST);
            this.mCtx.mSoapClient.invoke(req);
        }

        public void GET_AVAILABLE_SKINS_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_AVAILABLE_SKINS_REQUEST);
            this.mCtx.mSoapClient.invoke(req);
        }

        public void CREATE_IDENTITY_REQUEST() throws Exception {
            this.mCtx.mSoapClient.createIdentity(this.mCtx.mTargetAcct, this.identityName(), new HashMap<String, Object>());
        }

        public void MODIFY_IDENTITY_REQUEST() throws Exception {
            this.mCtx.mSoapClient.modifyIdentity(this.mCtx.mTargetAcct, this.identityName(), new HashMap<String, Object>());
        }

        public void DELETE_IDENTITY_REQUEST() throws Exception {
            this.mCtx.mSoapClient.deleteIdentity(this.mCtx.mTargetAcct, this.identityName());
        }

        public void GET_IDENTITIES_REQUEST() throws Exception {
            this.mCtx.mSoapClient.getAllIdentities(this.mCtx.mTargetAcct);
        }

        public void CREATE_SIGNATURE_REQUEST() throws Exception {
            Signature sig = this.mCtx.mSoapClient.createSignature(this.mCtx.mTargetAcct, this.signatureName(), new HashMap<String, Object>());
            this.mSignatureNameIdMap.put(sig.getName(), sig.getId());
        }

        public void MODIFY_SIGNATURE_REQUEST() throws Exception {
            String sigId = this.mSignatureNameIdMap.get(this.signatureName());
            this.mCtx.mSoapClient.modifySignature(this.mCtx.mTargetAcct, sigId, new HashMap<String, Object>());
        }

        public void DELETE_SIGNATURE_REQUEST() throws Exception {
            String sigId = this.mSignatureNameIdMap.get(this.signatureName());
            this.mCtx.mSoapClient.deleteSignature(this.mCtx.mTargetAcct, sigId);
        }

        public void GET_SIGNATURES_REQUEST() throws Exception {
            this.mCtx.mSoapClient.getAllSignatures(this.mCtx.mTargetAcct);
        }

        public void PING_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.PING_REQUEST);
            this.mCtx.mSoapClient.invoke(req);
        }

        public void CHECK_HEALTH_REQUEST() throws Exception {
            this.mCtx.mSoapClient.healthCheck();
        }

        public void ADMIN_AUTH_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
            req.addElement("name").setText(this.mCtx.mTargetAcct.getName());
            req.addElement("password").setText(PASSWORD);
            this.mCtx.mSoapClient.invoke(req);
        }

        public void CREATE_ACCOUNT_REQUEST() throws Exception {
            Account acct = this.mCtx.mSoapClient.createAccount(this.accountName(), PASSWORD, null);
        }

        public void DELEGATE_AUTH_REQUEST() throws Exception {
            SoapProvisioning.DelegateAuthResponse r = this.mCtx.mSoapClient.delegateAuth(Provisioning.AccountBy.name, this.mCtx.mTargetAcct.getName(), 0);
        }

        public void GET_ACCOUNT_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ACCOUNT_REQUEST);
            Element a = req.addElement("account");
            a.addAttribute("by", "name");
            a.setText(this.mCtx.mTargetAcct.getName());
            this.mCtx.mSoapClient.invokeOnTargetAccount(req, this.mCtx.mTargetAcct.getId());
        }

        public void ADMIN_GET_ACCOUNT_INFO_REQUEST() throws Exception {
            this.mCtx.mSoapClient.getAccountInfo(Provisioning.AccountBy.name, this.mCtx.mTargetAcct.getName());
        }

        public void GET_ALL_ACCOUNTS_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_ACCOUNTS_REQUEST);
            Element eDomain = req.addElement("domain");
            eDomain.addAttribute("by", Provisioning.DomainBy.name.name());
            eDomain.setText(this.mCtx.mDomainName);
            this.mCtx.mSoapClient.invoke(req);
        }

        public void KNOWNBUG_GET_ALL_ACCOUNTS_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_ACCOUNTS_REQUEST);
            this.mCtx.mSoapClient.invoke(req);
        }

        public void GET_ALL_ADMIN_ACCOUNTS_REQUEST() throws Exception {
            this.mCtx.mSoapClient.getAllAdminAccounts();
        }

        public void MODIFY_ACCOUNT_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.MODIFY_ACCOUNT_REQUEST);
            Element eId = req.addElement("id");
            eId.setText(this.mCtx.mTargetAcct.getId());
            Element eA = req.addElement("a");
            eA.addAttribute("n", "zimbraAttachmentsBlocked");
            this.mCtx.mSoapClient.invoke(req);
        }

        public void DELETE_ACCOUNT_REQUEST() throws Exception {
            this.mCtx.mSoapClient.deleteAccount(this.mCtx.mTesters[TesterObjs.TESTER_ID_ACCOUNT_FOR_DELETE_ACCOUNT_REQUEST.ordinal()]);
        }

        public void SET_PASSWORD_REQUEST() throws Exception {
            this.mCtx.mSoapClient.setPassword(this.mCtx.mTargetAcct, PASSWORD);
        }

        public void CHECK_PASSWORD_STRENGTH_REQUEST() throws Exception {
            this.mCtx.mSoapClient.checkPasswordStrength(this.mCtx.mTargetAcct, PASSWORD);
        }

        public void ADD_ACCOUNT_ALIAS_REQUEST() throws Exception {
            this.mCtx.mSoapClient.addAlias(this.mCtx.mTargetAcct, this.aliasName());
        }

        public void REMOVE_ACCOUNT_ALIAS_REQUEST() throws Exception {
            this.mCtx.mSoapClient.removeAlias(this.mCtx.mTargetAcct, this.aliasName());
        }

        public void CREATE_DOMAIN_REQUEST() throws Exception {
            this.mCtx.mSoapClient.createDomain(this.domainName(), null);
        }

        public void GET_DOMAIN_REQUEST() throws Exception {
            this.mCtx.mSoapClient.get(Provisioning.DomainBy.name, this.mCtx.mDomainName);
        }

        public void GET_DOMAIN_INFO_REQUEST() throws Exception {
            this.mCtx.mSoapClient.getDomainInfo(Provisioning.DomainBy.name, this.mCtx.mDomainName);
        }

        public void GET_ALL_DOMAINS_REQUEST() throws Exception {
            this.mCtx.mSoapClient.getAllDomains();
        }

        public void MODIFY_DOMAIN_REQUEST() throws Exception {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.MODIFY_DOMAIN_REQUEST);
            Element eId = req.addElement("id");
            eId.setText(this.mCtx.mDomainId);
            Element eA = req.addElement("a");
            eA.addAttribute("n", "description").addText("this is a domain");
            this.mCtx.mSoapClient.invoke(req);
        }

        public void DELETE_DOMAIN_REQUEST() throws Exception {
            this.mCtx.mSoapClient.deleteDomain(this.mCtx.mDomainId);
        }

        public void CREATE_COS_REQUEST() throws Exception {
            this.mCtx.mSoapClient.createCos(this.cosName(), null);
        }

        public static void run(SoapTestContext ctx) throws Exception {
            SoapCommands cmds = new SoapCommands(ctx);
            Class<?> cls = cmds.getClass();
            for (Command c : Command.values()) {
                System.out.println((ctx.mSuspended ? "suspended " : "active ") + ctx.mAuthedAcctType.name() + ": " + c.name());
                if (c.mFuncName == null) continue;
                Method method = cls.getMethod(c.mFuncName, new Class[0]);
                Result expectedResult = c.expectedResult(ctx.mSuspended, ctx.mAuthedAcctType);
                Result actualResult = null;
                try {
                    method.invoke((Object)cmds, new Object[0]);
                    actualResult = Result.GOOD;
                }
                catch (InvocationTargetException e) {
                    actualResult = Result.BAD;
                    Throwable te = e.getTargetException();
                    if (te instanceof ServiceException) {
                        ServiceException se = (ServiceException)te;
                        actualResult = Result.toResult(se);
                    }
                    te.printStackTrace();
                }
                if (expectedResult == Result.KNOWN_BUG) continue;
                Assert.assertEquals((String)c.name(), (Object)((Object)expectedResult), (Object)((Object)actualResult));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Command {
            ACCOUNT_FIRST_COMMAND,
            ACCOUNT_AUTH_REQUEST("AUTH_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.MAINTENANCE_MODE, Result.MAINTENANCE_MODE, Result.MAINTENANCE_MODE),
            ACCOUNT_CHANGE_PASSWORD_REQUEST("CHANGE_PASSWORD_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.MAINTENANCE_MODE, Result.MAINTENANCE_MODE, Result.MAINTENANCE_MODE),
            ACCOUNT_GET_PREFS_REQUEST("GET_PREFS_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.GOOD),
            ACCOUNT_MODIFY_PREFS_REQUEST("MODIFY_PREFS_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.GOOD),
            ACCOUNT_GET_INFO_REQUEST("GET_INFO_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.GOOD),
            ACCOUNT_GET_ACCOUNT_INFO_REQUEST("GET_ACCOUNT_INFO_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.ACCOUNT_INACTIVE),
            ACCOUNT_SEARCH_GAL_REQUEST("SEARCH_GAL_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.GOOD),
            ACCOUNT_AUTO_COMPLETE_GAL_REQUEST("AUTO_COMPLETE_GAL_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.GOOD),
            ACCOUNT_SYNC_GAL_REQUEST("SYNC_GAL_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.GOOD),
            ACCOUNT_SEARCH_CALENDAR_RESOURCES_REQUEST("SEARCH_CALENDAR_RESOURCES_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.GOOD),
            ACCOUNT_MODIFY_PROPERTIES_REQUEST("MODIFY_PROPERTIES_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.GOOD),
            ACCOUNT_GET_ALL_LOCALES_REQUEST("GET_ALL_LOCALES_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.GOOD),
            ACCOUNT_GET_AVAILABLE_LOCALES_REQUEST("GET_AVAILABLE_LOCALES_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.GOOD),
            ACCOUNT_GET_AVAILABLE_SKINS_REQUEST("GET_AVAILABLE_SKINS_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.GOOD),
            ACCOUNT_CREATE_IDENTITY_REQUEST("CREATE_IDENTITY_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.ACCOUNT_INACTIVE),
            ACCOUNT_MODIFY_IDENTITY_REQUEST("MODIFY_IDENTITY_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.ACCOUNT_INACTIVE),
            ACCOUNT_DELETE_IDENTITY_REQUEST("DELETE_IDENTITY_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.ACCOUNT_INACTIVE),
            ACCOUNT_GET_IDENTITIES_REQUEST("GET_IDENTITIES_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.ACCOUNT_INACTIVE),
            ACCOUNT_CREATE_SIGNATURE_REQUEST("CREATE_SIGNATURE_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.ACCOUNT_INACTIVE),
            ACCOUNT_MODIFY_SIGNATURE_REQUEST("MODIFY_SIGNATURE_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.ACCOUNT_INACTIVE),
            ACCOUNT_DELETE_SIGNATURE_REQUEST("DELETE_SIGNATURE_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.ACCOUNT_INACTIVE),
            ACCOUNT_GET_SIGNATURES_REQUEST("GET_SIGNATURES_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.AUTH_EXPIRED, Result.AUTH_EXPIRED, Result.ACCOUNT_INACTIVE),
            ACCOUNT_LAST_COMMAND,
            ADMIN_FIRST_COMMAND,
            ADMIN_PING_REQUEST("PING_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.GOOD, Result.GOOD, Result.GOOD),
            ADMIN_CHECK_HEALTH_REQUEST("CHECK_HEALTH_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.GOOD, Result.GOOD, Result.GOOD),
            ADMIN_AUTH_REQUEST("ADMIN_AUTH_REQUEST", Result.PERM_DENIED_1, Result.PERM_DENIED_1, Result.PERM_DENIED_1, Result.MAINTENANCE_MODE, Result.MAINTENANCE_MODE, Result.MAINTENANCE_MODE),
            ADMIN_CREATE_ACCOUNT_REQUEST("CREATE_ACCOUNT_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.PERM_DENIED_3),
            ADMIN_DELEGATE_AUTH_REQUEST("DELEGATE_AUTH_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.PERM_DENIED_3),
            ADMIN_GET_ACCOUNT_REQUEST("GET_ACCOUNT_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.PERM_DENIED_3),
            ADMIN_GET_ACCOUNT_INFO_REQUEST("ADMIN_GET_ACCOUNT_INFO_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.PERM_DENIED_3),
            ADMIN_GET_ALL_ACCOUNTS_REQUEST("GET_ALL_ACCOUNTS_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.PERM_DENIED_3),
            ADMIN_KNOWNBUG_GET_ALL_ACCOUNTS_REQUEST("KNOWNBUG_GET_ALL_ACCOUNTS_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.KNOWN_BUG),
            ADMIN_GET_ALL_ADMIN_ACCOUNTS_REQUEST("GET_ALL_ADMIN_ACCOUNTS_REQUEST", Result.PERM_DENIED_2, Result.PERM_DENIED_2, Result.GOOD, Result.PERM_DENIED_2, Result.PERM_DENIED_2, Result.GOOD),
            ADMIN_MODIFY_ACCOUNT_REQUEST("MODIFY_ACCOUNT_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.PERM_DENIED_3),
            ADMIN_DELETE_ACCOUNT_REQUEST("DELETE_ACCOUNT_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.PERM_DENIED_3),
            ADMIN_SET_PASSWORD_REQUEST("SET_PASSWORD_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.PERM_DENIED_3),
            ADMIN_CHECK_PASSWORD_STRENGTH_REQUEST("CHECK_PASSWORD_STRENGTH_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.PERM_DENIED_3),
            ADMIN_ADD_ACCOUNT_ALIAS_REQUEST("ADD_ACCOUNT_ALIAS_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.PERM_DENIED_3),
            ADMIN_REMOVE_ACCOUNT_ALIAS_REQUEST("REMOVE_ACCOUNT_ALIAS_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.PERM_DENIED_3),
            ADMIN_CREATE_DOMAIN_REQUEST("CREATE_DOMAIN_REQUEST", Result.PERM_DENIED_2, Result.PERM_DENIED_2, Result.GOOD, Result.PERM_DENIED_2, Result.PERM_DENIED_2, Result.GOOD),
            ADMIN_GET_DOMAIN_REQUEST("GET_DOMAIN_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.GOOD),
            ADMIN_GET_DOMAIN_INFO_REQUEST("GET_DOMAIN_INFO_REQUEST", Result.GOOD, Result.GOOD, Result.GOOD, Result.GOOD, Result.GOOD, Result.GOOD),
            ADMIN_GET_ALL_DOMAINS_REQUEST("GET_ALL_DOMAINS_REQUEST", Result.PERM_DENIED_2, Result.PERM_DENIED_2, Result.GOOD, Result.PERM_DENIED_2, Result.PERM_DENIED_2, Result.GOOD),
            ADMIN_MODIFY_DOMAIN_REQUEST("MODIFY_DOMAIN_REQUEST", Result.PERM_DENIED_2, Result.GOOD, Result.GOOD, Result.PERM_DENIED_2, Result.AUTH_EXPIRED, Result.GOOD),
            ADMIN_DELETE_DOMAIN_REQUEST("DELETE_DOMAIN_REQUEST", Result.PERM_DENIED_2, Result.PERM_DENIED_2, Result.DOMAIN_NOT_EMPTY, Result.PERM_DENIED_2, Result.PERM_DENIED_2, Result.DOMAIN_NOT_EMPTY),
            ADMIN_CREATE_COS_REQUEST("CREATE_COS_REQUEST", Result.PERM_DENIED_2, Result.PERM_DENIED_2, Result.GOOD, Result.PERM_DENIED_2, Result.PERM_DENIED_2, Result.GOOD),
            ADMIN_LAST_COMMAND;

            private String mFuncName;
            private Result[][] mExpectedResult;

            private Command() {
            }

            private Command(String funcName, Result activeUser, Result activeDomainAdmin, Result activeGlobalAdmin, Result suspendedUser, Result suspendedDomainAdmin, Result suspendedGlobalAdmin) {
                this.mFuncName = funcName;
                this.mExpectedResult = new Result[2][AccountType.values().length];
                this.mExpectedResult[0][AccountType.ACCT_USER.ordinal()] = activeUser;
                this.mExpectedResult[0][AccountType.ACCT_DOMAIN_ADMIN.ordinal()] = activeDomainAdmin;
                this.mExpectedResult[0][AccountType.ACCT_GLOBAL_ADMIN.ordinal()] = activeGlobalAdmin;
                this.mExpectedResult[1][AccountType.ACCT_USER.ordinal()] = suspendedUser;
                this.mExpectedResult[1][AccountType.ACCT_DOMAIN_ADMIN.ordinal()] = suspendedDomainAdmin;
                this.mExpectedResult[1][AccountType.ACCT_GLOBAL_ADMIN.ordinal()] = suspendedGlobalAdmin;
            }

            Result expectedResult(boolean suspended, AccountType acctType) {
                int idx = suspended ? 1 : 0;
                return this.mExpectedResult[idx][acctType.ordinal()];
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Result {
            GOOD("G_O_O_D", "G_O_O_D"),
            BAD("B_A_D", "B_A_D"),
            KNOWN_BUG("KNOWN_BUG", "KNOWN_BUG"),
            ACCOUNT_INACTIVE("account.ACCOUNT_INACTIVE", "account is not active"),
            AUTH_EXPIRED("service.AUTH_EXPIRED", "auth credentials have expired"),
            DOMAIN_NOT_EMPTY("account.DOMAIN_NOT_EMPTY", "domain not empty"),
            MAINTENANCE_MODE("account.MAINTENANCE_MODE", "account is in maintenance mode"),
            PERM_DENIED_1("service.PERM_DENIED", "permission denied: not an admin account"),
            PERM_DENIED_2("service.PERM_DENIED", "permission denied: need admin token"),
            PERM_DENIED_3("service.PERM_DENIED", "permission denied: domain is suspended");

            String mCode;
            String mMsg;

            private Result(String code, String msg) {
                this.mCode = code;
                this.mMsg = msg;
                R.sMap.put(R.getKey(this.mCode, this.mMsg), this);
            }

            static Result toResult(ServiceException e) {
                String code = e.getCode();
                String msg = e.getMessage();
                Assert.assertNotNull((Object)code);
                Assert.assertNotNull((Object)msg);
                String key = R.getKey(code, msg);
                for (String k : R.sMap.keySet()) {
                    if (!key.startsWith(k)) continue;
                    return R.sMap.get(k);
                }
                Assert.fail((String)("unknow exception " + key));
                return null;
            }

            private static class R {
                static Map<String, Result> sMap = new HashMap<String, Result>();

                private R() {
                }

                static String getKey(String code, String msg) {
                    return "[" + code + "]" + " - " + msg;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TesterObjs {
            TESTER_ID_ACCOUNT_FOR_DELETE_ACCOUNT_REQUEST;

        }
    }

    static class SoapTestContext {
        private SoapClient mSoapClient;
        private AccountType mAuthedAcctType;
        private Account mTargetAcct;
        private boolean mSuspended;
        private String mDomainName;
        private String mDomainId;
        private String[] mTesters;
        private String mTestId;

        SoapTestContext(SoapClient soapClient, AccountType authedAcctType, Account targetAcct, boolean suspended, String domainName, String domainId, String[] testers, String testId) {
            this.mSoapClient = soapClient;
            this.mAuthedAcctType = authedAcctType;
            this.mTargetAcct = targetAcct;
            this.mSuspended = suspended;
            this.mDomainName = domainName;
            this.mDomainId = domainId;
            this.mTesters = testers;
            this.mTestId = testId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AccountType {
        ACCT_USER,
        ACCT_DOMAIN_ADMIN,
        ACCT_GLOBAL_ADMIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AccountStatus {
        active,
        lockout,
        locked,
        maintenance,
        closed;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DomainStatus {
        EMPTY,
        active,
        locked,
        maintenance,
        suspended,
        closed;

    }
}

