/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mime.ParsedDocument;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.qa.unittest.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.List;
import junit.framework.TestCase;

public class TestDocument
extends TestCase {
    private static final String NAME_PREFIX = TestDocument.class.getSimpleName();
    private static final String USER_NAME = "user1";

    public void setUp() throws Exception {
        this.cleanUp();
    }

    public void testDeleteRevisions() throws Exception {
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        String content = "one";
        ParsedDocument pd = new ParsedDocument(new ByteArrayInputStream(content.getBytes()), "testDeleteRevisions.txt", "text/plain", System.currentTimeMillis(), USER_NAME);
        Document doc = mbox.createDocument(null, 16, pd, (byte)8);
        int docId = doc.getId();
        byte type = doc.getType();
        File blobDir = this.getBlobDir(mbox, doc);
        List revisions = mbox.getAllRevisions(null, docId, type);
        TestDocument.assertEquals((int)1, (int)revisions.size());
        TestDocument.assertEquals((int)1, (int)this.getBlobCount(blobDir, docId));
        content = "two";
        pd = new ParsedDocument(new ByteArrayInputStream(content.getBytes()), NAME_PREFIX + "-testDeleteRevisions.txt", "text/plain", System.currentTimeMillis(), USER_NAME);
        doc = mbox.addDocumentRevision(null, docId, pd);
        TestDocument.assertEquals((int)2, (int)mbox.getAllRevisions(null, docId, type).size());
        TestDocument.assertEquals((int)2, (int)this.getBlobCount(blobDir, docId));
        mbox.move(null, doc.getId(), doc.getType(), 3);
        mbox.emptyFolder(null, 3, false);
        TestDocument.assertEquals((int)0, (int)this.getBlobCount(blobDir, docId));
    }

    private int getBlobCount(File dir, int id) throws Exception {
        int count = 0;
        String prefix = id + "-";
        for (File file : dir.listFiles()) {
            if (!file.getName().startsWith(prefix)) continue;
            ++count;
        }
        return count;
    }

    private File getBlobDir(Mailbox mbox, Document doc) throws Exception {
        MailboxBlob mblob = StoreManager.getInstance().getMailboxBlob(doc);
        File blobFile = mblob.getLocalBlob().getFile();
        return blobFile.getParentFile();
    }

    public void tearDown() throws Exception {
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        for (MailItem item : mbox.getItemList(null, (byte)8)) {
            mbox.delete(null, item.getId(), item.getType());
        }
    }
}

