/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.qa.unittest.TestUtil;
import junit.framework.TestCase;

public class TestDbUtil
extends TestCase {
    public void testNormalizeSql() throws Exception {
        String sql = " \t SELECT a, 'b', 1, '', ',', NULL, '\\'' FROM table1\n\nWHERE c IN (1, 2, 3) ";
        String normalized = DbUtil.normalizeSql(sql);
        String expected = "SELECT a, XXX, XXX, XXX, XXX, XXX, XXX FROM tableXXX WHERE c IN (...)";
        TestDbUtil.assertEquals((String)expected, (String)normalized);
    }

    public void testDatabaseExists() throws Exception {
        Mailbox mbox = TestUtil.getMailbox("user1");
        Db db = Db.getInstance();
        String dbName = DbMailbox.getDatabaseName(mbox);
        DbPool.Connection conn = DbPool.getConnection();
        TestDbUtil.assertTrue((String)("Could not find database " + dbName), (boolean)db.databaseExists(conn, dbName));
        TestDbUtil.assertFalse((String)"False positive", (boolean)db.databaseExists(conn, "foobar"));
        DbPool.quietClose(conn);
    }
}

