/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.zclient.ZCalDataSource;
import com.zimbra.cs.zclient.ZDataSource;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZRssDataSource;
import com.zimbra.qa.unittest.TestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;

public class TestDataSource
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String DS_NAME = "TestDataSource";
    private static final String TEST_USER_NAME = "testdatasource";
    private static final String NAME_PREFIX = TestDataSource.class.getSimpleName();
    private String mOriginalAccountPollingInterval;
    private String mOriginalAccountPop3PollingInterval;
    private String mOriginalAccountImapPollingInterval;
    private String mOriginalCosPollingInterval;
    private String mOriginalCosPop3PollingInterval;
    private String mOriginalCosImapPollingInterval;

    public void setUp() throws Exception {
        this.cleanUp();
        Account account = TestUtil.getAccount(USER_NAME);
        Cos cos = account.getCOS();
        this.mOriginalAccountPollingInterval = account.getAttr("zimbraDataSourcePollingInterval", false);
        if (this.mOriginalAccountPollingInterval == null) {
            this.mOriginalAccountPollingInterval = "";
        }
        this.mOriginalAccountPop3PollingInterval = account.getAttr("zimbraDataSourcePop3PollingInterval", false);
        if (this.mOriginalAccountPop3PollingInterval == null) {
            this.mOriginalAccountPop3PollingInterval = "";
        }
        this.mOriginalAccountImapPollingInterval = account.getAttr("zimbraDataSourceImapPollingInterval", false);
        if (this.mOriginalAccountImapPollingInterval == null) {
            this.mOriginalAccountImapPollingInterval = "";
        }
        this.mOriginalCosPollingInterval = cos.getAttr("zimbraDataSourcePollingInterval", "");
        this.mOriginalCosPop3PollingInterval = cos.getAttr("zimbraDataSourcePop3PollingInterval", "");
        this.mOriginalCosImapPollingInterval = cos.getAttr("zimbraDataSourceImapPollingInterval", "");
    }

    public void testPollingInterval() throws Exception {
        Provisioning prov = Provisioning.getInstance();
        Account account = TestUtil.getAccount(USER_NAME);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDataSourceEnabled", "FALSE");
        attrs.put("zimbraDataSourceHost", "testhost");
        attrs.put("zimbraDataSourcePort", "0");
        attrs.put("zimbraDataSourceUsername", "testuser");
        attrs.put("zimbraDataSourcePassword", "testpass");
        attrs.put("zimbraDataSourceFolderId", "1");
        attrs.put("zimbraDataSourceConnectionType", DataSource.ConnectionType.cleartext.toString());
        DataSource ds = prov.createDataSource(account, DataSource.Type.pop3, NAME_PREFIX + " testPollingInterval", attrs);
        TestDataSource.assertNotNull((String)"Min not defined", (Object)account.getAttr("zimbraDataSourceMinPollingInterval"));
        long min = account.getTimeInterval("zimbraDataSourceMinPollingInterval", 0L) / 1000L;
        attrs.clear();
        attrs.put("zimbraDataSourcePollingInterval", Long.toString(min));
        prov.modifyDataSource(account, ds.getId(), attrs);
        attrs.clear();
        attrs.put("zimbraDataSourcePollingInterval", Long.toString(min - 1L));
        try {
            prov.modifyDataSource(account, ds.getId(), attrs);
            TestDataSource.fail((String)"modifyDataSource() was not supposed to succeed");
        }
        catch (ServiceException e) {
            TestDataSource.assertTrue((String)("Unexpected message: " + e.getMessage()), (boolean)e.getMessage().contains("shorter than the allowed minimum"));
        }
    }

    public void testErrorStatus() throws Exception {
        Account account = TestUtil.createAccount(TEST_USER_NAME);
        Provisioning prov = Provisioning.getInstance();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDataSourceEnabled", "TRUE");
        attrs.put("zimbraDataSourceHost", "localhost");
        attrs.put("zimbraDataSourcePort", TestUtil.getServerAttr("zimbraPop3BindPort"));
        attrs.put("zimbraDataSourceUsername", "user2");
        attrs.put("zimbraDataSourcePassword", "test123");
        attrs.put("zimbraDataSourceFolderId", Integer.toString(2));
        attrs.put("zimbraDataSourceConnectionType", DataSource.ConnectionType.cleartext.toString());
        attrs.put("zimbraDataSourceLeaveOnServer", "TRUE");
        DataSource ds = prov.createDataSource(account, DataSource.Type.pop3, DS_NAME, attrs);
        ZMailbox mbox = TestUtil.getZMailbox(TEST_USER_NAME);
        this.confirmErrorStatus(mbox, null);
        ZDataSource zds = TestUtil.getDataSource(mbox, DS_NAME);
        TestUtil.importDataSource(zds, mbox, null, true);
        this.confirmErrorStatus(mbox, null);
        attrs.clear();
        attrs.put("zimbraDataSourcePassword", "bogus");
        prov.modifyDataSource(account, ds.getId(), attrs);
        zds = TestUtil.getDataSource(mbox, DS_NAME);
        long startTimestamp = System.currentTimeMillis() - 1000L;
        TestUtil.importDataSource(zds, mbox, null, false);
        this.confirmErrorStatus(mbox, (Long)startTimestamp);
        attrs.put("zimbraDataSourcePassword", "test123");
        prov.modifyDataSource(account, ds.getId(), attrs);
        this.confirmErrorStatus(mbox, null);
        zds = TestUtil.getDataSource(mbox, DS_NAME);
        startTimestamp = System.currentTimeMillis();
        TestUtil.importDataSource(zds, mbox, null, true);
        this.confirmErrorStatus(mbox, null);
    }

    private void confirmErrorStatus(ZMailbox mbox, Long laterThanTimestamp) throws Exception {
        Element.XMLElement request = new Element.XMLElement(AccountConstants.GET_INFO_REQUEST);
        Element response = mbox.invoke(request);
        Element eDS = response.getElement("dataSources");
        Element ePop3 = null;
        for (Element e : eDS.listElements("pop3")) {
            if (!e.getAttribute("name").equals(DS_NAME)) continue;
            ePop3 = e;
        }
        TestDataSource.assertNotNull((String)("Could not find data source in response: " + response.prettyPrint()), ePop3);
        this.confirmErrorStatus(ePop3, laterThanTimestamp);
        ePop3 = null;
        request = new Element.XMLElement(MailConstants.GET_DATA_SOURCES_REQUEST);
        response = mbox.invoke(request);
        for (Element e : response.listElements("pop3")) {
            if (!e.getAttribute("name").equals(DS_NAME)) continue;
            ePop3 = e;
        }
        TestDataSource.assertNotNull((String)("Could not find data source in response: " + response.prettyPrint()), (Object)ePop3);
        this.confirmErrorStatus(ePop3, laterThanTimestamp);
    }

    private void confirmErrorStatus(Element ePop3, Long timestampBeforeSync) throws Exception {
        if (timestampBeforeSync != null) {
            TestDataSource.assertTrue((ePop3.getElement("lastError").getText().length() > 0 ? 1 : 0) != 0);
            long failingSince = ePop3.getAttributeLong("failingSince") * 1000L;
            long now = System.currentTimeMillis();
            TestDataSource.assertTrue((String)(failingSince + " is earlier than " + timestampBeforeSync), (failingSince >= timestampBeforeSync ? 1 : 0) != 0);
            TestDataSource.assertTrue((String)(failingSince + " is later than " + now), (failingSince < now ? 1 : 0) != 0);
        } else {
            TestDataSource.assertNull((String)"Last error was not reset", (Object)ePop3.getOptionalElement("lastError"));
            TestDataSource.assertNull((String)"Error timestamp was not reset", (Object)ePop3.getAttribute("failingSince", null));
        }
    }

    public void testIsScheduled() throws Exception {
        Provisioning prov = Provisioning.getInstance();
        Account account = TestUtil.getAccount(USER_NAME);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDataSourceEnabled", "FALSE");
        attrs.put("zimbraDataSourceHost", "testhost");
        attrs.put("zimbraDataSourcePort", "0");
        attrs.put("zimbraDataSourceUsername", "testuser");
        attrs.put("zimbraDataSourcePassword", "testpass");
        attrs.put("zimbraDataSourceFolderId", "1");
        attrs.put("zimbraDataSourceConnectionType", DataSource.ConnectionType.cleartext.toString());
        String name = NAME_PREFIX + " testNegativePollingInterval";
        DataSource ds = prov.createDataSource(account, DataSource.Type.pop3, name, attrs);
        ds = account.getDataSourceByName(name);
        TestDataSource.assertFalse((boolean)ds.isScheduled());
        attrs.clear();
        attrs.put("zimbraDataSourcePollingInterval", "0");
        prov.modifyDataSource(account, ds.getId(), attrs);
        ds = account.getDataSourceByName(name);
        TestDataSource.assertFalse((boolean)ds.isScheduled());
        attrs.clear();
        attrs.put("zimbraDataSourcePollingInterval", "365d");
        prov.modifyDataSource(account, ds.getId(), attrs);
        ds = account.getDataSourceByName(name);
        TestDataSource.assertTrue((boolean)ds.isScheduled());
    }

    public void testMigratePollingInterval() throws Exception {
        Account account = TestUtil.getAccount(USER_NAME);
        Cos cos = account.getCOS();
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        ZFolder folder = TestUtil.createFolder(mbox, NAME_PREFIX + " testMigratePollingInterval");
        Provisioning prov = Provisioning.getInstance();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDataSourceEnabled", "FALSE");
        attrs.put("zimbraDataSourceHost", "localhost");
        int port = Integer.parseInt(TestUtil.getServerAttr("zimbraPop3BindPort"));
        attrs.put("zimbraDataSourcePort", Integer.toString(port));
        attrs.put("zimbraDataSourceUsername", "user2");
        attrs.put("zimbraDataSourcePassword", "test123");
        attrs.put("zimbraDataSourceFolderId", folder.getId());
        attrs.put("zimbraDataSourceConnectionType", DataSource.ConnectionType.cleartext.toString());
        String dsName = NAME_PREFIX + " testMigratePollingInterval";
        DataSource ds = prov.createDataSource(account, DataSource.Type.pop3, dsName, attrs);
        account.unsetDataSourcePop3PollingInterval();
        account.unsetDataSourceImapPollingInterval();
        cos.unsetDataSourcePop3PollingInterval();
        cos.unsetDataSourceImapPollingInterval();
        account.setDataSourcePollingInterval("1h");
        cos.setDataSourcePollingInterval("2h");
        ds.getPollingInterval();
        account = TestUtil.getAccount(USER_NAME);
        cos = account.getCOS();
        ds = account.getDataSourceByName(dsName);
        TestDataSource.assertEquals((String)"1h", (String)account.getAttr("zimbraDataSourcePop3PollingInterval"));
        TestDataSource.assertEquals((String)"1h", (String)account.getAttr("zimbraDataSourceImapPollingInterval"));
        TestDataSource.assertEquals((String)"2h", (String)cos.getAttr("zimbraDataSourcePop3PollingInterval"));
        TestDataSource.assertEquals((String)"2h", (String)cos.getAttr("zimbraDataSourceImapPollingInterval"));
    }

    public void testRss() throws Exception {
        ZFolder folder;
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        String parentId = Integer.toString(1);
        String urlString = "http://feeds.theonion.com/theonion/weekly";
        try {
            folder = mbox.createFolder(parentId, NAME_PREFIX + " testRss", null, null, null, urlString);
        }
        catch (ServiceException e) {
            TestDataSource.assertEquals((String)"service.RESOURCE_UNREACHABLE", (String)e.getCode());
            ZimbraLog.test.warn("Unable to test RSS data source for %s: %s.", (Object)urlString, e);
            return;
        }
        ZRssDataSource ds = (ZRssDataSource)this.getDataSource(mbox, folder.getId());
        TestDataSource.assertNotNull((Object)ds);
        String error = mbox.testDataSource(ds);
        if (error != null) {
            ZimbraLog.test.warn("Unable to test RSS data source for %s: %s.", urlString, error);
            return;
        }
        ArrayList<ZDataSource> list = new ArrayList<ZDataSource>();
        list.add(ds);
        mbox.importData(list);
        this.waitForData(mbox, folder);
        mbox.deleteFolder(folder.getId());
        mbox.importData(list);
        ds = (ZRssDataSource)this.getDataSource(mbox, folder.getId());
        TestDataSource.assertNull((Object)ds);
    }

    public void xtestCal() throws Exception {
        ZFolder folder;
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        String parentId = Integer.toString(1);
        String urlString = "http://www.google.com/calendar/ical/k2kh7ncij3s05dog63g0o0n254%40group.calendar.google.com/public/basic.ics";
        try {
            folder = mbox.createFolder(parentId, NAME_PREFIX + " testCal", ZFolder.View.appointment, null, null, urlString);
        }
        catch (ServiceException e) {
            TestDataSource.assertEquals((String)"service.RESOURCE_UNREACHABLE", (String)e.getCode());
            ZimbraLog.test.warn("Unable to test calendar data source for %s: %s", urlString, e.toString());
            return;
        }
        ZCalDataSource ds = (ZCalDataSource)this.getDataSource(mbox, folder.getId());
        TestDataSource.assertNotNull((Object)ds);
        String error = mbox.testDataSource(ds);
        if (error != null) {
            ZimbraLog.test.warn("Unable to test iCal data source for %s: %s.", urlString, error);
            return;
        }
        ArrayList<ZDataSource> list = new ArrayList<ZDataSource>();
        list.add(ds);
        mbox.importData(list);
        this.waitForData(mbox, folder);
        mbox.deleteFolder(folder.getId());
        mbox.importData(list);
        ds = (ZCalDataSource)this.getDataSource(mbox, folder.getId());
        TestDataSource.assertNull((Object)ds);
    }

    private void waitForData(ZMailbox mbox, ZFolder folder) throws Exception {
        for (int i = 1; i <= 10; ++i) {
            mbox.noOp();
            long folderSize = folder.getSize();
            if (folderSize > 0L) {
                return;
            }
            Thread.sleep(500L);
        }
        TestDataSource.fail((String)("No items found in folder " + folder.getPath()));
    }

    private ZDataSource getDataSource(ZMailbox mbox, String folderId) throws ServiceException {
        for (ZDataSource i : mbox.getAllDataSources()) {
            if (!(i instanceof ZRssDataSource) || !((ZRssDataSource)i).getFolderId().equals(folderId)) continue;
            return i;
        }
        return null;
    }

    public void tearDown() throws Exception {
        Account account = TestUtil.getAccount(USER_NAME);
        Cos cos = account.getCOS();
        account.setDataSourcePollingInterval(this.mOriginalAccountPollingInterval);
        account.setDataSourcePop3PollingInterval(this.mOriginalAccountPop3PollingInterval);
        account.setDataSourceImapPollingInterval(this.mOriginalAccountImapPollingInterval);
        cos.setDataSourcePollingInterval(this.mOriginalCosPollingInterval);
        cos.setDataSourcePop3PollingInterval(this.mOriginalCosPop3PollingInterval);
        cos.setDataSourceImapPollingInterval(this.mOriginalCosImapPollingInterval);
        this.cleanUp();
    }

    public void cleanUp() throws Exception {
        TestUtil.deleteAccount(TEST_USER_NAME);
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestDataSource.class);
    }
}

