/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import junit.framework.TestCase;

public class TestCreateAccount
extends TestCase {
    private String TEST_ID = TestProvisioningUtil.genTestId();
    private static String TEST_NAME = "test-accounts";
    private static String PASSWORD = "test123";
    private static int NUM_THREADS = 1;
    private static int NUM_ACCTS_PER_THREAD = 100;
    private String DOMAIN_NAME = null;

    private void setUpDomain() throws Exception {
        Provisioning prov = Provisioning.getInstance();
        TestCreateAccount.assertTrue((boolean)(prov instanceof LdapProvisioning));
        this.DOMAIN_NAME = TestProvisioningUtil.baseDomainName(TEST_NAME, this.TEST_ID);
        Domain domain = prov.createDomain(this.DOMAIN_NAME, new HashMap<String, Object>());
        TestCreateAccount.assertNotNull((Object)domain);
    }

    private void setUpAccounts() throws Exception {
        Provisioning prov = Provisioning.getInstance();
        TestCreateAccount.assertTrue((boolean)(prov instanceof LdapProvisioning));
        this.DOMAIN_NAME = TestProvisioningUtil.baseDomainName(TEST_NAME, null);
        Domain domain = prov.get(Provisioning.DomainBy.name, this.DOMAIN_NAME);
        if (domain != null) {
            return;
        }
        domain = prov.createDomain(this.DOMAIN_NAME, new HashMap<String, Object>());
        TestCreateAccount.assertNotNull((Object)domain);
        for (int i = 0; i < NUM_THREADS; ++i) {
            this.createAccount(prov, i);
        }
    }

    private SoapProvisioning getSoapProv() throws Exception {
        SoapProvisioning sp = new SoapProvisioning();
        String server = LC.zimbra_zmprov_default_soap_server.value();
        int port = LC.zimbra_admin_service_port.intValue();
        sp.soapSetURI(LC.zimbra_admin_service_scheme.value() + server + ":" + port + "/service/admin/soap/");
        sp.soapZimbraAdminAuthenticate();
        return sp;
    }

    private String makeAcctName(int threadIdx, int idx) {
        return "a-" + idx + "-thread-" + threadIdx + "@" + this.DOMAIN_NAME;
    }

    private void createAccount(Provisioning prov, int threadIdx) throws Exception {
        for (int i = 0; i < NUM_ACCTS_PER_THREAD; ++i) {
            String acctName = this.makeAcctName(threadIdx, i);
            try {
                Account acct = prov.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
                TestCreateAccount.assertNotNull((Object)acct);
                System.out.println("createAccount: " + threadIdx + ", " + i);
                continue;
            }
            catch (Exception e) {
                System.out.println("createAccount caught exception: " + threadIdx + ", " + i);
                throw e;
            }
        }
    }

    private void getAccount(int threadIdx) throws Exception {
        SoapProvisioning prov = this.getSoapProv();
        for (int i = 0; i < NUM_ACCTS_PER_THREAD; ++i) {
            System.out.println("getAccount: " + threadIdx + ", " + i);
            String acctName = this.makeAcctName(threadIdx, i);
            Account acct = prov.get(Provisioning.AccountBy.name, acctName);
            TestCreateAccount.assertNotNull((Object)acct);
        }
    }

    public void testCreateAccount() throws Exception {
        this.setUpDomain();
        CliUtil.toolSetup();
        for (int i = 0; i < NUM_THREADS; ++i) {
            TestCreateAccountThread t = new TestCreateAccountThread(i);
            t.start();
        }
    }

    public void xxxtestGetAccount() throws Exception {
        this.setUpAccounts();
        CliUtil.toolSetup();
        for (int i = 0; i < NUM_THREADS; ++i) {
            TestGetAccountThread t = new TestGetAccountThread(i);
            t.start();
        }
    }

    public void xxxtestCreateDomain() throws Exception {
        Provisioning prov = Provisioning.getInstance();
        TestCreateAccount.assertTrue((boolean)(prov instanceof LdapProvisioning));
        String baseDomainName = TestProvisioningUtil.baseDomainName("domaintest", this.TEST_ID);
        int NUM_DOMAINS = 100;
        for (int i = 0; i < NUM_DOMAINS; ++i) {
            String domainName = "d-" + (i + 1) + "." + baseDomainName;
            Domain domain = prov.createDomain(domainName, new HashMap<String, Object>());
            TestCreateAccount.assertNotNull((Object)domain);
        }
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup();
        try {
            TestUtil.runTest(TestCreateAccount.class);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    class TestGetAccountThread
    extends TestThread {
        TestGetAccountThread(int threadIdx) {
            super(threadIdx);
        }

        public void doRun() throws Exception {
            TestCreateAccount.this.getAccount(this.mThreadIdx);
        }
    }

    class TestCreateAccountThread
    extends TestThread {
        TestCreateAccountThread(int threadIdx) {
            super(threadIdx);
        }

        public void doRun() throws Exception {
            SoapProvisioning soapProv = TestCreateAccount.this.getSoapProv();
            TestCreateAccount.this.createAccount(soapProv, this.mThreadIdx);
        }
    }

    abstract class TestThread
    extends Thread {
        protected int mThreadIdx;

        TestThread(int threadIdx) {
            this.mThreadIdx = threadIdx;
        }

        abstract void doRun() throws Exception;

        public void run() {
            try {
                System.out.println("thread " + this.mThreadIdx + " started");
                this.doRun();
            }
            catch (Exception e) {
                System.out.println("thread " + this.mThreadIdx + " caught exception");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

