/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import junit.framework.TestCase;

public class TestCos
extends TestCase {
    Provisioning mProv = Provisioning.getInstance();
    private String DOMAIN_NAME = "test.com";
    private String ACCT_NAME = "user@" + this.DOMAIN_NAME;
    private String COS1_NAME = "cos1";
    private String COS2_NAME = "cos2";
    private String DOMAIN_DEFAULT_COS_NAME = "domain-default-cos";
    private Account ACCT;
    private Cos COS1;
    private Cos COS2;
    private Cos DOMAIN_DEFAULT_COS;
    private long DEFAULT_COS_VALUE = 0L;
    private Domain DOMAIN;
    private String ATTR_NAME = "zimbraMailQuota";
    private long COS1_VALUE = 10000L;
    private long COS2_VALUE = 20000L;
    private long DOMAIN_DEFAULT_COS_VALUE = 30000L;
    private long ACCOUNT_VALUE = 40000L;

    public void setUp() throws Exception {
        this.cleanup();
        this.COS1 = this.createCos(this.COS1_NAME, this.COS1_VALUE);
        this.COS2 = this.createCos(this.COS2_NAME, this.COS2_VALUE);
        this.DOMAIN_DEFAULT_COS = this.createCos(this.DOMAIN_DEFAULT_COS_NAME, this.DOMAIN_DEFAULT_COS_VALUE);
        HashMap<String, Object> domainAttrs = new HashMap<String, Object>();
        domainAttrs.put("zimbraDomainDefaultCOSId", this.DOMAIN_DEFAULT_COS.getId());
        this.DOMAIN = this.mProv.createDomain(this.DOMAIN_NAME, domainAttrs);
        this.ACCT = this.mProv.createAccount(this.ACCT_NAME, "test123", null);
        Cos cos = this.mProv.getCOS(this.ACCT);
    }

    public void tearDown() throws ServiceException {
        this.cleanup();
    }

    private void cleanup() {
        try {
            Cos cos1 = this.mProv.get(Provisioning.CosBy.name, this.COS1_NAME);
            if (cos1 != null) {
                this.mProv.deleteCos(cos1.getId());
            }
        }
        catch (ServiceException e) {
            // empty catch block
        }
        try {
            Cos cos2 = this.mProv.get(Provisioning.CosBy.name, this.COS2_NAME);
            if (cos2 != null) {
                this.mProv.deleteCos(cos2.getId());
            }
        }
        catch (ServiceException e) {
            // empty catch block
        }
        try {
            Cos domainDefaultCos = this.mProv.get(Provisioning.CosBy.name, this.DOMAIN_DEFAULT_COS_NAME);
            if (domainDefaultCos != null) {
                this.mProv.deleteCos(domainDefaultCos.getId());
            }
        }
        catch (ServiceException e) {
            // empty catch block
        }
        try {
            Account acct = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_NAME);
            if (acct != null) {
                this.mProv.deleteAccount(acct.getId());
            }
        }
        catch (ServiceException e) {
            // empty catch block
        }
        try {
            Domain domain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME);
            if (domain != null) {
                this.mProv.deleteDomain(domain.getId());
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    private void reloadAccountIfSoap() throws ServiceException {
        if (this.mProv instanceof SoapProvisioning) {
            this.ACCT = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_NAME);
        }
    }

    public void testDomainCos() throws Exception {
        TestCos.assertEquals((long)this.DOMAIN_DEFAULT_COS_VALUE, (long)this.getAttrValue());
        long newValue = this.DOMAIN_DEFAULT_COS_VALUE - 1L;
        this.modifyCosValue(this.DOMAIN_DEFAULT_COS, newValue);
        this.reloadAccountIfSoap();
        TestCos.assertEquals((long)newValue, (long)this.getAttrValue());
        this.modifyCosValue(this.DOMAIN_DEFAULT_COS, this.DOMAIN_DEFAULT_COS_VALUE);
        this.reloadAccountIfSoap();
        TestCos.assertEquals((long)this.DOMAIN_DEFAULT_COS_VALUE, (long)this.getAttrValue());
        this.modifyDomainDefaultCos(this.COS1);
        TestCos.assertEquals((long)this.DOMAIN_DEFAULT_COS_VALUE, (long)this.getAttrValue());
        this.flushAccountCache();
        TestCos.assertEquals((long)this.COS1_VALUE, (long)this.getAttrValue());
        this.modifyDomainDefaultCos(null);
        TestCos.assertEquals((long)this.COS1_VALUE, (long)this.getAttrValue());
        this.flushAccountCache();
        TestCos.assertEquals((long)this.DEFAULT_COS_VALUE, (long)this.getAttrValue());
    }

    public void testAcctCos() throws ServiceException {
        TestCos.assertEquals((long)this.DOMAIN_DEFAULT_COS_VALUE, (long)this.getAttrValue());
        this.modifyAccountCos(this.COS1);
        TestCos.assertEquals((long)this.COS1_VALUE, (long)this.getAttrValue());
        this.modifyAccountCos(this.COS2);
        TestCos.assertEquals((long)this.COS2_VALUE, (long)this.getAttrValue());
        this.modifyAccountCos(null);
        TestCos.assertEquals((long)this.DOMAIN_DEFAULT_COS_VALUE, (long)this.getAttrValue());
        this.modifyAccountCos(this.COS1);
        TestCos.assertEquals((long)this.COS1_VALUE, (long)this.getAttrValue());
        this.modifyAccountValue("" + this.ACCOUNT_VALUE);
        TestCos.assertEquals((long)this.ACCOUNT_VALUE, (long)this.getAttrValue());
        this.modifyAccountValue("");
        TestCos.assertEquals((long)this.COS1_VALUE, (long)this.getAttrValue());
    }

    private long getAttrValue() {
        return this.ACCT.getLongAttr(this.ATTR_NAME, 0L);
    }

    private Cos createCos(String cosName, long value) throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put(this.ATTR_NAME, "" + value);
        return this.mProv.createCos(cosName, attrs);
    }

    private void modifyCosValue(Cos cos, long newValue) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(this.ATTR_NAME, "" + newValue);
        this.mProv.modifyAttrs(cos, attrs);
    }

    private void modifyAccountValue(String newValue) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(this.ATTR_NAME, newValue);
        this.mProv.modifyAttrs(this.ACCT, attrs);
    }

    private void modifyDomainDefaultCos(Cos cos) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (cos == null) {
            attrs.put("zimbraDomainDefaultCOSId", "");
        } else {
            attrs.put("zimbraDomainDefaultCOSId", cos.getId());
        }
        this.mProv.modifyAttrs(this.DOMAIN, attrs);
    }

    private void modifyAccountCos(Cos cos) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (cos == null) {
            attrs.put("zimbraCOSId", "");
        } else {
            attrs.put("zimbraCOSId", cos.getId());
        }
        this.mProv.modifyAttrs(this.ACCT, attrs);
    }

    private void flushAccountCache() throws ServiceException {
        this.mProv.flushCache(Provisioning.CacheEntryType.account, new Provisioning.CacheEntry[]{new Provisioning.CacheEntry(Provisioning.CacheEntryBy.name, this.ACCT_NAME)});
        this.ACCT = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_NAME);
    }

    public static void main(String[] args) throws ServiceException {
        CliUtil.toolSetup();
        TestUtil.runTest(TestCos.class);
    }
}

