/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeVisitor;
import com.zimbra.qa.unittest.TestUtil;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import junit.framework.TestCase;

public class TestConversion
extends TestCase {
    public void testTnef() throws Exception {
        ZimbraLog.test.debug("testTnef()");
        AttachmentFinder finder = new AttachmentFinder("upload.gif");
        Message msg = this.getTnefMessage();
        finder.accept(msg.getMimeMessage());
        TestConversion.assertTrue((String)"Could not find upload.gif", (boolean)finder.found());
        finder = new AttachmentFinder("upload2.gif");
        finder.accept(msg.getMimeMessage());
        TestConversion.assertTrue((String)"Could not find upload2.gif", (boolean)finder.found());
    }

    private Message getTnefMessage() throws Exception {
        Account account = TestUtil.getAccount("user1");
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        String query = "subject:Rich text (TNEF) test";
        ZimbraQueryResults results = mbox.search(new OperationContext(mbox), query, new byte[]{5}, SortBy.SUBJ_ASCENDING, 100);
        TestConversion.assertTrue((String)("No results found for '" + query + "'"), (boolean)results.hasNext());
        ZimbraHit hit = results.getNext();
        results.doneWithSearchResults();
        return mbox.getMessageById(null, hit.getItemId());
    }

    private class AttachmentFinder
    extends MimeVisitor {
        private String mFilename;
        private boolean mFound = false;

        public AttachmentFinder(String filename) {
            this.mFilename = filename;
        }

        public boolean found() {
            return this.mFound;
        }

        protected boolean visitBodyPart(MimeBodyPart bp) throws MessagingException {
            String filename = Mime.getFilename((MimePart)bp);
            if (filename != null && filename.equals(this.mFilename)) {
                this.mFound = true;
            }
            return false;
        }

        protected boolean visitMessage(MimeMessage msg, MimeVisitor.VisitPhase visitKind) {
            return false;
        }

        protected boolean visitMultipart(MimeMultipart mp, MimeVisitor.VisitPhase visitKind) {
            return false;
        }
    }
}

