/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbResults;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.zclient.ZContact;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.qa.unittest.TestUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import junit.framework.TestCase;
import org.testng.TestNG;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestContacts
extends TestCase {
    private static final String NAME_PREFIX = TestContacts.class.getSimpleName();
    private static final String USER_NAME = "user1";
    String mOriginalMaxContacts;

    @BeforeMethod
    public void setUp() throws Exception {
        this.cleanUp();
        this.mOriginalMaxContacts = TestUtil.getAccountAttr(USER_NAME, "zimbraContactMaxNumEntries");
    }

    @Test(groups={"Server"})
    public void testVolumeId() throws Exception {
        Account account = Provisioning.getInstance().get(Provisioning.AccountBy.name, TestUtil.getAddress(USER_NAME));
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        String sql = String.format("SELECT COUNT(*) FROM %s WHERE type = %d AND blob_digest IS NULL AND volume_id IS NOT NULL", DbMailItem.getMailItemTableName(mbox), (byte)6);
        DbResults results = DbUtil.executeQuery(sql);
        int count = results.getInt(1);
        TestContacts.assertEquals((String)"Found non-null volumeId values for contacts", (int)0, (int)count);
    }

    @Test(groups={"Server"})
    public void testGetAttachmentContent() throws Exception {
        ZMailbox zmbox = TestUtil.getZMailbox(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("fullName", NAME_PREFIX + " testAttachments");
        String attachment1Text = "attachment 1";
        int timeout = 60000;
        String folderId = Integer.toString(7);
        String attachment1Id = zmbox.uploadAttachment("attachment.txt", attachment1Text.getBytes(), "text/plain", timeout);
        HashMap<String, ZMailbox.ZAttachmentInfo> attachmentMap = new HashMap<String, ZMailbox.ZAttachmentInfo>();
        ZMailbox.ZAttachmentInfo info = new ZMailbox.ZAttachmentInfo().setAttachmentId(attachment1Id);
        attachmentMap.put("attachment1", info);
        zmbox.createContact(folderId, null, attrs, attachmentMap);
        Account account = Provisioning.getInstance().get(Provisioning.AccountBy.name, TestUtil.getAddress(USER_NAME));
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        for (Contact contact : mbox.getContactList(null, 7)) {
            List<Contact.Attachment> attachments = contact.getAttachments();
            for (Contact.Attachment attach : attachments) {
                attach.getContent();
            }
        }
    }

    @Test
    public void testMaxContacts() throws Exception {
        int i;
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        List<ZContact> contacts = mbox.getAllContacts(null, ZMailbox.ContactSortBy.nameAsc, false, null);
        int max = contacts.size() + 2;
        TestUtil.setAccountAttr(USER_NAME, "zimbraContactMaxNumEntries", Integer.toString(max));
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (i = 1; i <= 10; ++i) {
            attrs.put("fullName", NAME_PREFIX + " testMaxContacts" + i);
            try {
                mbox.createContact(Integer.toString(7), null, attrs);
                continue;
            }
            catch (SoapFaultException e) {
                TestContacts.assertEquals((String)"mail.TOO_MANY_CONTACTS", (String)e.getCode());
                break;
            }
        }
        TestContacts.assertEquals((String)"Unexpected contact number", (int)3, (int)i);
    }

    @Test
    public void testServerAttachment() throws Exception {
        byte[] data = "test".getBytes();
        ByteArrayDataSource ds = new ByteArrayDataSource(data, "text/plain");
        ds.setName("attachment.txt");
        DataHandler dh = new DataHandler((DataSource)ds);
        Contact.Attachment attach = new Contact.Attachment(dh, "attachment", data.length);
        attach = new Contact.Attachment(dh, "attachment");
        this.checkServerAttachment(data, attach);
        attach = new Contact.Attachment(data, "text/plain", "attachment", "attachment.txt");
        this.checkServerAttachment(data, attach);
    }

    private void checkServerAttachment(byte[] expected, Contact.Attachment attach) throws Exception {
        TestUtil.assertEquals(expected, attach.getContent());
        TestUtil.assertEquals(expected, ByteUtil.getContent(attach.getInputStream(), 4));
        TestContacts.assertEquals((int)expected.length, (int)attach.getSize());
        TestContacts.assertEquals((String)"text/plain", (String)attach.getContentType());
        TestContacts.assertEquals((String)"attachment", (String)attach.getName());
        TestContacts.assertEquals((String)"attachment.txt", (String)attach.getFilename());
    }

    @Test
    public void testContactAttachments() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("fullName", NAME_PREFIX + " testAttachments");
        String attachment1Text = "attachment 1";
        int timeout = 60000;
        String folderId = Integer.toString(7);
        String attachment1Id = mbox.uploadAttachment("attachment.txt", attachment1Text.getBytes(), "text/plain", timeout);
        HashMap<String, ZMailbox.ZAttachmentInfo> attachments = new HashMap<String, ZMailbox.ZAttachmentInfo>();
        ZMailbox.ZAttachmentInfo info = new ZMailbox.ZAttachmentInfo().setAttachmentId(attachment1Id);
        attachments.put("attachment1", info);
        ZContact contact = mbox.createContact(folderId, null, attrs, attachments);
        TestContacts.assertTrue((boolean)contact.getAttachmentNames().contains("attachment1"));
        byte[] data = this.getAttachmentData(contact, "attachment1");
        TestContacts.assertEquals((String)attachment1Text, (String)new String(data));
        String attachment2Text = "attachment 2";
        String attachment2Id = mbox.uploadAttachment("attachment.txt", attachment2Text.getBytes(), "text/plain", timeout);
        attachments.clear();
        info.setAttachmentId(attachment2Id);
        attachments.put("attachment2", info);
        contact = mbox.modifyContact(contact.getId(), false, null, attachments);
        data = this.getAttachmentData(contact, "attachment2");
        TestContacts.assertEquals((String)attachment2Text, (String)new String(data));
        String newAttachment2Text = "new attachment 2";
        String newAttachment2Id = mbox.uploadAttachment("attachment.txt", newAttachment2Text.getBytes(), "text/plain", timeout);
        info.setAttachmentId(newAttachment2Id);
        contact = mbox.modifyContact(contact.getId(), false, null, attachments);
        data = this.getAttachmentData(contact, "attachment2");
        TestContacts.assertEquals((String)newAttachment2Text, (String)new String(data));
        info.setAttachmentId(null);
        info.setPartName(contact.getAttachmentPartName("attachment2"));
        attachments.clear();
        attachments.put("attachment3", info);
        contact = mbox.modifyContact(contact.getId(), false, null, attachments);
        data = this.getAttachmentData(contact, "attachment2");
        TestContacts.assertEquals((String)newAttachment2Text, (String)new String(data));
        data = this.getAttachmentData(contact, "attachment3");
        TestContacts.assertEquals((String)newAttachment2Text, (String)new String(data));
        String attachment4Text = "attachment 4";
        String attachment4Id = mbox.uploadAttachment("attachment.txt", attachment4Text.getBytes(), "text/plain", timeout);
        info.setAttachmentId(attachment4Id);
        info.setPartName(null);
        attachments.clear();
        attachments.put("attachment4", info);
        contact = mbox.modifyContact(contact.getId(), true, attrs, attachments);
        Set<String> names = contact.getAttachmentNames();
        TestContacts.assertEquals((int)1, (int)names.size());
        TestContacts.assertTrue((boolean)names.contains("attachment4"));
        data = this.getAttachmentData(contact, "attachment4");
        TestContacts.assertEquals((String)attachment4Text, (String)new String(data));
        info.setAttachmentId(null);
        contact = mbox.modifyContact(contact.getId(), false, attrs, attachments);
        TestContacts.assertEquals((int)0, (int)contact.getAttachmentNames().size());
        attachment4Id = mbox.uploadAttachment("attachment.txt", attachment4Text.getBytes(), "text/plain", timeout);
        info.setAttachmentId(attachment4Id);
        info.setPartName(null);
        attachments.clear();
        attachments.put("attachment4", info);
        contact = mbox.modifyContact(contact.getId(), false, attrs, attachments);
        names = contact.getAttachmentNames();
        TestContacts.assertEquals((int)1, (int)names.size());
        TestContacts.assertTrue((boolean)names.contains("attachment4"));
        data = this.getAttachmentData(contact, "attachment4");
        TestContacts.assertEquals((String)attachment4Text, (String)new String(data));
    }

    private byte[] getAttachmentData(ZContact contact, String attachmentName) throws Exception {
        InputStream in = contact.getAttachmentData(attachmentName);
        return ByteUtil.getContent(in, 0);
    }

    @AfterMethod
    public void tearDown() throws Exception {
        TestUtil.setAccountAttr(USER_NAME, "zimbraContactMaxNumEntries", this.mOriginalMaxContacts);
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestNG testng = TestUtil.newTestNG();
        testng.setExcludedGroups("Server");
        testng.setTestClasses(new Class[]{TestContacts.class});
        testng.run();
    }
}

