/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DbPool;
import junit.framework.TestCase;

public class TestConnectionPool
extends TestCase {
    public void testPool() throws Exception {
        int initialSize = DbPool.getSize();
        ZimbraLog.test.info("Initial connection pool size: %d", initialSize);
        DbPool.Connection conn1 = DbPool.getConnection();
        TestConnectionPool.assertEquals((String)"After first connection", (int)(initialSize + 1), (int)DbPool.getSize());
        DbPool.Connection conn2 = DbPool.getConnection();
        TestConnectionPool.assertEquals((String)"After second connection", (int)(initialSize + 2), (int)DbPool.getSize());
        DbPool.Connection maint = DbPool.getMaintenanceConnection();
        TestConnectionPool.assertEquals((String)"After maintenance connection", (int)(initialSize + 2), (int)DbPool.getSize());
        DbPool.quietClose(conn1);
        TestConnectionPool.assertEquals((String)"After first close", (int)(initialSize + 1), (int)DbPool.getSize());
        DbPool.quietClose(conn2);
        TestConnectionPool.assertEquals((String)"After second close", (int)initialSize, (int)DbPool.getSize());
        DbPool.quietClose(maint);
        TestConnectionPool.assertEquals((String)"After closing maintenance connection", (int)initialSize, (int)DbPool.getSize());
        ZimbraLog.test.info("Final connection pool size: %d", DbPool.getSize());
    }
}

