/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.client.LmcSession;
import com.zimbra.cs.client.soap.LmcGetMsgRequest;
import com.zimbra.cs.client.soap.LmcMsgActionRequest;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.qa.unittest.TestUtil;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestConcurrency
extends TestCase {
    public static final String TAG_PREFIX = "TestConcurrency";
    public static final String FOLDER_NAME = "TestConcurrency";
    Account mAccount;
    Mailbox mMbox;

    public void setUp() throws Exception {
        this.mAccount = TestUtil.getAccount("user1");
        this.mMbox = MailboxManager.getInstance().getMailboxByAccount(this.mAccount);
        this.cleanUp();
    }

    public void testRead() throws Exception {
        int numThreads = 5;
        Thread[] threads = new Thread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            threads[i] = new Thread((Runnable)new ReadMessagesThread(5), "ReadMessagesThread-" + i);
        }
        this.runThreads(threads);
    }

    public void testTag() throws Exception {
        int numThreads = 5;
        Thread[] threads = new Thread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            Tag tag = this.mMbox.createTag(null, "TestConcurrency" + i + 1, (byte)0);
            threads[i] = new Thread((Runnable)new TagMessagesThread(tag, 5), "TagMessagesThread-" + i);
        }
        this.runThreads(threads);
    }

    public void testReadAndTag() throws Exception {
        int numThreads = 6;
        Thread[] threads = new Thread[numThreads];
        int tagNum = 1;
        for (int i = 0; i < numThreads; i += 2) {
            Tag tag = this.mMbox.createTag(null, "TestConcurrency" + tagNum, (byte)0);
            threads[i] = new Thread((Runnable)new ReadMessagesThread(5), "ReadMessagesThread-" + i);
            threads[i + 1] = new Thread((Runnable)new TagMessagesThread(tag, 5), "TagMessagesThread-" + i);
            ++tagNum;
        }
        this.runThreads(threads);
    }

    public void testReadAndMove() throws Exception {
        int numThreads = 5;
        Thread[] threads = new Thread[numThreads];
        Folder folder = this.mMbox.createFolder(null, "TestConcurrency", 1, (byte)-1, 0, (byte)0, null);
        threads[0] = new Thread(new MoveMessagesThread(folder, 5));
        for (int i = 1; i < numThreads; ++i) {
            threads[i] = new Thread(new ReadMessagesThread(5));
        }
        this.runThreads(threads);
    }

    private void runThreads(Thread[] threads) throws Exception {
        for (int i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        while (true) {
            boolean allDone = true;
            for (int i = 0; i < threads.length; ++i) {
                if (!threads[i].isAlive()) continue;
                allDone = false;
                break;
            }
            if (allDone) {
                return;
            }
            Thread.sleep(50L);
        }
    }

    public void tearDown() throws Exception {
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        Folder folder;
        List<Tag> tagList = this.mMbox.getTagList(null);
        if (tagList != null) {
            for (Tag tag : tagList) {
                if (!tag.getName().startsWith("TestConcurrency")) continue;
                this.mMbox.delete(null, tag.getId(), tag.getType());
            }
        }
        if ((folder = TestUtil.getFolderByPath(this.mMbox, "TestConcurrency")) != null) {
            List ids = this.mMbox.getItemList(null, (byte)5, folder.getId());
            for (Message message : ids) {
                this.mMbox.move(null, message.getId(), (byte)5, 2);
            }
            this.mMbox.delete(null, folder.getId(), folder.getType());
        }
    }

    private class MoveMessagesThread
    implements Runnable {
        Folder mFolder;
        int mNumToMove;

        MoveMessagesThread(Folder folder, int numToMove) {
            this.mFolder = folder;
            this.mNumToMove = numToMove;
        }

        public void run() {
            ZimbraLog.test.debug("Starting MoveMessagesThread");
            int numMoved = 0;
            try {
                LmcSession session = TestUtil.getSoapSession("user1");
                List<Integer> ids = TestUtil.search(TestConcurrency.this.mMbox, "in:inbox", (byte)5);
                for (Integer id : ids) {
                    LmcMsgActionRequest req = new LmcMsgActionRequest();
                    req.setOp("move");
                    req.setMsgList(id.toString());
                    req.setFolder(Integer.toString(this.mFolder.getId()));
                    req.setSession(session);
                    req.invoke(TestUtil.getSoapUrl());
                    if (++numMoved != this.mNumToMove) continue;
                    break;
                }
            }
            catch (Exception e) {
                ZimbraLog.test.error((Object)"Error in MoveMessagesThread", e);
            }
            ZimbraLog.test.debug("MoveMessagesThread moved " + numMoved + " messages");
        }
    }

    private class TagMessagesThread
    implements Runnable {
        Tag mTag;
        int mNumToTag;

        TagMessagesThread(Tag tag, int numToTag) {
            this.mTag = tag;
            this.mNumToTag = numToTag;
        }

        public void run() {
            ZimbraLog.test.debug("Starting TagMessagesThread");
            int numTagged = 0;
            try {
                LmcSession session = TestUtil.getSoapSession("user1");
                List<Integer> ids = TestUtil.search(TestConcurrency.this.mMbox, "in:inbox", (byte)5);
                for (Integer id : ids) {
                    LmcMsgActionRequest req = new LmcMsgActionRequest();
                    req.setOp("tag");
                    req.setMsgList(id.toString());
                    req.setTag(Integer.toString(this.mTag.getId()));
                    req.setSession(session);
                    req.invoke(TestUtil.getSoapUrl());
                    if (++numTagged != this.mNumToTag) continue;
                    break;
                }
            }
            catch (Exception e) {
                ZimbraLog.test.error((Object)"Error in TagMessagesThread", e);
            }
            ZimbraLog.test.debug("TagMessagesThread tagged " + numTagged + " messages");
        }
    }

    private class ReadMessagesThread
    implements Runnable {
        int mNumToRead;

        ReadMessagesThread(int numToRead) {
            this.mNumToRead = numToRead;
        }

        public void run() {
            ZimbraLog.test.debug("Starting ReadMessagesThread");
            int numRead = 0;
            try {
                LmcSession session = TestUtil.getSoapSession("user1");
                List<Integer> ids = TestUtil.search(TestConcurrency.this.mMbox, "in:inbox roland", (byte)5);
                Assert.assertTrue((String)("Search returned " + ids.size() + " messages.  Expected at least " + this.mNumToRead), (ids.size() >= this.mNumToRead ? 1 : 0) != 0);
                for (Integer id : ids) {
                    LmcGetMsgRequest req = new LmcGetMsgRequest();
                    req.setMsgToGet(id.toString());
                    req.setSession(session);
                    req.invoke(TestUtil.getSoapUrl());
                    if (++numRead != this.mNumToRead) continue;
                    break;
                }
            }
            catch (Exception e) {
                ZimbraLog.test.error((Object)"Error in ReadMessagesThread", e);
            }
            ZimbraLog.test.debug("ReadMessagesThread read " + numRead + " messages");
        }
    }
}

