/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.DummySSLSocketFactory;
import com.zimbra.common.util.EasySSLProtocolSocketFactory;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.qa.unittest.TestUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import junit.framework.TestCase;

public class TestCiphers
extends TestCase {
    private static final String[] EXCLUDED_CIPHERS = new String[]{"SSL_RSA_WITH_DES_CBC_SHA"};
    private static final boolean TESTING_NIO = false;
    private static final boolean zimbraSSLExcludeCipherSuites_configured = true;
    private static final String CRLF = "\r\n";
    private static final String HOSTNAME = "localhost";
    private static final String POP3_CONNECT_RESPONSE = "\\+OK .* POP3 server ready";
    private static final String POP3_USER = "USER user1\r\n";
    private static final String POP3_USER_RESPONSE = "\\+OK hello user1, please enter your password";
    private static final String POP3_PASS = "PASS test123\r\n";
    private static final String POP3_PASS_RESPONSE = "\\+OK server ready";
    private static final String POP3_STLS = "STLS\r\n";
    private static final String POP3_STLS_RESPONSE = "\\+OK Begin TLS negotiation";
    private static final String POP3_CLEARTEXT_FAILED_RESPONSE = "-ERR only valid after entering TLS mode";
    private static final String POP3_QUIT = "QUIT\r\n";
    private static final String POP3_QUIT_RESPONSE = "\\+OK .* closing connection";
    private static final String POP3_XOIP = "XOIP 100.99.98.97\r\n";
    private static final String POP3_XOIP_RESPONSE = "\\+OK";
    private static final String IMAP_CONNECT_RESPONSE = "\\* OK .* Zimbra IMAP4rev1 service ready";
    private static final String IMAP_LOGIN = "1 LOGIN user1 test123\r\n";
    private static final String IMAP_LOGIN_RESPONSE = "1 OK.*LOGIN completed";
    private static final String IMAP_CLEARTEXT_FAILED_RESPONSE = "1 NO cleartext logins disabled";
    private static final String IMAP_STARTTLS = "2 STARTTLS\r\n";
    private static final String IMAP_STARTTLS_RESPONSE = "2 OK Begin TLS negotiation now";
    private static final String IMAP_STARTTLS_RESPONSE_NIO = "2 OK begin TLS negotiation now";
    private static final String IMAP_LOGOUT = "3 LOGOUT\r\n";
    private static final String IMAP_LOGOUT_RESPONSE1 = "\\* BYE.*IMAP4rev1 server terminating connection";
    private static final String IMAP_LOGOUT_RESPONSE2 = "3 OK LOGOUT completed";
    private static final String IMAP_ID = "4 ID (\"X-ORIGINATING-IP\" \"100.99.98.97\")\r\n";
    private static final String IMAP_ID_RESPONSE1 = "\\* ID.*";
    private static final String IMAP_ID_RESPONSE2 = "4 OK ID completed";
    private static final String SOAP_ENV = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">  <soap:Header>    <context xmlns=\"urn:zimbra\">      <session></session>    </context>  </soap:Header>  <soap:Body>    <PingRequest xmlns=\"urn:zimbraAdmin\"></PingRequest>  </soap:Body></soap:Envelope>";
    private static final String HTTP_SOAP_PING = "POST /service/admin/soap/ HTTP/1.1\r\nContent-Type: text/xml; charset=utf-8\r\nUser-Agent: Jakarta Commons-HttpClient/3.0\r\nHost: localhost:7070\r\nContent-Length: " + "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">  <soap:Header>    <context xmlns=\"urn:zimbra\">      <session></session>    </context>  </soap:Header>  <soap:Body>    <PingRequest xmlns=\"urn:zimbraAdmin\"></PingRequest>  </soap:Body></soap:Envelope>".length() + "\r\n" + "\r\n" + "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">  <soap:Header>    <context xmlns=\"urn:zimbra\">      <session></session>    </context>  </soap:Header>  <soap:Body>    <PingRequest xmlns=\"urn:zimbraAdmin\"></PingRequest>  </soap:Body></soap:Envelope>";
    private static final String HTTP_SOAP_PING_RESPONSE = "HTTP/1.1 200 OK";
    private static final String HTTP_SOAP_PING_RESPONSE_CLEARTEXT = "HTTP/1.1 500 Internal Server Error";
    private static int mPop3CleartextPort;
    private static int mPop3SslPort;
    private static int mImapCleartextPort;
    private static int mImapSslPort;
    private static int mHttpCleartextPort;
    private static int mHttpSslPort;
    private Map<Socket, BufferedReader> mReaders = new HashMap<Socket, BufferedReader>();

    static void init() throws Exception {
        EasySSLProtocolSocketFactory.init();
        Provisioning prov = Provisioning.getInstance();
        Server server = prov.getLocalServer();
        mPop3CleartextPort = server.getIntAttr("zimbraPop3BindPort", 7110);
        mPop3SslPort = server.getIntAttr("zimbraPop3SSLBindPort", 7995);
        mImapCleartextPort = server.getIntAttr("zimbraImapBindPort", 7143);
        mImapSslPort = server.getIntAttr("zimbraImapSSLBindPort", 7995);
        mHttpCleartextPort = server.getIntAttr("zimbraMailPort", 7070);
        mHttpSslPort = server.getIntAttr("zimbraAdminPort", 7071);
    }

    private void setEnabledCipherSuites(Socket socket) {
        SSLSocket sslSocket = (SSLSocket)socket;
        sslSocket.setEnabledCipherSuites(EXCLUDED_CIPHERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pop3(boolean useExcludedCipher) throws Exception {
        boolean good;
        block11: {
            Socket socket;
            block10: {
                socket = new Socket(HOSTNAME, mPop3CleartextPort);
                this.send(socket, "", POP3_CONNECT_RESPONSE);
                this.send(socket, POP3_USER, POP3_USER_RESPONSE);
                this.send(socket, POP3_PASS, POP3_PASS_RESPONSE);
                this.send(socket, POP3_QUIT, POP3_QUIT_RESPONSE);
                socket.close();
                good = false;
                socket = DummySSLSocketFactory.getDefault().createSocket(HOSTNAME, mPop3SslPort);
                if (useExcludedCipher) {
                    this.setEnabledCipherSuites(socket);
                }
                try {
                    try {
                        this.send(socket, "", POP3_CONNECT_RESPONSE);
                        this.send(socket, POP3_USER, POP3_USER_RESPONSE);
                        this.send(socket, POP3_PASS, POP3_PASS_RESPONSE);
                        this.send(socket, POP3_QUIT, POP3_QUIT_RESPONSE);
                        good = !useExcludedCipher;
                    }
                    catch (SSLHandshakeException e) {
                        good = useExcludedCipher;
                        Object var6_5 = null;
                        socket.close();
                        break block10;
                    }
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    socket.close();
                    throw throwable;
                }
                socket.close();
            }
            TestCiphers.assertTrue((boolean)good);
            good = false;
            socket = new Socket(HOSTNAME, mPop3CleartextPort);
            this.send(socket, "", POP3_CONNECT_RESPONSE);
            this.send(socket, POP3_STLS, POP3_STLS_RESPONSE);
            SSLSocketFactory factory = (SSLSocketFactory)DummySSLSocketFactory.getDefault();
            socket = factory.createSocket(socket, HOSTNAME, mPop3CleartextPort, true);
            if (useExcludedCipher) {
                this.setEnabledCipherSuites(socket);
            }
            try {
                try {
                    this.send(socket, POP3_USER, POP3_USER_RESPONSE);
                    this.send(socket, POP3_PASS, POP3_PASS_RESPONSE);
                    this.send(socket, POP3_QUIT, POP3_QUIT_RESPONSE);
                    good = !useExcludedCipher;
                }
                catch (SSLHandshakeException e) {
                    good = useExcludedCipher;
                    Object var8_12 = null;
                    socket.close();
                    break block11;
                }
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                socket.close();
                throw throwable;
            }
            socket.close();
        }
        TestCiphers.assertTrue((boolean)good);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void imap(boolean useExcludedCipher) throws Exception {
        boolean good;
        block11: {
            Socket socket;
            block10: {
                socket = new Socket(HOSTNAME, mImapCleartextPort);
                this.send(socket, null, IMAP_CONNECT_RESPONSE);
                this.send(socket, IMAP_LOGIN, IMAP_LOGIN_RESPONSE);
                this.send(socket, IMAP_LOGOUT, IMAP_LOGOUT_RESPONSE1);
                this.send(socket, null, IMAP_LOGOUT_RESPONSE2);
                good = false;
                socket = DummySSLSocketFactory.getDefault().createSocket(HOSTNAME, mImapSslPort);
                if (useExcludedCipher) {
                    this.setEnabledCipherSuites(socket);
                }
                try {
                    try {
                        this.send(socket, null, IMAP_CONNECT_RESPONSE);
                        this.send(socket, IMAP_LOGIN, IMAP_LOGIN_RESPONSE);
                        this.send(socket, IMAP_LOGOUT, IMAP_LOGOUT_RESPONSE1);
                        this.send(socket, null, IMAP_LOGOUT_RESPONSE2);
                        good = !useExcludedCipher;
                    }
                    catch (SSLHandshakeException e) {
                        good = useExcludedCipher;
                        Object var6_5 = null;
                        socket.close();
                        break block10;
                    }
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    socket.close();
                    throw throwable;
                }
                socket.close();
            }
            TestCiphers.assertTrue((boolean)good);
            good = false;
            socket = new Socket(HOSTNAME, mImapCleartextPort);
            this.send(socket, null, IMAP_CONNECT_RESPONSE);
            String expectedStartTLSResp = IMAP_STARTTLS_RESPONSE;
            this.send(socket, IMAP_STARTTLS, expectedStartTLSResp);
            SSLSocketFactory factory = (SSLSocketFactory)DummySSLSocketFactory.getDefault();
            socket = factory.createSocket(socket, HOSTNAME, mImapCleartextPort, true);
            if (useExcludedCipher) {
                this.setEnabledCipherSuites(socket);
            }
            try {
                try {
                    this.send(socket, IMAP_LOGIN, IMAP_LOGIN_RESPONSE);
                    this.send(socket, IMAP_LOGOUT, IMAP_LOGOUT_RESPONSE1);
                    this.send(socket, null, IMAP_LOGOUT_RESPONSE2);
                    good = !useExcludedCipher;
                }
                catch (SSLHandshakeException e) {
                    good = useExcludedCipher;
                    Object var8_13 = null;
                    socket.close();
                    break block11;
                }
                Object var8_12 = null;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                socket.close();
                throw throwable;
            }
            socket.close();
        }
        TestCiphers.assertTrue((boolean)good);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void http(boolean useExcludedCipher) throws Exception {
        boolean good;
        block5: {
            Socket socket = new Socket(HOSTNAME, mHttpCleartextPort);
            this.send(socket, HTTP_SOAP_PING, HTTP_SOAP_PING_RESPONSE_CLEARTEXT);
            good = false;
            socket = DummySSLSocketFactory.getDefault().createSocket(HOSTNAME, mHttpSslPort);
            if (useExcludedCipher) {
                this.setEnabledCipherSuites(socket);
            }
            try {
                try {
                    this.send(socket, HTTP_SOAP_PING, HTTP_SOAP_PING_RESPONSE);
                    good = !useExcludedCipher;
                }
                catch (SSLHandshakeException e) {
                    good = useExcludedCipher;
                    Object var6_5 = null;
                    socket.close();
                    break block5;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                socket.close();
                throw throwable;
            }
            socket.close();
        }
        TestCiphers.assertTrue((boolean)good);
    }

    public void testPop3() throws Exception {
        this.pop3(true);
        this.pop3(false);
    }

    public void testImap() throws Exception {
        this.imap(true);
        this.imap(false);
    }

    public void testHttp() throws Exception {
        this.http(true);
        this.http(false);
    }

    private void send(Socket socket, String msg, String responsePattern) throws Exception {
        BufferedReader reader;
        if (msg != null) {
            OutputStream out = socket.getOutputStream();
            out.write(msg.getBytes());
            out.flush();
        }
        if ((reader = this.mReaders.get(socket)) == null) {
            reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.mReaders.put(socket, reader);
        }
        String response = reader.readLine();
        String errorMsg = "Unexpected response: '" + response + "'";
        TestCiphers.assertTrue((String)errorMsg, (boolean)response.matches(responsePattern));
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestCiphers.class);
    }

    static {
        try {
            TestCiphers.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

