/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.qa.unittest.TestUtil;
import junit.framework.TestCase;

public class TestBuildInfo
extends TestCase {
    public void invalid(String version) throws Exception {
        try {
            new BuildInfo.Version(version);
        }
        catch (ServiceException e) {
            System.out.println("good:" + e.getMessage());
            return;
        }
        TestBuildInfo.fail();
    }

    public void testInvalid() throws Exception {
        this.invalid("a.0.0");
        this.invalid("6.0.0_GB");
        this.invalid("5.0.12.1");
    }

    public void testValid() throws Exception {
        BuildInfo.Version ver = new BuildInfo.Version("6");
        ver = new BuildInfo.Version("6_M1");
        ver = new BuildInfo.Version("6_BETA1");
        ver = new BuildInfo.Version("6_RC1");
        ver = new BuildInfo.Version("6_GA");
        ver = new BuildInfo.Version("6.0");
        ver = new BuildInfo.Version("6.0_M1");
        ver = new BuildInfo.Version("6.0_BETA1");
        ver = new BuildInfo.Version("6.0_RC1");
        ver = new BuildInfo.Version("6.0_GA");
        ver = new BuildInfo.Version("6.0.0");
        ver = new BuildInfo.Version("6.0.0_M1");
        ver = new BuildInfo.Version("6.0.0_BETA1");
        ver = new BuildInfo.Version("6.0.0_RC1");
        ver = new BuildInfo.Version("6.0.0_GA");
        ver = new BuildInfo.Version("6.0.0_GA1");
    }

    public void testVersion() throws Exception {
        BuildInfo.Version v1 = new BuildInfo.Version("5.0.10");
        BuildInfo.Version v2 = new BuildInfo.Version("5.0.9");
        BuildInfo.Version v3 = new BuildInfo.Version("5.0.10");
        BuildInfo.Version v4 = new BuildInfo.Version("5.0");
        BuildInfo.Version future = new BuildInfo.Version("future");
        TestBuildInfo.assertTrue((v1.compare(v2) > 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((v1.compare(v3) == 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((v2.compare(v1) < 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((v1.compare(v4) > 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((v1.compare(future) < 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((future.compare(v1) > 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((future.compare(future) == 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((BuildInfo.Version.compare("5.0.10", "5.0.9") > 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((BuildInfo.Version.compare("5.0.9", "5.0.10") < 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((BuildInfo.Version.compare("5.0.10", "5.0.10") == 0 ? 1 : 0) != 0);
    }

    public void testRealReleases() throws Exception {
        String[] versions = new String[]{"3.0.0_M2", "3.0.0_M3", "3.0.0_M4", "3.0.0_GA", "3.0.1_GA", "3.1.0_GA", "3.1.1_GA", "3.1.2_GA", "3.1.3_GA", "3.1.4_GA", "3.2.0_M1", "3.2.0_M2", "4.0.0_RC1", "4.0.0_GA", "4.0.1_GA", "4.0.2_GA", "4.0.3_GA", "4.0.4_GA", "4.0.5_GA", "4.1.0_BETA1", "4.5.0_BETA1", "4.5.0_BETA2", "4.5.0_RC1", "4.5.0_RC2", "4.5.0_GA", "4.5.1_GA", "4.5.2_GA", "4.5.3_GA", "4.5.4_GA", "4.5.5_GA", "4.5.6_GA", "4.5.7_GA", "4.5.8_GA", "4.5.9_GA", "4.5.10_GA", "4.5.11_GA", "5.0.0_BETA1", "5.0.0_BETA2", "5.0.0_BETA3", "5.0.0_BETA4", "5.0.0_RC1", "5.0.0_RC2", "5.0.0_RC3", "5.0.0_GA", "5.0.1_GA", "5.0.2_GA", "5.0.3_GA", "5.0.4_GA", "5.0.5_GA", "5.0.6_GA", "5.0.7_GA", "5.0.8_GA", "5.0.9_GA", "5.0.10_GA", "5.0.11_GA", "5.0.12_GA", "6.0.0_BETA1", "6.0.0_BETA2", "6.0.0_RC1", "6.0.0_RC2", "6.0.0_GA"};
        for (int i = 0; i < versions.length - 1; ++i) {
            TestBuildInfo.assertTrue((BuildInfo.Version.compare(versions[i], versions[i]) == 0 ? 1 : 0) != 0);
            for (int j = i + 1; j < versions.length; ++j) {
                TestBuildInfo.assertTrue((BuildInfo.Version.compare(versions[j], versions[i]) > 0 ? 1 : 0) != 0);
            }
        }
    }

    public void testVersionWithRelease() throws Exception {
        TestBuildInfo.assertTrue((BuildInfo.Version.compare("6.0.0_GA", "6.0.0") > 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((BuildInfo.Version.compare("6.0.0", "6.0.0_GA") < 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((BuildInfo.Version.compare("6.0.0_RC1", "6.0.0_RC") > 0 ? 1 : 0) != 0);
        TestBuildInfo.assertTrue((BuildInfo.Version.compare("6.0.0_RC", "6.0.0_RC1") < 0 ? 1 : 0) != 0);
    }

    public void testInVersion() throws Exception {
        AttributeManager am = AttributeManager.getInstance();
        TestBuildInfo.assertTrue((boolean)am.inVersion("zimbraId", "0"));
        TestBuildInfo.assertTrue((boolean)am.inVersion("zimbraId", "5.0.10"));
        TestBuildInfo.assertFalse((boolean)am.inVersion("zimbraZimletDomainAvailableZimlets", "5.0.9"));
        TestBuildInfo.assertTrue((boolean)am.inVersion("zimbraZimletDomainAvailableZimlets", "5.0.10"));
        TestBuildInfo.assertTrue((boolean)am.inVersion("zimbraZimletDomainAvailableZimlets", "5.0.11"));
        TestBuildInfo.assertTrue((boolean)am.inVersion("zimbraZimletDomainAvailableZimlets", "5.5"));
        TestBuildInfo.assertTrue((boolean)am.inVersion("zimbraZimletDomainAvailableZimlets", "6"));
    }

    public static void main(String[] args) throws Exception {
        TestUtil.runTest(TestBuildInfo.class);
    }
}

