/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.store.BlobInputStream;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.qa.unittest.TestUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.mail.internet.SharedInputStream;
import junit.framework.TestCase;

public class TestBlobInputStream
extends TestCase {
    private File mFile;
    private String mOrigBufferSize;

    public void setUp() throws Exception {
        this.mOrigBufferSize = TestUtil.getServerAttr("zimbraMailFileDescriptorBufferSize");
    }

    public void testBlobInputStream() throws Exception {
        int[] bufferSizes;
        for (int bufferSize : bufferSizes = new int[]{0, 1, 4, 5, 9, 10, 99, 999, 1000, 2000}) {
            TestUtil.setServerAttr("zimbraMailFileDescriptorBufferSize", Integer.toString(bufferSize));
            this.runBlobInputStreamTest();
            this.runLargeFileTest();
        }
    }

    public void runBlobInputStreamTest() throws Exception {
        String CONTENT = "0123456789";
        this.createFile(CONTENT);
        BlobInputStream in = new BlobInputStream(this.mFile, this.mFile.length());
        String read = this.getContent(in, 100);
        TestBlobInputStream.assertEquals((String)CONTENT, (String)read);
        this.checkEof(in);
        in.close();
        in = new BlobInputStream(this.mFile, this.mFile.length());
        TestBlobInputStream.assertEquals((String)"01234", (String)this.getContent(in, 5));
        TestBlobInputStream.assertEquals((String)"56789", (String)this.getContent(in, 100));
        this.checkEof(in);
        in.close();
        try {
            in = new BlobInputStream(this.mFile, this.mFile.length(), 6L, 5L);
            TestBlobInputStream.fail((String)"Test with start=6 and end=5 should not have succeeded.");
        }
        catch (IOException e) {
            // empty catch block
        }
        in = new BlobInputStream(this.mFile, this.mFile.length());
        TestBlobInputStream.assertEquals((long)2L, (long)in.skip(2L));
        TestBlobInputStream.assertEquals((String)"23", (String)this.getContent(in, 2));
        TestBlobInputStream.assertEquals((long)3L, (long)in.skip(3L));
        TestBlobInputStream.assertEquals((String)"7", (String)this.getContent(in, 1));
        TestBlobInputStream.assertEquals((long)2L, (long)in.skip(1000L));
        this.checkEof(in);
        in.close();
        in = new BlobInputStream(this.mFile, this.mFile.length());
        TestBlobInputStream.assertTrue((boolean)in.markSupported());
        boolean success = true;
        try {
            in.reset();
        }
        catch (IOException e) {
            success = false;
        }
        TestBlobInputStream.assertFalse((String)"reset() should not have succeeded", (boolean)success);
        TestBlobInputStream.assertEquals((String)"012", (String)this.getContent(in, 3));
        in.mark(3);
        TestBlobInputStream.assertEquals((String)"34", (String)this.getContent(in, 2));
        in.reset();
        TestBlobInputStream.assertEquals((String)"34", (String)this.getContent(in, 2));
        TestBlobInputStream.assertEquals((String)"56", (String)this.getContent(in, 2));
        success = true;
        try {
            in.reset();
        }
        catch (IOException e) {
            success = false;
        }
        TestBlobInputStream.assertFalse((String)"reset() should not have succeeded", (boolean)success);
        in.close();
        in = new BlobInputStream(this.mFile, this.mFile.length());
        byte[] buf = new byte[5];
        for (int i = 0; i < 5; ++i) {
            buf[i] = 57;
        }
        int numRead = in.read(buf, 3, 2);
        TestBlobInputStream.assertTrue((String)("Unexpected number of bytes read: " + numRead), (numRead == 1 || numRead == 2 ? 1 : 0) != 0);
        int[] untouchedIndexes = null;
        if (numRead == 1) {
            TestBlobInputStream.assertEquals((byte)48, (byte)buf[3]);
            untouchedIndexes = new int[]{0, 1, 2, 4};
        }
        if (numRead == 2) {
            TestBlobInputStream.assertEquals((byte)48, (byte)buf[3]);
            TestBlobInputStream.assertEquals((byte)49, (byte)buf[4]);
            untouchedIndexes = new int[]{0, 1, 2};
        }
        for (void var11_16 : untouchedIndexes) {
            TestBlobInputStream.assertEquals((String)("Unexpected value at index " + (int)var11_16), (int)57, (int)buf[var11_16]);
        }
        in.close();
        in = new BlobInputStream(this.mFile, this.mFile.length());
        in.read();
        in.read();
        numRead = in.read(buf);
        TestBlobInputStream.assertTrue((numRead > 0 ? 1 : 0) != 0);
        TestBlobInputStream.assertTrue((numRead <= 5 ? 1 : 0) != 0);
        byte[] test = new byte[numRead];
        System.arraycopy(buf, 0, test, 0, numRead);
        TestBlobInputStream.assertTrue((boolean)"23456".startsWith(new String(test)));
        in.close();
        InputStream sub = in.newStream(0L, CONTENT.length());
        TestBlobInputStream.assertEquals((String)CONTENT, (String)this.getContent(sub, 100));
        this.checkEof(sub);
        sub.close();
        sub = in.newStream(0L, 5L);
        TestBlobInputStream.assertEquals((String)"01234", (String)this.getContent(sub, 100));
        this.checkEof(sub);
        sub.close();
        sub = in.newStream(5L, 10L);
        TestBlobInputStream.assertEquals((String)"56789", (String)this.getContent(sub, 100));
        this.checkEof(sub);
        sub.close();
        sub = in.newStream(5L, -1L);
        TestBlobInputStream.assertEquals((String)"56789", (String)this.getContent(sub, 100));
        this.checkEof(sub);
        sub.close();
        TestBlobInputStream.assertEquals(null, (Object)in.newStream(5L, 11L));
        sub = in.newStream(3L, 6L);
        TestBlobInputStream.assertEquals((String)"345", (String)this.getContent(sub, 100));
        this.checkEof(sub);
        sub.close();
        sub = in.newStream(3L, 6L);
        TestBlobInputStream.assertEquals((long)0L, (long)((SharedInputStream)sub).getPosition());
        sub.read(new byte[2]);
        TestBlobInputStream.assertEquals((long)2L, (long)((SharedInputStream)sub).getPosition());
        sub.close();
        InputStream subsub = ((BlobInputStream)sub).newStream(1L, 3L);
        TestBlobInputStream.assertEquals((String)"45", (String)this.getContent(subsub, 100));
        in.close();
        in = new BlobInputStream(this.mFile, this.mFile.length());
        TestBlobInputStream.assertEquals((long)0L, (long)in.getPosition());
        in.read();
        TestBlobInputStream.assertEquals((long)1L, (long)in.getPosition());
        in.close();
        in = new BlobInputStream(this.mFile, this.mFile.length());
        buf = new byte[4];
        while ((numRead = in.read(buf)) >= 0) {
        }
        in.close();
        this.mFile.delete();
    }

    public void runLargeFileTest() throws Exception {
        String content = this.createFile(5000);
        BlobInputStream in = new BlobInputStream(this.mFile, this.mFile.length());
        TestBlobInputStream.assertEquals((String)content, (String)this.getContent(in, 5000));
        in.close();
        in = new BlobInputStream(this.mFile, this.mFile.length());
        String firstChunk = this.getContent(in, 1000);
        TestBlobInputStream.assertEquals((String)content.substring(0, 1000), (String)firstChunk);
        byte[] secondChunk = new byte[2000];
        int numRead = in.read(secondChunk);
        TestBlobInputStream.assertTrue((numRead > 0 ? 1 : 0) != 0);
        byte[] test = new byte[numRead];
        System.arraycopy(secondChunk, 0, test, 0, numRead);
        TestBlobInputStream.assertEquals((String)content.substring(1000, 1000 + numRead), (String)new String(test));
        int thirdChunkStartPos = 1000 + numRead;
        byte[] thirdChunk = new byte[2000];
        numRead = in.read(thirdChunk);
        TestBlobInputStream.assertTrue((numRead > 0 ? 1 : 0) != 0);
        test = new byte[numRead];
        System.arraycopy(thirdChunk, 0, test, 0, numRead);
        TestBlobInputStream.assertEquals((String)content.substring(thirdChunkStartPos, thirdChunkStartPos + numRead), (String)new String(thirdChunk));
        this.mFile.delete();
        in.close();
    }

    private String createFile(int numBytes) throws Exception {
        StringBuilder buf = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < numBytes; ++i) {
            char c = 'a';
            c = (char)(c + random.nextInt(26));
            buf.append(c);
        }
        String s = buf.toString();
        this.createFile(s);
        return s;
    }

    private void createFile(String data) throws Exception {
        this.mFile = File.createTempFile("TestBlobInputStream", ".txt");
        FileWriter writer = new FileWriter(this.mFile);
        writer.write(data);
        writer.close();
    }

    private String getContent(InputStream in, int maxBytes) throws Exception {
        int c;
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i <= maxBytes && (c = in.read()) > 0; ++i) {
            builder.append((char)c);
        }
        return builder.toString();
    }

    private void checkEof(InputStream in) throws Exception {
        TestBlobInputStream.assertEquals((int)-1, (int)in.read());
        byte[] buf = new byte[10];
        TestBlobInputStream.assertEquals((int)-1, (int)in.read(buf));
        TestBlobInputStream.assertEquals((int)-1, (int)in.read(buf, 5, 2));
    }

    public void tearDown() throws Exception {
        if (this.mFile != null && this.mFile.exists()) {
            this.mFile.delete();
        }
        TestUtil.setServerAttr("zimbraMailFileDescriptorBufferSize", this.mOrigBufferSize);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        StoreManager.getInstance().startup();
        TestUtil.runTest(TestBlobInputStream.class);
    }
}

