/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.client.LmcSession;
import com.zimbra.cs.client.soap.LmcSearchRequest;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import junit.framework.TestCase;

public class TestAuthentication
extends TestCase {
    private static String USER_NAME = "testauthentication";
    private static String PASSWORD = "test123";
    private Provisioning mProv;
    private Long mMboxId;

    public void setUp() throws Exception {
        this.mProv = Provisioning.getInstance();
        this.cleanUp();
        String address = TestUtil.getAddress(USER_NAME);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraMailHost", TestUtil.getDomain());
        attrs.put("cn", "Unit test temporary user");
        attrs.put("displayName", "Unit test temporary user");
        Account account = this.mProv.createAccount(address, PASSWORD, attrs);
        TestAuthentication.assertNotNull((String)"Could not create account", (Object)account);
        this.mMboxId = MailboxManager.getInstance().getMailboxByAccount(account).getId();
    }

    protected void tearDown() throws Exception {
        this.cleanUp();
    }

    private Account getAccount() throws Exception {
        String address = TestUtil.getAddress(USER_NAME);
        return Provisioning.getInstance().get(Provisioning.AccountBy.name, address);
    }

    public void testAccessDeletedAccount() throws Exception {
        LmcSession session = TestUtil.getSoapSession(USER_NAME);
        LmcSearchRequest req = new LmcSearchRequest();
        req.setQuery("in:inbox");
        req.setSession(session);
        req.invoke(TestUtil.getSoapUrl());
        Account account = this.getAccount();
        TestAuthentication.assertNotNull((String)"Account does not exist", (Object)account);
        this.mProv.deleteAccount(account.getId());
        try {
            req.invoke(TestUtil.getSoapUrl());
        }
        catch (SoapFaultException ex) {
            TestAuthentication.assertTrue((String)("Unexpected error: " + ex.getMessage()), (ex.getMessage().indexOf("auth credentials have expired") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testAccessInactiveAccount() throws Exception {
        LmcSession session = TestUtil.getSoapSession(USER_NAME);
        LmcSearchRequest req = new LmcSearchRequest();
        req.setQuery("in:inbox");
        req.setSession(session);
        req.invoke(TestUtil.getSoapUrl());
        Account account = this.getAccount();
        this.mProv.modifyAccountStatus(account, "maintenance");
        try {
            req.invoke(TestUtil.getSoapUrl());
        }
        catch (SoapFaultException ex) {
            String substring = "auth credentials have expired";
            String msg = String.format("Error message '%s' does not contain '%s'", ex.getMessage(), substring);
            TestAuthentication.assertTrue((String)msg, (boolean)ex.getMessage().contains(substring));
        }
    }

    private void cleanUp() throws Exception {
        Account account = this.getAccount();
        if (account != null) {
            Provisioning.getInstance().deleteAccount(account.getId());
        }
        if (this.mMboxId != null) {
            Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.mMboxId);
            mbox.deleteMailbox();
        }
    }
}

