/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import java.util.Set;
import junit.framework.TestCase;

public class TestAttr
extends TestCase {
    private String TEST_ID = TestProvisioningUtil.genTestId();
    private static String TEST_NAME = "test-attr";
    private static String PASSWORD = "test123";
    private String DOMAIN_NAME;
    private String ACCT_EMAIL;
    private String SERVER_NAME;
    private String COS_NAME;
    private Provisioning mProv;

    public void setUp() throws Exception {
        this.DOMAIN_NAME = TestProvisioningUtil.baseDomainName(TEST_NAME, this.TEST_ID);
        this.ACCT_EMAIL = "user1@" + this.DOMAIN_NAME;
        this.SERVER_NAME = "server-" + this.TEST_ID + "-" + TEST_NAME;
        this.COS_NAME = "cos-" + this.TEST_ID + "-" + TEST_NAME;
        this.mProv = Provisioning.getInstance();
    }

    private Account createAccount() throws Exception {
        Domain domain = this.getDomain();
        Cos cos = this.getCos();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraCOSId", cos.getId());
        Account acct = this.mProv.createAccount(this.ACCT_EMAIL, PASSWORD, attrs);
        TestAttr.assertNotNull((Object)acct);
        return acct;
    }

    private Cos createCos() throws Exception {
        Cos cos = this.mProv.createCos(this.COS_NAME, new HashMap<String, Object>());
        TestAttr.assertNotNull((Object)cos);
        return cos;
    }

    private Domain createDomain() throws Exception {
        Domain domain = this.mProv.createDomain(this.DOMAIN_NAME, new HashMap<String, Object>());
        TestAttr.assertNotNull((Object)domain);
        return domain;
    }

    private Server createServer() throws Exception {
        Server server = this.mProv.createServer(this.SERVER_NAME, new HashMap<String, Object>());
        TestAttr.assertNotNull((Object)server);
        return server;
    }

    private Account getAccount() throws Exception {
        Account acct = this.mProv.get(Provisioning.AccountBy.name, this.ACCT_EMAIL);
        if (acct == null) {
            acct = this.createAccount();
        }
        TestAttr.assertNotNull((Object)acct);
        return acct;
    }

    private Cos getCos() throws Exception {
        Cos cos = this.mProv.get(Provisioning.CosBy.name, this.COS_NAME);
        if (cos == null) {
            cos = this.createCos();
        }
        TestAttr.assertNotNull((Object)cos);
        return cos;
    }

    private Domain getDomain() throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME);
        if (domain == null) {
            domain = this.createDomain();
        }
        TestAttr.assertNotNull((Object)domain);
        return domain;
    }

    private Server getServer() throws Exception {
        Server server = this.mProv.get(Provisioning.ServerBy.name, this.SERVER_NAME);
        if (server == null) {
            server = this.createServer();
        }
        TestAttr.assertNotNull((Object)server);
        return server;
    }

    private void cannotUnset(Entry entry, String attrName) {
        boolean good;
        block5: {
            block4: {
                good = false;
                try {
                    this.unsetByEmptyString(entry, attrName);
                }
                catch (ServiceException e) {
                    if (!"service.INVALID_REQUEST".equals(e.getCode()) || !e.getMessage().contains("is a required attribute")) break block4;
                    good = true;
                }
            }
            TestAttr.assertTrue((boolean)good);
            try {
                this.unsetByNull(entry, attrName);
            }
            catch (ServiceException e) {
                if (!"service.INVALID_REQUEST".equals(e.getCode()) || !e.getMessage().contains("is a required attribute")) break block5;
                good = true;
            }
        }
        TestAttr.assertTrue((boolean)good);
    }

    private void unsetByEmptyString(Entry entry, String attrName) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(attrName, "");
        this.mProv.modifyAttrs(entry, attrs);
        String newValue = entry.getAttr(attrName, false);
        TestAttr.assertNull((Object)newValue);
    }

    private void unsetByNull(Entry entry, String attrName) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put(attrName, null);
        this.mProv.modifyAttrs(entry, attrs);
        String newValue = entry.getAttr(attrName, false);
        TestAttr.assertNull((Object)newValue);
    }

    private void unsetTest(Entry entry, String attrName) throws ServiceException {
        this.unsetByEmptyString(entry, attrName);
        this.unsetByNull(entry, attrName);
    }

    private void setAttr(Entry entry, String attrName, String value) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(attrName, value);
        this.mProv.modifyAttrs(entry, attrs);
        String newValue = entry.getAttr(attrName, false);
        TestAttr.assertEquals((String)value, (String)newValue);
    }

    public void testSingleValuedAttr() throws Exception {
        Account acct = this.getAccount();
        HashMap<String, String> attrs = new HashMap<String, String>();
        String attrName = "zimbraInterceptAddress";
        String V = "test@example.com";
        String value = acct.getAttr(attrName);
        TestAttr.assertNull((Object)value);
        attrs.clear();
        attrs.put(attrName, V);
        this.mProv.modifyAttrs(acct, attrs);
        value = acct.getAttr(attrName);
        TestAttr.assertEquals((String)V, (String)value);
        this.unsetByEmptyString(acct, attrName);
        attrs.clear();
        attrs.put(attrName, V);
        this.mProv.modifyAttrs(acct, attrs);
        value = acct.getAttr(attrName);
        TestAttr.assertEquals((String)V, (String)value);
        this.unsetByNull(acct, attrName);
        attrs.clear();
        attrs.put(attrName, V);
        this.mProv.modifyAttrs(acct, attrs);
        value = acct.getAttr(attrName);
        TestAttr.assertEquals((String)V, (String)value);
        attrs.clear();
        attrs.put("-" + attrName, V);
        this.mProv.modifyAttrs(acct, attrs);
        value = acct.getAttr(attrName);
        TestAttr.assertNull((Object)value);
    }

    public void testMultiValuedAttr() throws Exception {
        Account acct = this.getAccount();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        String attrName = "zimbraMailForwardingAddress";
        String V1 = "test-1@example.com";
        String V2 = "test-2@example.com";
        Set<String> values = acct.getMultiAttrSet(attrName);
        TestAttr.assertTrue((values != null && values.size() == 0 ? 1 : 0) != 0);
        attrs.clear();
        attrs.put(attrName, V1);
        this.mProv.modifyAttrs(acct, attrs);
        values = acct.getMultiAttrSet(attrName);
        TestAttr.assertTrue((values != null && values.size() == 1 && values.contains(V1) ? 1 : 0) != 0);
        attrs.clear();
        attrs.put("+" + attrName, V2);
        this.mProv.modifyAttrs(acct, attrs);
        values = acct.getMultiAttrSet(attrName);
        TestAttr.assertTrue((values != null && values.size() == 2 && values.contains(V1) && values.contains(V2) ? 1 : 0) != 0);
        attrs.clear();
        attrs.put("-" + attrName, V1);
        this.mProv.modifyAttrs(acct, attrs);
        values = acct.getMultiAttrSet(attrName);
        TestAttr.assertTrue((values != null && values.size() == 1 && values.contains(V2) ? 1 : 0) != 0);
        attrs.clear();
        attrs.put(attrName, "");
        this.mProv.modifyAttrs(acct, attrs);
        String value = acct.getAttr(attrName);
        TestAttr.assertNull((Object)value);
        values = acct.getMultiAttrSet(attrName);
        TestAttr.assertTrue((values != null && values.size() == 0 ? 1 : 0) != 0);
        attrs.clear();
        attrs.put(attrName, new String[]{V1, V2});
        this.mProv.modifyAttrs(acct, attrs);
        values = acct.getMultiAttrSet(attrName);
        TestAttr.assertTrue((values != null && values.size() == 2 && values.contains(V1) && values.contains(V2) ? 1 : 0) != 0);
        attrs.clear();
        attrs.put(attrName, null);
        this.mProv.modifyAttrs(acct, attrs);
        value = acct.getAttr(attrName);
        TestAttr.assertNull((Object)value);
        values = acct.getMultiAttrSet(attrName);
        TestAttr.assertTrue((values != null && values.size() == 0 ? 1 : 0) != 0);
    }

    public void testDurationAttr() throws Exception {
        boolean good;
        block5: {
            HashMap<String, String> attrs;
            String attrName;
            Server server;
            block4: {
                server = this.getServer();
                attrName = "zimbraHsmAge";
                attrs = new HashMap<String, String>();
                attrs.put(attrName, "1d");
                this.mProv.modifyAttrs(server, attrs);
                String strValue = server.getAttr(attrName);
                TestAttr.assertEquals((String)"1d", (String)strValue);
                long msValue = server.getTimeInterval(attrName, 0L);
                TestAttr.assertEquals((long)86400000L, (long)msValue);
                long secValue = server.getTimeIntervalSecs(attrName, 0L);
                TestAttr.assertEquals((long)86400L, (long)secValue);
                attrs.put(attrName, "1h");
                this.mProv.modifyAttrs(server, attrs);
                strValue = server.getAttr(attrName);
                TestAttr.assertEquals((String)"1h", (String)strValue);
                msValue = server.getTimeInterval(attrName, 0L);
                TestAttr.assertEquals((long)3600000L, (long)msValue);
                secValue = server.getTimeIntervalSecs(attrName, 0L);
                TestAttr.assertEquals((long)3600L, (long)secValue);
                attrs.put(attrName, "1m");
                this.mProv.modifyAttrs(server, attrs);
                strValue = server.getAttr(attrName);
                TestAttr.assertEquals((String)"1m", (String)strValue);
                msValue = server.getTimeInterval(attrName, 0L);
                TestAttr.assertEquals((long)60000L, (long)msValue);
                secValue = server.getTimeIntervalSecs(attrName, 0L);
                TestAttr.assertEquals((long)60L, (long)secValue);
                attrs.put(attrName, "1s");
                this.mProv.modifyAttrs(server, attrs);
                strValue = server.getAttr(attrName);
                TestAttr.assertEquals((String)"1s", (String)strValue);
                msValue = server.getTimeInterval(attrName, 0L);
                TestAttr.assertEquals((long)1000L, (long)msValue);
                secValue = server.getTimeIntervalSecs(attrName, 0L);
                TestAttr.assertEquals((long)1L, (long)secValue);
                attrs.put(attrName, "1");
                this.mProv.modifyAttrs(server, attrs);
                strValue = server.getAttr(attrName);
                TestAttr.assertEquals((String)"1", (String)strValue);
                msValue = server.getTimeInterval(attrName, 0L);
                TestAttr.assertEquals((long)1000L, (long)msValue);
                secValue = server.getTimeIntervalSecs(attrName, 0L);
                TestAttr.assertEquals((long)1L, (long)secValue);
                attrs.put(attrName, "1ms");
                this.mProv.modifyAttrs(server, attrs);
                strValue = server.getAttr(attrName);
                TestAttr.assertEquals((String)"1ms", (String)strValue);
                msValue = server.getTimeInterval(attrName, 0L);
                TestAttr.assertEquals((long)1L, (long)msValue);
                secValue = server.getTimeIntervalSecs(attrName, 0L);
                TestAttr.assertEquals((long)0L, (long)secValue);
                attrs.put(attrName, "500ms");
                this.mProv.modifyAttrs(server, attrs);
                strValue = server.getAttr(attrName);
                TestAttr.assertEquals((String)"500ms", (String)strValue);
                msValue = server.getTimeInterval(attrName, 0L);
                TestAttr.assertEquals((long)500L, (long)msValue);
                secValue = server.getTimeIntervalSecs(attrName, 0L);
                TestAttr.assertEquals((long)1L, (long)secValue);
                attrs.put(attrName, "1000ms");
                this.mProv.modifyAttrs(server, attrs);
                strValue = server.getAttr(attrName);
                TestAttr.assertEquals((String)"1000ms", (String)strValue);
                msValue = server.getTimeInterval(attrName, 0L);
                TestAttr.assertEquals((long)1000L, (long)msValue);
                secValue = server.getTimeIntervalSecs(attrName, 0L);
                TestAttr.assertEquals((long)1L, (long)secValue);
                attrs.put(attrName, "1001ms");
                this.mProv.modifyAttrs(server, attrs);
                strValue = server.getAttr(attrName);
                TestAttr.assertEquals((String)"1001ms", (String)strValue);
                msValue = server.getTimeInterval(attrName, 0L);
                TestAttr.assertEquals((long)1001L, (long)msValue);
                secValue = server.getTimeIntervalSecs(attrName, 0L);
                TestAttr.assertEquals((long)1L, (long)secValue);
                attrs.put(attrName, "999ms");
                this.mProv.modifyAttrs(server, attrs);
                strValue = server.getAttr(attrName);
                TestAttr.assertEquals((String)"999ms", (String)strValue);
                msValue = server.getTimeInterval(attrName, 0L);
                TestAttr.assertEquals((long)999L, (long)msValue);
                secValue = server.getTimeIntervalSecs(attrName, 0L);
                TestAttr.assertEquals((long)1L, (long)secValue);
                attrs.put(attrName, "0ms");
                this.mProv.modifyAttrs(server, attrs);
                strValue = server.getAttr(attrName);
                TestAttr.assertEquals((String)"0ms", (String)strValue);
                msValue = server.getTimeInterval(attrName, 0L);
                TestAttr.assertEquals((long)0L, (long)msValue);
                secValue = server.getTimeIntervalSecs(attrName, 0L);
                TestAttr.assertEquals((long)0L, (long)secValue);
                good = false;
                attrs.put(attrName, "1y");
                try {
                    this.mProv.modifyAttrs(server, attrs);
                }
                catch (AccountServiceException e) {
                    if (!"account.INVALID_ATTR_VALUE".equals(e.getCode())) break block4;
                    good = true;
                }
            }
            TestAttr.assertTrue((boolean)good);
            good = false;
            attrs.put(attrName, "1mm");
            try {
                this.mProv.modifyAttrs(server, attrs);
            }
            catch (AccountServiceException e) {
                if (!"account.INVALID_ATTR_VALUE".equals(e.getCode())) break block5;
                good = true;
            }
        }
        TestAttr.assertTrue((boolean)good);
    }

    public void testCallbackAccountStatus() throws Exception {
        Account acct = this.getAccount();
        String attrName = "zimbraAccountStatus";
        String value = acct.getAttr(attrName);
        TestAttr.assertEquals((String)"active", (String)value);
        this.cannotUnset(acct, attrName);
        this.setAttr(acct, attrName, "closed");
        TestAttr.assertEquals((String)acct.getAttr("zimbraMailStatus"), (String)"disabled");
    }

    public void testCallbackCheckPortConflict() throws Exception {
        Server server = this.getServer();
        String attrName = "zimbraLmtpBindPort";
        this.unsetTest(server, attrName);
    }

    public void testCallbackDataSource() throws Exception {
        Account acct = this.getAccount();
        String attrName = "zimbraDataSourcePollingInterval";
        this.unsetTest(acct, attrName);
    }

    public void testCallbackDisplayName() throws Exception {
        Account acct = this.getAccount();
        String attrName = "displayName";
        this.unsetTest(acct, attrName);
    }

    public void testCallbackDomainStatus() throws Exception {
        Domain domain = this.getDomain();
        String attrName = "zimbraDomainStatus";
    }

    public void testCallbackMailSignature() throws Exception {
        boolean good;
        block2: {
            Account acct = this.getAccount();
            String attrName = "zimbraPrefMailSignature";
            this.unsetTest(acct, attrName);
            Cos cos = this.getCos();
            this.setAttr(cos, "zimbraMailSignatureMaxLength", "10");
            good = false;
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(attrName, "12345678901");
            try {
                this.mProv.modifyAttrs(acct, attrs);
            }
            catch (ServiceException e) {
                if (!"service.INVALID_REQUEST".equals(e.getCode()) || !e.getMessage().contains("is longer than the limited value")) break block2;
                good = true;
            }
        }
        TestAttr.assertTrue((boolean)good);
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup();
        try {
            TestUtil.runTest(TestAttr.class);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

