/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.account.ldap.LdapEntry;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestAlias
extends TestCase {
    private static String TEST_NAME = "test-alias";
    private static String PASSWORD = "test123";
    private static Provisioning mProv;
    private static String BASE_DOMAIN_NAME;
    private static String LOCAL_DOMAIN_NAME;
    private static String ALIAS_DOMAIN_NAME;

    private String underscoreToHyphen(String inStr) {
        return inStr.replaceAll("_", "-");
    }

    public void testInit() throws Exception {
        mProv = Provisioning.getInstance();
        String TEST_ID = TestProvisioningUtil.genTestId();
        BASE_DOMAIN_NAME = TestProvisioningUtil.baseDomainName(TEST_NAME, TEST_ID);
        LOCAL_DOMAIN_NAME = "local." + BASE_DOMAIN_NAME;
        ALIAS_DOMAIN_NAME = "alias." + BASE_DOMAIN_NAME;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDomainType", "local");
        Domain localDomain = mProv.createDomain(LOCAL_DOMAIN_NAME, attrs);
        attrs.clear();
        attrs.put("zimbraDomainType", "alias");
        attrs.put("zimbraDomainAliasTargetId", localDomain.getId());
        Domain aliasDomain = mProv.createDomain(ALIAS_DOMAIN_NAME, attrs);
    }

    private String getEmail(String localPart, String domainName, String testName) {
        return this.getLocalPart(localPart, testName) + "@" + domainName;
    }

    private String getEmail(String localPart, String domainName) {
        return localPart + "@" + domainName;
    }

    private String getLocalPart(String localPart, String testName) {
        return localPart + "-" + testName;
    }

    private List<NamedEntry> searchAliasesInDomain(Domain domain) throws ServiceException {
        Provisioning.SearchOptions options = new Provisioning.SearchOptions();
        int flags = 0;
        flags = 2;
        options.setFlags(flags);
        options.setDomain(domain);
        return mProv.searchDirectory(options);
    }

    public void testAliasDomain_Case1() throws Exception {
        String testName = this.getName();
        String acctLocalPart = "account1";
        String acctName = this.getEmail(acctLocalPart, LOCAL_DOMAIN_NAME, testName);
        String aliasLocalPart = "alias1";
        String aliasName = this.getEmail(aliasLocalPart, LOCAL_DOMAIN_NAME, testName);
        Account acct = mProv.createAccount(acctName, PASSWORD, null);
        mProv.addAlias(acct, aliasName);
        String authAs = this.getEmail(aliasLocalPart, ALIAS_DOMAIN_NAME, testName);
        Account acctGot = mProv.get(Provisioning.AccountBy.name, authAs);
        TestProvisioningUtil.verifySameEntry(acct, acctGot);
        mProv.authAccount(acctGot, PASSWORD, AuthContext.Protocol.test);
    }

    public void testAliasDomain_Case2() throws Exception {
        String testName = this.getName();
        String acctLocalPart = "account1";
        String acctName = this.getEmail(acctLocalPart, LOCAL_DOMAIN_NAME, testName);
        String aliasLocalPart = "alias1";
        String aliasName = this.getEmail(aliasLocalPart, ALIAS_DOMAIN_NAME, testName);
        Account acct = mProv.createAccount(acctName, PASSWORD, null);
        mProv.addAlias(acct, aliasName);
        String authAs = this.getEmail(aliasLocalPart, LOCAL_DOMAIN_NAME, testName);
        Account acctGot = mProv.get(Provisioning.AccountBy.name, authAs);
        TestAlias.assertNull((Object)acctGot);
        authAs = this.getEmail(acctLocalPart, ALIAS_DOMAIN_NAME, testName);
        acctGot = mProv.get(Provisioning.AccountBy.name, authAs);
        TestProvisioningUtil.verifySameEntry(acct, acctGot);
        mProv.authAccount(acctGot, PASSWORD, AuthContext.Protocol.test);
    }

    public void testAliasDomain_Case3() throws Exception {
        String testName = this.getName();
        String acctLocalPart = "account1";
        String acctName = this.getEmail(acctLocalPart, LOCAL_DOMAIN_NAME, testName);
        String aliasLocalPart = "alias1";
        String aliasName = this.getEmail(aliasLocalPart, ALIAS_DOMAIN_NAME, testName);
        Config config = mProv.getConfig();
        String origDefaltDomainName = config.getAttr("zimbraDefaultDomainName");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDefaultDomainName", LOCAL_DOMAIN_NAME);
        mProv.modifyAttrs(config, attrs);
        Account acct = mProv.createAccount(acctName, PASSWORD, null);
        mProv.addAlias(acct, aliasName);
        String authAs = this.getLocalPart(aliasLocalPart, testName);
        Account acctGot = mProv.get(Provisioning.AccountBy.name, authAs);
        TestAlias.assertNull((Object)acctGot);
        attrs.clear();
        attrs.put("zimbraDefaultDomainName", "");
        mProv.modifyAttrs(config, attrs);
    }

    public void testRemoveAlias_entryExist_aliasExist_aliasPointToEntry() throws Exception {
        String testName = this.getName().toLowerCase();
        String domainName = "EE-AE-aliasPointToEntry." + BASE_DOMAIN_NAME;
        domainName = domainName.toLowerCase();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDomainType", "local");
        Domain domain = mProv.createDomain(domainName, attrs);
        String acctName = this.getEmail("acct-1", domainName);
        Account acct = mProv.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
        String aliasName = this.getEmail("alias-1", domainName);
        mProv.addAlias(acct, aliasName);
        String dl1Name = this.getEmail("dl-1", domainName);
        DistributionList dl1 = mProv.createDistributionList(dl1Name, new HashMap<String, Object>());
        String dl2Name = this.getEmail("dl-2", domainName);
        DistributionList dl2 = mProv.createDistributionList(dl2Name, new HashMap<String, Object>());
        mProv.addMembers(dl1, new String[]{aliasName});
        mProv.addMembers(dl2, new String[]{aliasName});
        mProv.removeAlias(acct, aliasName);
        mProv.reload(acct);
        mProv.reload(dl1);
        mProv.reload(dl2);
        Set<String> values = acct.getMultiAttrSet("mail");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = acct.getMultiAttrSet("zimbraMailAlias");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = dl1.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = dl2.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
        TestAlias.assertEquals((int)aliases.size(), (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveAlias_entryExist_aliasExist_aliasPointToOtherEntry() throws Exception {
        String testName = this.getName().toLowerCase();
        String domainName = "EE-AE-aliasPointToOtherEntry." + BASE_DOMAIN_NAME;
        domainName = domainName.toLowerCase();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDomainType", "local");
        Domain domain = mProv.createDomain(domainName, attrs);
        String acctName = this.getEmail("acct-1", domainName);
        Account acct = mProv.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
        String aliasName = this.getEmail("alias-1", domainName);
        mProv.addAlias(acct, aliasName);
        String dl1Name = this.getEmail("dl-1", domainName);
        DistributionList dl1 = mProv.createDistributionList(dl1Name, new HashMap<String, Object>());
        String dl2Name = this.getEmail("dl-2", domainName);
        DistributionList dl2 = mProv.createDistributionList(dl2Name, new HashMap<String, Object>());
        mProv.addMembers(dl1, new String[]{aliasName});
        mProv.addMembers(dl2, new String[]{aliasName});
        String otherAcctName = this.getEmail("acct-other", domainName);
        Account otherAcct = mProv.createAccount(otherAcctName, PASSWORD, new HashMap<String, Object>());
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("mail", aliasName);
            attributes.put("zimbraMailAlias", aliasName);
            LdapEntry ldapAccount = (LdapEntry)((Object)otherAcct);
            LdapUtil.modifyAttrs(zlc, ldapAccount.getDN(), attributes, (Entry)((Object)ldapAccount));
            mProv.reload(otherAcct);
            Set<String> values = otherAcct.getMultiAttrSet("mail");
            TestAlias.assertTrue((boolean)values.contains(aliasName));
            values = otherAcct.getMultiAttrSet("zimbraMailAlias");
            TestAlias.assertTrue((boolean)values.contains(aliasName));
            Object var19_20 = null;
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
        boolean good = false;
        try {
            mProv.removeAlias(otherAcct, aliasName);
        }
        catch (ServiceException e) {
            TestAlias.assertEquals((String)e.getCode(), (String)"account.NO_SUCH_ALIAS");
            good = true;
        }
        TestAlias.assertTrue((boolean)good);
        mProv.reload(acct);
        mProv.reload(otherAcct);
        mProv.reload(dl1);
        mProv.reload(dl2);
        Set<String> values = acct.getMultiAttrSet("mail");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = acct.getMultiAttrSet("zimbraMailAlias");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = otherAcct.getMultiAttrSet("mail");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = otherAcct.getMultiAttrSet("zimbraMailAlias");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = dl1.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = dl2.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
        TestAlias.assertEquals((int)aliases.size(), (int)1);
        TestAlias.assertTrue((boolean)aliases.get(0).getName().equals(aliasName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveAlias_entryExist_aliasExist_aliasPointToNonExistEntry() throws Exception {
        String testName = this.getName().toLowerCase();
        String domainName = "EE-AE-aliasPointToNonExistEntry." + BASE_DOMAIN_NAME;
        domainName = domainName.toLowerCase();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDomainType", "local");
        Domain domain = mProv.createDomain(domainName, attrs);
        String acctName = this.getEmail("acct-1", domainName);
        Account acct = mProv.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
        String aliasName = this.getEmail("alias-1", domainName);
        mProv.addAlias(acct, aliasName);
        String dl1Name = this.getEmail("dl-1", domainName);
        DistributionList dl1 = mProv.createDistributionList(dl1Name, new HashMap<String, Object>());
        String dl2Name = this.getEmail("dl-2", domainName);
        DistributionList dl2 = mProv.createDistributionList(dl2Name, new HashMap<String, Object>());
        mProv.addMembers(dl1, new String[]{aliasName});
        mProv.addMembers(dl2, new String[]{aliasName});
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("zimbraAliasTargetId", LdapUtil.generateUUID());
            List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
            TestAlias.assertEquals((int)aliases.size(), (int)1);
            LdapEntry ldapAlias = (LdapEntry)((Object)aliases.get(0));
            LdapUtil.modifyAttrs(zlc, ldapAlias.getDN(), attributes, (Entry)((Object)ldapAlias));
            Object var17_18 = null;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
        boolean good = false;
        try {
            mProv.removeAlias(acct, aliasName);
        }
        catch (ServiceException e) {
            TestAlias.assertEquals((String)e.getCode(), (String)"account.NO_SUCH_ALIAS");
            good = true;
        }
        TestAlias.assertTrue((boolean)good);
        mProv.reload(acct);
        mProv.reload(dl1);
        mProv.reload(dl2);
        Set<String> values = acct.getMultiAttrSet("mail");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = acct.getMultiAttrSet("zimbraMailAlias");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = dl1.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = dl2.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
        TestAlias.assertEquals((int)aliases.size(), (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveAlias_entryExist_aliasNotExist() throws Exception {
        String testName = this.getName().toLowerCase();
        String domainName = "EE-AN." + BASE_DOMAIN_NAME;
        domainName = domainName.toLowerCase();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDomainType", "local");
        Domain domain = mProv.createDomain(domainName, attrs);
        String acctName = this.getEmail("acct-1", domainName);
        Account acct = mProv.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
        String aliasName = this.getEmail("alias-1", domainName);
        mProv.addAlias(acct, aliasName);
        String dl1Name = this.getEmail("dl-1", domainName);
        DistributionList dl1 = mProv.createDistributionList(dl1Name, new HashMap<String, Object>());
        String dl2Name = this.getEmail("dl-2", domainName);
        DistributionList dl2 = mProv.createDistributionList(dl2Name, new HashMap<String, Object>());
        mProv.addMembers(dl1, new String[]{aliasName});
        mProv.addMembers(dl2, new String[]{aliasName});
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
            TestAlias.assertEquals((int)aliases.size(), (int)1);
            LdapEntry ldapAlias = (LdapEntry)((Object)aliases.get(0));
            String aliasDn = ldapAlias.getDN();
            zlc.unbindEntry(aliasDn);
            Object var17_18 = null;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
        boolean good = false;
        try {
            mProv.removeAlias(acct, aliasName);
        }
        catch (ServiceException e) {
            TestAlias.assertEquals((String)e.getCode(), (String)"account.NO_SUCH_ALIAS");
            good = true;
        }
        TestAlias.assertTrue((boolean)good);
        mProv.reload(acct);
        mProv.reload(dl1);
        mProv.reload(dl2);
        Set<String> values = acct.getMultiAttrSet("mail");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = acct.getMultiAttrSet("zimbraMailAlias");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = dl1.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = dl2.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
        TestAlias.assertEquals((int)aliases.size(), (int)0);
    }

    public void testRemoveAlias_entryNotExist_aliasExist_aliasPointToOtherEntry() throws Exception {
        String testName = this.getName().toLowerCase();
        String domainName = "EN-AE-aliasPointToOtherEntry." + BASE_DOMAIN_NAME;
        domainName = domainName.toLowerCase();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDomainType", "local");
        Domain domain = mProv.createDomain(domainName, attrs);
        String acctName = this.getEmail("acct-1", domainName);
        Account acct = mProv.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
        String aliasName = this.getEmail("alias-1", domainName);
        mProv.addAlias(acct, aliasName);
        String dl1Name = this.getEmail("dl-1", domainName);
        DistributionList dl1 = mProv.createDistributionList(dl1Name, new HashMap<String, Object>());
        String dl2Name = this.getEmail("dl-2", domainName);
        DistributionList dl2 = mProv.createDistributionList(dl2Name, new HashMap<String, Object>());
        mProv.addMembers(dl1, new String[]{aliasName});
        mProv.addMembers(dl2, new String[]{aliasName});
        Account nonExistingAcct = null;
        mProv.removeAlias(nonExistingAcct, aliasName);
        mProv.reload(acct);
        mProv.reload(dl1);
        mProv.reload(dl2);
        Set<String> values = acct.getMultiAttrSet("mail");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = acct.getMultiAttrSet("zimbraMailAlias");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = dl1.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = dl2.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
        TestAlias.assertEquals((int)aliases.size(), (int)1);
        TestAlias.assertTrue((boolean)aliases.get(0).getName().equals(aliasName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveAlias_entryNotExist_aliasExist_aliasPointToNonExistEntry() throws Exception {
        String testName = this.getName().toLowerCase();
        String domainName = "EN-AE-aliasPointToNonExistEntry." + BASE_DOMAIN_NAME;
        domainName = domainName.toLowerCase();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDomainType", "local");
        Domain domain = mProv.createDomain(domainName, attrs);
        String acctName = this.getEmail("acct-1", domainName);
        Account acct = mProv.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
        String aliasName = this.getEmail("alias-1", domainName);
        mProv.addAlias(acct, aliasName);
        String dl1Name = this.getEmail("dl-1", domainName);
        DistributionList dl1 = mProv.createDistributionList(dl1Name, new HashMap<String, Object>());
        String dl2Name = this.getEmail("dl-2", domainName);
        DistributionList dl2 = mProv.createDistributionList(dl2Name, new HashMap<String, Object>());
        mProv.addMembers(dl1, new String[]{aliasName});
        mProv.addMembers(dl2, new String[]{aliasName});
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("zimbraAliasTargetId", LdapUtil.generateUUID());
            List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
            TestAlias.assertEquals((int)aliases.size(), (int)1);
            LdapEntry ldapAlias = (LdapEntry)((Object)aliases.get(0));
            LdapUtil.modifyAttrs(zlc, ldapAlias.getDN(), attributes, (Entry)((Object)ldapAlias));
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
        Account nonExistingAcct = null;
        mProv.removeAlias(nonExistingAcct, aliasName);
        mProv.reload(acct);
        mProv.reload(dl1);
        mProv.reload(dl2);
        Set<String> values = acct.getMultiAttrSet("mail");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = acct.getMultiAttrSet("zimbraMailAlias");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = dl1.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = dl2.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
        TestAlias.assertEquals((int)aliases.size(), (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveAlias_entryNotExist_aliasNotExist() throws Exception {
        String testName = this.getName().toLowerCase();
        String domainName = "EN-AN." + BASE_DOMAIN_NAME;
        domainName = domainName.toLowerCase();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDomainType", "local");
        Domain domain = mProv.createDomain(domainName, attrs);
        String acctName = this.getEmail("acct-1", domainName);
        Account acct = mProv.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
        String aliasName = this.getEmail("alias-1", domainName);
        mProv.addAlias(acct, aliasName);
        String dl1Name = this.getEmail("dl-1", domainName);
        DistributionList dl1 = mProv.createDistributionList(dl1Name, new HashMap<String, Object>());
        String dl2Name = this.getEmail("dl-2", domainName);
        DistributionList dl2 = mProv.createDistributionList(dl2Name, new HashMap<String, Object>());
        mProv.addMembers(dl1, new String[]{aliasName});
        mProv.addMembers(dl2, new String[]{aliasName});
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
            TestAlias.assertEquals((int)aliases.size(), (int)1);
            LdapEntry ldapAlias = (LdapEntry)((Object)aliases.get(0));
            String aliasDn = ldapAlias.getDN();
            zlc.unbindEntry(aliasDn);
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
        Account nonExistingAcct = null;
        mProv.removeAlias(nonExistingAcct, aliasName);
        mProv.reload(acct);
        mProv.reload(dl1);
        mProv.reload(dl2);
        Set<String> values = acct.getMultiAttrSet("mail");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = acct.getMultiAttrSet("zimbraMailAlias");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = dl1.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = dl2.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
        TestAlias.assertEquals((int)aliases.size(), (int)0);
    }

    public void testRemoveAlias_aliasNameExistsButIsNotAnAlias() throws Exception {
        boolean good;
        String dlId;
        DistributionList dl;
        String dlName;
        block5: {
            String acct2Id;
            Account acct2;
            String acct2Name;
            Account acct;
            block4: {
                String testName = this.getName().toLowerCase();
                String domainName = this.underscoreToHyphen(testName) + "." + BASE_DOMAIN_NAME;
                domainName = domainName.toLowerCase();
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("zimbraDomainType", "local");
                Domain domain = mProv.createDomain(domainName, attrs);
                String acctName = this.getEmail("acct-1", domainName);
                acct = mProv.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
                acct2Name = this.getEmail("acct-2", domainName);
                acct2 = mProv.createAccount(acct2Name, PASSWORD, new HashMap<String, Object>());
                acct2Id = acct2.getId();
                dlName = this.getEmail("dl", domainName);
                dl = mProv.createDistributionList(dlName, new HashMap<String, Object>());
                dlId = dl.getId();
                good = false;
                try {
                    mProv.removeAlias(acct, acct2Name);
                }
                catch (ServiceException e) {
                    if (!"account.NO_SUCH_ALIAS".equals(e.getCode())) break block4;
                    good = true;
                }
            }
            TestAlias.assertTrue((boolean)good);
            mProv.flushCache(Provisioning.CacheEntryType.account, new Provisioning.CacheEntry[]{new Provisioning.CacheEntry(Provisioning.CacheEntryBy.id, acct2Id)});
            acct2 = mProv.get(Provisioning.AccountBy.id, acct2Id);
            TestAlias.assertNotNull((Object)acct2);
            TestAlias.assertEquals((String)acct2Id, (String)acct2.getId());
            TestAlias.assertEquals((String)acct2Name, (String)acct2.getName());
            try {
                mProv.removeAlias(acct, dlName);
            }
            catch (ServiceException e) {
                if (!"account.NO_SUCH_ALIAS".equals(e.getCode())) break block5;
                good = true;
            }
        }
        TestAlias.assertTrue((boolean)good);
        dl = mProv.get(Provisioning.DistributionListBy.id, dlId);
        TestAlias.assertNotNull((Object)dl);
        TestAlias.assertEquals((String)dlId, (String)dl.getId());
        TestAlias.assertEquals((String)dlName, (String)dl.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateAlias_aliasExistAndDangling() throws Exception {
        String testName = this.getName().toLowerCase();
        String domainName = this.underscoreToHyphen(testName) + "." + BASE_DOMAIN_NAME;
        domainName = domainName.toLowerCase();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDomainType", "local");
        Domain domain = mProv.createDomain(domainName, attrs);
        String acctName = this.getEmail("acct-1", domainName);
        Account acct = mProv.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
        String aliasName = this.getEmail("alias-1", domainName);
        mProv.addAlias(acct, aliasName);
        List<NamedEntry> aliases = this.searchAliasesInDomain(domain);
        TestAlias.assertEquals((int)aliases.size(), (int)1);
        String origZimbraIdOfAlias = aliases.get(0).getId();
        String dl1Name = this.getEmail("dl-1", domainName);
        DistributionList dl1 = mProv.createDistributionList(dl1Name, new HashMap<String, Object>());
        String dl2Name = this.getEmail("dl-2", domainName);
        DistributionList dl2 = mProv.createDistributionList(dl2Name, new HashMap<String, Object>());
        mProv.addMembers(dl1, new String[]{aliasName});
        mProv.addMembers(dl2, new String[]{aliasName});
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            LdapEntry ldapAccount = (LdapEntry)((Object)acct);
            zlc.unbindEntry(ldapAccount.getDN());
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            ZimbraLdapContext.closeContext(zlc);
            throw throwable;
        }
        ZimbraLdapContext.closeContext(zlc);
        String otherAcctName = this.getEmail("acct-other", domainName);
        Account otherAcct = mProv.createAccount(otherAcctName, PASSWORD, new HashMap<String, Object>());
        mProv.addAlias(otherAcct, aliasName);
        mProv.reload(otherAcct);
        mProv.reload(dl1);
        mProv.reload(dl2);
        Set<String> values = acct.getMultiAttrSet("mail");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = acct.getMultiAttrSet("zimbraMailAlias");
        TestAlias.assertTrue((boolean)values.contains(aliasName));
        values = dl1.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        values = dl2.getMultiAttrSet("zimbraMailForwardingAddress");
        TestAlias.assertFalse((boolean)values.contains(aliasName));
        aliases = this.searchAliasesInDomain(domain);
        TestAlias.assertEquals((int)aliases.size(), (int)1);
        TestAlias.assertFalse((boolean)aliases.get(0).getId().equals(origZimbraIdOfAlias));
    }

    public void testCreateAlias_aliasNameExistsButIsNotAnAlias() throws Exception {
        boolean good;
        block5: {
            String dlName;
            Account acct;
            block4: {
                String testName = this.getName().toLowerCase();
                String domainName = this.underscoreToHyphen(testName) + "." + BASE_DOMAIN_NAME;
                domainName = domainName.toLowerCase();
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("zimbraDomainType", "local");
                Domain domain = mProv.createDomain(domainName, attrs);
                String acctName = this.getEmail("acct-1", domainName);
                acct = mProv.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
                String acct2Name = this.getEmail("acct-2", domainName);
                Account acct2 = mProv.createAccount(acct2Name, PASSWORD, new HashMap<String, Object>());
                dlName = this.getEmail("dl", domainName);
                DistributionList dl = mProv.createDistributionList(dlName, new HashMap<String, Object>());
                good = false;
                try {
                    mProv.addAlias(acct, acct2Name);
                }
                catch (ServiceException e) {
                    if (!"account.ACCOUNT_EXISTS".equals(e.getCode())) break block4;
                    good = true;
                }
            }
            TestAlias.assertTrue((boolean)good);
            try {
                mProv.addAlias(acct, dlName);
            }
            catch (ServiceException e) {
                if (!"account.ACCOUNT_EXISTS".equals(e.getCode())) break block5;
                good = true;
            }
        }
        TestAlias.assertTrue((boolean)good);
    }

    public void testCreateAlias_aliasExists() throws Exception {
        boolean good;
        block2: {
            String testName = this.getName().toLowerCase();
            String domainName = this.underscoreToHyphen(testName) + "." + BASE_DOMAIN_NAME;
            domainName = domainName.toLowerCase();
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("zimbraDomainType", "local");
            Domain domain = mProv.createDomain(domainName, attrs);
            String acct1Name = this.getEmail("acct-1", domainName);
            Account acct1 = mProv.createAccount(acct1Name, PASSWORD, new HashMap<String, Object>());
            String acct2Name = this.getEmail("acct-2", domainName);
            Account acct2 = mProv.createAccount(acct2Name, PASSWORD, new HashMap<String, Object>());
            String aliasName = this.getEmail("alias", domainName);
            mProv.addAlias(acct1, aliasName);
            good = false;
            try {
                mProv.addAlias(acct2, aliasName);
            }
            catch (ServiceException e) {
                if (!"account.ACCOUNT_EXISTS".equals(e.getCode())) break block2;
                good = true;
            }
        }
        TestAlias.assertTrue((boolean)good);
    }

    public void testBug41884() throws Exception {
        boolean good;
        block2: {
            String OLD_DOMAIN_NAME = "main." + BASE_DOMAIN_NAME;
            String NEW_DOMAIN_NAME = "other." + BASE_DOMAIN_NAME;
            String OLD_LOCALPART = "junk";
            String NEW_LOCALPART = "phoebe";
            String OLD_ACCT_NAME = OLD_LOCALPART + "@" + OLD_DOMAIN_NAME;
            String NEW_ACCT_NAME = NEW_LOCALPART + "@" + NEW_DOMAIN_NAME;
            String ALIAS_NAME = NEW_LOCALPART + "@" + OLD_DOMAIN_NAME;
            Domain oldDomain = mProv.createDomain(OLD_DOMAIN_NAME, new HashMap<String, Object>());
            Domain newDomain = mProv.createDomain(NEW_DOMAIN_NAME, new HashMap<String, Object>());
            Account acct = mProv.createAccount(OLD_ACCT_NAME, "test123", new HashMap<String, Object>());
            mProv.addAlias(acct, ALIAS_NAME);
            good = false;
            try {
                mProv.renameAccount(acct.getId(), NEW_ACCT_NAME);
            }
            catch (ServiceException e) {
                if (!"account.ACCOUNT_EXISTS".equals(e.getCode())) break block2;
                good = true;
            }
        }
        TestAlias.assertTrue((boolean)good);
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup();
        TestUtil.runTest(TestAlias.class);
    }
}

